VERSION 5.00
Object = "{0E59F1D2-1FBE-11D0-8FF2-00A0D10038BC}#1.0#0"; "MSSCRIPT.OCX"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6180
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9720
   LinkTopic       =   "Form1"
   ScaleHeight     =   6180
   ScaleWidth      =   9720
   StartUpPosition =   3  'Windows Default
   Begin MSScriptControlCtl.ScriptControl ScriptControl1 
      Left            =   9120
      Top             =   5640
      _ExtentX        =   1005
      _ExtentY        =   1005
      AllowUI         =   0   'False
   End
   Begin MSFlexGridLib.MSFlexGrid MSFlexGrid1 
      Height          =   5535
      Left            =   5280
      TabIndex        =   7
      Top             =   120
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   9763
      _Version        =   393216
      Rows            =   10
      Cols            =   3
      RowHeightMin    =   300
      WordWrap        =   -1  'True
      FocusRect       =   0
      HighLight       =   0
      GridLinesFixed  =   1
      ScrollBars      =   0
      AllowUserResizing=   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox Text2 
      Appearance      =   0  'Flat
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Top             =   4200
      Width           =   4935
   End
   Begin VB.Frame Frame1 
      Caption         =   "Available tests"
      Height          =   6135
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   5175
      Begin VB.TextBox Text3 
         Height          =   285
         Left            =   3120
         TabIndex        =   8
         Text            =   "10"
         Top             =   5520
         Width           =   495
      End
      Begin VB.CommandButton Command1 
         Caption         =   "Hit it!"
         Height          =   495
         Left            =   3720
         TabIndex        =   6
         Top             =   5520
         Width           =   1335
      End
      Begin VB.TextBox Text1 
         Appearance      =   0  'Flat
         BackColor       =   &H8000000F&
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1215
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   4
         Top             =   2640
         Width           =   4935
      End
      Begin VB.ListBox List1 
         Height          =   2010
         ItemData        =   "Form1.frx":0000
         Left            =   120
         List            =   "Form1.frx":0002
         TabIndex        =   1
         Top             =   240
         Width           =   4935
      End
      Begin VB.Label Label3 
         Caption         =   "Iterations:"
         Height          =   255
         Left            =   2160
         TabIndex        =   9
         Top             =   5520
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Description technique B:"
         Height          =   375
         Left            =   120
         TabIndex        =   3
         Top             =   3960
         Width           =   1935
      End
      Begin VB.Label Label1 
         Caption         =   "Description technique A:"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   2400
         Width           =   4935
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Dim lIterations As Long
Dim oSelectedNode As IXMLDOMElement
Dim xmlSettings As DOMDocument
Dim WithEvents oEventTester As SAXtester
Attribute oEventTester.VB_VarHelpID = -1
Dim i As Long
Const testnr = 5

Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)


Private Sub Command1_Click()
    Dim name As String
    If oSelectedNode Is Nothing Then Exit Sub
    clearResults
    If IsNumeric(Text3.Text) Then
        lIterations = CLng(Text3.Text)
    Else
        lIterations = 10
        Text3.Text = "10"
    End If
    DoEvents
    name = oSelectedNode.getAttribute("name")
    Select Case name
        Case "Create xml string"
            CheckBuildDocument
        Case "Create xml object"
            CheckBuildDocumentObject
        Case "Create xml string in script"
            CheckBuildDocumentStringVar
        Case "Create xml object in script"
            CheckBuildDocumentObjectVar
        Case "Load document with/without validation"
            CheckLoadDocument
        Case "Parse with SAX or DOM"
            CheckDOMSAX
        Case "Access element by ID"
            CheckAccessID
        Case "General XPath vs. specific XPath"
            CheckAccessXPath
        Case "Updates in DOMDocument vs. DOMFreeThreadedDocument"
            CheckThread
        Case "Load documents with internal/external DTD validating"
            Checkintext (True)
        Case "Load documents with internal/external DTD non-validating"
            Checkintext (False)
        Case "Transforming to a very simple HTML file with XSLT/hard coded"
            CheckTransform
        Case Else
            Err.Raise 9999, "PerfTest.exe", "Unknown test"
    End Select
    
    calcAverage
End Sub

Private Sub Form_Load()
    Dim oList As IXMLDOMNodeList

    Set xmlSettings = New DOMDocument
    xmlSettings.Load (App.Path & "\settings.xml")
    
    Set oList = xmlSettings.selectNodes("/settings/tests/test")
    For i = 0 To oList.length - 1
        List1.AddItem oList.Item(i).Attributes.getNamedItem("name").nodeValue
    Next
    clearResults
    
    loadScripts
End Sub

Private Sub loadScripts()
    Dim fso As New FileSystemObject
    Dim ofile As File
    Dim sScriptContent As String
    
    sScriptContent = fso.OpenTextFile(App.Path & "\scriptcode.vbs", ForReading).ReadAll
    
    ScriptControl1.AddCode (sScriptContent)
    

End Sub

Private Sub List1_Click()
    Set oSelectedNode = xmlSettings.selectSingleNode("/settings/tests/test[" & List1.ListIndex & "]")
    If IsNumeric(oSelectedNode.getAttribute("defaultIterations")) Then
        Text3.Text = oSelectedNode.getAttribute("defaultIterations")
    End If
    If oSelectedNode.getAttribute("iterationsFixed") = "true" Then
        Text3.Enabled = False
    Else
        Text3.Enabled = True
    End If
    Text1.Text = oSelectedNode.selectSingleNode("technique[@name='A']/@title").nodeValue & vbCrLf & oSelectedNode.selectSingleNode("technique[@name='A']/text()").nodeValue
    Text2.Text = oSelectedNode.selectSingleNode("technique[@name='B']/@title").nodeValue & vbCrLf & oSelectedNode.selectSingleNode("technique[@name='B']/text()").nodeValue
End Sub

Private Sub clearResults()
    MSFlexGrid1.Clear
    With MSFlexGrid1
        .Col = 0
        
        .Row = 2
        .Text = "1"
        .Row = 3
        .Text = "2"
        .Row = 4
        .Text = "3"
        .Row = 5
        .Text = "4"
        .Row = 6
        .Text = "5"
        .Row = 7
        .Text = "Total"
        .Row = 8
        .Text = "Relative"
        
        .Row = 0
        .Col = 1
        .Text = "A"
        .Row = 0
        .Col = 2
        .Text = "B"
        
    End With
End Sub

Private Sub CheckBuildDocument()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    Call QueryPerformanceCounter(liStarttime)
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckBuildDocumentA
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckBuildDocumentB
        Next
        Call QueryPerformanceCounter(liEndtime)
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckBuildDocumentA()
    Dim sXML As String
    Dim sContentString As String
    
    sContentString = "This is some text with a ""quote"" and &'s "
    sXML = "<?xml version=""1.0""?>" & vbCrLf
    sXML = sXML & "<items>"
    For i = 1 To 10
        sXML = sXML & "<item "
        If i > 5 Then
            sXML = sXML & "someAttribute=""" & i & """"
        End If
        sXML = sXML & replaceSpecialChars(sContentString)
        sXML = sXML & "</item>"
    Next
    sXML = sXML & "</items>"

End Sub

Public Function replaceSpecialChars(sPassed As String) As String
    replaceSpecialChars = Replace(sPassed, "&", "&amp;")
    replaceSpecialChars = Replace(replaceSpecialChars, "<", "&lt;")
    replaceSpecialChars = Replace(replaceSpecialChars, ">", "&gt;")
    replaceSpecialChars = Replace(replaceSpecialChars, """", "&quot;")
    replaceSpecialChars = Replace(replaceSpecialChars, "'", "&apos;")
End Function
Private Sub CheckBuildDocumentB()
    Dim sXML As String
    Dim oXML As New DOMDocument
    Dim oRoot As IXMLDOMElement
    Dim oCurrElem As IXMLDOMElement
    Dim sContentString As String
    
    sContentString = "This is some text with a ""quote"" and &'s "
    
    Set oRoot = oXML.createElement("items")
    Set oXML.documentElement = oRoot
    oXML.insertBefore oXML.createProcessingInstruction("xml", " version=""1.0"""), oRoot
    
    For i = 1 To 10
        Set oCurrElem = oXML.createElement("item")
        oRoot.appendChild oCurrElem
        If i > 5 Then
            oCurrElem.setAttribute "someAttribute", CStr(i)
        End If
        oCurrElem.Text = sContentString
    Next
    sXML = oXML.xml

End Sub

Private Sub CheckBuildDocumentObjectA()
    Dim sXML As String
    Dim oXML As New DOMDocument
    Dim sContentString As String
    
    sContentString = "This is some text with a ""quote"" and &'s "
    sXML = "<?xml version=""1.0""?>" & vbCrLf
    sXML = sXML & "<items>"
    For i = 1 To 10
        sXML = sXML & "<item "
        If i > 5 Then
            sXML = sXML & "someAttribute=""" & i & """"
        End If
        sXML = sXML & replaceSpecialChars(sContentString)
        sXML = sXML & "</item>"
    Next
    sXML = sXML & "</items>"
    oXML.loadXML sXML

End Sub
Private Sub CheckBuildDocumentObjectB()
    Dim sXML As String
    Dim oXML As New DOMDocument
    Dim oRoot As IXMLDOMElement
    Dim oCurrElem As IXMLDOMElement
    Dim sContentString As String
    
    sContentString = "This is some text with a ""quote"" and &'s "
    
    Set oRoot = oXML.createElement("items")
    Set oXML.documentElement = oRoot
    oXML.insertBefore oXML.createProcessingInstruction("xml", " version=""1.0"""), oRoot
    
    For i = 1 To 10
        Set oCurrElem = oXML.createElement("item")
        oRoot.appendChild oCurrElem
        If i > 5 Then
            oCurrElem.setAttribute "someAttribute", CStr(i)
        End If
        oCurrElem.Text = sContentString
    Next

End Sub


Private Sub CheckBuildDocumentObject()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckBuildDocumentObjectA
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckBuildDocumentObjectB
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub


Private Sub CheckBuildDocumentStringVar()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            ScriptControl1.Run "CheckBuildDocumentStringVarA"
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            ScriptControl1.Run "CheckBuildDocumentStringVarB"
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub
Private Sub CheckBuildDocumentObjectVar()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    Dim Params(0)
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            ScriptControl1.Run "CheckBuildDocumentObjectVarA"
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            ScriptControl1.Run "CheckBuildDocumentObjectVarB"
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckLoadDocumentA()
    Dim oXML As New DOMDocument
    
    oXML.async = False
    oXML.validateOnParse = True
    oXML.Load App.Path & "\macbeth.xml"

End Sub
Private Sub CheckLoadDocumentB()
    Dim oXML As New DOMDocument
    
    oXML.async = False
    oXML.validateOnParse = False
    oXML.Load App.Path & "\macbeth.xml"

End Sub


Private Sub CheckLoadDocument()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckLoadDocumentA
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckLoadDocumentB
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub oEventTester_ParseReady(ByVal dTime As Double, parseType As DOMorSAX)
    MSFlexGrid1.Row = 1 + i
    If parseType = SAX Then
        MSFlexGrid1.Col = 1
    Else
        MSFlexGrid1.Col = 2
    End If
    MSFlexGrid1.Text = Format(dTime, "##0.000")
    
End Sub

Private Sub CheckDOMSAX()
    
    MsgBox "Because of the asynchronous architecture of SAX parsing, the iterations are ignored in this case (purely for conveniance). " & vbCrLf & _
            "If your version of ActiveSAX is a free version, you will be nagged." & vbCrLf & _
            "This does not affect the performance measurements."
    
    For i = 1 To testnr
        Set oEventTester = New SAXtester
        oEventTester.StartSax
        Sleep (300)
    Next
    For i = 1 To testnr
        Set oEventTester = New SAXtester
        oEventTester.StartDOM
        Sleep (300)
    Next
    

End Sub

Private Sub CheckAccessID()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    Dim oXML As New DOMDocument
    oXML.Load App.Path & "\idholding.xml"

    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckAccessIDA oXML
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckAccessIDB oXML
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckAccessIDA(oDOM As DOMDocument)
    Dim sResult As String
    
    sResult = oDOM.selectSingleNode("//PERSONA[@persid='p8']").Text

End Sub
Private Sub CheckAccessIDB(oDOM As DOMDocument)
    Dim sResult As String
    
    sResult = oDOM.nodeFromID("p8").Text
End Sub


Private Sub CheckAccessXPath()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    Dim oXML As New DOMDocument
    oXML.Load App.Path & "\macbeth.xml"

    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckAccessXPathA oXML
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckAccessXPathB oXML
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckAccessXPathA(oDOM As DOMDocument)
    Dim lResult As Long
    
    lResult = oDOM.selectNodes("//*[text()='MACBETH']").length

End Sub
Private Sub CheckAccessXPathB(oDOM As DOMDocument)
    Dim lResult As Long
    
    lResult = oDOM.selectNodes("/PLAY/ACT/SCENE/SPEECH/SPEAKER[text()='MACBETH']").length
End Sub

Private Sub CheckThread()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    Dim oDOM As New DOMDocument
    Dim oDOMFT As New DOMFreeThreadedDocument
    Dim oAttr As IXMLDOMElement
    
    oDOM.Load App.Path & "\idholding.xml"
    oDOMFT.Load App.Path & "\idholding.xml"

    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Set oAttr = oDOM.nodeFromID("p8")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckThreadA oAttr
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Set oAttr = oDOMFT.nodeFromID("p8")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckThreadB oAttr
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckThreadA(oElem As IXMLDOMElement)
    oElem.setAttribute "persid", "p8"
End Sub
Private Sub CheckThreadB(oElem As IXMLDOMElement)
    oElem.setAttribute "persid", "p8"
End Sub


Private Sub calcAverage()
    Dim dSum As Double
    Dim dMax As Double
    Dim dMin As Double
    Dim iCount As Integer
    Dim i As Integer
    Dim dValue As Double
    Dim dFirstCol As Double
    
    MSFlexGrid1.Col = 1
    
    iCount = 0
    dSum = 0
    dMax = 0
    dMin = -1
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        dValue = CDbl(MSFlexGrid1.Text)
        dSum = dSum + dValue
        If dMax < dValue Then dMax = dValue
        If (dMin > dValue Or dMin = -1) Then dMin = dValue
        iCount = iCount + 1
    Next
    
    MSFlexGrid1.Row = 2 + testnr
    MSFlexGrid1.Text = CStr(dSum - dMax - dMin)
    dFirstCol = dSum - dMax - dMin
    
    
    MSFlexGrid1.Row = 3 + testnr
    MSFlexGrid1.Text = "100%"
        

    ' Now the second column

    MSFlexGrid1.Col = 2
    iCount = 0
    dSum = 0
    dMax = 0
    dMin = -1
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        dValue = CDbl(MSFlexGrid1.Text)
        dSum = dSum + dValue
        If dMax < dValue Then dMax = dValue
        If (dMin > dValue Or dMin = -1) Then dMin = dValue
        iCount = iCount + 1
    Next
    
    MSFlexGrid1.Row = 2 + testnr
    MSFlexGrid1.Text = CStr(dSum - dMax - dMin)
    
    
    MSFlexGrid1.Row = 3 + testnr
    MSFlexGrid1.Text = CStr(Round(((dSum - dMax - dMin) / dFirstCol) * 100, 1)) + "%"
    

End Sub
Private Sub Checkintext(bValidating As Boolean)
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    Dim oDoc As New DOMDocument
    
    oDoc.async = False
    oDoc.validateOnParse = bValidating
    oDoc.resolveExternals = bValidating
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            oDoc.Load (App.Path & "\family.xml")
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            oDoc.Load (App.Path & "\family_ext.xml")
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub
Private Sub CheckEncodings2(enc As String)
    Dim sXML As String
    Dim oXML As New DOMDocument
    Dim oRoot As IXMLDOMElement
    Dim oCurrElem As IXMLDOMElement
    Dim sContentString As String
    
    sContentString = "This is some text with a ""quote"" and &'s "
    
    Set oRoot = oXML.createElement("items")
    Set oXML.documentElement = oRoot
    oXML.insertBefore oXML.createProcessingInstruction("xml", " version=""1.0"" encoding=""" & enc & """"), oRoot
    
    For i = 1 To 10
        Set oCurrElem = oXML.createElement("item")
        oRoot.appendChild oCurrElem
        If i > 5 Then
            oCurrElem.setAttribute "someAttribute", CStr(i)
        End If
        oCurrElem.Text = sContentString
    Next
    sXML = oXML.xml

End Sub

Private Sub CheckTransform()
    Dim liStarttime As LARGE_INTEGER
    Dim liEndtime As LARGE_INTEGER
    Dim i As Long
    Dim j As Long
    
    For i = 1 To testnr
        MSFlexGrid1.Row = 1 + i
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckTransformA
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 1
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
        Call QueryPerformanceCounter(liStarttime)
        For j = 1 To lIterations
            CheckTransformB
        Next
        Call QueryPerformanceCounter(liEndtime)
        MSFlexGrid1.Col = 2
        MSFlexGrid1.Text = Format(getSecondsDifference(liStarttime, liEndtime), "##0.000")
     Next
    
End Sub

Private Sub CheckTransformA()
    Dim oDoc As New DOMDocument
    Dim oXSL As New DOMDocument
    Dim sResult As String
    
    oDoc.Load (App.Path & "\family.xml")
    oXSL.Load (App.Path & "\family.xsl")
    
    sResult = oDoc.transformNode(oXSL)

End Sub
Private Sub CheckTransformB()
    Dim oDoc As New DOMDocument
    Dim oList As IXMLDOMNodeList
    Dim oElem As IXMLDOMElement
    Dim sResult As String
    
    oDoc.Load (App.Path & "\family.xml")
    
    sResult = "<HTML><HEAD></HEAD><BODY><UL>"
    Set oList = oDoc.selectNodes("//PERSON")
    For i = 0 To oList.length - 1
        Set oElem = oList.Item(i)
        sResult = sResult & "<LI><B>" & oElem.getAttribute("name") & "</B></LI>"
    Next
    
    Set oList = oDoc.selectNodes("//PET")
    For i = 0 To oList.length - 1
        Set oElem = oList.Item(i)
        sResult = sResult & "<LI>" & oElem.getAttribute("name") & " (" & oElem.getAttribute("type") & ")</LI>"
    Next
    
    sResult = sResult & "</UL></BODY></HTML>"

End Sub

