<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="Article"><HTML><BODY>
<xsl:apply-templates select="Title"/>
<xsl:apply-templates select="Intro"/>
<xsl:apply-templates select="Body"/>
<xsl:apply-templates select="Authors"/>
<xsl:apply-templates select="Related"/>

<xsl:apply-templates select="document(/Article/Allarticles/ID)//Author"/>

</BODY>
</HTML>
</xsl:template>

<xsl:template match="Title"><H1><xsl:apply-templates/></H1></xsl:template>

<xsl:template match="Intro"><p style="width:80%;font-weight:bold"><xsl:apply-templates/></p></xsl:template>

<xsl:template match="Body"><p style="width:80%"><xsl:apply-templates/></p></xsl:template>

<xsl:template match="Item"><xsl:if test="@type='URL'">
	<a href="{@loc}"><xsl:value-of select="."/></a>
</xsl:if>
<xsl:if test="@type='local'">
	<a href="art{@loc}.htm"><xsl:value-of select="document(concat('art', @loc, '.xml'))/Article/Title"/></a>
	(<xsl:apply-templates select="document(concat('art', @loc, '.xml'))/Article/Authors/Author"/>)
</xsl:if>
<br/>
</xsl:template>

<xsl:template match="Authors"><p>Author(s): <xsl:apply-templates select="Author"/></p></xsl:template>

<xsl:template match="Author"><xsl:apply-templates/>
<xsl:if test="position() != last()">,
</xsl:if>
</xsl:template>


<xsl:template match="Related"><p>Related items:<br/>
<xsl:apply-templates/></p></xsl:template>

</xsl:stylesheet>
