<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/Article">
		<HTML>
			<BODY>
				<xsl:apply-templates select="/Article/Title"/>
				<xsl:apply-templates select="/Article/Intro"/>
				<xsl:apply-templates select="/Article/Body"/>
				<xsl:apply-templates select="/Article/Authors"/>
				<xsl:apply-templates select="/Article/Related"/>
			</BODY>
		</HTML>
	</xsl:template>
	<xsl:template match="/Article/Title">
		<H1>
			<xsl:apply-templates />
		</H1>
	</xsl:template>
	<xsl:template match="/Article/Intro">
		<p style="width:80%;font-weight:bold">
			<xsl:apply-templates />
		</p>
	</xsl:template>
	<xsl:template match="/Article/Body">
		<p style="width:80%">
			<xsl:apply-templates />
		</p>
	</xsl:template>
	<xsl:template match="/Article/Authors">
		<p>
			Author(s):
			<xsl:apply-templates select="/Article/Authors/Author"/>
		</p>
	</xsl:template>
	<xsl:template match="/Article/Authors/Author">
		<xsl:apply-templates />
		<xsl:if test="position() != last()">,</xsl:if>
	</xsl:template>
	<xsl:template match="/Article/Related">
		<p>
			Related items:
			<br/>
			<xsl:apply-templates select="/Article/Related/Item"/>
		</p>
	</xsl:template>
	<xsl:template match="/Article/Related/Item">
		<xsl:if test="@type='URL'">
			<a href="{@loc}">
				<xsl:apply-templates />
			</a>
		</xsl:if>
		<xsl:if test="@type='local'">
			<a href="art{@loc}.htm">
				<xsl:value-of select="document(concat('art', @loc, '.xml'))/Article/Title"/>
			</a>
			(
			<xsl:apply-templates select="document(concat('art', @loc, '.xml'))/Article/Authors/Author"/>
			)
		</xsl:if>
		<br/>
	</xsl:template>
</xsl:stylesheet>
