VERSION 5.00
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "SHDOCVW.DLL"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{48E59290-9880-11CF-9754-00AA00C00908}#1.0#0"; "MSINET.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "HTTP Send & Receive"
   ClientHeight    =   8610
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   9525
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   8610
   ScaleWidth      =   9525
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txtLocalPort 
      Height          =   330
      Left            =   7455
      TabIndex        =   27
      Text            =   "80"
      Top             =   105
      Width           =   750
   End
   Begin VB.TextBox txtLocalIP 
      Height          =   345
      Left            =   1260
      TabIndex        =   25
      Text            =   "127.0.0.1"
      Top             =   105
      Width           =   4950
   End
   Begin VB.Frame fRole 
      Caption         =   "Role"
      Height          =   960
      Left            =   6720
      TabIndex        =   22
      Top             =   630
      Width           =   2115
      Begin VB.OptionButton optClient 
         Caption         =   "Clien&t"
         Height          =   195
         Left            =   210
         TabIndex        =   24
         Top             =   630
         Width           =   1485
      End
      Begin VB.OptionButton optServer 
         Caption         =   "Ser&ver"
         Height          =   225
         Left            =   210
         TabIndex        =   23
         Top             =   315
         Width           =   1275
      End
   End
   Begin VB.TextBox txtRemoteHost 
      Height          =   330
      Left            =   1260
      TabIndex        =   19
      Text            =   "127.0.0.1"
      Top             =   630
      Width           =   4950
   End
   Begin VB.TextBox txtMessages 
      Height          =   750
      Left            =   210
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   16
      Top             =   7665
      Width           =   7260
   End
   Begin VB.PictureBox picTab1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   4950
      Index           =   2
      Left            =   420
      ScaleHeight     =   4920
      ScaleWidth      =   6915
      TabIndex        =   13
      Top             =   2205
      Width           =   6945
      Begin VB.TextBox txtPostData 
         Appearance      =   0  'Flat
         Height          =   4845
         Left            =   0
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   15
         Top             =   0
         Width           =   6945
      End
   End
   Begin VB.PictureBox picTab1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   4950
      Index           =   1
      Left            =   420
      ScaleHeight     =   4920
      ScaleWidth      =   6810
      TabIndex        =   12
      Top             =   2205
      Width           =   6840
      Begin SHDocVwCtl.WebBrowser wbBrowser 
         Height          =   4635
         Left            =   105
         TabIndex        =   18
         Top             =   105
         Width           =   6315
         ExtentX         =   11139
         ExtentY         =   8176
         ViewMode        =   0
         Offline         =   0
         Silent          =   0
         RegisterAsBrowser=   0
         RegisterAsDropTarget=   1
         AutoArrange     =   0   'False
         NoClientEdge    =   0   'False
         AlignLeft       =   0   'False
         ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
         Location        =   ""
      End
   End
   Begin VB.PictureBox picTab1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   4950
      Index           =   0
      Left            =   420
      ScaleHeight     =   4920
      ScaleWidth      =   6915
      TabIndex        =   11
      Top             =   2205
      Width           =   6945
      Begin VB.TextBox txtHTTP 
         Height          =   4635
         Left            =   105
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   14
         Top             =   105
         Width           =   6630
      End
   End
   Begin MSComctlLib.TabStrip tabCtrls 
      Height          =   5475
      Left            =   210
      TabIndex        =   10
      Top             =   1785
      Width           =   7260
      _ExtentX        =   12806
      _ExtentY        =   9657
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   3
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Raw HTTP Stuff"
            Object.ToolTipText     =   "Cool stuff for cool people!"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Rendered HTML"
            Object.ToolTipText     =   "For the rest of the world"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "POST data"
            Object.ToolTipText     =   "No, not the cereal. Duh."
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   435
      Left            =   7770
      TabIndex        =   9
      Top             =   5880
      Width           =   1380
   End
   Begin VB.TextBox txtPage 
      Height          =   330
      Left            =   1260
      TabIndex        =   7
      Text            =   "/"
      Top             =   1050
      Width           =   4950
   End
   Begin VB.CommandButton cmdGet 
      Caption         =   "&Get"
      Height          =   435
      Left            =   7770
      TabIndex        =   6
      Top             =   4305
      Width           =   1380
   End
   Begin VB.CheckBox chkKeepAlive 
      Caption         =   "Keep &Alive"
      Height          =   225
      Left            =   7770
      TabIndex        =   5
      Top             =   2100
      Width           =   1275
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   250
      Left            =   1995
      Top             =   8715
   End
   Begin VB.CommandButton cmdDisconnect 
      Caption         =   "&Disconnect"
      Height          =   435
      Left            =   7770
      TabIndex        =   3
      Top             =   3045
      Width           =   1380
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "&Connect"
      Height          =   435
      Left            =   7770
      TabIndex        =   2
      Top             =   2520
      Width           =   1380
   End
   Begin VB.CommandButton cmdListen 
      Caption         =   "&Listen"
      Height          =   435
      Left            =   7770
      TabIndex        =   1
      Top             =   5040
      Width           =   1380
   End
   Begin InetCtlsObjects.Inet Inet1 
      Left            =   2940
      Top             =   8715
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
   End
   Begin VB.CommandButton cmdPost 
      Caption         =   "&Post"
      Height          =   435
      Left            =   7770
      TabIndex        =   0
      Top             =   3780
      Width           =   1380
   End
   Begin MSWinsockLib.Winsock sock 
      Left            =   1260
      Top             =   8715
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label lblLocalPort 
      AutoSize        =   -1  'True
      Caption         =   "Local port"
      Height          =   195
      Left            =   6615
      TabIndex        =   28
      Top             =   105
      Width           =   705
   End
   Begin VB.Label lblLocalIP 
      AutoSize        =   -1  'True
      Caption         =   "Local IP"
      Height          =   195
      Left            =   525
      TabIndex        =   26
      Top             =   105
      Width           =   585
   End
   Begin VB.Label lblState 
      AutoSize        =   -1  'True
      Caption         =   "State"
      Height          =   195
      Left            =   7665
      TabIndex        =   21
      Top             =   6615
      Width           =   375
   End
   Begin VB.Label lblRemoteHost 
      AutoSize        =   -1  'True
      Caption         =   "Remote host:"
      Height          =   195
      Left            =   165
      TabIndex        =   20
      Top             =   630
      Width           =   945
   End
   Begin VB.Label lblMessages 
      AutoSize        =   -1  'True
      Caption         =   "Messages"
      Height          =   195
      Left            =   210
      TabIndex        =   17
      Top             =   7455
      Width           =   720
   End
   Begin VB.Label lblPage 
      AutoSize        =   -1  'True
      Caption         =   "Page:"
      Height          =   195
      Left            =   690
      TabIndex        =   8
      Top             =   1050
      Width           =   420
   End
   Begin VB.Label lblStateText 
      AutoSize        =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   195
      Left            =   7665
      TabIndex        =   4
      Top             =   6825
      Width           =   75
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************************************************
' SoapClientServer EXE project
' Handles SOAP requests or submits HTTP calls
' frmMain
'************************************************
Option Explicit

Const MAXTABS As Integer = 3

Dim g_bDataDone As Boolean
Dim g_bListening As Boolean
Dim g_bSendComplete As Boolean
Dim asDataReceived() As String
Dim soapSrvUtils As SoapUtils.Utils
Dim HttpUtils As HttpUtils.Utils
Dim g_sSoapResponse As String
Dim g_bRequestedKeepAlive As Boolean
Dim asSockState(9) As String

Private Sub cmdConnect_Click()
    Connect
End Sub
'************************************************
' Sub Connect()
'************************************************
Sub Connect()
    On Error GoTo ErrHand
    
    If (sock.State = sckConnecting) Or (sock.State = sckConnected) Then
        txtMessages.Text = "Still coneecting, or already connected."
    Else
        sock.Protocol = sckTCPProtocol
        sock.Connect txtRemoteHost.Text, "80"
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        lblStateText.Caption = "Error"
        txtMessages = Err.Description
        MsgBox "Error: " & Err.Description, vbInformation, "Connect Error"
    End If
End Sub

Private Sub cmdDisconnect_Click()
    sock.Close
End Sub
'************************************************
' Sub webGET()
' Build the GET request inline and send it.
'************************************************
Sub webGET()
    On Error GoTo ErrHand
    Dim s As String

    s = "GET " & Trim$(txtPage.Text) & " HTTP/1.0" & Chr(10)
    s = s & "User-Agent: Wrox HTTP/1.0 (WinNT)" & Chr(10)
    If chkKeepAlive.Value Then
        s = s & "Connection: keep-alive" & Chr(10)
        lblStateText.Caption = "KEEP ALIVE"
    End If
    s = s & "Accept: *.*" & Chr(10) & Chr(10)
    If sock.State = sckConnected Then
        Call sock.SendData(s)
    Else
        txtMessages.Text = "Not connected!"
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error: " & Err.Description, vbInformation, "GET Error"
    End If
End Sub
'************************************************
' Sub webPOST()
' Build a POST request using the HttpUtils class
' and send it
'************************************************
Sub webPOST()
    On Error GoTo ErrHand
    Dim s As String
        
    With HttpUtils
        .HttpMethod = "POST"
        .HttpUri = txtPage
        .ContentType = "text/xml"
        .HttpVersion = "1.0"
        .HttpHost = txtRemoteHost.Text
        .UserAgent = "Wrox POSTer"
        .PostData = txtPostData.Text
        .SoapMethodHeader = GetSoapMethodName()
        s = .BuildPOSTRequest()
    End With
    If Len(s) Then
        txtMessages.Text = "Request string:" & vbCrLf & s
        If sock.State = sckConnected Then
            Call sock.SendData(s)
        Else
            MsgBox "Not connected!", vbExclamation, "Socket error"
        End If
    Else
        txtMessages.Text = "Request string error: " _
            & vbCrLf & HttpUtils.ErrorDescription
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error: " & Err.Description, vbInformation, "POST Error"
    End If
End Sub

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub cmdGet_Click()
    webGET
End Sub

Private Sub cmdListen_Click()
    Call Listen
End Sub
Private Sub Listen()
    On Error GoTo ErrHand
    sock.Protocol = sckTCPProtocol
    g_bListening = True
    sock.Bind txtLocalPort.Text, txtLocalIP.Text
    sock.Listen
    g_bDataDone = False
    
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error: " & Err.Description, vbInformation, "Listen Error"
    End If

End Sub
Private Sub cmdPost_Click()
    webPOST
End Sub
'************************************************
' Private Sub Form_Load()
' Do some initialization stuff
'************************************************
Private Sub Form_Load()
    Dim nIdx As Integer
    
    Set HttpUtils = New HttpUtils.Utils
    Set soapSrvUtils = New SoapUtils.Utils
    soapSrvUtils.LoadMethodBindings ("c:\SOAPBindings.xml")
    Call RenderHtml
    For nIdx = 0 To MAXTABS - 1
        picTab1(nIdx).Visible = False
        picTab1(nIdx).BackColor = frmMain.BackColor
        picTab1(nIdx).BorderStyle = 0
    Next
    
    picTab1(0).Visible = True
    InitSockStateArray
    Timer1.Enabled = True
    Timer1.Interval = 250
    g_bRequestedKeepAlive = False

End Sub
'************************************************
' Private Sub optClient_Click()
' Toggle valid commands
'************************************************
Private Sub optClient_Click()
    If (optClient.Value) Then
        cmdConnect.Enabled = True
        cmdDisconnect.Enabled = True
        cmdGet.Enabled = True
        cmdListen.Enabled = False
        cmdPost.Enabled = True
        txtLocalIP.Enabled = False
        txtLocalPort.Enabled = False
        txtRemoteHost.Enabled = True
        txtPage.Enabled = True
    End If
End Sub
'************************************************
' Private Sub optServer_Click()
' Toggle valid commands
'************************************************
Private Sub optServer_Click()
    If (optServer.Value) Then
        cmdConnect.Enabled = False
        cmdDisconnect.Enabled = True
        cmdGet.Enabled = False
        cmdListen.Enabled = True
        cmdPost.Enabled = False
        txtLocalIP.Enabled = True
        txtLocalPort.Enabled = True
        txtRemoteHost.Enabled = False
        txtPage.Enabled = False
    End If
End Sub

Private Sub sock_Close()
    sock.Close
End Sub

'************************************************
' Private Sub sock_ConnectionRequest(ByVal requestID As Long)
' Respond to the request, and handle SOAP calls
'************************************************
Private Sub sock_ConnectionRequest(ByVal requestID As Long)
    Dim sSend As String
    
    txtMessages.Text = "requestID = " & requestID
    g_bDataDone = False
    
    If sock.State <> sckClosed Then sock.Close
        sock.Accept requestID
    sSend = ""

    Do While g_bDataDone = False
        DoEvents
    Loop
    
    ' the SOAP response is built up in the data arrival event handler
    sSend = g_sSoapResponse
    g_bSendComplete = False
    sock.SendData sSend

    Do While Not g_bSendComplete
        DoEvents
    Loop
    sock.Close
    ' If we're the server, wait let the
    ' socket report itself closed ...
    If optServer.Value Then
        Do While sock.State <> sckClosed
            DoEvents
        Loop
        'then wait 2 seconds and start listening again ...
        Call ListenAgain(2)
    End If

End Sub
'******************************************************************
' Private Sub sock_DataArrival(ByVal bytesTotal As Long)
' Grab the incoming data, and process SOAP requests if we're a server
'******************************************************************
Private Sub sock_DataArrival(ByVal bytesTotal As Long)
    Dim sData As String
    Dim nIdx As Integer

    sock.GetData sData, vbString, bytesTotal

    ' Get rid of errant line terminators ...
    txtHTTP.Text = Replace(sData, Chr(10), vbCrLf)
    asDataReceived = Split(sData, Chr(10))

    ' If we're a server then try the SOAP stuff
    If optServer Then
        g_sSoapResponse = DoSoap(sData)
    End If
    
    g_bDataDone = True
End Sub

Private Sub sock_Error(ByVal Number As Integer, Description As String, _
                       ByVal sCode As Long, ByVal Source As String, _
                       ByVal HelpFile As String, ByVal HelpContext As Long, _
                       CancelDisplay As Boolean)
    txtMessages.Text = "Socket error " & CStr(Number) & _
        "; Desc: " & Description
End Sub

Private Sub sock_SendComplete()
    g_bSendComplete = True
End Sub
'*********************************************************
' Private Sub RenderHtml()
' Show the HTTP body as a web page.
'*********************************************************
Private Sub RenderHtml()
    On Error GoTo ErrHand
    
    Dim sHTML As String
    
    sHTML = HttpUtils.GetContent(txtHTTP.Text)
    
    ' See if there's anyhting to show ...
    If Len(sHTML) < 1 Then
        sHTML = "<HTML><BODY><H1>No data</H1></BODY></HTML>"
    End If
    
    wbBrowser.Navigate2 "about:" & sHTML
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error! " & Err.Description, vbCritical
    End If
End Sub

Private Sub SendResponse()

End Sub
Private Sub tabCtrls_Click()
   Dim nIdx As Integer
   For nIdx = 0 To 2
    picTab1(nIdx).Visible = False
    Next
   picTab1(tabCtrls.SelectedItem.Index - 1).Visible = True
   If (tabCtrls.SelectedItem.Index = 2) Then
    Call RenderHtml
   End If
End Sub
'************************************************
' Private Sub Timer1_Timer()
' Display the current state of the socket
'************************************************
Private Sub Timer1_Timer()
    lblStateText.Caption = asSockState(sock.State)
End Sub
'************************************************
' Private Function GetSoapMethodName() As String
'************************************************
Private Function GetSoapMethodName() As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sMethodName As String
    
    Set oDOM = New DOMDocument
    If oDOM.loadXML(txtPostData) Then
        Set oEl = oDOM.getElementsByTagName("SOAP:Body").Item(0)
        If Not oEl Is Nothing Then
            sMethodName = oEl.firstChild.baseName
        Else
            sMethodName = ""
        End If
    Else
        MsgBox "Error parsing POST data: " & oDOM.parseError.reason, _
            vbExclamation, "Parsing error"
        sMethodName = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error finding SOAP method name: " & Err.Description, vbCritical
        sMethodName = ""
    End If
    GetSoapMethodName = sMethodName
End Function


'************************************************
' Sub InitSockStateArray()
' Set up an array to make socket state display nicer.
'************************************************
Sub InitSockStateArray()
    asSockState(0) = "Closed"
    asSockState(1) = "Open"
    asSockState(2) = "Listening"
    asSockState(3) = "Connection pending"
    asSockState(4) = "Resolving host"
    asSockState(5) = "Host resolved"
    asSockState(6) = "Connecting"
    asSockState(7) = "Connected"
    asSockState(8) = "Closing"
    asSockState(9) = "Error"
End Sub
'************************************************
' Sub ListenAgain(dblWaitSeconds As Double)
' Even though the socket state may say "closed".
' we get errors if we try to listen right away.
' Pause for dblWaitSeconds seconds, then listen.
'************************************************
Sub ListenAgain(dblWaitSeconds As Double)
    Dim datLater As Date
    datLater = DateAdd("s", dblWaitSeconds, Now)
    Do While datLater > Now()
        DoEvents
    Loop
    Call Listen
End Sub
'************************************************
' Function DoSoap(sData As String) As String
' Take the SOAP body from the POST data and send it
' off to the SOAP server
'************************************************
Function DoSoap(sData As String) As String
    Dim sXml As String
    Dim sResults As String
    
    sXml = soapSrvUtils.GetSoapBody(sData)
    If Len(sXml) Then
        sResults = soapSrvUtils.ExecuteRequestWrapper(sXml)
        DoSoap = sResults
    Else
        DoSoap = "DoSoap error: " & sData
    End If
End Function
