VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Utils"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'**********************************************************
' Class HttpUtils.Utils
' Some funtions to help manage HTTP requests and responses
'**********************************************************
Option Explicit
Dim ClassErrors As ErrorUtils.ErrorInfo

Private m_sConnection As String     ' e.g., Keep-alive
Private m_sHttpVersion As String    ' e.g., 0.9, 1.0, or 1.1
Private m_sHttpMethod As String     ' PUT, GET, HEAD,
Private m_sHttpReferer As String    ' Where we came from
Private m_sUserAgent As String      ' Our "browser"
Private m_sContentType As String    ' E.g., text/xml
Private m_sContentBody As String    ' What we're sending
Private m_nContentLength As Integer ' Byte-length of the body
Private m_sHttpHost As String       ' Who we're calling
Private m_sLastModified As String   ' When our reponse data last changed
Private m_sHttpUri As String        ' The URI we're calling
Private m_sHttpAccept As String     ' Media formats the client can handle
Private m_nHttpStatusCode As Integer ' e.g. 200, or 404
Private m_sHttpServer As String     ' Name/version of responding server
Private m_sSoapMethodHeader As String   ' "SOAPMethodName" header content
Private m_sPostData As String       ' What we're sending in the POST

Public Property Get ErrorDescription() As String
    ErrorDescription = ClassErrors.Description
End Property

Public Property Get ErrorNumber() As Long
    ErrorNumber = ClassErrors.Number
End Property
Public Property Get ErrorLocation() As String
    ErrorLocation = ClassErrors.Location
End Property

Public Property Get ConnectionType() As String
    ConnectionType = m_sConnection
End Property

Public Property Let ConnectionType(sConnType As String)
    m_sConnection = sConnType
End Property

Public Property Get HttpVersion() As String
    HttpVersion = m_sHttpVersion
End Property

Public Property Let HttpVersion(sVersion As String)
    m_sHttpVersion = sVersion
End Property

Public Property Get HttpMethod() As String
    HttpMethod = m_sHttpMethod
End Property

Public Property Let HttpMethod(sMethod As String)
    m_sHttpMethod = sMethod
End Property

Public Property Get HttpReferer() As String
    HttpReferer = m_sHttpReferer
End Property

Public Property Get UserAgent() As String
    UserAgent = m_sUserAgent
End Property

Public Property Let UserAgent(sUA As String)
    m_sUserAgent = sUA
End Property

Public Property Get ContentType() As String
    ContentType = m_sContentType
End Property

Public Property Let ContentType(sContType As String)
    m_sContentType = sContType
End Property

Public Property Get ContentLength() As Integer
    ContentLength = m_nContentLength
End Property

Public Property Get HttpHost() As String
    HttpHost = m_sHttpHost
End Property

Public Property Let HttpHost(sHost As String)
    m_sHttpHost = sHost
End Property

Public Property Get LastModified() As String
    LastModified = m_sLastModified
End Property

Public Property Let LastModified(sDate As String)
    m_sLastModified = sDate
End Property

Public Property Get HttpUri() As String
    HttpUri = m_sHttpUri
End Property

Public Property Let HttpUri(sURI As String)
    m_sHttpUri = sURI
End Property

Public Property Get HttpAccept() As String
    HttpAccept = m_sHttpAccept
End Property

Public Property Get HttpServer() As String
    HttpServer = m_sHttpServer
End Property

Public Property Get HttpStatusCode() As Integer
    HttpStatusCode = m_nHttpStatusCode
End Property

Public Property Let HttpStatusCode(sCode As Integer)
    m_nHttpStatusCode = sCode
End Property

Public Property Get PostData() As String
    PostData = m_sPostData
End Property

Public Property Let PostData(sData As String)
    m_sPostData = sData
End Property

Public Property Get SoapMethodHeader() As String
    SoapMethodHeader = m_sSoapMethodHeader
End Property

Public Property Let SoapMethodHeader(sData As String)
    m_sSoapMethodHeader = sData
End Property


'**********************************************************
' Public Function GetContent(sResponse As String) As String
'**********************************************************
Public Function GetContent(sResponse As String) As String
    On Error GoTo ErrHand
    Dim asPost() As String
    Dim sContent As String
    ' The data should contain an empty line; actually,
    ' two consecutive vbLf. But it might not.
    ' Might have Chr(13) as well.
    sResponse = Replace(sResponse, vbCrLf, vbLf)
    asPost = Split(sResponse, vbLf & vbLf)
    If UBound(asPost) > 0 Then
        sContent = asPost(1)
    Else
        sContent = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        sContent = ""
    End If
    GetContent = sContent
End Function


'**********************************************************
' Public Function ParseResponse(sResponse As String) As Boolean
' For debugging. Not used in code
'**********************************************************
Public Function ParseResponse(sResponse As String) As Boolean
    On Error GoTo ErrHand
    
    Dim asResponse() As String
    Dim nIdx As Integer
    
    asResponse = Split(sResponse, vbLf)
    ParseResponse = True
    
ErrHand:
    If Err.Number <> 0 Then
        Call ClassErrors.SetErrorInfo(Err.Description, Err.Number, "CHTTPUtils.ParseResponse")
        ParseResponse = False
    End If
End Function

'**********************************************************
' Public Function BuildMPOSTRequest() As String
' Uses the class properties to construct an HTTP POST request.
' If any required information ismissing, it sets the Error properties
' and returns an empty string.  So, you can call this with
' If(Len(BuildMPOSTRequest())) then
'   ' OK
' Else
'   ' Error!
' End if
'**********************************************************
Public Function BuildMPOSTRequest() As String
    On Error GoTo ErrHand
    Dim sRq As String
    Dim sMissingData As String

    Call ClassErrors.ClearErrorInfo
    
    sRq = ""
    
    sMissingData = ""
    If Len(m_sHttpUri) < 1 Then
        sMissingData = "URI"
    ElseIf Len(m_sHttpVersion) < 1 Then
        sMissingData = "HTTP Version"
    ElseIf Len(m_sHttpHost) < 1 Then
        sMissingData = "HTTP Host"
    ElseIf Len(m_sUserAgent) < 1 Then
        sMissingData = "User Agent"
    ElseIf Len(m_sContentType) < 1 Then
        sMissingData = "Content Type"
    ElseIf Len(m_sSoapMethodHeader) < 1 Then
        sMissingData = "SoapMethodHeader"
    End If
    
    
    If Len(sMissingData) > 0 Then
        sRq = sRq & "POST /" & m_sHttpUri & " HTTP/" & m_sHttpVersion & vbLf
        sRq = sRq & "Host: " & m_sHttpHost & vbLf
        sRq = sRq & "User-Agent: " & m_sUserAgent & vbLf
        sRq = sRq & "Content-Length: " & CStr(Len(m_sPostData)) & vbLf
        sRq = sRq & "Man: urn:schemas-xmlsoap-org:soap.v1; ns=01" & vbLf
        sRq = sRq & "01-MessageType: Call" & Chr(1)
        sRq = sRq & "01-SOAPMethodName: " & m_sSoapMethodHeader & vbLf
        sRq = sRq & "Content-Type: " & m_sContentType & vbLf & vbLf
        sRq = sRq & m_sPostData
    Else
        sRq = ""
        Call ClassErrors.SetErrorInfo("Missing header information" _
        & sMissingData, -1, "CHTTPUtils.BuildMPOSTRequest")
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sRq = ""
        Call ClassErrors.SetErrorInfo(Err.Description, _
                Err.Number, "CHTTPUtils.BuildMPOSTRequest")
    End If
    
    BuildMPOSTRequest = sRq
End Function

'**********************************************************
' Public Function BuildPOSTRequest() As String
' Uses the class properties to construct an HTTP POST request.
' If any required information ismissing, it sets the Error properties
' and returns an empty string.  So, you can call this with
' If(Len(BuildPOSTRequest())) then
'   ' OK
' Else
'   ' Error!
' End if
'**********************************************************
Public Function BuildPOSTRequest() As String
    On Error GoTo ErrHand
    Dim sRq As String
    Dim sMissingData As String
    
    Call ClassErrors.ClearErrorInfo
    sRq = ""
    sMissingData = ""
    
    If Len(m_sHttpUri) < 1 Then
        sMissingData = "URI"
    ElseIf Len(m_sHttpVersion) < 1 Then
        sMissingData = "HTTP Version"
    ElseIf Len(m_sHttpHost) < 1 Then
        sMissingData = "HTTP Host"
    ElseIf Len(m_sUserAgent) < 1 Then
        sMissingData = "User Agent"
    ElseIf Len(m_sContentType) < 1 Then
        sMissingData = "Content Type"
    ElseIf Len(m_sSoapMethodHeader) < 1 Then
        sMissingData = "SoapMethodHeader"
    End If
    
    If Len(sMissingData) < 1 Then
        sRq = sRq & "POST /" & m_sHttpUri & " HTTP/" & m_sHttpVersion & vbLf
        sRq = sRq & "Host: " & m_sHttpHost & vbLf
        sRq = sRq & "SOAPMethodName: " & m_sSoapMethodHeader & vbLf
        sRq = sRq & "User-Agent: " & m_sUserAgent & vbLf
        sRq = sRq & "Content-Length: " & CStr(Len(m_sPostData)) & vbLf
        sRq = sRq & "Content-Type: " & m_sContentType & vbLf & vbLf
        sRq = sRq & m_sPostData
    Else
        sRq = ""
        Call ClassErrors.SetErrorInfo("Missing header information: " _
            & sMissingData, -1, "CHTTPUtils.BuildPOSTRequest")
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call ClassErrors.SetErrorInfo(Err.Description, Err.Number, _
            "CHTTPUtils.BuildPOSTRequest")
        sRq = ""
    End If
    
    BuildPOSTRequest = sRq
End Function

Public Function RetrieveHeaderItem(sHeaderType As String, sResponse As String) As String
    Dim nStart As Integer
    Dim nEnd As Integer
    Dim sValue As String
    sHeaderType = Trim(sHeaderType)
    If Right(sHeaderType, 1) <> ":" Then
        sHeaderType = sHeaderType & ":"
    End If
    nStart = InStr(1, sResponse, sHeaderType)
    nStart = nStart + Len(sHeaderType) + 1
    nEnd = InStr(nStart, sResponse, vbLf)
    sValue = Trim(Mid(sResponse, nStart, (nEnd - nStart)))
    
    RetrieveHeaderItem = sValue

End Function

Private Sub Class_Initialize()
    Set ClassErrors = New ErrorInfo
    Call ClassErrors.ClearErrorInfo
    m_sConnection = ""
    m_sHttpVersion = "1.0"
    m_sHttpMethod = ""
    m_sHttpReferer = """"
    m_sUserAgent = "Wrox VB-XML"
    m_sContentType = "text/html"
    m_sContentBody = ""
    m_nContentLength = 0
    m_sHttpHost = ""
    m_sLastModified = ""
    m_sHttpUri = ""
    m_sHttpAccept = "text/*"
    m_nHttpStatusCode = 500
    m_sHttpServer = "Wrox VB-XML/1.0"
End Sub

