VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "WebTx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'*********************************************************************
' Public Function BuildSoapRequestGetProductList() As String
'*********************************************************************
Public Function BuildSoapRequestGetProductList() As String
    Dim sSoap As String
    sSoap = ""
    sSoap = sSoap & "<SOAP:Envelope"
    sSoap = sSoap & " xmlns:SOAP='urn:schemas-xmlsoap-org:soap.v1' "
    sSoap = sSoap & " SOAP:encodingStyle="
    sSoap = sSoap & "'urn:schemas-xmlsoap-org:soap.v1'>" & vbLf
    sSoap = sSoap & " <SOAP:Body>" & vbLf
    sSoap = sSoap & "  <w:soapGetProductList "
    sSoap = sSoap & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
    sSoap = sSoap & "  </w:soapGetProductList>" & vbLf
    sSoap = sSoap & " </SOAP:Body>" & vbLf
    sSoap = sSoap & "</SOAP:Envelope>"
        
    BuildSoapRequestGetProductList = sSoap
End Function
'*********************************************************************
' Private Function BuildSoapRequestWrite(sXMLDoc As String) As String
'  Creates the XML for our SOAP request to
'*********************************************************************
Public Function BuildSoapRequestSaveProdFile(sProdXml As String) As String
    Dim sSoap As String
   
    If Len(sProdXml) > 0 Then
        sSoap = ""
        sSoap = sSoap & "<SOAP:Envelope"
        sSoap = sSoap & " xmlns:SOAP='urn:schemas-xmlsoap-org:soap.v1' "
        sSoap = sSoap & " SOAP:encodingStyle="
        sSoap = sSoap & "'urn:schemas-xmlsoap-org:soap.v1'>" & vbLf
        sSoap = sSoap & " <SOAP:Body>" & vbLf
        sSoap = sSoap & "  <w:soapSaveProductFile "
        sSoap = sSoap & " xmlns:w='www.wrox.com/VbXml'>" & vbLf
        sSoap = sSoap & "   <doc>" & vbLf
        sSoap = sSoap & sProdXml & vbLf
        sSoap = sSoap & "   </doc>" & vbLf
        sSoap = sSoap & "  </w:soapSaveProductFile>" & vbLf
        sSoap = sSoap & " </SOAP:Body>" & vbLf
        sSoap = sSoap & "</SOAP:Envelope>"
    Else
        sSoap = ""
    End If
    
    BuildSoapRequestSaveProdFile = sSoap
End Function

'**********************************************************
' Public Function GetSoapBody(sPostData As String) As String
' Retrieves the XML from the http post results
'**********************************************************
Public Function GetSoapBody(ByVal sPostData As String) As String
    On Error GoTo ErrHand
    Dim asPost() As String
    Dim sXML As String
    ' The data should contain an empty line; actually,
    ' two consecutive vbLf. But it might not.
    sPostData = Replace(sPostData, vbCrLf, vbLf)
    asPost = Split(sPostData, vbLf & vbLf)
    If UBound(asPost) > 0 Then
        sXML = asPost(1)
    Else
       MsgBox "Error extracting SOAP body from response.", _
        vbExclamation, "Error"
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error extracting SOAP body from response:" & _
            Err.Description, vbExclamation, "Error"
        sXML = ""
    End If
    GetSoapBody = sXML
End Function

'**********************************************************
' Public Function GetReturnedDoc(sSoapBody As String) As String
' Extracts the product file contained in the <doc> element of
' a SOAP response.
'**********************************************************
Public Function GetReturnedDoc(sSoapBody As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As DOMDocument
    Dim sDoc As String
    Dim oEl As IXMLDOMElement
    
    Set oDOM = New DOMDocument
    If Not oDOM.loadXML(sSoapBody) Then
        sDoc = ""
    Else
        Set oEl = oDOM.getElementsByTagName("doc").Item(0)
        sDoc = oEl.childNodes(0).xml
    End If

ErrHand:
    If Err.Number <> 0 Then
        sDoc = ""
    End If
    GetReturnedDoc = sDoc
End Function
'********************************************************************************
' Public Function DisplayFileList(sXML As String) As Boolean
'********************************************************************************
Public Function DisplayFileList(sXML As String) As Boolean
    Dim oDOM As DOMDocument
    Dim sItem As String
    Dim oEl As IXMLDOMElement
    Dim oNodeList As IXMLDOMNodeList
    Dim nIdx As Integer
    Dim bResults As Boolean
    
    Dim sProdID As String
    Dim sCategory As String
    Dim sName As String
    Dim sURI As String
    
    Set oDOM = New DOMDocument
    If oDOM.loadXML(sXML) Then
    
        Load frmWebFileList
        Set oNodeList = oDOM.getElementsByTagName("Row")
        For nIdx = 0 To oNodeList.length - 1
            Set oEl = oNodeList.Item(nIdx)
            sProdID = oEl.Attributes.getNamedItem("ProdID").nodeValue
            sCategory = oEl.Attributes.getNamedItem("Category").nodeValue
            If Len(Trim(sCategory)) < 1 Then
                sCategory = String(10, " ")
            End If
            
            sName = oEl.Attributes.getNamedItem("Name").nodeValue
            If Len(Trim(sName)) < 1 Then
                sName = String(10, " ")
            End If
            
            sURI = oEl.Attributes.getNamedItem("XmlDetails").nodeValue
            
            sItem = sProdID & vbTab & sName & vbTab & sCategory & vbTab & sURI
            If Not frmWebFileList.AddItem(sItem) Then
                bResults = False
            End If
        Next
        frmWebFileList.Show
    Else
        bResults = False
        MsgBox "Error displaying list of files", vbExclamation, "Error"
    End If
    
    DisplayFileList = bResults
End Function

Public Function GetListData(sSoapBody As String) As String
    Dim oDOM As DOMDocument
    Dim sXML As String
    Dim oEl As IXMLDOMElement
        
    Set oDOM = New DOMDocument
    If oDOM.loadXML(sSoapBody) Then
        Set oEl = oDOM.getElementsByTagName("list").Item(0)
        sXML = oEl.xml
    Else
        sXML = ""
    End If
    GetListData = sXML
    
End Function

'********************************************************************************
' Public Function RetrieveFile(sURL As String) As String
' Makes HTTP request to get XML file from server, returns the XML
'********************************************************************************
Public Function RetrieveFile(sURL As String) As String
    On Error GoTo ErrHand
    Dim oHttpRq As MSXML.XMLHTTPRequest
    Dim oDomResponse As DOMDocument
    Dim sXML As String
    Set oDomResponse = New DOMDocument
    
    Set oHttpRq = New XMLHTTPRequest
    
    oHttpRq.open "GET", sURL, False
    oHttpRq.send
    Set oDomResponse = oHttpRq.responseXML
    RetrieveFile = oDomResponse.xml
ErrHand:
    If Err.Number <> 0 Then
        RetrieveFile = ""
    End If
End Function
