VERSION 5.00
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "SHDOCVW.DLL"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{41C8FEA5-A5E7-4FC5-B084-4314B3D03682}#1.0#0"; "XmlText.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Product Info Editor"
   ClientHeight    =   6120
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   13290
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6120
   ScaleWidth      =   13290
   StartUpPosition =   2  'CenterScreen
   Begin MSComDlg.CommonDialog dlgOpen 
      Left            =   6720
      Top             =   5775
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin SHDocVwCtl.WebBrowser wbPreview 
      Height          =   5475
      Left            =   6720
      TabIndex        =   1
      Top             =   105
      Width           =   6420
      ExtentX         =   11324
      ExtentY         =   9657
      ViewMode        =   0
      Offline         =   0
      Silent          =   0
      RegisterAsBrowser=   0
      RegisterAsDropTarget=   1
      AutoArrange     =   0   'False
      NoClientEdge    =   0   'False
      AlignLeft       =   0   'False
      ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
      Location        =   "res://C:\WINNT\system32\shdoclc.dll/dnserror.htm#http:///"
   End
   Begin TabDlg.SSTab tabCtl 
      Height          =   5685
      Left            =   315
      TabIndex        =   0
      Top             =   210
      Width           =   6105
      _ExtentX        =   10769
      _ExtentY        =   10028
      _Version        =   393216
      Tabs            =   4
      TabsPerRow      =   2
      TabHeight       =   520
      TabCaption(0)   =   "Product Essentials"
      TabPicture(0)   =   "frmMain.frx":0000
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "lblProdID"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "lblProdName"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "lblMftID"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).Control(3)=   "lblProdCategory"
      Tab(0).Control(3).Enabled=   0   'False
      Tab(0).Control(4)=   "lblPrice"
      Tab(0).Control(4).Enabled=   0   'False
      Tab(0).Control(5)=   "txtProductID"
      Tab(0).Control(5).Enabled=   0   'False
      Tab(0).Control(6)=   "txtProductName"
      Tab(0).Control(6).Enabled=   0   'False
      Tab(0).Control(7)=   "txtMftID"
      Tab(0).Control(7).Enabled=   0   'False
      Tab(0).Control(8)=   "lstProductCategory"
      Tab(0).Control(8).Enabled=   0   'False
      Tab(0).Control(9)=   "txtPrice"
      Tab(0).Control(9).Enabled=   0   'False
      Tab(0).ControlCount=   10
      TabCaption(1)   =   "Product Description"
      TabPicture(1)   =   "frmMain.frx":001C
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "xmlTxtProductDesc"
      Tab(1).Control(1)=   "txtMessages"
      Tab(1).Control(2)=   "cmbElements"
      Tab(1).Control(3)=   "lblXmlErrors"
      Tab(1).Control(4)=   "lblElements"
      Tab(1).ControlCount=   5
      TabCaption(2)   =   "Related Products"
      TabPicture(2)   =   "frmMain.frx":0038
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "lstRelatedProducts"
      Tab(2).Control(1)=   "lstPickAvailProds"
      Tab(2).Control(2)=   "lblRemoveRelProd"
      Tab(2).Control(3)=   "lblRelProds"
      Tab(2).Control(4)=   "Label1"
      Tab(2).ControlCount=   5
      TabCaption(3)   =   "Related URLs"
      TabPicture(3)   =   "frmMain.frx":0054
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "lblUrslHelp1"
      Tab(3).Control(1)=   "lblUrlHelp2"
      Tab(3).Control(2)=   "cmbUrls"
      Tab(3).ControlCount=   3
      Begin VB.TextBox txtPrice 
         Height          =   330
         Left            =   1890
         TabIndex        =   22
         Text            =   "$0.00"
         Top             =   2415
         Width           =   3795
      End
      Begin XmlText.XmlTextbox xmlTxtProductDesc 
         Height          =   3270
         Left            =   -74685
         TabIndex        =   21
         Tag             =   "<DESCRIPTION>"
         Top             =   1470
         Width           =   5370
         _ExtentX        =   9472
         _ExtentY        =   5768
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BorderStyle     =   1
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         ParseErrorReason=   $"frmMain.frx":0070
      End
      Begin VB.ListBox lstRelatedProducts 
         Height          =   2400
         ItemData        =   "frmMain.frx":00A1
         Left            =   -74685
         List            =   "frmMain.frx":00A3
         TabIndex        =   18
         Top             =   2730
         Width           =   5265
      End
      Begin VB.ListBox lstPickAvailProds 
         Height          =   1230
         ItemData        =   "frmMain.frx":00A5
         Left            =   -74685
         List            =   "frmMain.frx":00A7
         Sorted          =   -1  'True
         TabIndex        =   16
         Top             =   1050
         Width           =   5265
      End
      Begin VB.TextBox txtMessages 
         ForeColor       =   &H000000FF&
         Height          =   435
         Left            =   -74685
         MultiLine       =   -1  'True
         TabIndex        =   14
         Top             =   5040
         Width           =   5265
      End
      Begin VB.ComboBox cmbElements 
         Height          =   315
         Left            =   -72375
         TabIndex        =   13
         Top             =   1050
         Width           =   2955
      End
      Begin VB.ComboBox cmbUrls 
         Height          =   3495
         Left            =   -74685
         Style           =   1  'Simple Combo
         TabIndex        =   10
         Top             =   1155
         Width           =   5370
      End
      Begin VB.ListBox lstProductCategory 
         Height          =   2010
         Left            =   1890
         TabIndex        =   9
         Top             =   3150
         Width           =   3795
      End
      Begin VB.TextBox txtMftID 
         Height          =   285
         Left            =   1890
         TabIndex        =   7
         Text            =   "00000"
         Top             =   1995
         Width           =   3795
      End
      Begin VB.TextBox txtProductName 
         Height          =   285
         Left            =   1890
         TabIndex        =   5
         Top             =   1470
         Width           =   3795
      End
      Begin VB.TextBox txtProductID 
         Enabled         =   0   'False
         Height          =   285
         Left            =   1890
         TabIndex        =   3
         Text            =   "000000"
         Top             =   1050
         Width           =   3795
      End
      Begin VB.Label lblXmlErrors 
         Caption         =   "XML Errors"
         Height          =   225
         Left            =   -74685
         TabIndex        =   24
         Top             =   4830
         Width           =   2115
      End
      Begin VB.Label lblPrice 
         AutoSize        =   -1  'True
         Caption         =   "Retail price:"
         Height          =   195
         Left            =   210
         TabIndex        =   23
         Top             =   2415
         Width           =   840
      End
      Begin VB.Label lblRemoveRelProd 
         AutoSize        =   -1  'True
         Caption         =   "Double-click an item to remove it."
         Height          =   195
         Left            =   -74685
         TabIndex        =   20
         Top             =   5250
         Width           =   2355
      End
      Begin VB.Label lblRelProds 
         AutoSize        =   -1  'True
         Caption         =   "... to add to this list"
         Height          =   195
         Left            =   -74685
         TabIndex        =   19
         Top             =   2520
         Width           =   1320
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Double-click on on an item ..."
         Height          =   195
         Left            =   -74685
         TabIndex        =   17
         Top             =   840
         Width           =   2070
      End
      Begin VB.Label lblElements 
         AutoSize        =   -1  'True
         Caption         =   "Elements"
         Height          =   195
         Left            =   -70065
         TabIndex        =   15
         Top             =   840
         Width           =   645
      End
      Begin VB.Label lblUrlHelp2 
         AutoSize        =   -1  'True
         Caption         =   "Double-click an item to remove."
         Height          =   195
         Left            =   -74685
         TabIndex        =   12
         Top             =   5145
         Width           =   2235
      End
      Begin VB.Label lblUrslHelp1 
         AutoSize        =   -1  'True
         Caption         =   "Enter text and press ""Enter"" to add URL."
         Height          =   195
         Left            =   -74685
         TabIndex        =   11
         Top             =   4830
         Width           =   2895
      End
      Begin VB.Label lblProdCategory 
         AutoSize        =   -1  'True
         Caption         =   "Product category:"
         Height          =   300
         Left            =   210
         TabIndex        =   8
         Top             =   3150
         Width           =   1260
      End
      Begin VB.Label lblMftID 
         AutoSize        =   -1  'True
         Caption         =   "Manufactuer's ID:"
         Height          =   195
         Left            =   210
         TabIndex        =   6
         Top             =   1995
         Width           =   1260
      End
      Begin VB.Label lblProdName 
         AutoSize        =   -1  'True
         Caption         =   "Product name:"
         Height          =   195
         Left            =   210
         TabIndex        =   4
         Top             =   1470
         Width           =   1035
      End
      Begin VB.Label lblProdID 
         AutoSize        =   -1  'True
         Caption         =   "Product ID"
         Height          =   195
         Left            =   210
         TabIndex        =   2
         Top             =   1050
         Width           =   765
      End
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&Local"
      Begin VB.Menu mnuNew 
         Caption         =   "&New"
      End
      Begin VB.Menu mnuLocalOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuLocalSave 
         Caption         =   "&Save"
      End
      Begin VB.Menu mnuPreview 
         Caption         =   "&Preview"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuWeb 
      Caption         =   "&Web"
      Begin VB.Menu mnuWebOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuWebSave 
         Caption         =   "&Save"
      End
      Begin VB.Menu mnuWebConfig 
         Caption         =   "&Configure"
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "Editing &Options"
      Begin VB.Menu mnuDisableAngles 
         Caption         =   "Disable < and >"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuAutoCheck 
         Caption         =   "&Auto-check"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuLoadRes 
         Caption         =   "&Load resource"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'**********************************************************************
' Product Information XML Editor
'**********************************************************************
Option Explicit

Dim oSoapRqst As SoapRequest.XmlHttp  ' SOAP posting DLL
Dim oWebTx As WebTx                   ' Our SOAP tools
Dim g_bLoadComplete As Boolean
Dim g_nSelTextLocation As Integer

Private oWroxRes As IResFile.ILoadRes

Const APPNAME As String = "Wrox Product Editor" ' For SOAP settings in registry

'********************************************************************************
' Private Sub cmbElements_Click()
' Adds element to XML text box text at selection point
'********************************************************************************
Private Sub cmbElements_Click()
    Dim sEl As String
    xmlTxtProductDesc.SelStart = g_nSelTextLocation
    sEl = cmbElements.List(cmbElements.ListIndex)
    xmlTxtProductDesc.SelText = "<" & sEl & "></" & sEl & ">"
End Sub

Private Sub cmbUrls_DblClick()
    cmbUrls.RemoveItem (cmbUrls.ListIndex)
End Sub

Private Sub cmbUrls_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = Asc(vbCr) Then
        cmbUrls.AddItem (cmbUrls.Text)
    End If
End Sub

Private Sub Form_Load()
    
    Set oSoapRqst = New SoapRequest.XmlHttp ' SOAP posting DLL
    Set oWebTx = New WebTx                  ' SOAP tools
    
    ' Get out RES data object
    Set oWroxRes = CreateObject("WroxEditorRes.LoadRes")
    
    ' Set up our lists
    Call PopulateCategoryList
    Call PopulateElementList
    Call PopulatePickRelatedProductsList
    
    ' Set the product description XML to a default entry:
    Call SetXmlDefault
    xmlTxtProductDesc.AutoCheck = True
    xmlTxtProductDesc.NoUserElements = True
    
    ' Get our SOAP config info from registry
    g_sSoapUrl = GetSetting(APPNAME, "Startup", "SoapUrl")
    g_sTxNamespace = GetSetting(APPNAME, "Startup", "TxNamespace")
 
   
End Sub

Private Sub lstPickAvailProds_DblClick()
    lstRelatedProducts.AddItem (lstPickAvailProds.List(lstPickAvailProds.ListIndex))
    lstPickAvailProds.RemoveItem (lstPickAvailProds.ListIndex)
End Sub

Private Sub lstRelatedProducts_DblClick()
    lstPickAvailProds.AddItem (lstRelatedProducts.List(lstRelatedProducts.ListIndex))
    lstRelatedProducts.RemoveItem (lstRelatedProducts.ListIndex)
    
End Sub

Private Sub mnuAutoCheck_Click()
    mnuAutoCheck.Checked = Not mnuAutoCheck.Checked
    xmlTxtProductDesc.AutoCheck = mnuAutoCheck.Checked
End Sub

Private Sub mnuDisableAngles_Click()
    mnuDisableAngles.Checked = Not (mnuDisableAngles.Checked)
    xmlTxtProductDesc.NoUserElements = mnuDisableAngles.Checked
End Sub

Private Sub mnuExit_Click()
    End
End Sub
Private Sub mnuLoadRes_Click()
    Call LoadRes
End Sub
'********************************************************************************
' Private Sub LoadRes()
' Loads  a resource DLL and populates form lists
'********************************************************************************
Private Sub LoadRes()
    On Error GoTo ErrHand
    
    Dim sDllName As String
    Dim strFilefilter  As String
    Dim strFilename As String
    Dim asTemp() As String
    Dim sLastEl As Integer
    
    strFilefilter = "DLL Files (*.dll)|*.dll|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CancelError = True
        .Filter = strFilefilter
        .ShowOpen
    End With
    
    strFilename = dlgOpen.FileName
    If Len(strFilename) > 0 Then
        
        asTemp = Split(Trim(strFilename), "\")
        sLastEl = UBound(asTemp)
        sDllName = Left(asTemp(sLastEl), Len(asTemp(sLastEl)) - 4)
        Set oWroxRes = CreateObject(sDllName & ".LoadRes")
        ' Clear all lists
        Call ClearAllLists
        ' Set up our lists
        Call PopulateCategoryList
        Call PopulateElementList
        Call PopulatePickRelatedProductsList
    
        ' Set the product description XML to a default entry:
        Call SetXmlDefault
        
    End If
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
       MsgBox "Error: " & Err.Description, vbExclamation, "Error opening file"
    End If
    

End Sub
Private Sub mnuLocalOpen_Click()
    Call OpenLocalFile
End Sub

Private Sub mnuLocalSave_Click()
    Call SaveLocalFile
End Sub

Private Sub mnuNew_Click()
    txtProductID = "000000"
End Sub

Private Sub mnuPreview_Click()
    Call PreviewDocument
End Sub
'********************************************************************************
' Private Function GetSegments(sRelProd As String,
'                             sName As String,
'                             sID As String) As Boolean
' Retrieves the product name and ID from list item
'********************************************************************************
Private Function GetSegments(sRelProd As String, _
                             sName As String, _
                             sID As String) As Boolean
    Dim asTemp() As String
    
    asTemp = Split(sRelProd, "[")
    sName = Trim(asTemp(0))
    sID = Trim(Replace(asTemp(1), "]", ""))
    
    If (Len(sName) = 0) Or (Len(sID) = 0) Then
        GetSegments = False
    Else
        GetSegments = True
    End If
    
End Function
'********************************************************************************
' Private Function BuildDocument() As String
' Gathers form contents and builds an XML document
'********************************************************************************
Private Function BuildDocument() As String
    On Error GoTo ErrHand
    Dim sDescription As String
    Dim nIdx As Integer
    Dim sXML As String
    
    
    Dim sRelName As String
    Dim sRelID As String
    Dim bRes As Boolean
    
        
    sXML = "<PRODUCT ID='" & txtProductID & _
        "' xmlns:xl='http://www.w3.org/1999/xlink/namespaces/'>" & vbCrLf
    sXML = sXML & "<NAME>" & txtProductName & "</NAME>" & vbCrLf
    sXML = sXML & "<PRICE>" & txtPrice & "</PRICE>" & vbCrLf
    sXML = sXML & xmlTxtProductDesc.Text & vbCrLf
    sXML = sXML & "<CATEGORY>" & _
        lstProductCategory.List(lstProductCategory.ListIndex) & _
        "</CATEGORY>" & vbCrLf
    sXML = sXML & "<RELATEDURLS>" & vbCrLf
    For nIdx = 0 To cmbUrls.ListCount - 1
        sXML = sXML & "<URL href='" & cmbUrls.List(nIdx) & "' />" & vbCrLf
    Next
    sXML = sXML & "</RELATEDURLS>" & vbCrLf
    sXML = sXML & "<RELATEDPRODUCTS>" & vbCrLf
    For nIdx = 0 To lstRelatedProducts.ListCount - 1
        Call GetSegments(lstRelatedProducts.List(nIdx), sRelName, sRelID)
        sXML = sXML & _
        "<PRODUCT id='" & sRelID & _
          "'  name='" & sRelName & "' xl:type='simple' xl:Show='replace' " & _
          "xl:actuate='onRequest' xl:href='" & sRelID & "'/>" & vbCrLf
    Next
    sXML = sXML & "</RELATEDPRODUCTS>" & vbCrLf
    sXML = sXML & "</PRODUCT>"
    
    
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error! " & Err.Description, vbCritical, "Error in " & Err.Source
        sXML = ""
    End If
    BuildDocument = sXML

End Function

'*********************************************************************
' Private Sub ConfigureWeb()
' This lets us set the information for the SOAP server.
' Ideally, this would be set during an installation process as well.
'*********************************************************************
Private Sub ConfigureWeb()
    On Error GoTo ErrHand
    Dim sSoapUrl As String
    Dim sTxNamespace As String
    frmWebConfig.Show vbModal
    Call SaveSetting(APPNAME, "Startup", "SoapUrl", g_sSoapUrl)
    Call SaveSetting(APPNAME, "Startup", "TxNamespace", g_sTxNamespace)
    
ErrHand:
        If Err.Number <> 0 Then
            MsgBox Err.Description, vbExclamation, "Config error."
        End If
End Sub

'********************************************************************************
' Private Function ConvertToAnsi(ByVal vData As Variant) As String
' Converts custm resource text to ANSI
'********************************************************************************
Private Function ConvertToAnsi(ByVal vData As Variant) As String
    On Error GoTo ErrHand
    Dim nIdx As Integer
    Dim sText As String
    sText = ""

    For nIdx = 1 To LenB(vData)
        sText = sText & Chr(AscB(MidB(vData, nIdx, 1)))
    Next
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error retreiving the XSL for browser display", vbExclamation
        sText = ""
    End If
    ConvertToAnsi = sText
End Function
'*********************************************************************
' Private Sub OpenLocalFile()
' Read in a file from the local file system and parse it into
' the form.  Check that the XML is well-formed, or complain.
'*********************************************************************
Private Sub OpenLocalFile()
    On Error GoTo ErrHand
    Dim strFilefilter  As String
    Dim strFilename As String
    Dim objDOM As MSXML.DOMDocument
    
    Set objDOM = New DOMDocument
    strFilefilter = "XML Files (*.xml)|*.xml|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CancelError = True
        .Filter = strFilefilter
        .ShowOpen
    End With
    
    strFilename = dlgOpen.FileName
    
    If (Len(strFilename) > 0) Then
        If Not objDOM.Load("file://" & strFilename) Then
            MsgBox "Error loading XML document: " & objDOM.parseError.reason, vbExclamation, "XML load error"
            strFilename = ""
        Else
            mnuLocalSave.Enabled = True
            mnuWebSave.Enabled = True
            If Not ParseDomIntoForm(objDOM) Then
                MsgBox "Error parsing data file into form", vbCritical
            End If
        End If
    End If
    
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
       MsgBox "Error: " & Err.Description, vbExclamation, "Error opening file"
    End If
    
    Set objDOM = Nothing
End Sub
'*********************************************************************
' Public Function OpenWebFile() As Boolean
' We build a SOAP transaction to retrieve a list of products,
' and display the results in a dialog box. Selecting an item
' will send another SOAP transaction to retrieve the selected XML
' file fom the file server.
'*********************************************************************
Public Function OpenWebFile() As Boolean
    Dim sSoapTx As String
    Dim sResults As String
    Dim sSoapBody As String
    Dim sListData As String
    
    sSoapTx = oWebTx.BuildSoapRequestGetProductList()
    With oSoapRqst
        .SoapServerURL = g_sSoapUrl
        .TransactionNamespaceURI = g_sTxNamespace
        .TimeoutSeconds = 300
        sResults = .PostRequest(sSoapTx)
    End With
    ' Now we need to pull out the response body
    sSoapBody = oWebTx.GetSoapBody(sResults)
    sListData = oWebTx.GetListData(sSoapBody)
    If Len(sListData) > 0 Then
        Call oWebTx.DisplayFileList(sListData)
    Else
        MsgBox "Error getting list data from SOAP response.", vbExclamation, "Error."
    End If

End Function


'*********************************************************************
' Public Function ParseDomIntoForm(oDOM As DOMDocument) As Boolean
' We want to take the contents of the DOM and put the data into the
' correct form elements.
'*********************************************************************
Public Function ParseDomIntoForm(oDOM As DOMDocument) As Boolean
    On Error GoTo ErrHand
    Dim oEl As IXMLDOMElement
    Dim oNodeList As IXMLDOMNodeList
    Dim sTemp As String
    Dim nIdx As Integer
    
    With oDOM
        sTemp = ""
        Set oEl = .childNodes(0)
        
        txtProductID = oEl.Attributes.getNamedItem("ID").nodeValue
        Set oEl = .getElementsByTagName("NAME").Item(0)
        For nIdx = 0 To oEl.childNodes.length - 1
            sTemp = sTemp & oEl.childNodes.Item(nIdx).nodeValue
        Next
        txtProductName = sTemp
        
        Set oEl = .getElementsByTagName("DESCRIPTION").Item(0)
        If Not oEl Is Nothing Then
            xmlTxtProductDesc.Text = oEl.xml
        End If
        
        Set oEl = .getElementsByTagName("PRICE").Item(0)
        If Not oEl Is Nothing Then
            txtPrice.Text = oEl.Text
        End If
        
        sTemp = ""
        Set oEl = .getElementsByTagName("CATEGORY").Item(0)
        For nIdx = 0 To oEl.childNodes.length - 1
            sTemp = sTemp & oEl.childNodes.Item(nIdx).nodeValue
        Next
        
        For nIdx = 0 To lstProductCategory.ListCount - 1
            If lstProductCategory.List(nIdx) = sTemp Then
                lstProductCategory.ListIndex = nIdx
            End If
        Next
        
        sTemp = ""
        
        Set oNodeList = .selectNodes("//RELATEDURLS/URL")
        For nIdx = 0 To oNodeList.length - 1
            cmbUrls.AddItem (oNodeList.Item(nIdx).Attributes.getNamedItem("href").nodeValue)
        Next
        
        Set oNodeList = .selectNodes("//RELATEDPRODUCTS/PRODUCT")
        For nIdx = 0 To oNodeList.length - 1
            
            sTemp = oNodeList.Item(nIdx).Attributes.getNamedItem("name").nodeValue
            sTemp = sTemp & " [" & oNodeList.Item(nIdx).Attributes.getNamedItem("id").nodeValue & "]"
            lstRelatedProducts.AddItem (sTemp)
            
        '    lstRelatedProducts.AddItem (oNodeList.Item(nIdx).Attributes.getNamedItem("name").nodeValue)
        Next
        
    End With
    
    ParseDomIntoForm = True
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error loading XML into form:" & Err.Description, vbCritical, "Error"
        ParseDomIntoForm = False
    End If
End Function
Private Sub ClearAllLists()
    
    Do While lstProductCategory.ListCount > 0
        lstProductCategory.RemoveItem 0
    Loop
    Do While cmbElements.ListCount > 0
        cmbElements.RemoveItem 0
    Loop
    Do While lstPickAvailProds.ListCount > 0
        lstPickAvailProds.RemoveItem 0
    Loop
  
End Sub

'********************************************************************************
' Private Sub PopulateCategoryList()
' Adds items from RES file to Category list box
'********************************************************************************
Private Sub PopulateCategoryList()
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = oWroxRes.LoadResString(RES_CATEGORY_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        lstProductCategory.AddItem (varItem)
    Next
  
End Sub
'********************************************************************************
' Private Sub PopulateElementList()
' Adds items from RES file to Element list box for XML text box
'********************************************************************************
Private Sub PopulateElementList()
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = oWroxRes.LoadResString(RES_ELEMENT_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        cmbElements.AddItem (varItem)
    Next
  
End Sub

'********************************************************************************
' Private Function PopulatePickRelatedProductsList() As Boolean
' Adds items from RES file to Releated Products list box
'********************************************************************************
Private Function PopulatePickRelatedProductsList() As Boolean
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = oWroxRes.LoadResString(RES_RELPROD_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        lstPickAvailProds.AddItem (varItem)
    Next
End Function

'********************************************************************************
' Private Sub PreviewDocument()
' Displays product XML in browser control
'********************************************************************************
Private Sub PreviewDocument()
    On Error GoTo ErrHand
    
    Dim sProdXml As String
    Dim sXSL As String
    Dim sHTML As String
    Dim oDomXsl  As MSXML.DOMDocument
    Dim objDOM As MSXML.DOMDocument
    
    ' Build the document
    sProdXml = BuildDocument()
    Set objDOM = New DOMDocument
    
    If Not objDOM.loadXML(sProdXml) Then
        wbPreview.Navigate2 "about:<HTML><BODY><H1>Error</H1></BODY></HTML>"
    Else
        Set oDomXsl = New DOMDocument
        sXSL = ConvertToAnsi(oWroxRes.LoadResData(RES_PREVIEW_XSL, "CUSTOM"))
        If Not oDomXsl.loadXML(sXSL) Then
            wbPreview.Navigate2 "about:<HTML><BODY><H1>Error</H1></BODY></HTML>"
            MsgBox "XSL Error: " & oDomXsl.parseError.reason
        Else
            sHTML = objDOM.transformNode(oDomXsl)
            wbPreview.Navigate2 "about:" & sHTML
        End If
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error previewing document." & _
            Err.Description, vbCritical, "Preview Error"
    End If
    Set objDOM = Nothing
    Set oDomXsl = Nothing
End Sub

'********************************************************************************
' Sub SaveLocalFile()
' Saves product XML file to disk
'********************************************************************************
Sub SaveLocalFile()
    On Error GoTo ErrHand
    Dim strFilename  As String
    Dim fsoSave As Scripting.FileSystemObject
    Dim tsSave As Scripting.TextStream
    Dim strFilefilter  As String
    Dim sXML As String
    Dim nSaveQuery As Integer
    
    Set fsoSave = New FileSystemObject
    strFilefilter = "XML Files (*.xml)|*.xml|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CancelError = True
        .Filter = strFilefilter
        .ShowSave
    End With
    
    strFilename = dlgOpen.FileName
    
    If (Len(strFilename) > 0) Then
        sXML = BuildDocument()
        If Len(sXML) < 0 Then
            MsgBox "Error building file data"
            strFilename = ""
        Else
            If fsoSave.FileExists(strFilename) Then
                nSaveQuery = MsgBox("File exists. Overwrite?", vbYesNoCancel, "Save local file")
                Select Case nSaveQuery
                    Case vbYes
                        ' Go overwrite and quite
                        Set tsSave = fsoSave.OpenTextFile(strFilename, ForWriting, False)
                        tsSave.Write (sXML)
                        tsSave.Close
                    Case vbNo
                        Call SaveLocalFile
                        ' Redisplay the Save dialog
                    Case vbCancel
                        ' Forget it and quit
                End Select
            Else
                Set tsSave = fsoSave.OpenTextFile(strFilename, ForWriting, True)
                tsSave.Write (sXML)
                tsSave.Close
            End If
        End If
    End If
    
    
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
       MsgBox "Error: " & Err.Description, vbExclamation, "Error saving  file"
    End If
    
    Set fsoSave = Nothing
    Set tsSave = Nothing

End Sub
'**********************************************************************
' Private Function SaveWebFile() As Boolean
'**********************************************************************
Private Function SaveWebFile() As Boolean
    On Error GoTo ErrHand
    
    Dim sErrMsg As String
    Dim sResults As String
    Dim sSoapTx As String
    Dim sSoapBody As String
    Dim sReturnedDoc As String
    Dim oDomResults As DOMDocument
    Dim sProdXml  As String
    
    ' Check that we have SOAP conig info ...
    If (Len(g_sTxNamespace) < 1) Or _
       (Len(g_sSoapUrl) < 1) Then
        ' Prompt for config info
        Call ConfigureWeb
    End If
    Screen.MousePointer = vbHourglass
    sProdXml = BuildDocument()
    sSoapTx = oWebTx.BuildSoapRequestSaveProdFile(sProdXml)
    If Len(sSoapTx) > 0 Then
        With oSoapRqst
            .SoapServerURL = g_sSoapUrl
            .TransactionNamespaceURI = g_sTxNamespace
            .TimeoutSeconds = 300
            sResults = .PostRequest(sSoapTx)
        End With
    Else
        MsgBox "Error creating SOAP transaction", vbExclamation, "Web save error."
    End If
    
    ' Need to parse out the body from the response
    sSoapBody = oWebTx.GetSoapBody(sResults)
    sReturnedDoc = oWebTx.GetReturnedDoc(sSoapBody)
    
    Set oDomResults = New DOMDocument
    If Not oDomResults.loadXML(sReturnedDoc) Then
        MsgBox "File server did not return proper XML:" & _
            oDomResults.parseError.reason, vbCritical, _
            "XML error"
    Else
        If Not ParseDomIntoForm(oDomResults) Then
            MsgBox "Error parsing data file into form", vbCritical
        End If
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sErrMsg = "Error saving file to remote server."
        SaveWebFile = False
    Else
        SaveWebFile = True
    End If
    Screen.MousePointer = vbDefault
    
End Function
'********************************************************************************
'Private Sub SetXmlDefault()
'********************************************************************************
Private Sub SetXmlDefault()
    Dim sXML As String
    sXML = oWroxRes.LoadResString(RES_DESC_DEFAULT_XML)
    sXML = Replace(sXML, vbLf, vbCrLf)
    xmlTxtProductDesc.Text = sXML
End Sub
Private Sub mnuWebConfig_Click()
    Call ConfigureWeb
End Sub
'**********************************************************************
' Private Sub mnuWebOpen_Click()
'**********************************************************************
Private Sub mnuWebOpen_Click()
    Call OpenWebFile
End Sub

Private Sub mnuWebSave_Click()
    Screen.MousePointer = vbHourglass
    Call SaveWebFile
    Screen.MousePointer = vbDefault
End Sub

Private Sub wbPreview_DocumentComplete(ByVal pDisp As Object, URL As Variant)
    g_bLoadComplete = True
End Sub

Private Sub xmlTxtProductDesc_LostFocus()
    g_nSelTextLocation = xmlTxtProductDesc.SelStart
End Sub

Private Sub xmlTxtProductDesc_ParseError()
    txtMessages = xmlTxtProductDesc.ParseErrorReason
    xmlTxtProductDesc.SelStart = xmlTxtProductDesc.ParseErrorPosition
End Sub

Private Sub xmlTxtProductDesc_ParseOK()
    txtMessages = ""
End Sub
