VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ErrorInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'*********************************************************
' ErrorUtils.ErrorInfo
'*********************************************************
Option Explicit

Private m_sErrorLocation As String
Private m_sErrorDescription As String
Private m_lErrorNumber As Long

Public Property Get Location() As String
    Location = m_sErrorLocation
End Property

Public Property Let Location(ByVal sLocation As String)
    m_sErrorLocation = sLocation
End Property

Public Property Get Description() As String
    Description = m_sErrorDescription
End Property

Public Property Let Description(ByVal sDescription As String)
    m_sErrorDescription = sDescription
End Property

Public Property Get Number() As Long
    Number = m_lErrorNumber
End Property

Public Property Let Number(ByVal lNumber As Long)
    m_lErrorNumber = lNumber
End Property
'**************************************************************************
'Public Sub LogEvent(LogMode As LogModeConstants,
'                     sLogFileName As String,
'                     sMsg As String)
' Used to log errr info
'**************************************************************************
Public Sub LogEvent(LogMode As LogModeConstants, _
        sLogFileName As String, _
        sMsg As String)
    On Error GoTo ErrHand
    
    Dim fso As FileSystemObject
    Dim tso As TextStream
    Set fso = New FileSystemObject
    Set tso = fso.OpenTextFile(sLogFileName, ForAppending, True)
    tso.Write Now() & " " & String(20, "*") & vbCrLf & sMsg & vbCrLf & vbCrLf
    tso.Close
    Set tso = Nothing
    
    
ErrHand:
End Sub

Public Sub SetErrorInfo(sDesc As String, sLocation As String, lNumber As Long)
    m_sErrorLocation = sLocation
    m_sErrorDescription = sDesc
    m_lErrorNumber = lNumber

End Sub

Public Sub ClearErrorInfo()
    m_sErrorLocation = ""
    m_sErrorDescription = ""
    m_lErrorNumber = 0
End Sub

Public Function GetErrorInfoXML() As String
    Dim sXML As String
    sXML = ""
    sXML = sXML & "<ERROR>" & Chr(10)
    sXML = sXML & "<LOCATION>" & XmlEncode(m_sErrorLocation) & "</LOCATION>" & Chr(10)
    sXML = sXML & "<DESCRIPTION>" & XmlEncode(m_sErrorDescription) & "</DESCRIPTION>" & Chr(10)
    sXML = sXML & "<NUMBER>" & CStr(m_lErrorNumber) & "</NUMBER>"
    sXML = sXML & "</ERROR>"
    
    GetErrorInfoXML = sXML
End Function


Private Function XmlEncode(sText As String) As String
    sText = Replace(sText, "&", "&amp;")
    sText = Replace(sText, "<", "&lt;")
    sText = Replace(sText, ">", "&gt;")
    sText = Replace(sText, "'", "&apos;")
    sText = Replace(sText, """", "&quot;")
    XmlEncode = sText
End Function
