VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "XmlFileUtils"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'**********************************************************
' WroxFileServer.XmlFileUtils
' MTS object to handle putting product description files
' on the web server
'**********************************************************
Option Explicit
Implements ObjectControl

Const PROGID As String = "WroxFileServer.XmlFileUtils"

Dim oError As ErrorUtils.ErrorInfo
'**********************************************************
' Public Function GetErrorInofXml()
' Return the error info as an XML string
'**********************************************************
Public Function GetErrorInofXml()
    GetErrorInofXml = oError.GetErrorInfoXML
End Function
'**********************************************************
' Public Function WriteFile(sXML As String,
'                           sFilepath As String,
'                           sFilename As String
'                           ) As Boolean
' Take the XML and write the contents to a local file.

'**********************************************************
Public Function WriteFile(sXML As String, _
                          sFilepath As String, _
                          sFilename As String _
                          ) As Boolean
    On Error GoTo ErrHand
    
    Dim bResults As Boolean
    Dim fso As Scripting.FileSystemObject
    Dim tso As Scripting.TextStream
    Dim sDetails As String
    Dim bOverWrite
    
    bOverWrite = True
    
    Dim sDbug As String
    sDbug = "WriteFile "
    'With App
    '    .StartLogging "c:\VbApp.log", 2
    '    .LogEvent sDbug & "Start " & Now, vbLogEventTypeInformation
    'End With
    Call oError.ClearErrorInfo
    
    If (Len(sFilepath) > 0) Then
        If (Len(sFilename) > 0) Then
            Set fso = New FileSystemObject
            ' Make sure we're consistent ...
            sFilepath = Replace(sFilepath, "\", "/")
            If (Right(sFilepath, 1) <> "/") Then
                sFilepath = sFilepath & "/"
            End If
            If fso.FileExists(sFilepath & sFilename) Then
                If bOverWrite Then
                    'With App
                    '    .StartLogging "c:\VbApp.log", 2
                    '    .LogEvent sDbug & "overwriting  " & sFilepath & sFilename, vbLogEventTypeInformation
                    'End With

                    Set tso = fso.OpenTextFile(sFilepath & sFilename, ForWriting, True)
                    tso.Write (sXML)
                    'With App
                    '    .StartLogging "c:\VbApp.log", 2
                    '    .LogEvent sDbug & "Wrote to  " & sFilepath & sFilename, vbLogEventTypeInformation
                    'End With
                    
                    tso.Close
                    Set tso = Nothing
                    Set fso = Nothing
                    bResults = True
                    
                Else
                    bResults = False
                    Call oError.SetErrorInfo("File exists, over write is False.", _
                        PROGID & ".WriteFile", -1)
                End If
            Else
                Set tso = fso.OpenTextFile(sFilepath & sFilename, ForWriting, True)
                tso.Write (sXML)
                tso.Close
                Set tso = Nothing
                Set fso = Nothing
                bResults = True
            End If
        Else
            bResults = False
            Call oError.SetErrorInfo("No file name.", _
                        PROGID & ".WriteFile", -1)
        End If
    Else
        bResults = False
        Call oError.SetErrorInfo("No file path.", _
                PROGID & ".WriteFile", -1)
    End If

ErrHand:
    If Err.Number <> 0 Then
        sDetails = " - Path=" & sFilepath & "; File name=" & sFilename
        Call oError.SetErrorInfo(Err.Description & sDetails, _
                PROGID & ".WriteFile", Err.Number)
        bResults = False
        'With App
        '    .StartLogging "c:\VbApp.log", 2
        '    .LogEvent sDbug & "COM error  " & oError.GetErrorInfoXML(), vbLogEventTypeInformation
        'End With
        
    End If
    
    WriteFile = bResults
End Function

Private Sub ObjectControl_Activate()
    Set oError = New ErrorUtils.ErrorInfo
    Call oError.ClearErrorInfo
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oError = Nothing
End Sub


