<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" >

<xsl:template><xsl:apply-templates/></xsl:template>

<xsl:template match="text()"><xsl:value-of select="."/></xsl:template>

<xsl:template match="text()|@*">
 <xsl:value-of select="."/>
 </xsl:template>

<xsl:template match="*"><xsl:apply-templates/></xsl:template>

<xsl:template match="text()">

</xsl:template>

<xsl:template match="DATA">
 <table border="0" cellpadding="3" cellspacing="5" width="100%">
  <tr>
    <td class="ResultsHeader">Name</td>
    <td class="ResultsHeader">Category</td>
    <td class="ResultsHeader">Desc</td>
    <td class="ResultsHeader">Price</td>
    <td class="ResultsHeader">Qty</td>
  </tr>
  <xsl:for-each select="Row">
  <tr>
    <td class="ResultsBody"><xsl:value-of select="@Name" /></td>
    <td class="ResultsBody"><xsl:value-of select="@Category" /></td>
    <td class="ResultsBody"><xsl:value-of select="@BriefDesc" /></td>
    <td class="ResultsBody">
    <xsl:choose>
      <xsl:when test="Inventory[. = '0']">
        This item is not currently available
      </xsl:when>
      <xsl:otherwise>$<xsl:value-of select="@Price" />
      </xsl:otherwise>
      </xsl:choose>
    </td>
    <td class="ResultsBody">
    <xsl:value-of select="@Qty" />
    </td>
  </tr>
</xsl:for-each>
<tr>
 <td colspan="2">&#160;</td>
 <td align="right"><b>Total cost:</b></td>
 <td class="ResultsBody">$<xsl:value-of select="TotalCost"/>
 </td>
 </tr>
</table>
   <input type="hidden" name="PRODUCTS">
    <xsl:attribute name="value"><xsl:for-each select="Item[Inventory != '0']">
        <PRODUCT><xsl:value-of select="PRODUCT/@ID" /></PRODUCT></xsl:for-each></xsl:attribute>
   </input>
</xsl:template>

</xsl:stylesheet>
