<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:sl="http://www.wrox.com/books/XML/ProVBXML/SimpleLink" version="1.0">

<xsl:template match="*|/"><xsl:apply-templates/></xsl:template>

<xsl:template match="text()|@*"><xsl:value-of select="."/></xsl:template>

<xsl:template match="/PRODUCT"><HTML>
<HEAD>
<link rel="stylesheet" type="text/css" href="style/wrox.css"/>
</HEAD>

<BODY>
<SCRIPT>
//<![CDATA[
function openHere(url, elm)
{
	var doc = new ActiveXObject("MSXML.DOMDocument");
	doc.async = false;
	doc.load(url);
	if (doc.parseError.errorCode == 0)
	{
		elm.outerHTML = doc.documentElement.xml;
	}
}
//]]>
</SCRIPT>
	<xsl:apply-templates select="NAME"/>
	<xsl:apply-templates select="DESCRIPTION"/>
	<xsl:apply-templates select="RELATEDPRODUCTS"/>
	</BODY></HTML>
</xsl:template>

<xsl:template match="*[@sl:id]" priority="2">
	<A><xsl:attribute name="name"><xsl:value-of select="@sl:id"/></xsl:attribute></A>
	<xsl:apply-templates select="sl:ext-target|sl:int-target" mode="linkmaking"/>
	<xsl:apply-templates select="node()|text()"/>
	<xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="DESCRIPTION">
	<P><B><xsl:apply-templates select="HEADER"/></B></P>
	<P><xsl:apply-templates select="BODY"/></P>
</xsl:template>

<xsl:template match="BODY"><xsl:copy-of select="node()|text()"/></xsl:template>

<xsl:template match="PRODUCT/NAME"><H3> <xsl:apply-templates/></H3></xsl:template>

<xsl:template match="RELATEDPRODUCTS"><xsl:apply-templates/></xsl:template>

<xsl:template match="sl:int-target|sl:ext-target"/>

<xsl:template match="sl:int-target" mode="linkmaking">
	<A>
		<xsl:attribute name="href">#<xsl:value-of select="@sl:href"/>.xml</xsl:attribute>
		<xsl:if test="@sl:show='new' ">
			<xsl:attribute name="target">_new</xsl:attribute>
		</xsl:if>
	<xsl:if test="count(@xl:title) = 0">
		Related link
	</xsl:if>
	<xsl:value-of select="@xl:title"/><xsl:text> </xsl:text>
	</A>
</xsl:template>

<xsl:template match="sl:ext-target" mode="linkmaking">
	<A>
	<xsl:if test="@sl:show !='embed' ">
		<xsl:attribute name="href">getXLinkedResource.asp?resURL=<xsl:value-of select="text()"/></xsl:attribute>
		<xsl:if test="@sl:show='new' ">
			<xsl:attribute name="target">_new</xsl:attribute>
		</xsl:if>
	</xsl:if>
	<xsl:if test="@sl:show='embed' ">
		<xsl:attribute name="onClick">openHere('getXLinkedResource.asp?resURL=<xsl:value-of select="text()"/>', this).xml</xsl:attribute>
	</xsl:if>
	<xsl:if test="count(@sl:title) = 0">
		[related link]
	</xsl:if>
	<xsl:value-of select="@sl:title"/><xsl:text> </xsl:text>
	</A>
</xsl:template>

</xsl:stylesheet>
