VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Convert"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' Important note:
' This object uses references to a Word.Application object
' To avoid having to set the reference in each method, the
' code uses global variables. Because of this you must call
' AssignDocument before using anything else. This sets the global
' reference for the other code.

Option Explicit

Private Type CellAttributes
        Shading As Boolean
        Texture As Long
        BackPatternColor As Long
        ForePatternColor As Long
        Text As String
End Type



' Constant used by Word
Const msoPropertyTypeString As Integer = 4

Private g_mbAppAssigned As Boolean
Private g_wdDoc As Word.Document
Private g_wdApp As Application
Private g_dictColors As Scripting.Dictionary
Private g_sErrLog As String

Private Sub Class_Initialize()
'    g_sErrLog = "C:\Word2Xml2.log"
    Set g_dictColors = New Scripting.Dictionary
'    Call WriteError("Init", Err, g_sErrLog, "*****************************")
End Sub
Private Sub AssignColorHash()
    g_dictColors.Add wdAuto, "White"
    g_dictColors.Add wdBlack, "Black"
    g_dictColors.Add wdBlue, "Blue"
    g_dictColors.Add wdBrightGreen, "32CD32"
    g_dictColors.Add wdDarkBlue, "6B238E"
    g_dictColors.Add wdDarkRed, "8E236B"
    g_dictColors.Add wdDarkYellow, "B87333"
    g_dictColors.Add wdGray25, "A8A8A8"
    g_dictColors.Add wdGray50, "C0C0C0"
    g_dictColors.Add wdGreen, "Green"
    g_dictColors.Add wdPink, "BC8F8F"
    g_dictColors.Add wdRed, "Red"
    g_dictColors.Add wdTeal, "Teal"
    g_dictColors.Add wdTurquoise, "Turquoise"
    g_dictColors.Add wdViolet, "Violet"
    g_dictColors.Add wdWhite, "White"
    g_dictColors.Add wdYellow, "Yellow"
End Sub
'*******************************************************************
' AssignDocument
' Takes a reference to a Word Application object, and the name of
' the open document to use, and sets the class
' variables for further use
'*******************************************************************
Public Function AssignDocument(wdNewApp As Application, _
                               sNewDoc As String) As Boolean
    On Error GoTo ErrHand
   
    Dim bResults As Boolean
    
    Set g_wdApp = wdNewApp
    g_wdApp.Windows(sNewDoc).Activate
    Set g_wdDoc = g_wdApp.ActiveDocument
    bResults = True
    g_mbAppAssigned = True
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        g_mbAppAssigned = False
    End If
    
    AssignDocument = bResults
    
End Function

'***********************************************************
' Private Function ChangeSpaces(strSource, strNew) As String
' Replaces spaces with the string passed in strNew
' returns the modified strSource
'***********************************************************
Private Function ChangeSpaces(strSource, strNew) As String
    Dim nIdx As Integer
    ChangeSpaces = Replace(strSource, " ", strNew)
End Function
'***********************************************
' Private Function CleanUp() As Integer
'***********************************************
Private Sub CleanUp()
    
    If Not g_wdApp Is Nothing Then Set g_wdApp = Nothing
    If Not g_wdDoc Is Nothing Then Set g_wdDoc = Nothing
    g_mbAppAssigned = False
  

End Sub
'****************************************************
' Private Function ConvertToXML() As Boolean
' Main fuunction
'
' Runs through the entire document and coverts formatting to XML tags
' This version does not use any attributes; it just creates tags
' from formatting. Another method for tagging bookmarks (created
' from heading styles) should be used for that. The next step is
' a method for loading an XML file and inserting attributes into
' different elements using information in the bookmark-tagged elements.
'****************************************************
Public Function ConvertToXML() As Boolean
    On Error GoTo ErrHand
    Dim sResults As Boolean
    
    Dim arrStyles() As String
    Dim nStyCount As Integer
    Dim sMsg As String
    Dim bMoreToDo As Boolean
    Dim nStyIdx  As Integer
    Dim nIdx As Integer
    Dim nSwitch As Integer
    Dim sID As String
    
    Dim bRes As Boolean
    
    bRes = True
    
    If Not g_mbAppAssigned Then
        ConvertToXML = False
        Exit Function
    End If
    sResults = True
    ' Set up an array of styles
    ReDim arrStyles(g_wdApp.ActiveDocument.Styles.Count)
    g_wdApp.ActiveDocument.ActiveWindow.View.Type = wdNormalView
    
    ' Fix up the stuff that confuses some automatic formatting
    If Not PrepareDoc() Then
        ConvertToXML = False
        Exit Function
    End If

    sMsg = ""
    nStyCount = 0
    For nIdx = 1 To g_wdApp.ActiveDocument.Styles.Count
        If (ActiveDocument.Styles.Item(nIdx).InUse) And (ActiveDocument.Styles.Item(nIdx) <> "Default Paragraph Font") _
        And (ActiveDocument.Styles.Item(nIdx) <> "Normal") And (ActiveDocument.Styles.Item(nIdx) <> "Normal,Normal.dot") Then
            arrStyles(nStyCount) = g_wdApp.ActiveDocument.Styles.Item(nIdx)
            nStyCount = nStyCount + 1
            sMsg = sMsg & " " & g_wdApp.ActiveDocument.Styles.Item(nIdx) & "."
        End If
     Next
    
    ReplaceSpecialChars ' Change "&", "<", etc. into &amp;, &lt;, etc.

    '---------------- The busy part -----------------
    For nStyIdx = 0 To nStyCount - 1
        DoEvents
        sMsg = arrStyles(nStyIdx)
        g_wdApp.Selection.Find.ClearFormatting
        g_wdApp.Selection.Find.Style = g_wdApp.ActiveDocument.Styles(sMsg)
        g_wdApp.Selection.HomeKey Unit:=wdStory
        With g_wdApp.Selection.Find
            .Text = ""
            .Replacement.Text = ""
            .Forward = True
            .Wrap = wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        
        bMoreToDo = True
        
        Do While bMoreToDo = True
            DoEvents
            bMoreToDo = g_wdApp.Selection.Find.Execute
            If bMoreToDo = True Then
                g_wdApp.Selection.Range.Style = _
                    g_wdApp.ActiveDocument.Styles("Default Paragraph Font")
                g_wdApp.Selection.Range.Style = _
                    g_wdApp.ActiveDocument.Styles(wdStyleNormal)
                    
'                If Len(Selection.Text) >1 Then '' BUG:
'                Code may pause until the user clicks the document,
'                unless the Len() comparison is used.  But the use
'                of the comparsion may cause something to be missed.
                    Do While (vbCr = Right(Selection.Text, 1))
                        g_wdApp.Selection.MoveLeft _
                            Unit:=wdCharacter, Count:=1, Extend:=wdExtend
                        DoEvents
                    Loop
                    If (Selection.Text <> vbFormFeed) _
                        And (Selection.Text <> vbCr) Then
                        g_wdApp.Selection.Copy
                        g_wdApp.Selection.Cut
                        sMsg = Replace(sMsg, " ", "-")
                        g_wdApp.Selection.TypeText Text:="<" & sMsg & ">"
                        g_wdApp.Selection.Paste
                        g_wdApp.Selection.TypeText Text:="</" & sMsg & ">"
                    End If
                End If
 '           End If
        Loop
    Next nStyIdx
   
    TagBold
    TagItalics
    TagUnderLine
    
    For nStyIdx = 0 To nStyCount - 1
        DoEvents
        g_wdApp.Selection.HomeKey Unit:=wdStory
        sMsg = Replace(arrStyles(nStyIdx), " ", "-")
        If ((InStr(sMsg, "List") = 0) And (InStr(sMsg, "Bullet") = 0)) Then
            Call TightenTags(sMsg)
        End If
    Next
    
    TagLineBreaks
    Call BookmarkTags
    g_wdApp.Selection.HomeKey Unit:=wdStory
    AddRoot
    DoAllTables
ErrHand:
    If Err.Number <> 0 Then
        sResults = False
    End If
    ConvertToXML = sResults
    Call CleanUp
End Function
Private Function InsertRoot() As Boolean
    With g_wdApp
        Selection.WholeStory
        Selection.MoveRight Unit:=wdCharacter, Count:=1
        Selection.TypeText Text:="</Word>"
        Selection.HomeKey Unit:=wdStory
        Selection.TypeText Text:="<?xml version='1.0 ?>"
        Selection.TypeParagraph
        Selection.TypeText Text:="<Word>"
    End With
End Function

'***************************************************
' Private Function DoAllTables() As Boolean
'***************************************************
Private Function DoAllTables() As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean

    'Call AssignColorArray
    Call AssignColorHash
    Do While g_wdApp.ActiveDocument.Tables.Count > 0
    ' Note that as we tag the tables, the tables vanish,
    ' so we always want to do the first one
    ' until there are no more tables
        Call TagTable(1)
    Loop
    
    bResults = True

ErrHand:
    If Err.Number <> 0 Then
        bResults = False
    End If
    DoAllTables = bResults
End Function

'*****************************************************
' Private Function FixListTags(strTagname As String) As Integer
'  Fixes list tags and wraps the list in <UL> tags
'*****************************************************
Private Function FixListTags(strTagname As String) As Boolean
    On Error GoTo ErrHand
    
    Dim sLstTag  As String
    Dim bResults As Boolean
    
    If Not g_mbAppAssigned Then
        FixListTags = False
        Exit Function
    End If
    
    bResults = True
    If InStr(strTagname, "Bullet") Then
        sLstTag = "UL"
    Else
        sLstTag = "OL"
    End If
    
    ' Set up the Find call ...
    g_wdApp.Selection.Find.ClearFormatting
    g_wdApp.Selection.Find.Replacement.ClearFormatting
    
    With g_wdApp.Selection.Find
        .Text = "</" & strTagname & ">^p<" & strTagname & ">"
        .Replacement.Text = "<\\" & strTagname & "><\\" & strTagname & ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    g_wdApp.Selection.Find.Execute Replace:=wdReplaceAll
    
    g_wdApp.Selection.Find.ClearFormatting
    g_wdApp.Selection.Find.Replacement.ClearFormatting
    With g_wdApp.Selection.Find
        .Text = "<" & strTagname & ">"
        .Replacement.Text = "<" & sLstTag & ">^p<" & strTagname & ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    g_wdApp.Selection.Find.Execute Replace:=wdReplaceAll
    
    g_wdApp.Selection.Find.ClearFormatting
    g_wdApp.Selection.Find.Replacement.ClearFormatting
    With g_wdApp.Selection.Find
        .Text = "</" & strTagname & ">"
        .Replacement.Text = "</" & strTagname & ">^p</" & sLstTag & ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    g_wdApp.Selection.Find.Execute Replace:=wdReplaceAll
        
    g_wdApp.Selection.Find.ClearFormatting
    g_wdApp.Selection.Find.Replacement.ClearFormatting
    With g_wdApp.Selection.Find
        .Text = "<\\" & strTagname & "><\\" & strTagname & ">"
        .Replacement.Text = "</" & strTagname & ">^p<" & strTagname & ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    g_wdApp.Selection.Find.Execute Replace:=wdReplaceAll
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
    End If
    
    FixListTags = bResults
End Function

'********************************************
' Private Function IsPreviousCharVbCr() As Boolean
'********************************************
Private Function IsPreviousCharVbCr() As Boolean
    Dim selTemp As Selection
    
    IsPreviousCharVbCr = False
    Set selTemp = g_wdApp.Selection
    selTemp.MoveLeft Unit:=wdCharacter, Count:=1
    selTemp.MoveLeft Unit:=wdCharacter, Count:=1, Extend:=wdExtend
    If selTemp.Text = vbCr Then
        IsPreviousCharVbCr = True
    End If
    
End Function

'************************************************************
' Private Function MakeNormalSoloCr() As Boolean
' Fix clusters of carriage returns.
'************************************************************
Private Function MakeNormalSoloCr() As Boolean
    Dim bResult As Boolean
    Dim dblOldEnd As Double
    Dim dblNewEnd As Double
    
    Selection.EndKey Unit:=wdStory
    dblOldEnd = Selection.End
    
    If Not g_mbAppAssigned Then
        MakeNormalSoloCr = False
        Exit Function
    End If

    g_wdApp.Selection.HomeKey Unit:=wdStory
    g_wdApp.Selection.Find.ClearFormatting
    g_wdApp.Selection.Find.Replacement.ClearFormatting
    With g_wdApp.Selection.Find
        .Text = "^p"
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Do While g_wdApp.Selection.Find.Execute
    
        If IsPreviousCharVbCr Then
            g_wdApp.Selection.Style = "Normal"
        End If
        dblNewEnd = g_wdApp.Selection.Start
        g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=2
    
        If dblOldEnd = dblNewEnd + 1 Then ' We've hit the end
        ' Check the final paragraph mark.
            g_wdApp.Selection.Find.Execute
            If IsPreviousCharVbCr Then
            g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
                g_wdApp.Selection.Style = "Normal"
            End If
            MakeNormalSoloCr = True
            Exit Function
        End If
    Loop

End Function

'***********************************************************
' Private Function ModPageBreak() As Boolean
' Adds a CR to manual page break, sets style to Normal
'***********************************************************
Private Function ModPageBreak() As Boolean
    g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
    g_wdApp.Selection.TypeParagraph
    g_wdApp.Selection.MoveUp Unit:=wdLine, Count:=2
    g_wdApp.Selection.Style = ActiveDocument.Styles("Normal")
    ModPageBreak = True
End Function
'***********************************************************
' Private Sub MoveDown()
' Moves the selection point down one line
'***********************************************************
Private Sub MoveDown()
    g_wdApp.Selection.MoveDown Unit:=wdLine, Count:=1
End Sub
'**************************************************************
' Private Function PrepareDoc() As Integer
' Tries to fix all of the junk that screws up
' automated tagging.
'**************************************************************
Private Function PrepareDoc() As Boolean

    If Not RemoveAllPictures() Then
        PrepareDoc = False
        Exit Function
    End If
    DoEvents
    If Not PrepareManualPageBreaks() Then
        PrepareDoc = False
        Exit Function
    End If
    DoEvents
    If Not RemoveAllBorders() Then
        PrepareDoc = False
        Exit Function
    End If
    
    DoEvents
    If Not PrepareSectionBreaks Then
        PrepareDoc = False
        Exit Function
    End If
    
    DoEvents
    If Not MakeNormalSoloCr Then
        PrepareDoc = False
        Exit Function
    End If
    
    PrepareDoc = True
End Function
'**************************************************************
' Private Function PrepareManualPageBreaks() As Integer
'**************************************************************
Private Function PrepareManualPageBreaks() As Boolean
    On Error GoTo ErrHand
    
    g_wdApp.Selection.HomeKey Unit:=wdStory
    g_wdApp.Selection.Find.ClearFormatting
    With g_wdApp.Selection.Find
        .Text = "^m"
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindStop
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With

    Do While g_wdApp.Selection.Find.Execute
        ModPageBreak
        MoveDown
        DoEvents
    Loop
ErrHand:
    If Err.Number <> 0 Then
        PrepareManualPageBreaks = False
    Else
        PrepareManualPageBreaks = True
    End If
    
End Function
'*********************************************************
' Private Function PrepareSectionBreaks() As Integer
' Makes sure section breaks are preceded by a paragraph mark.
'*********************************************************
Private Function PrepareSectionBreaks() As Boolean
    Dim nIdx As Integer
    Dim bResults  As Boolean
   
    If Not g_mbAppAssigned Then
        PrepareSectionBreaks = False
        Exit Function
    End If
    bResults = True
    
    g_wdApp.Selection.HomeKey Unit:=wdStory
    For nIdx = 1 To g_wdApp.ActiveDocument.Sections.Count - 1
        g_wdApp.Selection.GoTo What:=wdGoToSection, Which:=wdGoToNext
        DoEvents
        ' Back up to place the selection right on the section break.
        g_wdApp.Selection.MoveLeft Unit:=wdCharacter, Count:=1
    
        ' Now select the chracter immediately before the break.
        g_wdApp.Selection.MoveLeft Unit:=wdCharacter, Count:=1, Extend:=wdExtend
    
        ' See if it's a paragraph mark.
        If Not (vbCr = g_wdApp.Selection.Text) Then
            g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
            g_wdApp.Selection.InsertAfter vbCrLf
            g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
            g_wdApp.Selection.Style = "Normal"
        Else
            g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
        End If
        g_wdApp.Selection.Style = "Normal"
        g_wdApp.Selection.MoveRight Unit:=wdCharacter, Count:=1
        DoEvents
    Next
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
    End If
    PrepareSectionBreaks = bResults
End Function
'*************************************************************
' Private Function ProcessFootnotes() As Boolean
' Gets all of the ffotnotes and inserts them into the
' main text at the selection point. makes no asssumptions about
' where that might be.  Not currently used in ConvertToXml, but
' included in case anyone wants to experiment.
' You *could* call this right before the root element is
' added to the converted text, setting the selection point
' to the end of the document.
'*************************************************************
Private Function ProcessFootnotes() As Boolean
    On Error GoTo ErrHand
    Dim iIdx As Integer
   
    For iIdx = 1 To g_wdDoc.Footnotes.Count
        With g_wdApp.Selection
            .InsertAfter "<Footnote number='" & CStr(iIdx) & "' >" & vbCr
            .InsertAfter vbTab & g_wdDoc.Footnotes(iIdx).Range.Text & vbCr
            .InsertAfter "</Footnote>" & vbCr
        End With
    Next iIdx
    ProcessFootnotes = True
    
ErrHand:
    If Err.Number <> 0 Then
        ProcessFootnotes = False
    End If

End Function
'********************************************************
' Private Function RemoveAllBorders() As Boolean
' Selects whole doc and removes all border from everything
'********************************************************
Private Function RemoveAllBorders() As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    
    bResults = True
    g_wdApp.Selection.WholeStory
    
    With g_wdApp.Selection.ParagraphFormat
        .Borders(wdBorderLeft).LineStyle = wdLineStyleNone
        .Borders(wdBorderRight).LineStyle = wdLineStyleNone
        .Borders(wdBorderTop).LineStyle = wdLineStyleNone
        .Borders(wdBorderBottom).LineStyle = wdLineStyleNone
        .Borders(wdBorderHorizontal).LineStyle = wdLineStyleNone
        With .Borders
            .DistanceFromTop = 1
            .DistanceFromLeft = 4
            .DistanceFromBottom = 1
            .DistanceFromRight = 4
            .Shadow = False
        End With
    End With
    With Options
        .DefaultBorderLineStyle = wdLineStyleSingle
        .DefaultBorderLineWidth = wdLineWidth150pt
        .DefaultBorderColorIndex = wdAuto
    End With
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
    End If
    
    RemoveAllBorders = bResults
End Function
'*************************************************************
' Private Function RemoveAllPictures() As Integer
'*************************************************************
Private Function RemoveAllPictures() As Boolean
    On Error GoTo ErrHand
    
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "^g"
        .Replacement.Text = "GRAFIX"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    RemoveAllPictures = True
ErrHand:
    If Err.Number <> 0 Then
        RemoveAllPictures = False
    End If
End Function
'**************************************************
' Private Sub ReplaceSpecialChars()
' Finds "&" and puts in "&amp;", and so on.
'**************************************************
Private Sub ReplaceSpecialChars()
    
    Selection.HomeKey Unit:=wdStory
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "&"
        .Replacement.Text = "&amp;"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection.Find
        .Text = ">"
        .Replacement.Text = "&gt;"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection.Find
        .Text = "<"
        .Replacement.Text = "&lt;"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll

End Sub
Private Sub SetErrorLog(sLog As String)
    g_sErrLog = sLog
End Sub
'***********************************************************
' Private Sub SnipBreakTags()
' Removes <BR> tags that come right after another tag
'***********************************************************
Private Sub SnipBreakTags()
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "><br/>"
        .Replacement.Text = ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll

End Sub
'*************************************
' Private Sub TagBold()
' Should wrap tags around bolded text.
'*************************************
Private Sub TagBold()
    Dim bRes As Boolean
    Dim nSwitch As Integer
    
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Font.Bold = True
    With Selection.Find
        .Text = ""
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    bRes = True
    Do While bRes
        DoEvents
        bRes = Selection.Find.Execute
        If bRes Then
            If vbCr = Selection.Text Then
                Selection.Style = "Normal"
                Selection.Collapse wdCollapseEnd
            Else
                Selection.Copy
                Selection.Font.Bold = wdToggle
                nSwitch = 0
                Do While (vbCr = Right(Selection.Text, 1)) And nSwitch < 50 ' Extreme, but useful
                    Selection.MoveLeft Unit:=wdCharacter, Count:=1, Extend:=wdExtend
                    DoEvents
                    nSwitch = nSwitch + 1
                Loop
                Selection.Copy
                
                Selection.Cut
                Selection.TypeText Text:="<b>"
                Selection.Paste
                'Clear all formatting before inserting!
                Selection.Collapse wdCollapseEnd
                ' We need to replace normal|default paragraph font
                ' stuff with some silly temp replacement format.
                ' If this doesn't exist, then create it.
                On Error Resume Next
                ActiveDocument.Styles.Add "FakeStyle", wdStyleTypeParagraph
                If Err.Number <> 5173 Then
                    ' Not what we expected!
                    ' Very rare.
                    Err.Raise Err.Number
                End If
                
                Selection.Style = ActiveDocument.Styles("FakeStyle")
                Selection.TypeText Text:="</b>"
            End If
        End If
    Loop
    
End Sub
'***************************************************
' Private Sub TagItalics()
' Should wrap tags around italic text.
'***************************************************
Private Sub TagItalics()

    Dim bRes As Boolean
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Font.Italic = True
    With Selection.Find
        .Text = ""
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    bRes = True
    Do While bRes = True
        bRes = Selection.Find.Execute
        If bRes = True Then
            Selection.Copy
            Selection.Font.Italic = wdToggle
            Selection.Copy
            Selection.Cut
            Selection.TypeText Text:="<i>"
            Selection.Paste
            Selection.TypeText Text:="</i>"
        End If
    Loop
       
End Sub
'********************************************************
' Private Sub TagLineBreaks()
'********************************************************
Private Sub TagLineBreaks()

    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "^p"
        .Replacement.Text = "<br/>^p"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Call SnipBreakTags

End Sub
'***************************************************
' Private Function TagTable(nTable As Integer) As Integer
'***************************************************
Private Function TagTable(nTable As Integer) As Boolean
    On Error GoTo ErrHand
    
    Dim caCellInfo() As CellAttributes
    Dim nRows As Integer
    Dim nCols As Integer
    Dim asContent() As String
    Dim nX As Integer
    Dim nY As Integer
    Dim sTableBookmark As String
    Dim oDoc As Document
    
    Set oDoc = g_wdApp.ActiveDocument
        
    oDoc.Tables(nTable).Select
    nRows = oDoc.Tables(nTable).Rows.Count
    nCols = oDoc.Tables(nTable).Columns.Count
    If g_wdApp.Selection.Bookmarks.Count > 0 Then
        sTableBookmark = g_wdApp.Selection.Bookmarks(1).Name
    End If

    ReDim caCellInfo(1 To nRows, 1 To nCols)
    For nY = 1 To nCols
        For nX = 1 To nRows
            caCellInfo(nX, nY).Text = oDoc.Tables(nTable).Cell(nX, nY).Range.Text
            caCellInfo(nX, nY).Text = Left(caCellInfo(nX, nY).Text, _
                    Len(caCellInfo(nX, nY).Text) - 2)
            caCellInfo(nX, nY).BackPatternColor = _
                oDoc.Tables(nTable).Cell(nX, nY).Shading.BackgroundPatternColorIndex
            caCellInfo(nX, nY).ForePatternColor = _
                oDoc.Tables(nTable).Cell(nX, nY).Shading.ForegroundPatternColorIndex
        Next nX
    Next nY
        
    oDoc.Tables(nTable).Delete
    g_wdApp.Selection.InsertAfter "<TABLE  NAME = " & Chr(34) & _
        sTableBookmark & Chr(34) & " >" & vbCr
    For nX = 1 To nRows
        g_wdApp.Selection.InsertAfter vbTab & "<TR>" & vbCr
            For nY = 1 To nCols
                g_wdApp.Selection.InsertAfter vbTab & vbTab & _
                    " <TD BGCOLOR='" & _
                    g_dictColors.Item(caCellInfo(nX, nY).BackPatternColor) & "'"
                g_wdApp.Selection.InsertAfter "> <FONT COLOR='" & _
                   g_dictColors.Item(caCellInfo(nX, nY).ForePatternColor) & "'>" & _
                   caCellInfo(nX, nY).Text & "</FONT></TD>" & vbCr
            Next nY
        g_wdApp.Selection.InsertAfter vbTab & "</TR>" & vbCr
    Next nX
    g_wdApp.Selection.InsertAfter "</TABLE>" & vbCr
    
ErrHand:
    If Err.Number <> 0 Then
        TagTable = False
    Else
        TagTable = True
    End If
    
End Function
'**************************
' Private Sub TagUnderLine()
'**************************
Private Sub TagUnderLine()
    Dim bRes As Boolean
   
    Selection.HomeKey Unit:=wdStory
    Selection.Find.ClearFormatting
    Selection.Find.Font.Underline = True
    With Selection.Find
        .Text = ""
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    bRes = True
    Do While bRes
        bRes = Selection.Find.Execute
        If bRes Then
            Selection.Copy
            Selection.Font.Underline = False
            Selection.Copy
            Selection.Cut
            Selection.TypeText Text:="<u>"
            Selection.Paste
            Selection.TypeText Text:="</u>"
        End If
    Loop
   
End Sub
'*****************************************************
' Private Sub TightenTags(strTagname)
' Finds adjacent  </strTagname><strTagname> tags and deletes
'*****************************************************
Private Sub TightenTags(strTagname)

    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    
    With Selection.Find
        .Text = "</" & strTagname & ">^p<" & strTagname & ">"
        .Replacement.Text = "<P/>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    
    Selection.Find.Execute Replace:=wdReplaceAll

End Sub
'**************************************************************
' Private Function SaveAsText() As Boolean
' Not used in ConvertToXml; saves the active document as a text
' file with an xml file extension
'**************************************************************
Private Function SaveAsText() As Boolean
    On Error GoTo ErrHand
    
    Dim sDocName As String
    sDocName = g_wdApp.ActiveDocument.Name
    
    If (LCase(Right(sDocName, 4)) = ".doc") Then
        sDocName = Replace(sDocName, ".doc", ".xml")
    Else
        sDocName = sDocName & ".xml"
    End If
        
    g_wdApp.ActiveDocument.SaveAs FileName:=sDocName, _
                        FileFormat:=wdFormatText, _
                        AddToRecentFiles:=True
    SaveAsText = True
ErrHand:
    If Err.Number <> 0 Then
        SaveAsText = False
    End If
End Function
'**************************************************************
' Private Function AddRoot() As Boolean
' Adds the xml declaration and a root element for the document
'**************************************************************
Private Function AddRoot() As Boolean
    Dim sHead As String
    
    With Selection
        sHead = "<?xml version='" & "1.0" & "' ?>" & vbLf
        sHead = sHead & "<WordDoc>" & vbLf
        sHead = sHead & GetDocProperties
        sHead = sHead & GetCustomProperties
         .InsertBefore sHead
        .Collapse Direction:=wdCollapseEnd
    End With
    Selection.EndKey Unit:=wdStory
    With Selection
        .InsertAfter "</WordDoc>"
        .Collapse Direction:=wdCollapseEnd
    End With
    AddRoot = True
End Function
'**************************************************************
' Private Function GetDocProperties() As String
'  Returns markup contianing the document's built-in
'  properties
'**************************************************************
Private Function GetDocProperties() As String
    Dim sXML As String
    Dim nIdx As Integer
    Dim kDocProps As Object 'DocumentProperties
    Dim oDocProp As Object  'DocumentProperty
    Dim sName As String
    Dim sValue As String
    sXML = ""
    Set kDocProps = ActiveDocument.BuiltInDocumentProperties
    For nIdx = 1 To kDocProps.Count
        sName = kDocProps.Item(nIdx).Name
        On Error Resume Next
        sValue = kDocProps.Item(nIdx).Value
        If sValue <> "" Then
            sXML = sXML & "<meta type='builtin' name='" & sName & "' value='" & sValue & "' />" & vbCrLf
        End If
        sValue = ""
    Next
    
    GetDocProperties = sXML
End Function
'**************************************************************
' Private Function GetCustomProperties() As String
' Returns markup with the document's user-defined properties
'**************************************************************
Private Function GetCustomProperties() As String
    Dim sXML As String
    Dim nIdx As Integer
    Dim kDocProps As Object '  DocumentProperties
    Dim oDocProp As Object 'DocumentProperty
    Dim sName As String
    Dim sValue As String
    sXML = ""
    Set kDocProps = ActiveDocument.CustomDocumentProperties
    For nIdx = 1 To kDocProps.Count
        sName = kDocProps.Item(nIdx).Name
        On Error Resume Next
        sValue = kDocProps.Item(nIdx).Value
        If sValue <> "" Then
            sXML = sXML & "<meta type='custom' name='" & sName & "' value='" & sValue & "' />" & vbCrLf
        End If
        sValue = ""
    Next
    
    GetCustomProperties = sXML
End Function
'**************************************************************
' Private Sub WriteError(sProc As String, E As ErrObject,
'        sErrLog As String, Optional sExtra = "")
' Handy for writing a log file to see what's going on.
' Takes the name of a procedure, the VB Err object, the name of the error log,
' and any optional extra text to write out.
'**************************************************************
Private Sub WriteError(sProc As String, E As ErrObject, _
        sErrLog As String, Optional sExtra = "")

    Open sErrLog For Append As #1
    Write #1, Now() & " Error #" & E.Number & " in " & sProc & ": " & E.Description & " -- Extra: " & sExtra
    Close #1

End Sub
'**************************************************************
' Private Sub BookmarkTags()
' Goes through all of the bookmarks and puts tags around the
' bookmarked text.
'**************************************************************
Private Sub BookmarkTags()
    Dim nIdx As Integer
    Dim sTag As String
    
    Dim oBkMarks As Bookmarks
    Set oBkMarks = ActiveDocument.Bookmarks
    
    For nIdx = 1 To oBkMarks.Count
        sTag = oBkMarks.Item(nIdx).Name
        With ActiveDocument.Bookmarks
            .DefaultSorting = wdSortByName
            .ShowHidden = False
        End With

        Selection.GoTo What:=wdGoToBookmark, Name:=sTag
        Selection.MoveLeft Unit:=wdCharacter, Count:=1
        Selection.TypeText Text:="<" & sTag & ">"
        Selection.GoTo What:=wdGoToBookmark, Name:=sTag
        With ActiveDocument.Bookmarks
            .DefaultSorting = wdSortByName
            .ShowHidden = False
        End With
        Selection.MoveRight Unit:=wdCharacter, Count:=1
        Selection.TypeText Text:="</" & sTag & ">"
    Next
End Sub

