VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "ProdTxUtils"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'********************************************************************
' WebProducts.ProdTxUtils
' Assorted routines to aid product description transactions
' This code is intended to run under MTS on the web server that handels
' SOAP requests.
'********************************************************************
Option Explicit
Implements ObjectControl

Const PROG_ID As String = "WebProducts.ProdTxUtils"

Public Type dbInfo
    ProdID As String
    Name As String
    Category As String
    BriefDesc As String
    XmlDetails As String
    Inventory As Integer
    Price As String
End Type

Enum QUERY_TYPE
    SQL_INSERT = 1
    SQL_UPDATE = 2
    SQL_DELETE = 3
    SQL_SELECT = 4
    SQL_SELECT_DISTINCT_CATEGORY = 5
    SQL_SELECT_PRODUCTS_BY_ID = 65
End Enum

Private oError As ErrorUtils.ErrorInfo
Private oWds As WroxDataAccess.DataServices
Private oCtx As ObjectContext

Private m_ErrorOcurred As Boolean
Private m_sConnString As String
Private m_sDataErrorXML As String
Private m_sFileUri As String

Property Get ErrorOccured() As Boolean
    ErrorOccured = m_ErrorOcurred
End Property

Property Let ConnectionString(sConnString As String)
    m_sConnString = sConnString
End Property

Property Get DataErrorXML() As String
    DataErrorXML = m_sDataErrorXML
End Property
Property Let FileUri(sURI As String)
    m_sFileUri = sURI
End Property
'********************************************************************
' Public Function BuildSQL(QueryType As QUERY_TYPE, ByRef dbInfo As dbInfo) As String
' Utility method to construct the types of SQL statements we'll need.
'********************************************************************
Public Function BuildSQL(QueryType As QUERY_TYPE, _
                         ByRef dbInfo As dbInfo) As String
    On Error GoTo ErrHand
    Dim sSQL As String
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
    
    Select Case QueryType
        Case SQL_UPDATE:
            With dbInfo
                sSQL = "UPDATE Catalog Set  Name='" & .Name & _
                "', Category='" & .Category & _
                "', Price=" & CCur(.Price) & _
                ", Inventory=" & .Inventory & _
                ", BriefDesc='" & .BriefDesc & _
                "', XmlDetails='" & .XmlDetails & _
                "' Where (ProdID = " & .ProdID & ")"
            End With

        Case SQL_INSERT:
            With dbInfo
                sSQL = "INSERT INTO Catalog " & _
                    " (Name, Category, Price, BriefDesc, Inventory, XmlDetails) "
                sSQL = sSQL & "VALUES ('" & .Name & "', '" & _
                .Category & "', " & CCur(.Price) & ", '" _
                & .BriefDesc & "', " & .Inventory & ", '" & .XmlDetails & "')"
            End With
            
        Case SQL_DELETE:
                sSQL = "DELETE FROM Catalog WHERE ProdID='" & dbInfo.ProdID & "' "
        Case SQL_SELECT:
            With dbInfo
                sSQL = "SELECT * FROM Catalog WHERE (Inventory > 0) "
                If Len(.ProdID) > 0 Then
                    sSQL = sSQL & " AND ProdID='" & .ProdID & "' "
                End If
                If Len(.Name) > 0 Then
                    sSQL = sSQL & " AND Name='" & .Name & "' "
                End If
                If Len(.Category) > 0 Then
                    sSQL = sSQL & " AND Category='" & .Category & "' "
                End If
                 If Len(.BriefDesc) > 0 Then
                    sSQL = sSQL & " AND BriefDesc='" & .BriefDesc & "' "
                End If
                If Len(.XmlDetails) > 0 Then
                    sSQL = sSQL & " AND XmlDetails='" & .XmlDetails & "' "
                End If
                If Len(.Price) > 0 Then
                    sSQL = sSQL & " AND Price='" & .Price & "' "
                End If
            
            End With
        Case SQL_SELECT_DISTINCT_CATEGORY:
                sSQL = "SELECT DISTINCT Category  FROM Catalog WHERE Inventory > 0"

        Case Else
            sSQL = ""
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
            PROG_ID & ".BuildSQL", Err.Number)
        m_ErrorOcurred = True
        sSQL = ""
    End If
    BuildSQL = sSQL
End Function
'********************************************************************
' Public Sub ClearMainInfo(ByRef dbi As DbInfo)
'********************************************************************
Public Sub ClearMainInfo(ByRef dbi As dbInfo)
    With dbi
        .BriefDesc = ""
        .Category = ""
        .Name = ""
        .ProdID = ""
        .XmlDetails = ""
        .Inventory = 0
        .Price = ""
    End With
End Sub
Public Function ConvertToAnsi(ByVal vData As Variant) As String
    Dim nIdx As Integer
    Dim sText As String
    sText = ""
    For nIdx = 1 To LenB(vData)
        sText = sText & Chr(AscB(MidB(vData, nIdx, 1)))
    Next
    ConvertToAnsi = sText
End Function

'********************************************************************
' Public Function CreateFileUri(sProdID As String) As String
' We need to know where the files are kept so we can build a URI to it
' This data gets put into the database, so it needs to be an HTTP UTL
'********************************************************************
Public Function CreateFileUri(sProdID As String) As String
    Dim sTemp As String
    sTemp = m_sFileUri & "/" & sProdID & ".xml"
    CreateFileUri = sTemp
End Function
'********************************************************************
' Public Function ExecuteSelect(ByVal sSQL As String) As String
'********************************************************************
Public Function ExecuteSelect(ByVal sSQL As String) As String
    On Error GoTo ErrHand
    Dim sResults As String
    
    If Len(m_sConnString) > 0 Then
        oWds.ConnectionString = m_sConnString
        sResults = oWds.ExecuteSelectXml(sSQL)
    Else
        Call oError.SetErrorInfo("No connection stirng!", _
        PROG_ID & ".ExecuteSelect", -1)
        m_ErrorOcurred = True
        m_sDataErrorXML = oWds.GetErrorInfoXml()
        sResults = ""
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
        PROG_ID & ".ExecuteSelect", Err.Number)
        m_ErrorOcurred = True
        m_sDataErrorXML = oWds.GetErrorInfoXml()
        sResults = ""
    End If
    ExecuteSelect = sResults
End Function
'********************************************************************
' Public Function GetErrorInfoXml() As String
'  Retunrs the error info as an XML string. Just wraps
'  the ErrorUtils.ErrorInfo function of the same name
'********************************************************************
Public Function GetErrorInfoXml() As String
    GetErrorInfoXml = oError.GetErrorInfoXml
End Function

Public Function AddNextProdToDB(dbiData As dbInfo) As String
    On Error GoTo ErrHand
    
    Dim sSQL As String
    Dim sDate As String
    Dim bRes As Boolean
    Dim sXML As String
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sProdID As String

    If Len(m_sConnString) > 0 Then
        oWds.ConnectionString = m_sConnString
        ' We don;t have the correct URL for the details until we know th ID
        sDate = CStr(Now())
        dbiData.ProdID = ""
        dbiData.XmlDetails = sDate
        sSQL = BuildSQL(SQL_INSERT, dbiData)

        If oWds.ExecuteSQL(sSQL) Then
            ' retrieve the prodID based on the bogus XmlDetails
            sSQL = "SELECT ProdID FROM Catalog WHERE XmlDetails='" & sDate & "' "
            sXML = oWds.ExecuteSelectXml(sSQL)
            If Len(sXML) > 0 Then  ' Parse out the ProdID:
                Set oDOM = New DOMDocument
                If oDOM.loadXML(sXML) Then
                    Set oEl = oDOM.getElementsByTagName("Row").Item(0)
                    If Not oEl Is Nothing Then
                        sProdID = oEl.Attributes.getNamedItem("ProdID").nodeValue
                        Set oDOM = Nothing
                    Else
                        sProdID = ""
                        Call oError.SetErrorInfo("Failed to locate DATA element: " & _
                            oDOM.xml, _
                            PROG_ID & ".AddNextProdToDB", -1)
                        m_ErrorOcurred = True
                    End If
                Else ' Error parsing results
                    sProdID = ""
                    Call oError.SetErrorInfo("Error parsing results: " & _
                        oDOM.parseError.reason, _
                        PROG_ID & ".AddNextProdToDB", -1)
                    m_ErrorOcurred = True
                End If
            Else ' Error retriving record
                sProdID = ""
                Call oError.SetErrorInfo("Error retrieving record", _
                    PROG_ID & ".AddNextProdToDB", -1)
                m_sDataErrorXML = oWds.GetErrorInfoXml()
                m_ErrorOcurred = True
            End If
        Else ' The INSERT faild
            sProdID = ""
            Call oError.SetErrorInfo("Error calling ExecuteSQL", _
                PROG_ID & ".AddNextProdToDB", -1)
            m_sDataErrorXML = oWds.GetErrorInfoXml()
            m_ErrorOcurred = True
        End If
    Else ' No connection string
        Call oError.SetErrorInfo("No connection string.", _
        PROG_ID & ".AddNextProdToDB", -1)
        m_ErrorOcurred = True
        sProdID = ""
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
        PROG_ID & ".AddNextProdToDB", Err.Number)
        m_ErrorOcurred = True
        sProdID = ""
    End If
    
    AddNextProdToDB = sProdID

End Function

'********************************************************************
' Public Function InsertNewProduct(Dbi As DbInfo, sXMLDoc As String) As Boolean
' Takes the product main info, and the XML file contents, and inserts it
' Into the database.  Actually, we're going to UPDATE the DB using the
' ProdID, since it was obtained by creating a place holder.
' Then we'll write the XML file to the file server.
' If all goe well, we'll retunr the XML doc with the ID updated.
' Otherwise we'll return an empty string
'********************************************************************
Public Function InsertNewProduct(dbi As dbInfo, sXmlDoc As String) As String
    On Error GoTo ErrHand
    
    Dim sResults As String
    Dim sSQL As String
    Dim sProdID As String
    Dim sURI As String
    Dim sFilename As String
    Dim sWriteFileResults As String
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
    
    sProdID = AddNextProdToDB(dbi)
   
    If Len(sProdID) > 0 Then
        dbi.ProdID = sProdID
       ' Update the contents of the product XML  file with the new ID
       sResults = UpdateXmlProdID(sXmlDoc, dbi.ProdID)
       If Len(sResults) < 1 Then
        ' Error info was set in UpdateXmlProdID
            m_ErrorOcurred = True
            sResults = ""
        Else
            ' Try writing the file to the server
            sURI = m_sFileUri
            sFilename = sProdID & ".xml"
            If Not (WriteXmlFileToServer(sResults, sURI, sFilename, dbi)) Then
                sResults = ""
                m_ErrorOcurred = True
                ' Failed, so delete the recent database entry:
                sSQL = BuildSQL(SQL_DELETE, dbi)
                Call oWds.ExecuteSQL(sSQL)
            Else
                ' Now that we have the final URI, based on where the file
                ' was writen to, let's update the database
                If Not UpdateDbInfo(dbi) Then
                    ' Leave the error stuff set by UpdateDbInfo
                    sResults = ""
                    m_ErrorOcurred = True
                Else
                ' Success. sResults should have the updates XML already,
                ' so set the results flag
                    m_ErrorOcurred = False
                End If
            End If
        End If
    Else ' Could not getnext prodid
        m_ErrorOcurred = True
        sResults = ""
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
                PROG_ID & ".InsertNewProduct", _
                Err.Number)
        m_ErrorOcurred = True
        sResults = ""
    End If
    
    InsertNewProduct = sResults
End Function

Private Function RemovePriceElement(sXML As String) As Boolean
    On Error GoTo ErrHand
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    
    Set oDOM = New DOMDocument
    oDOM.loadXML sXML
    
    Set oEl = oDOM.getElementsByTagName("PRICE").Item(0)
    Call oDOM.documentElement.removeChild(oEl)
    RemovePriceElement = True
    
ErrHand:
    If Err.Number <> 0 Then
    
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
                PROG_ID & ".RemovePriceElement", _
                Err.Number)
        m_ErrorOcurred = True
        RemovePriceElement = False
    End If
End Function
'********************************************************************
' Public Function SetMainInfo(sXML) As DbInfo
'********************************************************************
Public Function SetMainInfo(sXML) As dbInfo
    On Error GoTo ErrHand
    Dim dbiTemp As dbInfo
    Dim sTemp As String
    Dim oEl As IXMLDOMElement
    Dim oDOM As DOMDocument
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
    
    Set oDOM = New DOMDocument
    
    If Not oDOM.loadXML(sXML) Then
        Call ClearMainInfo(dbiTemp)
        Call oError.SetErrorInfo("Parse Errror: " & oDOM.parseError.reason, _
                PROG_ID & ".SetMainInfo", _
                oDOM.parseError.errorCode)
        m_ErrorOcurred = True
    Else
        Set oEl = oDOM.documentElement
        dbiTemp.ProdID = oEl.Attributes.getNamedItem("ID").nodeValue
        dbiTemp.Name = oDOM.getElementsByTagName("NAME").Item(0).Text
        Set oEl = oDOM.selectSingleNode("//DESCRIPTION/HEADER")
        If Not oEl Is Nothing Then
            dbiTemp.BriefDesc = oEl.Text
        End If
        dbiTemp.Price = oDOM.getElementsByTagName("PRICE").Item(0).Text
        dbiTemp.XmlDetails = ""

        dbiTemp.Category = oDOM.getElementsByTagName("CATEGORY").Item(0).Text
        dbiTemp.XmlDetails = ""
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call ClearMainInfo(dbiTemp)
        Call oError.SetErrorInfo(Err.Description, _
                PROG_ID & ".SetMainInfo", _
                Err.Number)
        m_ErrorOcurred = True
    End If
    SetMainInfo = dbiTemp
End Function
'********************************************************************
' Private Function UpdateDbInfo(dbi As dbInfo) As Boolean
' use this to update the product catalog database wth new information,
' such as a new XmlDetails entry.
'********************************************************************
Private Function UpdateDbInfo(dbi As dbInfo) As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    Dim sSQL As String
    
    ' Create SQL for the UPDATE
    sSQL = BuildSQL(SQL_UPDATE, dbi)
    
    oWds.ConnectionString = m_sConnString
    ' Need to call an UPDATE method on the data services objec
    If Not oWds.ExecuteSQL(sSQL) Then
        Call oError.SetErrorInfo("Failed to update database" & oWds.GetErrorInfoXml, _
              PROG_ID & ".UpdateDbInfo", -1)
        m_ErrorOcurred = True
        bResults = False
    Else
        m_ErrorOcurred = False
        bResults = True
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
              PROG_ID & ".UpdateDbInfo", Err.Number)
        m_ErrorOcurred = True
        bResults = False
    End If
    
    UpdateDbInfo = bResults
End Function
'********************************************************************
' Public Function UpdateProduct(sXML As String, dbInfo As dbInfo) As String
' we wnat to try to write the file to the XML file server, and if that
' works, we'll update the SQL Server.
' We return the XML document success, or an empty string on failure.
'********************************************************************
Public Function UpdateProduct(sXML As String, dbi As dbInfo) As String
    On Error GoTo ErrHand
    
    Dim sSQL As String
    Dim sProdID As String
    Dim sURI As String
    Dim sFilename As String
    Dim sWriteFileResults As String
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
  
    sURI = m_sFileUri
    sFilename = dbi.ProdID & ".xml"
    If Not (WriteXmlFileToServer(sXML, sURI, sFilename, dbi)) Then
        sXML = ""
        m_ErrorOcurred = True
    Else
        ' Now that we have the final URI, based on where the file
        ' was writen to, let's update the database
        If Not UpdateDbInfo(dbi) Then
        ' Leave the error stuff set by UpdateDbInfo
            sXML = ""
            m_ErrorOcurred = True
        Else
            ' Success. Set the results flag
            m_ErrorOcurred = False
        End If
    End If
   
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
                PROG_ID & ".UpdateProduct", _
                Err.Number)
        m_ErrorOcurred = True
        sXML = ""
    End If
    
    UpdateProduct = sXML

End Function
'********************************************************************
' Private Function UpdateXmlProdID(sXMl As String, sNewProdID as String) As Boolean
' Takes the XML file, locates the ID attribute on the roor element,
' and changes it to the new value
'********************************************************************
Private Function UpdateXmlProdID(sXML As String, sNewProdID As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sResults As String
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
    
    Set oDOM = New DOMDocument
    If Not oDOM.loadXML(sXML) Then
        Call oError.SetErrorInfo("Parse error: " & _
            oDOM.parseError.reason, PROG_ID & ".UpdateXmlProdID", _
            Err.Number)
        m_ErrorOcurred = True
        sResults = ""
    Else   ' Swap ID
        Set oEl = oDOM.documentElement
        oEl.Attributes.getNamedItem("ID").nodeValue = sNewProdID
        sResults = oDOM.xml
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
              PROG_ID & ".UpdateXmlProdID", Err.Number)
        m_ErrorOcurred = True
        sResults = ""
    End If
    
    UpdateXmlProdID = sResults
    
End Function

'********************************************************************
' Private Function ValidateXml(sXML As String) As Boolean
' Verify that the product description is as valid XML file for
' product descriptions.
'********************************************************************
Public Function ValidateXml(sXML As String) As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    
    Call oError.ClearErrorInfo
    m_ErrorOcurred = False
    bResults = True
    
ErrHand:
    If Err.Number <> 0 Then
        m_ErrorOcurred = True
        bResults = False
        Call oError.SetErrorInfo(Err.Description, _
            PROG_ID & ".ValidateXml", Err.Number)
    End If
    ValidateXml = bResults
End Function
'********************************************************************
' Private Function WriteXmlFileToServer(ByVal sXML As String,
'                                       ByVal sURI As String,
'                                       ByVal sFilename As String,
'                                       ByRef dbiProd As dbInfo
'                                       ) As Boolean
' Takes and XML doc and writes to sFilename at the location given
' by sURI.
' Returns True if life is good, False if an error occurs.
' The question here is, where is the machine to write to and how does it
' hand;e the task.  IF this is a local file then fine, if it's a remote
' machine then we may need an object on the other machine to handle this.
' We could POST the XML to a web page and have it write the data out.
' We'll look at the URI, and if contains 'http' then we'll so a post.
' Else we'll write local.  The URI should have a protocol prefix, such
' as "http://', or 'file://'.  Maybe even 'ftp://'?
' The URI must NOT contain the file name.  That's why there is a seperate
' parameter called sFilename.
' If all goes well we'll update the struct holding the database info,
' passed in as dbiProd
'********************************************************************
Private Function WriteXmlFileToServer(ByVal sXML As String, _
                                      ByVal sURI As String, _
                                      ByVal sFilename As String, _
                                      ByRef dbiProd As dbInfo _
                                      ) As Boolean
    On Error GoTo ErrHand
    Dim sUriType As String
    Dim sFullFilePath As String
    Dim asUriParts() As String
    Dim oXmlHttp As MSXML.XMLHTTPRequest
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim fso As Scripting.FileSystemObject
    Dim tso As Scripting.TextStream
    Dim sFinalURI  As String
    Dim bResults As Boolean
    
    m_ErrorOcurred = False
    Call oError.ClearErrorInfo
    asUriParts = Split(sURI, "://")
    If UBound(asUriParts) < 1 Then
        ' No protocol!
        m_ErrorOcurred = True
        bResults = False
        Call oError.SetErrorInfo("URI does not have a protocol", _
            PROG_ID & ".WriteXmlFileToServer", -1)
    Else
        Select Case UCase(asUriParts(0))
            Case "HTTP"
                ' The URI should look something like this:
                ' http://TheServer/TheRecievingPage.asp'
                Set oXmlHttp = New XMLHTTPRequest
                Set oDOM = New DOMDocument
                If Not oDOM.loadXML(sXML) Then
                    m_ErrorOcurred = True
                    bResults = False
                    Call oError.SetErrorInfo("Error parsing XML" & _
                    oDOM.parseError.reason, _
                    PROG_ID & ".WriteXmlFileToServer", -1)
                Else
                    oXmlHttp.open "POST", sURI & "?file=" & sFilename, False
                    oXmlHttp.send oDOM
                    Set oDOM = oXmlHttp.responseXML
                    ' Need to check that this worked.
                    ' We'll have the web server return errors
                    ' in the format as the ErrorUtils object
                    If oDOM.documentElement.nodeName = "ERROR" Then
                        m_ErrorOcurred = True
                        bResults = False
                        Call oError.SetErrorInfo("Server error:" & oDOM.xml, _
                            PROG_ID & ".WriteXmlFileToServer", -1)
                    ' Is the response ever the same as the data sent?
                    ElseIf (oDOM.documentElement.nodeName = "PRODUCT") Then
                        ' Error
                        m_ErrorOcurred = True
                        bResults = False
                        Call oError.SetErrorInfo("POST error", _
                            PROG_ID & ".WriteXmlFileToServer", -1)
                    Else

                        ' Parse out the new URI.  The ASP page that handles
                        ' saving files should return:
                        '<results><OK href='the new url to fetch the file'/></results>
                        Set oEl = oDOM.getElementsByTagName("OK").Item(0)
                        sFinalURI = oEl.Attributes.getNamedItem("href").nodeValue
                        If (Len(sFinalURI) > 0) Then
                            dbiProd.XmlDetails = sFinalURI
                            m_ErrorOcurred = False
                            bResults = True
                        Else
                            m_ErrorOcurred = True
                            bResults = False
                            Call oError.SetErrorInfo("No href in results", _
                                PROG_ID & ".WriteXmlFileToServer", -1)
                        End If
                    End If
                End If
            
            Case "FILE"
                Set fso = New FileSystemObject
                If (Right(asUriParts(1), 1) <> "/") Then
                    asUriParts(1) = asUriParts(1) & "/"
                End If
                Set tso = fso.OpenTextFile(asUriParts(1) & sFilename, ForWriting, True)
                tso.Write sXML
                tso.Close
                Set tso = Nothing
                Set fso = Nothing
                bResults = True
            Case Else
                m_ErrorOcurred = True
                bResults = False
                Call oError.SetErrorInfo("Unknown protocol: " & _
                    asUriParts(0), PROG_ID & ".WriteXmlFileToServer", -1)
        End Select
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        m_ErrorOcurred = True
        bResults = False
        Call oError.SetErrorInfo("sURI = " & sURI & ". " & Err.Description, _
            PROG_ID & ".WriteXmlFileToServer", Err.Number)
    End If
    WriteXmlFileToServer = bResults
End Function

Private Sub ObjectControl_Activate()
    Set oError = New ErrorUtils.ErrorInfo
    Set oCtx = GetObjectContext()
    Set oWds = oCtx.CreateInstance("WroxDataAccess.DataServices")
    m_ErrorOcurred = False
    Call oError.ClearErrorInfo
    m_sConnString = ""
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oError = Nothing
    Set oWds = Nothing
    Set oCtx = Nothing
End Sub
