VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "ProductDescriptionTx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'********************************************************************
' WebProducts.ProductDescriptionTx
' Methods for handling product description data in the SQL server
' and product description XML files.
'********************************************************************
Option Explicit

Implements ObjectControl

Const PROG_ID As String = "WebProducts.ProductDescriptionTx"

Const RES_PROD_XSL As String = "RES_PRODUCT_XSL"
Const RES_SELECTED_XSL As String = "RES_SELECTED_XSL"
Const RES_RES_TYPE As String = "CUSTOM"

Private oDOM As MSXML.DOMDocument
Private oError  As ErrorUtils.ErrorInfo
Private TxUtils As ProdTxUtils
Private oCtx As ObjectContext
Private oResData As IResFile.ILoadRes

'********************************************************************
' Public Function Configure(sConnStr As String,
'                           sFileDestUri As String
'                          ) As Boolean
'********************************************************************
Public Function Configure(ByVal sConnStr As String, _
                          ByVal sFileDestUri As String _
                          ) As Boolean
    
    TxUtils.FileUri = sFileDestUri
    TxUtils.ConnectionString = sConnStr
    

End Function

'********************************************************************
' Public Function CreateNewProduct(ByVal sXMLDoc As String) As String
'********************************************************************
Public Function CreateNewProduct(ByVal sXmlDoc As String) As String
    On Error GoTo ErrHand
    
    Dim dbi As dbInfo
    Dim sReturn As String
    Dim sFileURI  As String
    
    dbi = TxUtils.SetMainInfo(sXmlDoc)
    dbi.Inventory = 1
   
    If TxUtils.ErrorOccured Then
        Call oError.SetErrorInfo("Could not set main info", _
                PROG_ID & ".CreateNewProduct", -1)
        sReturn = oError.GetErrorInfoXml()
    Else
        sReturn = TxUtils.InsertNewProduct(dbi, sXmlDoc)
        If Len(sReturn) < 1 Then
            Call oError.SetErrorInfo("Could not insert new file." & _
                    TxUtils.GetErrorInfoXml, _
                    PROG_ID & ".CreateNewProduct", -1)
            sReturn = oError.GetErrorInfoXml()
        End If
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
            PROG_ID & ".CreateNewProduct", Err.Number)
        sReturn = oError.GetErrorInfoXml()
    End If
    
    CreateNewProduct = sReturn
End Function
Public Function GetCategoryList() As String
    On Error GoTo ErrHand
    Dim sSQL As String
    Dim sResults As String
    
    Dim dbi As dbInfo
        
    ' We need to connect to the database, pull back all of the
    ' product info, and return and XML string encoding this.
    sSQL = TxUtils.BuildSQL(SQL_SELECT_DISTINCT_CATEGORY, dbi)
    sResults = TxUtils.ExecuteSelect(sSQL)
    If Len(sResults) < 1 Then
        sResults = TxUtils.GetErrorInfoXml()
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".GetCategoryList", Err.Number)
        sResults = oError.GetErrorInfoXml()
    End If
    GetCategoryList = sResults
End Function
'********************************************************************
' Public Function GetProduct(ByVal sProdID As String) As String
'  Queries the Catalog table to get the main info for the given
' product ID.  Takes the resulting XML and converts it into an XML doc
' using XLink for the XML detail URL. The resulting document is returned.
'********************************************************************
'
' No longer used!
Public Function GetProduct(ByVal sProdID As String) As String
    On Error GoTo ErrHand
    
    Dim sSQL As String
    Dim sResults As String
    Dim sXML As String
    Dim sXsl As String
    Dim oXmlDom As MSXML.DOMDocument
    Dim oXslDom As DOMDocument
    Dim dbi As dbInfo
    
    Call TxUtils.ClearMainInfo(dbi)
    dbi.ProdID = sProdID
    sSQL = TxUtils.BuildSQL(SQL_SELECT, dbi)
    sXML = TxUtils.ExecuteSelect(sSQL)
    Set oXmlDom = New DOMDocument
    Set oXslDom = New DOMDocument
    ' Need to transform the XML to a doc that uses XLink ...
    If oXmlDom.loadXML(sXML) Then
        sXsl = TxUtils.ConvertToAnsi(oResData.LoadResData(RES_PROD_XSL, RES_RES_TYPE))     '   .LoadResString(RES_PRODUCT_XSL)
        If Not oXslDom.loadXML(sXsl) Then
            Call oError.SetErrorInfo("Failed to parse XSL: " & _
            oXslDom.parseError.reason, PROG_ID & ".GetProduct", -1)
            sResults = oError.GetErrorInfoXml()
        Else
            sResults = oXmlDom.transformNode(oXslDom)
        End If
    Else
        Call oError.SetErrorInfo("Failed to parse SELECT results: " & _
            oXmlDom.parseError.reason, PROG_ID & ".GetProduct", -1)
        sResults = oError.GetErrorInfoXml()
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".GetProduct", Err.Number)
        sResults = oError.GetErrorInfoXml()
    End If
    GetProduct = sResults
End Function

'********************************************************************
' Public Function GetProductList() As String
' Queries the Catalaog table and returns a list of products as XML
'********************************************************************
Public Function GetProductList() As String
    On Error GoTo ErrHand
    Dim sSQL As String
    Dim sResults As String
    
    Dim dbi As dbInfo
        
    ' We need to connect to the database, pull back all of the
    ' product info, and return and XML string encoding this.
    sSQL = TxUtils.BuildSQL(SQL_SELECT, dbi)
    sResults = TxUtils.ExecuteSelect(sSQL)
    If Len(sResults) < 1 Then
        sResults = TxUtils.GetErrorInfoXml()
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".CreateNewProduct", Err.Number)
        sResults = ""
    End If
    
    GetProductList = sResults
End Function
Public Function GetPickedProds(ByVal sXmlIdList As String) As String
    On Error GoTo ErrHand
    Dim oDOM As MSXML.DOMDocument
    Dim oNodeList As IXMLDOMNodeList
    Dim oEl As IXMLDOMElement
    Dim sSQL As String
    Dim sResults As String
    Dim nIdx As Integer
    sSQL = "SELECT * FROM Catalog WHERE "
    Set oDOM = New DOMDocument
    
    If oDOM.loadXML(sXmlIdList) Then
        Set oEl = oDOM.getElementsByTagName("Products").Item(0)
        Set oNodeList = oEl.getElementsByTagName("id")
        ' Build our own SQL, since it fals outside the scope
        ' of the BuildSQL utility method
        For nIdx = 1 To oNodeList.length - 1
            sSQL = sSQL & " (ProdID = " & oNodeList.Item(nIdx).Text & ") OR "
        Next
        sSQL = sSQL & " (ProdID = " & oNodeList.Item(nIdx).Text & ") "
        sResults = TxUtils.ExecuteSelect(sSQL)
    Else
        Call oError.SetErrorInfo("Failed to parse XML ID list: " & _
                oDOM.parseError.reason, PROG_ID & ".GetPickedProds", _
                Err.Number)
        sResults = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".GetPickedProds", Err.Number)
        sResults = ""
    End If
    GetPickedProds = sResults
End Function

'********************************************************************
' Public Function GetSelectedProducts(ByVal sXmlIdList As String) As String
' Queres the Catalog table for the products specified by the list of
' IDs passed in sXmlIdList. We need to get the related XML file and pull
' out price info.  We send back an XML list of the product data
' <Products>
'  <id qty='2'>23</id>
'  <id qty='12'>24</id>
'  <id qty='32'>25</id>
' </Products>
'********************************************************************
Public Function GetSelectedProducts(ByVal sXmlIdList As String) As String
    On Error GoTo ErrHand
    Dim oXmlDom As MSXML.DOMDocument
    Dim oXslDom As MSXML.DOMDocument
    Dim oNodeList As IXMLDOMNodeList
    Dim sSQL As String
    Dim sXsl As String
    Dim sResults As String
    Dim nIdx As Integer
    
    Set oXmlDom = New DOMDocument
    Set oXslDom = New DOMDocument
    
    sSQL = "SELECT * FROM Catalog WHERE "
    
    If oXmlDom.loadXML(sXmlIdList) Then
        Set oNodeList = oXmlDom.getElementsByTagName("id")
        ' Build our own SQL, since it falls outside the scope
        ' of the BuildSQL utility method. We want to get items back even if
        ' Inventory is 0 so that we can inform the user that the item has
        ' become unavailable while shopping ...
        
        For nIdx = 1 To oNodeList.length - 1
            sSQL = sSQL & " (ProdID = " & oNodeList.Item(nIdx).Text & ") OR "
        Next
        sSQL = sSQL & " (ProdID = " & oNodeList.Item(0).Text & ") "
       
        sResults = TxUtils.ExecuteSelect(sSQL)
        If Len(sResults) > 0 Then
            ' Need to add qty attr to the XML ...
             sResults = AddQty(sResults, sXmlIdList)
        End If
    Else
        Call oError.SetErrorInfo("Failed to parse XML ID list: " & _
                oDOM.parseError.reason, PROG_ID & ".GetSelectedProducts", _
                Err.Number)
        sResults = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".GetSelectedProducts", Err.Number)
        sResults = ""
    End If
    GetSelectedProducts = sResults
End Function

Private Function AddQty(sXmlData As String, sXmlIdList As String) As String
    On Error GoTo ErrHand
    Dim oDomData As DOMDocument
    Dim oDomId As MSXML.DOMDocument
    Dim oNodeList As IXMLDOMNodeList
    Dim oElData As IXMLDOMElement
    Dim oElId As IXMLDOMElement
    Dim oWroxDw As WroxXml.CDomFunctions
    Dim sResults As String
    Dim nIdx As Integer
    Dim sProdID  As String
    Dim sQtyVal As String
    Dim dblTotal As Double
    Dim sPrice As String
    
    dblTotal = 0
    Set oDomData = New DOMDocument
    Set oDomId = New DOMDocument
    Set oWroxDw = New WroxXml.CDomFunctions
    
    If Not oDomData.loadXML(sXmlData) Then
        Call oError.SetErrorInfo("oDomData.loadXML erorr = " & _
              oDomData.parseError.reason, PROG_ID & _
         ".AddQty", -1)
        sResults = ""
       Exit Function
    End If

    If Not oDomId.loadXML(sXmlIdList) Then
        Call oError.SetErrorInfo("oDomId.loadXML erorr = " & _
              oDomId.parseError.reason, PROG_ID & _
         ".AddQty", -1)
        sResults = ""
       Exit Function
    End If

    '  <id qty='32'>25</id>
    Set oNodeList = oDomData.getElementsByTagName("Row")
    For nIdx = 0 To oNodeList.length - 1
        Set oElData = oNodeList.Item(nIdx)
        sProdID = oElData.Attributes.getNamedItem("ProdID").nodeValue
        Set oElId = oDomId.selectSingleNode("Products/id[.=" & sProdID & "]")
        sQtyVal = oElId.Attributes.getNamedItem("qty").nodeValue
        Call oWroxDw.AddAttribute(oDomData, oElData, "Qty", sQtyVal)
        sPrice = oElData.Attributes.getNamedItem("Price").nodeValue
        dblTotal = dblTotal + CDbl(sQtyVal) * CDbl(sPrice)
    Next
    Set oElData = oDomData.getElementsByTagName("DATA").Item(0)
    If Not oWroxDw.AddElement(oDomData, oElData, _
         "TotalCost", CStr(dblTotal)) Then
        Call oError.SetErrorInfo("AddElement failed.", PROG_ID & ".AddQty", -1)
        sResults = ""
    Else
        sResults = oDomData.xml
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".AddQty", Err.Number)
        sResults = ""
    End If
    Set oDomData = Nothing
    Set oDomId = Nothing
    Set oNodeList = Nothing
    Set oElData = Nothing
    Set oElId = Nothing
    Set oWroxDw = Nothing
    
    AddQty = sResults
End Function

Public Function LoadResObject(ByVal sProgID As String) As Boolean
    On Error GoTo ErrHand
    
    Dim oX As Object
    Dim bResults As Boolean
    ' Need to see that this object is available, otherwise
    ' we'll have a bad day ...
    Set oX = oCtx.CreateInstance(sProgID)
    If Not oX Is Nothing Then
        Set oX = Nothing
        Set oResData = oCtx.CreateInstance(sProgID)
        bResults = True
    Else
        bResults = False
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
            PROG_ID & ".", Err.Description)
        bResults = False
    End If
    
    LoadResObject = bResults
End Function
'********************************************************************
' Public Function SearchForProduct() As String
'********************************************************************
Public Function SearchForProduct(ByVal sName, ByVal sCategory) As String
    On Error GoTo ErrHand
    Dim dbi As dbInfo
    Dim sSQL As String
    Dim sResults As String
    
    dbi.Name = sName
    dbi.Category = sCategory
    sSQL = TxUtils.BuildSQL(SQL_SELECT, dbi)
    
    sResults = TxUtils.ExecuteSelect(sSQL)
    If Len(sResults) < 1 Then
        sResults = TxUtils.DataErrorXML()
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".SearchForProduct", Err.Number)
        sResults = oError.GetErrorInfoXml()
    End If
    SearchForProduct = sResults
End Function
'********************************************************************
' Public Function UpdateProductFile() As String
'********************************************************************
Public Function UpdateProductFile(ByVal sXmlDoc As String) As String
    On Error GoTo ErrHand
    
    Dim dbi As dbInfo
    Dim sReturn As String
    Dim sFileURI  As String
    
    dbi = TxUtils.SetMainInfo(sXmlDoc)
    If TxUtils.ErrorOccured Then
        Call oError.SetErrorInfo("Could not set main info", _
                PROG_ID & ".UpdateProductFile", -1)
        sReturn = oError.GetErrorInfoXml()
    Else
        sReturn = TxUtils.UpdateProduct(sXmlDoc, dbi)
        If Len(sReturn) < 1 Then
            Call oError.SetErrorInfo("Could not update file." & _
                TxUtils.GetErrorInfoXml, PROG_ID & ".UpdateProductFile", -1)
            sReturn = oError.GetErrorInfoXml()
        End If
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, PROG_ID & ".UpdateProductFile", Err.Number)
        sReturn = oError.GetErrorInfoXml()
    End If
    
    UpdateProductFile = sReturn

End Function
'********************************************************************
' Object/MTS stuff
'********************************************************************
Private Sub ObjectControl_Activate()
    Set oDOM = New MSXML.DOMDocument
    Set oError = New ErrorUtils.ErrorInfo
    Set oCtx = GetObjectContext()
    Set TxUtils = oCtx.CreateInstance("WebProducts.ProdTxUtils")
    Set oResData = oCtx.CreateInstance("WroxProdTxRes.ResData")
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oDOM = Nothing
    Set oError = Nothing
    Set TxUtils = Nothing
End Sub
