VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "SoapWrappers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'********************************************************************
' WebProducts.SoapWrappers
' Class to hold the wrappers that SOAP will call to run the
' back-end application code.
' Uses a reference to the ASP object library to get configuration
' info.
'********************************************************************
Option Explicit
Implements ObjectControl
Const PROG_ID As String = "WebProducts.SoapWrappers"

Private oApplication As ASPTypeLibrary.Application
Private oCtx As ObjectContext
Private ProdTx As WebProducts.ProductDescriptionTx
Private oError As ErrorUtils.ErrorInfo
Private oSoapUtils As SoapUtilsMts.Utils

Private m_sDbConnString As String
Private m_sFileServerURL As String

'********************************************************************
' Public Function soapWrapCreateNewProduct(sSoapParams As String) As String
' Wrapper for creating a new prodicut info file entry. Takes the SOAP
' request parameters, parses out the prooduct description XML file from
' the single SOAP paramter, grabs config info from ASP variables, configs
' the Web Products class, and calls CreateNew Product.  If all went well it
' returns a SOAP response with the XML file, updated with the new product ID.
' If there's an error, we return a SOAP fault.
'********************************************************************
Public Function soapWrapCreateNewProduct(sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim sXmlDoc As String
    Dim sResults As String
    Dim sResponse As String
    Dim sDbConnStr As String
    Dim XMLServerURL As String
    Dim oDOM As DOMDocument
    Dim oElNode As IXMLDOMElement

    Set oDOM = New DOMDocument
    If oDOM.loadXML(sSoapParams) Then
        Set oElNode = oDOM.getElementsByTagName("SOAP:Body").Item(0)
        Set oElNode = oElNode.firstChild
        Set oElNode = oDOM.getElementsByTagName("doc").Item(0)
        ' The stufff we want is an XML document held within the
        ' "doc" element:
        sXmlDoc = oElNode.childNodes.Item(0).xml
        ' Call the back-end method
        sResults = ProdTx.CreateNewProduct(sXmlDoc)
        sResponse = "<w:soapCreateNewProductResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml'>" & vbLf
        sResponse = sResponse & "<doc>"
        sResponse = sResponse & sResults
        sResponse = sResponse & "</doc>" & vbLf
        sResponse = sResponse & "</w:soapCreateNewProductResponse>"
    Else
        ' DOM parse Error!
        sResponse = BuildParamParseErrorResponse("soapWrapCreateNewProduct", oDOM)
   End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
    soapWrapCreateNewProduct = sResponse
End Function
'********************************************************************
' Public Function soapWrapSearchForProduct(sSoapParams As String) As String
' Search the product catalog for matching entries
'********************************************************************
Public Function soapWrapGetCategoryList(sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sName As String
    Dim sCategory As String
    Dim sResponse As String
    Dim sDbConnStr As String
    
    Set oDOM = New DOMDocument
    sResponse = ""

    If oDOM.loadXML(sSoapParams) Then
        ' There are no arguments for this, so just call the aplication method
        sResponse = sResponse & "<w:soapGetCategoryListResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
        sResponse = sResponse & "<results>" & vbLf
        sResponse = sResponse & ProdTx.GetCategoryList() & vbLf
        sResponse = sResponse & "</results>" & vbLf
        sResponse = sResponse & "</w:soapGetCategoryListResponse>"
    Else
        sResponse = BuildParamParseErrorResponse("soapGetCategoryListResponse", oDOM)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
    soapWrapGetCategoryList = sResponse

End Function
Public Function soapWrapGetProduct(ByVal sSoapParams As String)
    On Error GoTo ErrHand
    Dim sResponse  As String
    Dim sProdID  As String
    Dim oDOM As MSXML.DOMDocument
    
    sResponse = ""
    Set oDOM = New DOMDocument
    
    If oDOM.loadXML(sSoapParams) Then
        sProdID = oDOM.getElementsByTagName("prodid").Item(0).Text
        sResponse = sResponse & "<w:soapGetProductResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
        sResponse = sResponse & "<results>" & vbLf
        sResponse = sResponse & ProdTx.GetProduct(sProdID) & vbLf
        sResponse = sResponse & "</results>" & vbLf
        sResponse = sResponse & "</w:soapGetProductResponse>"
    Else
        sResponse = BuildParamParseErrorResponse("soapGetProductResponse", oDOM)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
    soapWrapGetProduct = sResponse
End Function
'********************************************************************
' Public Function soapWrapSearchForProduct(sSoapParams As String) As String
' Search the product catalog for matching entries
'********************************************************************
Public Function soapWrapSearchForProduct(ByVal sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim sName As String
    Dim sCategory As String
    Dim sResponse As String
    Dim sDbConnStr As String
    
    Set oDOM = New DOMDocument
    sResponse = ""
    
    If oDOM.loadXML(sSoapParams) Then
        sName = oDOM.getElementsByTagName("name").Item(0).Text
        sCategory = oDOM.getElementsByTagName("category").Item(0).Text
        sResponse = sResponse & "<w:soapSearchForProductResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
        sResponse = sResponse & "<results>" & vbLf
        sResponse = sResponse & ProdTx.SearchForProduct(sName, sCategory) & vbLf
        sResponse = sResponse & "</results>" & vbLf
        sResponse = sResponse & "</w:soapSearchForProductResponse>"
    Else
       sResponse = BuildParamParseErrorResponse("soapWrapCreateNewProduct", oDOM)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
    soapWrapSearchForProduct = sResponse
End Function


'********************************************************************
' Public Function soapWrapGetProductList(sSoapParams As String) As String
' Pulls back an XML string containing a list of entries in the Catalog table.
' The method takes the SOAP params as an argument because all SOAP wrapper
' functions must have a single parameter, but we don't actualy use it
' since the application method doesn't need any arguments.
'********************************************************************
Public Function soapWrapGetProductList(sSoapParams As String) As String
    On Error GoTo ErrHand
    Dim sResults As String
    Dim sResponse  As String
        
    sResults = ProdTx.GetProductList()
    sResponse = "<w:soapGetProductListResponse "
    sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
    sResponse = sResponse & "<list>"
    sResponse = sResponse & sResults
    sResponse = sResponse & "</list>" & vbLf
    sResponse = sResponse & "</w:soapGetProductListResponse>"
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
    soapWrapGetProductList = sResponse
End Function
'******************************************************************
' Public Function soapWrapSelectedProducts(ByVal sSoapParams As String) As String
' This one
Public Function soapWrapSelectedProducts(ByVal sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim sXmlDoc As String
    Dim sResults As String
    Dim sResponse As String
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sProdID As String
    '
    ' <soapGetSelectedProducts>
    ' <Products>
    '  <id qty='2'>23</id>
    '  <id qty='12'>24</id>
    '  <id qty='32'>25</id>
    ' </Products>
    ' </soapGetSelectedProducts>
    
    ' We want to pull out the params and send them off to the application
    ' transaction
    Set oDOM = New DOMDocument
    
    If oDOM.loadXML(sSoapParams) Then
        Set oEl = oDOM.getElementsByTagName("Products").Item(0)
        sResults = ProdTx.GetSelectedProducts(oEl.xml)
        sResponse = "<w:soapGetSelectedProductsResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
        sResponse = sResponse & sResults & vbLf
        sResponse = sResponse & "</w:soapGetSelectedProductsResponse>"
    Else ' Failed to parse SOAP body
        sResponse = BuildParamParseErrorResponse("soapWrapSelectedProducts", oDOM)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
     soapWrapSelectedProducts = sResponse
End Function
Public Function Test(ByVal sSoapParams As String) As String

    On Error GoTo ErrHand
    
    Dim sXmlDoc As String
    Dim sResults As String
    Dim sResponse As String
    Dim sDbConnStr As String
    Dim XMLServerURL As String
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sProdID As String

ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
     Test = sResponse
End Function
'********************************************************************
' Public Function soapWrapGetSelectedProducts(ByVal sSoapParams As String) As String
'********************************************************************
Public Function soapWrapGetSelectedProducts(sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim sXmlDoc As String
    Dim sResults As String
    Dim sResponse As String
    Dim sDbConnStr As String
    Dim XMLServerURL As String
    Dim oDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim sProdID As String

    ' We want to pull out the params and send them off to the application
    ' transaction
    Set oDOM = New DOMDocument
    
    If oDOM.loadXML(sSoapParams) Then
        Set oEl = oDOM.getElementsByTagName("Products").Item(0)
        sResults = ProdTx.GetSelectedProducts(oEl.xml)
    Else ' Failed to parse SOAP body
        sResponse = BuildParamParseErrorResponse("soapWrapGetSelectedProducts", oDOM)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If
    
     soapWrapGetSelectedProducts = sResponse
End Function
'********************************************************************
' Public Function soapWrapSaveProductFile(sSoapParams As String) As String
'********************************************************************
Public Function soapWrapSaveProductFile(sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim sXmlDoc As String
    Dim sResults As String
    Dim sResponse As String
    Dim sDbConnStr As String
    Dim XMLServerURL As String
    Dim oDOM As DOMDocument
    Dim oElNode As IXMLDOMElement
    Dim sProdID As String
    Dim sNsPrefix As String
    Dim sNsUriAttr As String
    

    Set oDOM = New DOMDocument
    ' We need to check the PRODUCT ID attribute. We can't simply
    ' save a document unless it has a valid ID (not 0)
    ' If it is a new document, we'll call CreateNewProduct instead
    ' of UpdateProduct.
    If oDOM.loadXML(sSoapParams) Then
        ' Get the ID
        Set oElNode = oDOM.getElementsByTagName("PRODUCT").Item(0)
        sProdID = oElNode.Attributes.getNamedItem("ID").nodeValue
        ' Get the product file from the SOAP envelope
        Set oElNode = oDOM.getElementsByTagName("doc").Item(0)
        sXmlDoc = oElNode.childNodes.Item(0).xml
        
        If CInt(sProdID) = 0 Then
            sResults = ProdTx.CreateNewProduct(sXmlDoc)
        Else
            sResults = ProdTx.UpdateProductFile(sXmlDoc)
        End If
        sResponse = "<w:soapSaveProductFileResponse "
        sResponse = sResponse & " xmlns:w='www.wrox.com/VbXml' >" & vbLf
        sResponse = sResponse & "<doc>"
        sResponse = sResponse & sResults
        sResponse = sResponse & "</doc>" & vbLf
        sResponse = sResponse & "</w:soapSaveProductFileResponse>"
    Else
        ' DOM parse Error!
        sResponse = BuildParamParseErrorResponse("soapSaveProductFile", oDOM)
   End If
    
ErrHand:
    If Err.Number <> 0 Then
        sResponse = BuildComErrorResponse(Err)
    End If

    soapWrapSaveProductFile = sResponse
End Function
Private Function BuildParamParseErrorResponse(sMethod As String, _
                oSoapDom As DOMDocument) As String
    Call oSoapUtils.SetDetailInfo("MyFault", "e", _
                 "Error parsing paramters: " & oSoapDom.parseError.reason, _
                 "www.wrox.org/VbSoap", _
                sMethod, -1)
    Call oSoapUtils.SetSoapFault(Invalid_Request, 0)
    Call oSoapUtils.BuildFaultXml(True)
    
    BuildParamParseErrorResponse = oSoapUtils.BuildSoapEvelopeFault(True)
End Function

Private Function BuildComErrorResponse(oVbErr As ErrObject) As String
    Call oSoapUtils.SetDetailInfo("MyFault", "e", _
                 "COM Error: " & oVbErr.Description, _
                 "www.wrox.org/VbSoap", _
                "SoapSrv.asp", -1)
    Call oSoapUtils.SetSoapFault(Application_Faulted, 0)
    Call oSoapUtils.BuildFaultXml(True)
    BuildComErrorResponse = oSoapUtils.BuildSoapEvelopeFault(True)
End Function
Private Sub ObjectControl_Activate()
    Dim sPrdTxResDataProgID As String
    
    Set oCtx = GetObjectContext()
    Set oError = New ErrorUtils.ErrorInfo
    Set ProdTx = oCtx.CreateInstance("WebProducts.ProductDescriptionTx")

    Set oApplication = oCtx.Item("Application")
    Set oSoapUtils = oCtx.CreateInstance("SoapUtilsMts.Utils")
    sPrdTxResDataProgID = oApplication("ProductTxResDataObject")
    
    If Len(sPrdTxResDataProgID) > 0 Then
        Call ProdTx.LoadResObject(sPrdTxResDataProgID)
    End If
    
    m_sDbConnString = oApplication("ConnString")
    m_sFileServerURL = oApplication("XmlServerURL")
    Call ProdTx.Configure(m_sDbConnString, m_sFileServerURL)
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oCtx = Nothing
    Set ProdTx = Nothing
    Set oApplication = Nothing
    Set oError = Nothing
    Set oSoapUtils = Nothing
End Sub
