VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DOM Test"
   ClientHeight    =   9165
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   11175
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   9165
   ScaleWidth      =   11175
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txtMessages 
      Height          =   3375
      Left            =   315
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   5355
      Width           =   10515
   End
   Begin VB.TextBox txtXML 
      Height          =   4425
      Left            =   330
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   420
      Width           =   10515
   End
   Begin MSComDlg.CommonDialog dlgOpen 
      Left            =   10185
      Top             =   5040
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label lblMessages 
      Caption         =   "Messages"
      Height          =   195
      Left            =   315
      TabIndex        =   3
      Top             =   5145
      Width           =   720
   End
   Begin VB.Label lblXml 
      AutoSize        =   -1  'True
      Caption         =   "XML"
      Height          =   195
      Left            =   315
      TabIndex        =   1
      Top             =   210
      Width           =   330
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuOpen 
         Caption         =   "&Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSave 
         Caption         =   "&Save"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
         Shortcut        =   ^X
      End
   End
   Begin VB.Menu mnuDOM 
      Caption         =   "&DOM"
      Enabled         =   0   'False
      Begin VB.Menu mnuRoot 
         Caption         =   "&Root"
      End
      Begin VB.Menu mnuCountNodes 
         Caption         =   "&Count nodes"
      End
      Begin VB.Menu mnuListNodes 
         Caption         =   "&List nodes"
      End
      Begin VB.Menu mnuCountElements 
         Caption         =   "Count Elemen&ts"
      End
      Begin VB.Menu mnuListElements 
         Caption         =   "List Eleme&nts"
      End
      Begin VB.Menu mnuImplementation 
         Caption         =   "&Implementaion"
      End
      Begin VB.Menu mnuDoctype 
         Caption         =   "doc&type"
      End
   End
   Begin VB.Menu mnuNodes 
      Caption         =   "&Nodes"
      Enabled         =   0   'False
      Begin VB.Menu mnuInspectNode 
         Caption         =   "&Inspect node"
      End
      Begin VB.Menu mnuAddNode 
         Caption         =   "&Add node"
      End
      Begin VB.Menu mnuAddElement 
         Caption         =   "Add &element"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuAddEntity 
         Caption         =   "Add e&ntity"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuAddAttribute 
         Caption         =   "Add a&ttribute"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuSearchAndReplace 
         Caption         =   "&Search and replace"
      End
      Begin VB.Menu mnuInsertElementBefore 
         Caption         =   "&Insert Element Before"
         Visible         =   0   'False
      End
   End
   Begin VB.Menu mnuNamedNodeMap 
      Caption         =   "Named Node &Map"
      Enabled         =   0   'False
      Begin VB.Menu mnuDisplayMapNodes 
         Caption         =   "&Display map nodes"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'********************************************************
' Simple application to load and manipulate the XML DOM
' frmMain
'********************************************************
Option Explicit

Dim dw As WroxXml.CDomFunctions
Dim strFilename As String
Dim domErr As WroxXml.DOMException

Private Sub Form_Load()
    Set objDOM = New DOMDocument
    Set dw = New CDomFunctions
   
End Sub

Private Sub mnuAddAttribute_Click()
    Dim oEl As IXMLDOMElement
    Set oEl = objDOM.selectNodes("//parser").Item(1)
    If Not dw.AddAttribute(objDOM, oEl, "TEST", "Boing!") Then
        txtMessages = "Add attribute failed." & vbCrLf & dw.GetErrorInfoXML()
    Else
        txtMessages = objDOM.xml
    End If
    
End Sub

Private Sub mnuAddElement_Click()
    Dim oEl As IXMLDOMElement
    Dim sEl As String
    sEl = "<1string id='1' type='text'>Hello</string>"
    
    Set oEl = objDOM.selectNodes("//parser").Item(1)
    If Not dw.AddElement(objDOM, oEl, "string", "Hello") Then
        txtMessages = "Add element failed." & vbCrLf & dw.GetErrorInfoXML()
    Else
        txtMessages = "Element added"
        txtXML = objDOM.xml
    End If
End Sub

Private Sub mnuAddEntity_Click()
    Dim oNode As IXMLDOMNode
    Set oNode = objDOM.selectNodes("//").Item(1)
    If Not dw.AddEntity(objDOM, oNode, "JGB") Then
        txtMessages = "Add entity failed." & vbCrLf & dw.GetErrorInfoXML()
    Else
        txtMessages = objDOM.xml
    End If
End Sub

Private Sub mnuAddNode_Click()
    frmAddNode.Show
End Sub

Private Sub mnuCountElements_Click()
    Call CountElements(objDOM)
End Sub

Private Sub mnuCountNodes_Click()
    Call CountNodes(objDOM)
End Sub

Private Sub mnuDisplayNodes_Click()

End Sub

Private Sub mnuDisplayMapNodes_Click()
    DisplayMapNodes objDOM, "//"
End Sub

Private Sub mnuDoctype_Click()
    Dim sDoctype As String
    If Not objDOM.doctype Is Nothing Then
        sDoctype = objDOM.doctype.Name
        MsgBox sDoctype, vbInformation
    Else
        MsgBox "No doctype!", vbExclamation
    End If
End Sub

Private Sub mnuExit_Click()
    End
End Sub

Private Sub mnuImplementation_Click()
    If Not objDOM.implementation Is Nothing Then
        MsgBox objDOM.implementation.hasFeature("XML", "1.0"), vbInformation
    Else
        MsgBox "The IDOMImplementation object is null."
    
    End If
End Sub

Private Sub mnuInsertElementBefore_Click()
    Dim oRefNode As IXMLDOMNode
    
    Set oRefNode = objDOM.getElementsByTagName("*").Item(5)
    If dw.InsertElementBefore(objDOM, oRefNode, "INSERT", "Hello!") Then
        txtXML = objDOM.xml
        txtMessages = "New node inserted"
    Else
        txtMessages = dw.GetErrorInfoXML
    End If
End Sub

Private Sub mnuInspectNode_Click()
    Dim nNodeIndex As Integer
    Dim nNodeCount As Integer
    nNodeCount = objDOM.selectNodes("//").length - 1
    
    nNodeIndex = InputBox("Enter a node index value, 0 to " & CStr(nNodeCount), "Inspect node", 0)
    
    Call InspectNode(nNodeIndex)
End Sub

Private Sub mnuListElements_Click()
    Call ListElements(objDOM)
End Sub

Private Sub mnuListNodes_Click()
   txtMessages = ListNodes(objDOM.documentElement, 1)
End Sub

Private Sub mnuOpen_Click()
    On Error GoTo ErrHand
    
    Dim strFilefilter  As String
    
    strFilefilter = "XML Files (*.xml)|*.xml|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CancelError = True
        .Filter = strFilefilter
        .ShowOpen
    End With
    
    strFilename = dlgOpen.FileName
    
    If (Len(strFilename) > 0) Then
        If Not LoadDocument(strFilename) Then
            MsgBox "Error loading XML document", vbExclamation, "XML load error"
            strFilename = ""
        Else
            mnuSave.Enabled = True
            mnuDOM.Enabled = True
            mnuNodes.Enabled = True
            mnuNamedNodeMap.Enabled = True
        End If
    End If
    
    
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
        Call ShowError(Err)
    End If
End Sub
Private Sub mnuRoot_Click()
    Call ShowRootElement(objDOM)
End Sub
Private Sub mnuSave_Click()
    If Len(strFilename) Then
        objDOM.save (strFilename)
    End If
End Sub


Function IsNodeIndexOK(oDOM As DOMDocument, nIndex As Integer) As Boolean
    If nIndex < 0 Then
        IsNodeIndexOK = False
    ElseIf nIndex > (oDOM.selectNodes("//").length - 1) Then
        IsNodeIndexOK = False
    Else
        IsNodeIndexOK = True
    End If
End Function
Sub CountElements(objDOM As DOMDocument)
    On Error GoTo ErrHand
    Dim nNodeCount As Integer
    Dim nIdx As Integer
    
    nNodeCount = objDOM.getElementsByTagName("*").length
    
    If (nNodeCount) Then
        txtMessages = "The document has " & CStr(nNodeCount) & " elements."
    Else
        MsgBox "There are no elements.", vbInformation, "Element count"
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If

End Sub

Sub CountNodes(objDOM As DOMDocument)
    On Error GoTo ErrHand
    Dim nNodeCount As Integer
    
    nNodeCount = objDOM.selectNodes("//").length
    If (nNodeCount) Then
        txtMessages = "The document has " & CStr(nNodeCount) & " nodes."
    Else
        MsgBox "There are no nodes.", vbInformation, "Node count"
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If

End Sub
Function DisplayMapNodes(oDOM As DOMDocument, strSelect As String) As Boolean
    Dim oNodeMap As IXMLDOMNamedNodeMap
    Dim oNode As IXMLDOMNode
    Dim oNodeList As IXMLDOMNodeList
    Dim oNodeAttr As IXMLDOMAttribute
    Dim nAttIdx As Integer
    
    Dim nIdx As Integer
    
    Set oNodeList = oDOM.selectNodes("//*[@*]")
    
    If Not oNodeList Is Nothing Then
        txtMessages = ""
        For nIdx = 0 To oNodeList.length - 1
            txtMessages = txtMessages & "Name: " & oNodeList.Item(nIdx).nodeName & vbTab & _
                            "Value: " & oNodeList(nIdx).nodeValue & vbCrLf
           For nAttIdx = 0 To oNodeList(nIdx).Attributes.length - 1
           ' If oNodeList(nIdx).Attributes.length > 0 Then
            '    Set oNodeAttr = oNodeList(nIdx).Attributes(0)
             '   Do While Not oNodeAttr Is Nothing
                    txtMessages = txtMessages & vbTab & "Att name: " & oNodeList(nIdx).Attributes(nAttIdx).nodeName & vbTab & "Value: " & oNodeList(nIdx).Attributes(nAttIdx).nodeValue & vbCrLf
               '     Set oNodeAttr = oNodeList(nIdx).Attributes.nextNode
              '  Loop
              'End If
            Next
           
        Next nIdx
    Else
        txtMessages = "Node map is null"
    End If

End Function
Sub InspectNode(nNodeIndex As Integer)
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim strNodeInfo As String
    Dim nIdx As Integer
    
    strNodeInfo = ""

    If Not dw.IsNodeIndexOK(objDOM, nNodeIndex) Then
        MsgBox "Node index out-of-bounds", vbExclamation, "Inspect Node Error"
        Exit Sub
    Else
        Set oNode = objDOM.selectNodes("//").Item(nNodeIndex)
        strNodeInfo = "Node index: " & vbTab & CStr(nNodeIndex) & vbCrLf
        
        With oNode
            strNodeInfo = strNodeInfo & "Node name: " & vbTab & .nodeName & vbCrLf
            strNodeInfo = strNodeInfo & "Node type: " & vbTab & .nodeTypeString & vbCrLf
            
            If (.nodeType = NODE_ELEMENT) Then
                strNodeInfo = strNodeInfo & "Attributes:" & vbCrLf
                If (.Attributes.length > 0) Then
                    For nIdx = 0 To .Attributes.length - 1
                        strNodeInfo = strNodeInfo & vbTab & vbTab & "Name =  '" & _
                        .Attributes(nIdx).baseName & "' " & vbTab & "Value = '" & _
                        .Attributes(nIdx).Text & "'" & vbCrLf
                    Next
                Else
                    strNodeInfo = strNodeInfo & vbTab & vbTab & "None." & vbCrLf
                End If
            End If
            strNodeInfo = strNodeInfo & "Number of child nodes: " & vbTab & _
                .childNodes.length & vbCrLf
            strNodeInfo = strNodeInfo & "Data type:" & vbTab & .dataType & vbCrLf
            If Not (.definition Is Nothing) Then
                strNodeInfo = strNodeInfo & "Definition: " & vbTab & _
                    .definition & vbCrLf
            End If
            strNodeInfo = strNodeInfo & "Namespace URI:" & vbTab & .namespaceURI & vbCrLf
            
            If Not (.nextSibling Is Nothing) Then
                strNodeInfo = strNodeInfo & "nextSibling:" & vbTab & _
                    .nextSibling.baseName & vbCrLf
            End If
            strNodeInfo = strNodeInfo & "Node typed value : " & vbTab & _
                .nodeTypedValue & vbCrLf
            strNodeInfo = strNodeInfo & "Node type : " & vbTab & .nodeType & vbCrLf
            strNodeInfo = strNodeInfo & "Node value: " & vbTab & .nodeValue & vbCrLf
            strNodeInfo = strNodeInfo & "Node owner document element name: " & vbTab _
                & .ownerDocument.documentElement.tagName & vbCrLf
            strNodeInfo = strNodeInfo & "Node XML: " & vbTab & .xml & vbCrLf
        End With
    End If
    
    txtMessages = strNodeInfo
    
ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If
    
End Sub

Sub ListElements(oDOM As DOMDocument)
   ' On Error GoTo ErrHand
    Dim sNodeList As String
    Dim nNodeCount As Integer
    Dim nElCount As Integer
    Dim oEl As IXMLDOMElement
    
    sNodeList = ""
    nElCount = 0
   
    For nNodeCount = 0 To oDOM.getElementsByTagName("*").length - 1
        Set oEl = oDOM.getElementsByTagName("*").Item(nNodeCount)
        sNodeList = sNodeList & CStr(nElCount) & ": Element name: " & _
            oEl.nodeName & vbTab & "Element text: " & dw.GetElementText(oEl) & vbCrLf
        nElCount = nElCount + 1
    Next
    
    If (Len(sNodeList)) Then
        txtMessages = sNodeList
    Else
        MsgBox "There are no elements.", vbInformation, "Element list"
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If
End Sub

Function ListNodes(oNode As IXMLDOMNode, nLevel As Integer) As String
    On Error GoTo ErrHand
    Dim nIdx As Integer
    Dim sTemp As String
    
    ' First, list the basic information
    sTemp = String(nLevel, vbTab) & "Name: " & vbTab & oNode.nodeName & vbCrLf
    sTemp = sTemp & String(nLevel, vbTab) & "Value: " & vbTab & oNode.nodeValue & vbCrLf
    sTemp = sTemp & String(nLevel, vbTab) & "Type: " & vbTab & oNode.nodeTypeString & vbCrLf
    
    ' Not all nodes have atributes, so first check ...
    If Not oNode.Attributes Is Nothing Then
      If (oNode.Attributes.length > 0) Then
        sTemp = sTemp & String(nLevel, vbTab) & "Attributes" & vbCrLf
        For nIdx = 0 To oNode.Attributes.length - 1
            sTemp = sTemp & String(nLevel + 1, vbTab) & "Name: " & vbTab & oNode.Attributes(nIdx).nodeName & vbTab & "Value: " & vbTab & oNode.Attributes(nIdx).nodeValue & vbCrLf
        Next
      End If
    End If
    ' Now see if there are child nodes ...
    If (oNode.childNodes.length > 0) Then
        For nIdx = 0 To oNode.childNodes.length - 1
            sTemp = sTemp & ListNodes(oNode.childNodes(nIdx), nLevel + 1)
        Next
    End If
    
    ListNodes = sTemp
    
ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If
    
End Function
'********************************************************
' Function LoadDocument(strFilename As String) As Boolean
' Loads the given file into the DOM object
'********************************************************
Function LoadDocument(strFilename As String) As Boolean
    On Error GoTo ErrHand
    
    objDOM.async = False
    
    If (objDOM.Load(strFilename)) Then
        txtXML = objDOM.xml
        LoadDocument = True
        txtMessages = "Document " & strFilename & " loaded succesfully."
        lblXml = "Contents of " & strFilename
    Else
       txtMessages = objDOM.parseError.reason
       lblXml = "XML"
        LoadDocument = False
    End If

   Exit Function

ErrHand:
        Call ShowError(Err)
        LoadDocument = False
    
End Function
Sub ShowError(e As ErrObject)
    If e.Number <> 0 Then
        MsgBox e.Description, vbExclamation, "Error " & CStr(e.Number) & " " & e.Source
    End If

End Sub
Sub ShowRootElement(oDOM As DOMDocument)
    On Error GoTo ErrHand
    Dim sDocumentElement As String
    
    sDocumentElement = ""
    ' Note that if we do not have a document loaded, then
    ' a reference to objDOM.documentElement.nodeName will throw
    ' an error
    If (Len(objDOM.xml)) Then
        sDocumentElement = objDOM.documentElement.nodeName
        txtMessages = "The root element is " & sDocumentElement
    Else
        MsgBox "There is no root element", vbExclamation, "Show Root Element"
    End If
    
    
ErrHand:
    If Err.Number <> 0 Then
        Call ShowError(Err)
    End If
End Sub


Sub zTestAddtextNodes()
    Dim oDOM As DOMDocument
    Dim oElNode As IXMLDOMElement
    Set oDOM = New DOMDocument
    oDOM.loadXML ("<TEST>Hello!</TEST>")
    
    Set oElNode = oDOM.childNodes(0)
    Debug.Print "Element TEST has " & oElNode.childNodes.length & " children"
    
    If Not dw.AddTextNode(oDOM, oElNode, "one") Then
        Debug.Print "Add text node failed!"
    Else
        Debug.Print "Add text node OK!"
        Debug.Print "Element TEST has " & oElNode.childNodes.length & " children"
    End If
    If Not dw.AddTextNode(objDOM, oElNode, "two") Then
        Debug.Print "Add text node failed!"
        
    Else
        Debug.Print "Add text node OK!"
        Debug.Print "Element TEST has " & oElNode.childNodes.length & " children"
    End If
    
    oElNode.normalize
    Debug.Print "Element TEST has " & oElNode.childNodes.length & " children"
    
End Sub
Sub zTestSplitText()
    
    Dim oDOM As DOMDocument
    Dim oElNode As IXMLDOMElement
    Dim oTextNode As IXMLDOMText
    Dim oTextNode2 As IXMLDOMText
    
    Set oDOM = New DOMDocument
    oDOM.loadXML ("<TEST>Hello!</TEST>")
    
    Set oElNode = oDOM.childNodes(0)
    Set oTextNode = oElNode.childNodes(0)
    Set oTextNode2 = oTextNode.splitText(23)
    Debug.Print oTextNode2.nodeValue

End Sub

Sub zTestSearchAndReplace()
    If dw.SearchAndReplace(objDOM.childNodes(1).childNodes(0), NODE_PROCESSING_INSTRUCTION, "boink", "SPoof") Then
        txtXML = objDOM.xml
        txtMessages = "Replace complete."
    Else
        txtXML = objDOM.xml
        txtMessages = "Error!" & vbCrLf & dw.GetErrorInfoXML()
    End If
End Sub

Sub ReplaceElementType(sOldElType As String, sNewElType As String)
    Dim oNode As IXMLDOMNode
    
    Set oNode = objDOM.documentElement
    If dw.SearchAndReplaceElementType(objDOM, oNode, sOldElType, sNewElType) Then
        txtXML = objDOM.xml
        txtMessages = "Replace complete."
    Else
        txtXML = objDOM.xml
        txtMessages = "Error!" & vbCrLf & dw.GetErrorInfoXML()
    End If
End Sub

Sub zGetElTExt()
    Dim oDomx As DOMDocument
    Dim oEl As IXMLDOMElement
    
    Set oDomx = New DOMDocument
    If oDomx.loadXML("<doc><el>This is the text &amp; stuff.<x>More X</x> in the node</el></doc>") Then
        Set oEl = oDomx.getElementsByTagName("el").Item(0)
        Debug.Print dw.GetElementText(oEl)
    Else
        Debug.Print oDomx.parseError.reason
    End If
  
End Sub

Private Sub mnuSearchAndReplace_Click()
    Dim sOldElementType As String
    Dim sNewElementType As String
    sOldElementType = InputBox("Element type to find", "Search & Replace")
    sNewElementType = InputBox("New Element type", "Search & Replace")
    Call ReplaceElementType(sOldElementType, sNewElementType)
    
End Sub

