VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "XmlHttp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'********************************************************************
' Class SoapRequest.XmlHttp
'********************************************************************
Option Explicit

Private m_sTransactionNamespace As String
Private m_SoapServer As String
Private m_sErrDesc As String
Private m_lErrNumber As Long
Private m_sErrSource As String
Private m_nTimeoutSeconds As Integer
Const HTTPRQ_COMPLETE As Long = 4

Public Property Get ErrorDescription() As String
    ErrorDescription = m_sErrDesc
End Property
Public Property Get ErrorNumber() As Long
    ErrorNumber = m_lErrNumber
End Property
Public Property Get ErrorSource() As String
    ErrorSource = m_sErrSource
End Property
Public Property Get TransactionNamespaceURI() As String
    TransactionNamespaceURI = m_sTransactionNamespace
End Property
Public Property Let TransactionNamespaceURI(ByVal sNamespaceURI As String)
    m_sTransactionNamespace = sNamespaceURI
End Property

Public Property Get SoapServer() As String
    SoapServer = m_SoapServer
End Property

Public Property Let SoapServerURL(ByVal sServer As String)
    m_SoapServer = sServer
End Property
Public Property Get TimeoutSeconds() As Integer
    TimeoutSeconds = m_nTimeoutSeconds
End Property

Public Property Let TimeoutSeconds(ByVal nTimeoutSeconds As Integer)
    m_nTimeoutSeconds = nTimeoutSeconds
End Property
Private Sub ClearErrorInfo()
    m_sErrDesc = ""
    m_lErrNumber = 0
    m_sErrSource = ""
End Sub

'********************************************************************
' Private Function GetMethodName(sPayload As String) As String
' Parse out the name of the method we're calling so we can set the
' SOAP header.  Returns an empty string if any trouble.
'********************************************************************
Private Function GetMethodName(sPayload As String) As String
    On Error GoTo ErrHand
    Dim oPayDOM As DOMDocument
    Dim oEl As IXMLDOMElement
    Dim asTemp() As String
    Dim sMethodName As String
    
    Call ClearErrorInfo
    Set oPayDOM = New DOMDocument
        
    If oPayDOM.loadXML(sPayload) Then
        ' Method name should be the first element below SOAP:Body
        Set oEl = oPayDOM.getElementsByTagName("SOAP:Body").Item(0).childNodes.Item(0)
        If Not oEl Is Nothing Then
            sMethodName = oEl.nodeName
            If InStr(sMethodName, ":") Then
                asTemp = Split(sMethodName, ":")
                sMethodName = asTemp(1)
            Else
                sMethodName = ""
                Call SetErrorInfo("Error getting method name.", _
                    "SoapRequest.XmlHttp.GetMethodName", -1)
            End If
        Else
            sMethodName = ""
            Call SetErrorInfo("Error getting method name. No SOAP:Body", _
                "SoapRequest.XmlHttp.GetMethodName", -1)
        End If
    Else
        sMethodName = ""
        Call SetErrorInfo("Error getting method name.", _
            "SoapRequest.XmlHttp.GetMethodName", -1)
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo("COM error: " & Err.Description, _
            "SoapRequest.XmlHttp.GetMethodName", Err.Number)
        sMethodName = ""
    End If
    
    GetMethodName = sMethodName
End Function
'********************************************************************
' Public Function PostRequest(sSoapPayload As String) As String
' Posts a SOAP request to a SOAP server and returns the response.
' Returns an empty string if trouble.  Callers should check the
' length of the return value, and check the error properties if len = 0
'********************************************************************
Public Function PostRequest(sSoapPayload As String) As String
    On Error GoTo ErrHand
    Dim sMethodName As String
    Dim sResults As String
    Dim oDomRsp As DOMDocument
    Dim sDecoded As String
    Dim nIdx As Integer
    Dim datWaitUntil As Date
    Dim sErrorReason As String
    Dim oDOM As MSXML.DOMDocument
    Dim oHttp As MSXML.XMLHTTPRequest
    
    Call ClearErrorInfo
    Set oHttp = New XMLHTTPRequest
    Set oDOM = New DOMDocument
    If (Len(m_SoapServer) > 0) And (Len(m_sTransactionNamespace) > 0) Then
        If oDOM.loadXML(sSoapPayload) Then
            sMethodName = GetMethodName(sSoapPayload)
            If Len(sMethodName) Then
                oHttp.open "POST", m_SoapServer, False
                oHttp.setRequestHeader "Content-type:", "text/xml"
                oHttp.setRequestHeader "Content-length:", CStr(Len(sSoapPayload))
                oHttp.setRequestHeader "SOAPMethodName:", m_sTransactionNamespace _
                    & "#" & sMethodName
                oHttp.send oDOM
                ' Set up a timer so we don't wait forever
                ' for a response
                datWaitUntil = DateAdd("s", m_nTimeoutSeconds, Now())
                Do While (oHttp.readyState <> HTTPRQ_COMPLETE) And _
                         (datWaitUntil > Now())
                    DoEvents
                Loop
                If (oHttp.readyState <> HTTPRQ_COMPLETE) Then
                    sResults = ""
                    Call SetErrorInfo("Request timed out", _
                        "SoapRequest.XmlHttp.PostRequest", _
                        -1)
                Else
                    sResults = oHttp.getAllResponseHeaders
                    sResults = sResults & oHttp.responseText
                End If
            Else
            ' Could not retrieve method name
            ' Error info is set in GetMethodName
                sResults = ""
            End If
        Else
            Call SetErrorInfo("Error parsing request: " & _
                oDOM.parseError.reason & _
                "filepos: " & oDOM.parseError.filepos, _
                "SoapRequest.XmlHttp.PostRequest", oDOM.parseError.errorCode)
            sResults = ""
        End If
    Else
        ' no server name or no namespace!
        If Len(m_SoapServer) < 1 Then
            sErrorReason = "No remote server was specified."
        Else
            sErrorReason = "No transaction namespace was given."
        End If
        Call SetErrorInfo(sErrorReason, "SoapRequest.XmlHttp.PostRequest", -1)
        sResults = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo("COM error: " & Err.Description, _
            "SoapRequest.XmlHttp.PostRequest", Err.Number)
        sResults = ""
    End If
    
    Set oHttp = Nothing
    Set oDOM = Nothing

    PostRequest = sResults
End Function
'********************************************************************************
' Private Sub SetErrorInfo(sDesc As String, sSource As String, lNumber As Long)
'********************************************************************************
Private Sub SetErrorInfo(sDesc As String, sSource As String, lNumber As Long)
    m_sErrDesc = sDesc
    m_lErrNumber = lNumber
    m_sErrSource = sSource
End Sub

Private Sub Class_Initialize()
    m_nTimeoutSeconds = 120
End Sub
