VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDomFunctions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'***************************************************************************
' Class to demonstrate using the DOM in VB, and to provide
' DOM wrapper functions to simplify manipulating nodes
' Som observations:
' The DOC_TYPE node does not expose its contents as child nodes.
' You can inspect the entities by explicity looking at them, etc.,
' but you will not see the ELEMENT or ATTLIST  text unless you
' get the XML from the node.
' The DOM spec states:
' "Each Document has a doctype attribute whose value is either null
' or a DocumentType object. The DocumentType interface in the DOM Level 1
' Core provides an interface to the list of entities that are defined for
' the document, and little else because the effect of namespaces and the
' various XML scheme efforts on DTD representation are not clearly understood
' as of this writing. The DOM Level 1 doesn't support editing DocumentType nodes."

'***************************************************************************
Option Explicit
Public Enum DOMException
    NO_ERROR = 0
    INDEX_SIZE_ERR = 1
    DOMSTRING_SIZE_ERR = 2
    HIERARCHY_REQUEST_ERR = 3
    WRONG_DOCUMENT_ERR = 4
    INVALID_CHARACTER_ERR = 5
    NO_DATA_ALLOWED_ERR = 6
    NO_MODIFICATION_ALLOWED_ERR = 7
    NOT_FOUND_ERR = 8
    NOT_SUPPORTED_ERR = 9
    INUSE_ATTRIBUTE_ERR = 10
    UNKNOWN = 99
End Enum

Public Enum NodeType
    NODE_INVALID = 0
    NODE_ELEMENT = 1
    NODE_ATTRIBUTE = 2
    NODE_TEXT = 3
    NODE_CDATA_SECTION = 4
    NODE_ENTITY_REFERENCE = 5
    NODE_ENTITY = 6
    NODE_PROCESSING_INSTRUCTION = 7
    NODE_COMMENT = 8
    NODE_DOCUMENT = 9
    NODE_DOCUMENT_TYPE = 10
    NODE_DOCUMENT_FRAGMENT = 11
    NODE_NOTATION = 12
End Enum

Const domerrNO_ERROR As Integer = 0
Const domerrINDEX_SIZE_ERR As Integer = 1
Const domerrDOMSTRING_SIZE_ERR  As Integer = 2
Const domerrHIERARCHY_REQUEST_ERR  As Integer = 3
Const domerrWRONG_DOCUMENT_ERR  As Integer = 4
Const domerrINVALID_CHARACTER_ERR As Integer = 5
Const domerrNO_DATA_ALLOWED_ERR As Integer = 6
Const domerrNO_MODIFICATION_ALLOWED_ERR  As Integer = 7
Const domerrNOT_FOUND_ERR  As Integer = 8
Const domerrNOT_SUPPORTED_ERR  As Integer = 9
Const domerrINUSE_ATTRIBUTE_ERR  As Integer = 10
Const domerrUNKNOWN As Integer = 99

Private m_strErrorDescription As String
Private m_lngErrorNumber As Long
Private m_strErrorSource As String
Private m_DomError As DOMException

Public Property Get ErrorDescription() As String
    ErrorDescription = m_strErrorDescription
End Property
Public Property Get domError() As DOMException
    domError = m_DomError
End Property

Public Property Get ErrorNumber() As Long
    ErrorNumber = m_lngErrorNumber
End Property
Public Property Get ErrorSource() As String
    ErrorSource = m_strErrorSource
End Property

'***************************************************************************
' Public Function AddAttribute(oDOM As DOMDocument,
'                            oElement As IXMLDOMElement,
'                            sName As String,
'                            sValue As String
'                            ) As Boolean
'
'***************************************************************************
Public Function AddAttribute(oDOM As DOMDocument, _
                            oElement As IXMLDOMElement, _
                            sName As String, _
                            sValue As String, _
                            Optional bReplace As Boolean = False _
                            ) As Boolean
    On Error GoTo ErrHand
    
    Dim oAttr As IXMLDOMAttribute
    Dim bResults As Boolean
    
    Call ClearErrorInfo
    ' First see if the attribute already exists ...
    If (Not oElement.Attributes.getNamedItem(sName) Is Nothing) Then
        If bReplace = False Then
            bResults = False
        End If
    Else
        Set oAttr = oDOM.createAttribute(sName)
        oElement.setAttribute sName, sValue
        oElement.setAttribute sName, sValue
        bResults = True
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
        bResults = False
    End If
    
    AddAttribute = bResults
End Function

'***************************************************************************
' Public Function AddCDATA(oDOM As DOMDocument,
'                     oPNode As IXMLDOMNode,
'                     sElementContent As String
'                     ) As Boolean
'
'***************************************************************************
Public Function AddCDATA(oDOM As DOMDocument, _
                    oPNode As IXMLDOMNode, _
                    sCDATAContent As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMCDATASection
    Dim bResults As Boolean
    
    Call ClearErrorInfo
    ' <![CDATA[<greeting>Hello, world!</greeting>]]>
    ' We need to check that the string we're assigning to the
    ' CDATA section doesn't contain the "end of CDATA section"
    ' character combo: ]]>
    If (InStr(sCDATAContent, "]]>")) Then
        bResults = False
        Call SetErrorInfo(-1, "Invalid character string: ']]>' ", _
            "CDomFunctions.AddCDATA", INVALID_CHARACTER_ERR)
    Else
        Select Case oPNode.NodeType
            Case NODE_DOCUMENT_FRAGMENT, NODE_ENTITY_REFERENCE, NODE_ELEMENT:
                Set elNode = oDOM.createCDATASection(sCDATAContent)
                'Set oNode = oPNode.appendChild(elNode)
                oPNode.appendChild elNode
                bResults = True
            Case Else
                bResults = False
                Call SetErrorInfo(-1, "Invalid parent node type.", _
                    "CDomFunctions.AddCDATA", HIERARCHY_REQUEST_ERR)
        End Select
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
        bResults = False
    End If
    AddCDATA = bResults
End Function
Public Function AddComment(oDOM As DOMDocument, _
                    oPNode As IXMLDOMNode, _
                    sContent As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMComment
    Dim bResults As Boolean
    
    Call ClearErrorInfo

    Select Case oPNode.NodeType
        Case NODE_DOCUMENT_FRAGMENT, NODE_DOCUMENT, NODE_ENTITY_REFERENCE, NODE_ELEMENT:
            Set elNode = oDOM.createComment(sContent)
            'Set oNode = oPNode.appendChild(elNode)
            oPNode.appendChild elNode
            bResults = True
        Case Else
            bResults = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddComment", HIERARCHY_REQUEST_ERR)
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
        bResults = False
    End If

    AddComment = bResults

End Function
' doctype is read-only!
Public Function AddDocType(oDOM As DOMDocument, _
                    oPNode As IXMLDOMNode, _
                    sContent As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim dtNode As MSXML.IXMLDOMDocumentType
    
    Call ClearErrorInfo

    Select Case oPNode.NodeType
        Case NODE_DOCUMENT:
            Set dtNode = oDOM.createNode(NODE_DOCUMENT_TYPE, "", "")
            dtNode.Text = sContent
            'Set oNode = oPNode.appendChild(dtNode)
            oPNode.appendChild dtNode
            AddDocType = True
        Case Else
            AddDocType = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddDocType", HIERARCHY_REQUEST_ERR)
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
        AddDocType = False
    End If

End Function

Public Function AddElement(oDOM As DOMDocument, _
                    oPNode As IXMLDOMNode, _
                    sElementName As String, _
                    sElementContent As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMElement
    Dim bResults As Boolean
    
    Call ClearErrorInfo
    ' Need to check that the element name is valid
    If Not ValidateElementType(sElementName) Then
        AddElement = False
        Call SetErrorInfo(-1, "Invalid element type", _
            "CDomFunctions.AddElement", INVALID_CHARACTER_ERR)
        bResults = False
    Else
        Select Case oPNode.NodeType
            Case NODE_DOCUMENT, NODE_DOCUMENT_FRAGMENT, _
                NODE_ENTITY_REFERENCE, NODE_ELEMENT:
                Set elNode = oDOM.createElement(sElementName)
                Set oNode = oPNode.appendChild(elNode)
                If (Len(sElementContent)) Then
                    oNode.Text = sElementContent
                End If
                bResults = True
            Case Else
                bResults = False
                Call SetErrorInfo(-1, "Invalid parent node type.", _
                    "CDomFunctions.AddElement", HIERARCHY_REQUEST_ERR)
        End Select
    End If

ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
    End If
    
    AddElement = bResults
End Function

Public Function AddElementXML(oDOM As DOMDocument, _
                    oPNode As IXMLDOMNode, _
                    sElementXML As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMElement
    Dim oTempDOM As DOMDocument
    Dim nIdx As Integer
    Dim strParserErr As String
    Dim domErr As DOMException
    
    Call ClearErrorInfo
    
    Set oTempDOM = New DOMDocument
    If Not (oTempDOM.loadXML(sElementXML)) Then
        AddElementXML = False
        strParserErr = oTempDOM.parseError.reason
        If InStr(strParserErr, "name was started with an invalid character") Then
            domErr = INVALID_CHARACTER_ERR
        Else
            domErr = UNKNOWN
        End If
        Call SetErrorInfo(-1, "Invalid element XML: " & strParserErr, _
            "CDomFunctions.AddElementXML", domErr)
        AddElementXML = False
        Exit Function
    End If
    
    Select Case oPNode.NodeType
        Case NODE_DOCUMENT, NODE_DOCUMENT_FRAGMENT, NODE_ENTITY_REFERENCE, NODE_ELEMENT:
            Set elNode = oDOM.createElement(oTempDOM.documentElement.nodeName)
            Set oNode = oPNode.appendChild(elNode)
            If (Len(oTempDOM.documentElement.Text)) Then
                oNode.Text = oTempDOM.documentElement.Text
            End If
            If (oTempDOM.documentElement.Attributes.length > 0) Then
                With oTempDOM.documentElement.Attributes
                  For nIdx = 0 To oTempDOM.documentElement.Attributes.length - 1
                    If Not (AddAttribute(oDOM, oNode, .Item(nIdx).nodeName, .Item(nIdx).nodeValue)) Then
                      AddElementXML = False
                      Call SetErrorInfo(-1, "Error adding attribute.", "CDomFunctions.AddElementXML", UNKNOWN)
                      Exit Function
                    End If
                  Next
                End With
            End If
            AddElementXML = True
        Case Else
            AddElementXML = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddElementXML", UNKNOWN)
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
    AddElementXML = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
    End If
End Function

Public Function AddEntity(oDOM As DOMDocument, _
                            oPNode As IXMLDOMNode, _
                            sEntity As String _
                            ) As Boolean
    On Error GoTo ErrHand
    ' You cannot create a node of type NODE_DOCUMENT,
    ' NODE_DOCUMENT_TYPE,
    ' NODE_ENTITY, or
    ' NODE_NOTATION.
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMEntity
    'oDOM.doctype.entities.setNamedItem
    Call ClearErrorInfo
    
    Select Case oPNode.NodeType
        Case NODE_DOCUMENT_TYPE:
            Set elNode = oDOM.createNode(0, sEntity, "")  ' .createEntityReference(sEntity)
            oDOM.doctype.entities.SetNamedItem elNode
            AddEntity = True
        Case Else
            AddEntity = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddEntity", HIERARCHY_REQUEST_ERR)
    
    End Select

ErrHand:
    If Err.Number <> 0 Then
    AddEntity = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
    End If
End Function

Public Function AddEntityReference(oDOM As DOMDocument, _
                            oPNode As IXMLDOMNode, _
                            sEntity As String _
                            ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim entrefNode As MSXML.IXMLDOMEntityReference
    
    Call ClearErrorInfo
    
    Select Case oPNode.NodeType
        Case NODE_ATTRIBUTE, NODE_DOCUMENT_FRAGMENT, NODE_ENTITY_REFERENCE, NODE_ELEMENT:
            Set entrefNode = oDOM.createEntityReference(sEntity)
            'Set oNode = oPNode.appendChild(entrefNode)
            oPNode.appendChild entrefNode
            AddEntityReference = True
        Case Else
            AddEntityReference = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddEntityReference", HIERARCHY_REQUEST_ERR)
    End Select

ErrHand:
    If Err.Number <> 0 Then
    AddEntityReference = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
    End If
End Function

Public Function AddNode(oDOM As DOMDocument, nIndex As Integer, _
                        nNodeType As DOMNodeType, _
                        sNodeName As String, _
                        sNodeContent As String _
                        ) As Boolean
                        
    Dim oNode As Object
    
    AddNode = True
    
    If (IsNodeIndexOK(oDOM, nIndex)) Then
        Set oNode = oDOM.selectNodes("//").Item(nIndex)
        Select Case nNodeType
            Case NODE_ELEMENT
                If Not AddElement(oDOM, oNode, sNodeName, sNodeContent) Then
                    AddNode = False
                End If
            Case NODE_ATTRIBUTE
                If Not AddAttribute(oDOM, oNode, sNodeName, sNodeContent) Then
                    AddNode = False
                End If
           
            Case NODE_TEXT
                If Not AddTextNode(oDOM, oNode, sNodeContent) Then
                    AddNode = False
                End If
            
            Case NODE_CDATA_SECTION
                If Not AddCDATA(oDOM, oNode, sNodeContent) Then
                    AddNode = False
                End If
            
            Case NODE_ENTITY_REFERENCE
                If Not AddEntityReference(oDOM, oNode, sNodeName) Then
                    AddNode = False
                End If
            
            Case NODE_ENTITY
                AddNode = False
                Call SetErrorInfo(-1, "Not implememented", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
                
            Case NODE_PROCESSING_INSTRUCTION
                If Not AddPI(oDOM, oNode, sNodeName, sNodeContent) Then
                    AddNode = False
                End If
                
            Case NODE_COMMENT
                If Not AddComment(oDOM, oNode, sNodeContent) Then
                    AddNode = False
                End If
            
            Case NODE_DOCUMENT
                AddNode = False
                Call SetErrorInfo(-1, "Not implememented", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
            
            Case NODE_DOCUMENT_TYPE
                AddNode = False
                Call SetErrorInfo(-1, "Not implememented", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
            
            Case NODE_DOCUMENT_FRAGMENT
                AddNode = False
                Call SetErrorInfo(-1, "Not implememented", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
            
            Case NODE_NOTATION
                AddNode = False
                Call SetErrorInfo(-1, "Not implememented", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
            
            Case Else
                AddNode = False
                Call SetErrorInfo(-1, "Unknown parent node type", "CDomFucntions.AddNode", NOT_SUPPORTED_ERR)
        End Select
    Else
        AddNode = False
        Call SetErrorInfo(-1, "Parent node index out-of-bounds.", "CDomFunctions.AddNode", INDEX_SIZE_ERR)
    End If

End Function

Public Function AddPI(oDOM As DOMDocument, _
                            oPNode As IXMLDOMNode, _
                            sTarget As String, _
                            sInstruction As String _
                            ) As Boolean
    On Error GoTo ErrHand
   

    Dim piNode As MSXML.IXMLDOMProcessingInstruction
    Dim bResults As Boolean
    
    Call ClearErrorInfo
    
    Select Case oPNode.NodeType
        Case NODE_DOCUMENT, NODE_DOCUMENT_FRAGMENT, _
             NODE_ENTITY_REFERENCE, NODE_ELEMENT:
            Set piNode = oDOM.createProcessingInstruction(sTarget, sInstruction)
            oPNode.appendChild piNode
            bResults = True
        Case Else
            bResults = False
            Call SetErrorInfo(-1, "Invalid parent node type.", _
                "CDomFunctions.AddPI", HIERARCHY_REQUEST_ERR)
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." _
            & Err.Source, UNKNOWN)
    End If
    
    AddPI = bResults
End Function

Public Function AddTextNode(oDOM As DOMDocument, _
                            oPNode As IXMLDOMNode, _
                            sValue As String _
                            ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMText
    
    Call ClearErrorInfo
    
    Select Case oPNode.NodeType
        Case NODE_ATTRIBUTE, NODE_DOCUMENT_FRAGMENT, NODE_ENTITY_REFERENCE, NODE_ELEMENT:
            Set elNode = oDOM.createTextNode(sValue)
            ' Set oNode = oPNode.appendChild(elNode)
            oPNode.appendChild elNode
            AddTextNode = True
        Case Else
            AddTextNode = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.AddTextNode", HIERARCHY_REQUEST_ERR)
    End Select
    
ErrHand:
    If Err.Number <> 0 Then
    AddTextNode = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions." & Err.Source, UNKNOWN)
    End If
End Function
Private Sub ClearErrorInfo()
    m_strErrorDescription = ""
    m_lngErrorNumber = 0
    m_strErrorSource = ""
    m_DomError = NO_ERROR
End Sub

Public Function DOMErrorToString(domError As DOMException) As String
    Select Case domError
        Case NO_ERROR: DOMErrorToString = "NO_ERROR"
        Case INDEX_SIZE_ERR: DOMErrorToString = "INDEX_SIZE_ERR"
        Case DOMSTRING_SIZE_ERR: DOMErrorToString = "DOMSTRING_SIZE_ERR"
        Case HIERARCHY_REQUEST_ERR: DOMErrorToString = "HIERARCHY_REQUEST_ERR"
        Case WRONG_DOCUMENT_ERR: DOMErrorToString = "WRONG_DOCUMENT_ERR"
        Case INVALID_CHARACTER_ERR: DOMErrorToString = "INVALID_CHARACTER_ERR"
        Case NO_DATA_ALLOWED_ERR: DOMErrorToString = "NO_DATA_ALLOWED_ERR"
        Case NO_MODIFICATION_ALLOWED_ERR: DOMErrorToString = "NO_MODIFICATION_ERR"
        Case NOT_FOUND_ERR: DOMErrorToString = "NOT_FOUND_ERR"
        Case NOT_SUPPORTED_ERR: DOMErrorToString = "NOT_SUPPORTED_ERR"
        Case INUSE_ATTRIBUTE_ERR: DOMErrorToString = "INUSE_ATTRIBUTE_ERR"
        Case Else:          DOMErrorToString = "UKNOWN"
End Select
End Function
Public Function GetAttributeNode(oEL As IXMLDOMElement, sAttrName As String) As IXMLDOMAttribute
    Dim oAttrTemp As IXMLDOMAttribute
    
    If Not IsNull(oEL.getAttribute(sAttrName)) Then
        Set GetAttributeNode = oEL.GetAttributeNode(sAttrName)
        Exit Function
    Else
        Set GetAttributeNode = oAttrTemp
    End If
End Function

Public Function RemoveAttributeNode(oEL As IXMLDOMElement, oAttr As IXMLDOMAttribute) As IXMLDOMAttribute
    Dim oAttrTemp As IXMLDOMAttribute
    Dim sAttrName As String
    sAttrName = oAttr.Name
    
    If Not IsNull(oEL.getAttribute(sAttrName)) Then
     ' Attribute exists, so we can remove it
     ' and return the removed node
        Set RemoveAttributeNode = oEL.RemoveAttributeNode(oAttr)
        Exit Function
    Else
        ' Return a Nothing node
        Set RemoveAttributeNode = oAttrTemp
    End If

End Function
Public Function RemoveNamedItem(oNode As IXMLDOMNode, oMap As IXMLDOMNamedNodeMap) As IXMLDOMNode
    Dim sName As String
    Dim oNodeTemp As IXMLDOMNode
    
    sName = oNode.baseName
    If oMap.getNamedItem(sName) Is Nothing Then
        ' This node doesn't exist, so we can't remove it.
        ' Return a Nothing node object
        Set RemoveNamedItem = oNodeTemp
        Exit Function
    Else ' Let's remove it, and return the vanished node
        Set RemoveNamedItem = oMap.getNamedItem(sName)
        oMap.RemoveNamedItem oNode
        Exit Function
    
    End If
End Function
Public Function SetNamedItem(oNode As IXMLDOMNode, oMap As IXMLDOMNamedNodeMap) As IXMLDOMNode
    Dim sName As String
    Dim oNodeTemp As IXMLDOMNode
    
    sName = oNode.baseName
    If oMap.getNamedItem(sName) Is Nothing Then
        ' This is a new node. Return a Nothing node object
        Set SetNamedItem = oNodeTemp
        oMap.SetNamedItem oNode
        Exit Function
    Else ' We're replacing. Return the replaced node
        Set SetNamedItem = oMap.getNamedItem(sName)
        oMap.SetNamedItem oNode
        Exit Function
    
    End If
End Function
'**********************************************************************
' Public Function GetElementText(oEl As IXMLDOMElement) As String
' Takes an Element node and returns the textual content as a single string
'**********************************************************************
Public Function GetElementText(oEL As IXMLDOMElement) As String
    On Error GoTo ErrHand
    
    Dim oTextNode As IXMLDOMText
    Dim nIdx As Integer
    Dim sElText As String
    
    ClearErrorInfo
    
    sElText = ""
    For nIdx = 0 To oEL.childNodes.length - 1
        If oEL.childNodes.Item(nIdx).NodeType = NODE_TEXT Then
            sElText = sElText & oEL.childNodes.Item(nIdx).nodeValue
        End If
    Next
 
    
ErrHand:
    If Err.Number <> 0 Then
        sElText = ""
        Call SetErrorInfo(Err.Number, Err.Description, _
            "CDomFunctions.GetElementText", UNKNOWN)
    End If
    
    GetElementText = sElText
End Function

Public Function GetErrorInfoXML() As String
    Dim s As String
    s = ""
    s = s & "<ERROR object='CDomFunctions'>" & vbCrLf
    s = s & "<NUMBER>" & CStr(m_lngErrorNumber) & "</NUMBER>" & vbCrLf
    s = s & "<SOURCE>" & m_strErrorSource & "</SOURCE>" & vbCrLf
    s = s & "<DESCRIPTION>" & m_strErrorDescription & "</DESCRIPTION>" & vbCrLf
    s = s & "<DOMERROR>" & DOMErrorToString(m_DomError) & "</DOMERROR>" & vbCrLf
    s = s & "</ERROR>"
    GetErrorInfoXML = s
End Function

Public Function InsertElementBefore(oDOM As DOMDocument, _
                    oRefNode As IXMLDOMNode, _
                    sElementName As String, _
                    sElementContent As String _
                    ) As Boolean
    On Error GoTo ErrHand
    
    Dim oNode As MSXML.IXMLDOMNode
    Dim elNode As MSXML.IXMLDOMElement
    Dim oPNode As IXMLDOMNode
    
    Call ClearErrorInfo
    
    
    ' Need to check that the element name is valid
    If Not ValidateElementType(sElementName) Then
        InsertElementBefore = False
        Call SetErrorInfo(-1, "Invalid element type", _
            "CDomFunctions.InsertElementBefore", INVALID_CHARACTER_ERR)
        Exit Function
    End If
    
    Set oPNode = oRefNode.parentNode
    ' We need to check that the parent of the referring node
    ' will accept an Element node
    Select Case oPNode.NodeType
        Case NODE_DOCUMENT, NODE_DOCUMENT_FRAGMENT, NODE_ENTITY_REFERENCE, _
            NODE_ELEMENT:
            Set elNode = oDOM.createElement(sElementName)
            Set oNode = oPNode.insertBefore(elNode, oRefNode)
            If (Len(sElementContent)) Then
                oNode.Text = sElementContent
            End If
            InsertElementBefore = True
        Case Else
            InsertElementBefore = False
            Call SetErrorInfo(-1, "Invalid parent node type.", "CDomFunctions.InsertElementBefore", HIERARCHY_REQUEST_ERR)
    End Select

ErrHand:
    If Err.Number <> 0 Then
        InsertElementBefore = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions.InsertElementBefore " & Err.Source, UNKNOWN)
    End If
End Function
Public Function IsNodeIndexOK(oDOM As DOMDocument, nIndex As Integer) As Boolean
    If nIndex < 0 Then
        IsNodeIndexOK = False
    ElseIf nIndex > (oDOM.selectNodes("//").length - 1) Then
        IsNodeIndexOK = False
    Else
        IsNodeIndexOK = True
    End If
End Function

Public Function SearchAndReplace(oPNode As IXMLDOMNode, _
                                DomNodeTargetNodeType As DOMNodeType, _
                                sOldText As String, _
                                sNewText As String, _
                                Optional bLastFoundValue As Boolean = False _
                                ) As Boolean
    On Error GoTo ErrHand
    
    Dim strTemp As String
    Dim nIdx As Integer
    Dim bFoundIt As Boolean
    
    bFoundIt = bLastFoundValue
    
    ' We want to walk through the oPNode tree of nodes, looking for
    ' nodes of DomNodeTargetNodeType .  If we find any, we want to
    ' see if it contains text we can search and replace.
    ' First we need to see if the target node type can actually have
    ' any text.  If not, then return false and set the error info.
    
    'Default to False; we'll change this value if we actually replace anything
    If (Not bLastFoundValue) Then
        SearchAndReplace = False
        Call SetErrorInfo(-1, "Text not found", "CDomFunctions.SearchAndReplace", NOT_FOUND_ERR)
    End If
   
       
    Select Case DomNodeTargetNodeType
        Case NODE_ENTITY, NODE_DOCUMENT_TYPE, NODE_NOTATION, NODE_ENTITY_REFERENCE
            SearchAndReplace = False
            Call SetErrorInfo(-1, "Node and children are read-only", "CDomFunctions.SearchAndReplace", NO_MODIFICATION_ALLOWED_ERR)
            Exit Function
        Case Else
            ' Now see if the pNode is the type we're looking for
            If DomNodeTargetNodeType = oPNode.NodeType Then
                ' See what we can replace
                ' If the target type is Element or Attr, we'll interpret
                ' this to mean search and replace on the child nodes.
                Select Case oPNode.NodeType
                    Case NODE_TEXT
                        strTemp = oPNode.Text
                        If InStr(strTemp, sOldText) Then
                            strTemp = Replace(strTemp, sOldText, sNewText)
                            oPNode.Text = strTemp
                            SearchAndReplace = True
                            bFoundIt = True
                            Call ClearErrorInfo
                        End If
                    Case NODE_CDATA_SECTION
                        strTemp = oPNode.Text
                        If InStr(strTemp, sOldText) Then
                            strTemp = Replace(strTemp, sOldText, sNewText)
                            oPNode.Text = strTemp
                            SearchAndReplace = True
                            bFoundIt = True
                            Call ClearErrorInfo
                        End If
                    
                    Case NODE_COMMENT
                        strTemp = oPNode.Text
                        If InStr(strTemp, sOldText) Then
                            strTemp = Replace(strTemp, sOldText, sNewText)
                            oPNode.Text = strTemp
                            SearchAndReplace = True
                            bFoundIt = True
                            Call ClearErrorInfo
                        End If
                    Case NODE_PROCESSING_INSTRUCTION
                        Dim pi As IXMLDOMProcessingInstruction
                        'pi.Data
                        strTemp = oPNode.nodeValue
                        If InStr(strTemp, sOldText) Then
                            strTemp = Replace(strTemp, sOldText, sNewText)
                            oPNode.Text = strTemp
                            SearchAndReplace = True
                            bFoundIt = True
                            Call ClearErrorInfo
                        End If
                    
                    Case NODE_DOCUMENT_FRAGMENT, NODE_ELEMENT
                        For nIdx = 0 To oPNode.childNodes.length - 1
                            If (oPNode.childNodes(nIdx).NodeType = NODE_TEXT) Then
                                strTemp = oPNode.childNodes(nIdx).Text
                                If InStr(strTemp, sOldText) Then
                                    strTemp = Replace(strTemp, sOldText, sNewText)
                                    oPNode.childNodes(nIdx).Text = strTemp
                                    SearchAndReplace = True
                                    Call ClearErrorInfo
                                    bFoundIt = True
                                End If
                            ElseIf (oPNode.childNodes(nIdx).NodeType = NODE_ELEMENT) Then
                                ' Kepp walking the tree
                                bFoundIt = bFoundIt Or SearchAndReplace(oPNode.childNodes(nIdx), DomNodeTargetNodeType, sOldText, sNewText, bFoundIt)
                            End If
                         Next
                                            
                    Case Else
                        ' Error
                        SearchAndReplace = False
                        Call SetErrorInfo(-1, "Unexpected node type", "CDomFucntions.SearchAndReplace", UNKNOWN)
                        Exit Function
                End Select
            Else
                ' See if the parent node is an Attr; we won't
                ' see the attributes as child nodes, so just peek at
                ' them here and see if we can replace them
                If (DomNodeTargetNodeType = NODE_ATTRIBUTE) Then
                    If oPNode.NodeType = NODE_ELEMENT Then
                        For nIdx = 0 To oPNode.Attributes.length - 1
                            strTemp = oPNode.Attributes(0).nodeValue
                            If InStr(strTemp, sOldText) Then
                                strTemp = Replace(strTemp, sOldText, sNewText)
                                oPNode.Attributes(0).nodeValue = strTemp
                                SearchAndReplace = True
                                bFoundIt = True
                                Call ClearErrorInfo
                            End If
                        Next
                    End If
                End If
                ' Look at the parent node's children
                If oPNode.childNodes.length > 0 Then
                    For nIdx = 0 To oPNode.childNodes.length - 1
                        bFoundIt = bFoundIt Or SearchAndReplace(oPNode.childNodes(nIdx), DomNodeTargetNodeType, sOldText, sNewText, bFoundIt)
                    Next
                Else
                    ' All done
                    SearchAndReplace = bFoundIt
                    Exit Function
                End If
            End If
    End Select
    SearchAndReplace = bFoundIt
    
ErrHand:
    If Err.Number <> 0 Then
        SearchAndReplace = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions.SearchAndReplace " & Err.Source, UNKNOWN)
        End If

End Function
Public Function SearchAndReplaceElementType( _
                            oDOM As DOMDocument, _
                            oNode As IXMLDOMNode, _
                            sOldType As String, _
                            sNewType As String, _
                            Optional bFoundIt As Boolean = False _
                                ) As Boolean
                                
'    On Error GoTo Errhand
    
    Dim oTempEl As IXMLDOMElement
    Dim oAttr As IXMLDOMAttribute
    Dim oPNode As IXMLDOMNode
    Dim nIdx As Integer
    Dim oFrag As IXMLDOMDocumentFragment
    Dim nChildCount As Integer
    Dim bReplacedIt As Boolean
    
    'Default to False; we'll change this value if we actually replace anything
    If (Not bFoundIt) Then
        SearchAndReplaceElementType = False
        Call SetErrorInfo(-1, "Type not found", "CDomFunctions.SearchAndReplaceElementType", NOT_FOUND_ERR)
    End If
    
    bReplacedIt = bFoundIt
    Select Case oNode.NodeType
    Case NODE_ELEMENT
        If oNode.baseName = sOldType Then
            Set oTempEl = oDOM.createElement(sNewType)
            For nIdx = 0 To oNode.childNodes.length - 1
                Call oTempEl.appendChild(oNode.childNodes(nIdx).cloneNode(True))
                Debug.Print "oTempEl.xml = " & oTempEl.xml
            Next
            For nIdx = 0 To oNode.Attributes.length - 1
                Call AddAttribute(oDOM, oTempEl, oNode.Attributes(nIdx).nodeName, oNode.Attributes(nIdx).nodeValue)
            Next
            Set oPNode = oNode.parentNode
            Call oPNode.replaceChild(oTempEl, oNode)
            SearchAndReplaceElementType = True
            bReplacedIt = True
            Call ClearErrorInfo
        End If
        ' Now travers the child nodes, if any
        For nIdx = 0 To oNode.childNodes.length - 1
            bReplacedIt = bReplacedIt Or _
                SearchAndReplaceElementType(oDOM, _
                        oNode.childNodes(nIdx), sOldType, _
                        sNewType, bReplacedIt)
        Next
    Case NODE_DOCUMENT, NODE_DOCUMENT_FRAGMENT
        For nIdx = 0 To oNode.childNodes.length - 1
            bReplacedIt = bReplacedIt Or SearchAndReplaceElementType(oDOM, oNode.childNodes(nIdx), sOldType, sNewType, bReplacedIt)
        Next
        
    Case Else
        ' Well, this isn't an node that can have element children we can edit
        SearchAndReplaceElementType = bReplacedIt
        Exit Function
    End Select
   
    SearchAndReplaceElementType = bReplacedIt
    Exit Function
    
ErrHand:
    If Err.Number <> 0 Then
        SearchAndReplaceElementType = False
        Call SetErrorInfo(Err.Number, Err.Description, "CDomFunctions.SearchAndReplaceElementType" & Err.Source, UNKNOWN)
        End If

End Function

Private Sub SetErrorInfo(lngErrNum As Long, strErrDesc As String, strErrSource As String, domErr As DOMException)
    m_strErrorDescription = strErrDesc
    m_lngErrorNumber = lngErrNum
    m_strErrorSource = strErrSource
  
    m_DomError = domErr
End Sub
Public Function SplitTextNode(oTextNode As IXMLDOMText, nOffset As Integer) As IXMLDOMText
    Dim oTempTextNode As IXMLDOMText
    
    If (nOffset < 0) Or (nOffset > Len(oTextNode.nodeValue)) Then
        Set SplitTextNode = oTempTextNode
        Call SetErrorInfo(-1, "Offset out-of-bounds", "CDomFunctions.SplitTextNode", INDEX_SIZE_ERR)
        Exit Function
    Else
        Set SplitTextNode = oTextNode.splitText(nOffset)
    End If
End Function
Private Sub Class_Initialize()
    Call ClearErrorInfo
End Sub

Public Function TextDeleteData(oTextNode As IXMLDOMText, nOffset As Integer, nCount As Integer) As Boolean
    If (nOffset < 0) Or (nOffset > Len(oTextNode.Data) - 1) Then
        TextDeleteData = False
        Call SetErrorInfo(-1, "Offset out-of-bounds", "CDomFunctions.TextDeleteData", INDEX_SIZE_ERR)
        Exit Function
    Else
        Call oTextNode.deleteData(nOffset, nCount)
        TextDeleteData = True
    End If
End Function


Public Function TextInsertData(oTextNode As IXMLDOMText, nOffset As Integer, sData As String) As Boolean
    If (nOffset < 0) Or (nOffset > Len(oTextNode.Data) - 1) Then
        TextInsertData = False
        Call SetErrorInfo(-1, "Offset out-of-bounds", "CDomFunctions.TextInsertData", INDEX_SIZE_ERR)
        Exit Function
    Else
        Call oTextNode.insertData(nOffset, sData)
        TextInsertData = True
    End If
End Function

Public Function TextReplaceData(oTextNode As IXMLDOMText, nOffset As Integer, _
                nCount As Integer, sData As String) As Boolean
    If (nOffset < 0) Or (nOffset > Len(oTextNode.Data) - 1) Then
        TextReplaceData = False
        Call SetErrorInfo(-1, "Offset out-of-bounds", "CDomFunctions.TextReplaceData", INDEX_SIZE_ERR)
        Exit Function
    Else
        Call oTextNode.replaceData(nOffset, nCount, sData)
        TextReplaceData = True
    End If
End Function



Public Function ValidateElementType(strTagName As String) As Boolean
    ' An element tag name may begin with only certain characters.
    ' rather than test for them al, let's let the parser do it ...
    Dim oDOM As DOMDocument
    Dim sXML As String
    
    Set oDOM = New DOMDocument
    sXML = "<" & strTagName & "/>"
    If Not oDOM.loadXML(sXML) Then
        ValidateElementType = False
        Exit Function
    End If
    
    
    ValidateElementType = True
    
End Function

Public Sub zTestException(oDOM As DOMDocument, nIndex As Integer)
    Dim oNode As IXMLDOMNode
    
    Set oNode = oDOM.selectNodes("//").Item(nIndex + 100)
    Debug.Print oNode.baseName
    
    
End Sub
