<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/">
<HTML>
<HEAD>
<TITLE><xsl:value-of select="ARTICLE/TITLE" /></TITLE>
</HEAD>
<BODY BGCOLOR="green">
<TABLE WIDTH="80%" BORDER="1" ALIGN="CENTER" BGCOLOR="white">
<TR><TD VALIGN="TOP" ALIGN="LEFT">
<xsl:apply-templates  select=".//PAR"/>
</TD></TR>
<TR><TD VALIGN="TOP" ALIGN="RIGHT">
<xsl:apply-templates  select="/ARTICLE/AUTHORS/AUTHOR"/>
</TD></TR>
<TR><TD VALIGN="TOP" ALIGN="LEFT">
<xsl:apply-templates select="/ARTICLE/REVIEWS/REVIEW"/>
</TD></TR>
<TR><TD VALIGN="TOP" ALIGN="RIGHT">
<xsl:apply-templates select="/ARTICLE/REVIEWS/REVIEW/REVIEWER"/>
</TD></TR>
</TABLE>
</BODY>
</HTML>
</xsl:template>

<xsl:template match="PAR">
<P>
<xsl:if test="@STYLE='heading 1'"><H1><xsl:value-of select="self::PAR"/></H1></xsl:if>
<xsl:if test="@STYLE='heading 3'"><H3><xsl:value-of select="self::PAR"/></H3></xsl:if> 
<xsl:if test="@STYLE='normal'"><xsl:value-of select="self::PAR"/></xsl:if>
</P>
</xsl:template>

<xsl:template match="AUTHOR"><xsl:value-of select="@FIRSTNAME"/><xsl:text> </xsl:text>
<xsl:value-of select="@LASTNAME"/>
<BR/></xsl:template>

<xsl:template match="REVIEW">
<H3>Review</H3>
<P>Rating: <xsl:value-of select="/ARTICLE/REVIEWS/REVIEW/RATING"/></P>
<P><xsl:value-of select="/ARTICLE/REVIEWS/REVIEW/TEXT"/></P>
</xsl:template>

<xsl:template match="REVIEWER"><xsl:value-of select="@FIRSTNAME"/><xsl:text> </xsl:text>
<xsl:value-of select="@LASTNAME"/>
<BR/></xsl:template>

</xsl:stylesheet>