<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="yes" encoding="iso-8859-1"/>

<!-- We specify output parameters here. Using the standard ASCII ISO latin-1 set. 
Indent allows the processor to format the code for readability.-->

<xsl:template match="*|/"><xsl:apply-templates/></xsl:template>

<xsl:template match="text()|@*"><xsl:value-of select="."/></xsl:template>

<xsl:template match="Music">
<HTML>
<STYLE TYPE="text/css">
<xsl:comment>
<!-- we use the comment element to create a HTML comment node in the output to hide
		the style from older browsers. You cannot use a literal comment. It will be 
		ignored during XSLT processing-->
  BODY { 
  		font-family:arial
  }
  a:link { 
  		color:red;
		text-decoration:none;
  }
  a:hover { 
  		color:red;
		text-decoration:underline;
  }
  a:visited { 
  		color:red;
		text-decoration:none;
  }
 .elm-header {
  		background-color:navy;
		color:white
  }
  .attr-header {
  		background-color:silver;
  }
  

</xsl:comment>
</STYLE>
<BODY>
<TABLE id="full_descriptions" border="0" cellpadding="0" cellspacing="0" width="80%">
<xsl:apply-templates select="Song">
	<xsl:sort select="title"/>
</xsl:apply-templates>
</TABLE>
</BODY>
</HTML>

</xsl:template>

<xsl:template match="Song"><tr>
<td style="font-size:14pt;font-family:arial" valign="top" width="200"><a><xsl:attribute name="name">Song<xsl:number level="single" count="Song" format="1"/></xsl:attribute><xsl:value-of select="title"/></a></td>
<td valign="top" width="400"><table><xsl:apply-templates select="artist"/></table></td>
</tr>
</xsl:template>

<xsl:template match="artist"><tr><td valign="top" width="200"><xsl:value-of select="text()"/></td>
<td valign="top" width="200">
<xsl:for-each select="//Song[artist/text() = current()/text()][title != current()/ancestor::Song/title]">
	<a><xsl:attribute name="href">#Song<xsl:number/></xsl:attribute><xsl:value-of select="title"/></a><br/>
</xsl:for-each>
</td>
</tr>
</xsl:template>

</xsl:stylesheet>
