<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:key match="/publisher/books/book" use="author-ref/@ref" name="books-by-author"/>

<xsl:template match="/"><bestsellers-list>
<xsl:apply-templates select="/publisher/authors/author">
	<xsl:sort select="sum(key('books-by-author', @id)/sold)"/>
</xsl:apply-templates>
</bestsellers-list></xsl:template>

<xsl:template match="author">
<copy>
<name><xsl:value-of select="last_name"/>, <xsl:value-of select="first_name"/></name>
<total_publications><xsl:value-of select="count(key('books-by-author', @id))"/></total_publications>
<total_sold><xsl:value-of select="sum(key('books-by-author', @id)/sold)"/></total_sold>
<rank><xsl:value-of select="position()"/></rank>
</copy>
</xsl:template>

</xsl:stylesheet>
