<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" encoding="iso-8859-1"/>

<!-- We specify output parameters here. Using the standard ASCII ISO latin-1 set.
Indent allows the processor to format the code for readability.-->

<xsl:template match="PLAY">
<HTML>
<STYLE TYPE="text/css">
<xsl:comment>

<!-- we use the comment element to create a HTML comment node in 
the output to hide the style from older browsers. You cannot use
a literal comment. It will be ignored during XSLT processing-->

  BODY {
      font-family:arial
  }
  a:link {
      color:red;
    text-decoration:none;
  }
  a:hover {
      color:red;
    text-decoration:underline;
  }
  a:visited {
      color:red;
    text-decoration:none;
  }

</xsl:comment>
</STYLE>
<BODY>
<xsl:apply-templates select="TITLE"/>
<xsl:apply-templates select="PERSONAE"/>
<xsl:apply-templates select="ACT"/>
</BODY>
</HTML>

</xsl:template>

<xsl:template match="ACT">
  <DIV style="text-align:center;background-color:navy;color:white;
   font- family:arial;font-size:20;font-weight:bold">
  <xsl:if test="preceding-sibling::ACT">
    <A href="">
      <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:value-of select="generate-id(preceding-sibling::ACT[1])"/>
      </xsl:attribute>
    &lt;</A>
  </xsl:if>
  <A>
    <xsl:attribute name="name">
      <xsl:value-of select="generate-id()"/>
    </xsl:attribute>
    <xsl:value-of select="TITLE"/>
  </A>
  <xsl:if test="following-sibling::ACT">
    <A >
      <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:value-of select="generate-id(following-sibling::ACT[1])"/>
      </xsl:attribute>
    &gt;</A>
  </xsl:if>
  </DIV>
  <xsl:apply-templates select="SCENE"/>
</xsl:template>

<xsl:template match="SCENE">
  <DIV style="text-align:center;background-color:silver;color:black;
   font-family:arial;font-size:16;font-weight:bold">
  <xsl:if test="preceding-sibling::SCENE">
    <A href="">
      <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:value-of select= "generate-id(preceding-sibling::SCENE[1])"/>
      </xsl:attribute>
    &lt;</A>
  </xsl:if>
  <A>
    <xsl:attribute name="name">
      <xsl:text></xsl:text><xsl:value-of select="generate-id()"/>
    </xsl:attribute>
    <xsl:value-of select="TITLE"/>
  </A>
  <xsl:if test="following-sibling::SCENE">
    <A >
      <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:value-of select= "generate-id(following-sibling::SCENE[1])"/>
      </xsl:attribute>
    &gt;</A>
  </xsl:if>
  </DIV>
  <CENTER>
  <TABLE WIDTH="500">
    <xsl:apply-templates select="SPEECH|STAGEDIR"/>
  </TABLE>
  </CENTER>
</xsl:template>

<xsl:template match="SPEECH">
  <TR><TD style="font-weight:bold">
    <xsl:apply-templates select="SPEAKER"/>
  </TD><TD><xsl:value-of select="LINE[1]"/></TD></TR>
  <xsl:apply-templates select="LINE"/>
</xsl:template>

<xsl:template match="STAGEDIR">
  <TR><TD COLSPAN="2" style="background-color:yellow">
    <xsl:value-of select="."/>
  </TD></TR>
</xsl:template>

<xsl:template match="LINE">
  <xsl:if test="position() > 1">
  <TR><TD></TD><TD>
    <xsl:value-of select="."/>
  </TD></TR>
  </xsl:if>
</xsl:template>

<xsl:template match="PLAY/TITLE">
  <DIV style="text-align:center;font-size:25pt">
    <xsl:value-of select="."/>
  </DIV>
</xsl:template>

<xsl:template match="PERSONAE">
  <CENTER>
  <TABLE WIDTH="500">
    <xsl:apply-templates select="TITLE"/>
    <xsl:apply-templates select="PGROUP|PERSONA"/>
  </TABLE>
  </CENTER>
</xsl:template>

<xsl:template match="PERSONA">
  <xsl:param name="indented">no</xsl:param>
  <TR><TD>
    <xsl:if test="$indented = 'yes'">
      <xsl:attribute name="style">padding-left:20</xsl:attribute>
    </xsl:if>
    <xsl:value-of select="."/>
  </TD></TR>
</xsl:template>

<xsl:template match="PGROUP">
  <TR><TD style="font-weight:bold">
    <xsl:value-of select="GRPDESCR"/>
  </TD></TR>
  <xsl:apply-templates select="PERSONA">
    <xsl:with-param name="indented">yes</xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="PERSONAE/TITLE">
  <TR><TD style="font-weight:bold">
    <xsl:value-of select="."/>
  </TD></TR>
</xsl:template>

</xsl:stylesheet>
