VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Location"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"389E9B53035A"
'Contains information about a location. This is basically a URL that may
'contain an attached XPointer fragment. The Location object can split the URL
'into a base URL and a set of XPath expressions (this will not work for
'ranges).
'The Location can be connected to a Node object by setting the oXMLNode to
'that object. The location object does nothing with this information. It's
'just storage.
Option Base 0
Option Explicit


'##ModelId=389E9B5400E6
Public oXMLNode As MSXML2.IXMLDOMNode

'##ModelId=389E9B5400EE
Public sComplexURL As String

'##ModelId=389E9B540102
Public sURLPart As String

'##ModelId=389E9B540121
Private sTrailing As String

'##ModelId=389E9B540135
Public collXPaths As Collection

'##ModelId=389E9B540149
Public sRole As String

'##ModelId=389E9B54015D
Public sTitle As String

'##ModelId=389E9B54017B
Public sRelURL As String

'##ModelId=389E9B54018F
Public sBaseURL As String



'##ModelId=389E9B5401AD
Public Sub SplitURL()
    
    splitURLonHash
    ConvertHashStringToPaths (sTrailing)

End Sub

'##ModelId=389E9B5401C1
Public Sub CombineURLs()
    
    'The Internet Combine function needs a base
    If sBaseURL = "" Then Err.Raise 9999, "XLinker::XLinkedDocument", _
                                            "No base URL specified"
    
    sComplexURL = ResolveURL(sBaseURL, sRelURL)

End Sub

'##ModelId=389E9B5401D5
Private Sub Class_Initialize()
End Sub

'##ModelId=389E9B5401F3
Private Sub Class_Terminate()
End Sub

'##ModelId=389E9B540207
Private Sub splitURLonHash()
    Dim lHashLocation As Long
    
    lHashLocation = InStr(sComplexURL, "#")
    If lHashLocation > 0 Then
        sTrailing = Mid$(sComplexURL, lHashLocation + 1)
        sURLPart = Left$(sComplexURL, lHashLocation - 1)
    Else
        sURLPart = sComplexURL
        sTrailing = ""
    End If

End Sub


'##ModelId=389E9B540225
Private Sub ConvertHashStringToPaths(sTrailing As String)
    Dim sWorking As String
    Dim iPathNumber As Integer
    Dim iCharNumber As Integer
    Dim iLastPathStart As Integer
    Dim iNestingLevel As Integer
    
    sWorking = sTrailing
    iPathNumber = 0
    Set collXPaths = New Collection
    
    If Left(sTrailing, 9) = "xpointer(" Then
        ' Walk the string to match parentheses
        ' Literal )'s are to be escaped as ^) even within quotes
        iCharNumber = 10
        iNestingLevel = 1
        iLastPathStart = iCharNumber
        While iCharNumber <= Len(sWorking)
            If Mid(sWorking, iCharNumber, 1) = ")" Then iNestingLevel = iNestingLevel - 1
            If Mid(sWorking, iCharNumber, 1) = "(" Then iNestingLevel = iNestingLevel + 1
            If Mid(sWorking, iCharNumber, 2) = "^)" Then iCharNumber = iCharNumber + 1
            If Mid(sWorking, iCharNumber, 2) = "^(" Then iCharNumber = iCharNumber + 1
            If Mid(sWorking, iCharNumber, 2) = "^^" Then iCharNumber = iCharNumber + 1
            
            If iNestingLevel = 0 Then
                collXPaths.Add Mid(sWorking, iLastPathStart, iCharNumber - iLastPathStart)
                
                If Mid(sWorking, iCharNumber + 1, 9) = "xpointer(" Then
                    iNestingLevel = 1
                    iCharNumber = iCharNumber + 9
                    iLastPathStart = iCharNumber + 1
                    iPathNumber = iPathNumber + 1
                Else
                    ' Check if no content is left. If there is any: Syntax error
                    If Len(Trim(Mid(sWorking, iCharNumber + 1))) > 0 Then
                        Err.Raise 9999, "WROXSample:XLinkSolver", "Syntax error: unrecognized scheme"
                    End If
                End If
            End If
            iCharNumber = iCharNumber + 1
        Wend
        If iNestingLevel > 0 Then
            'Syntax error
            Err.Raise 9999, "WROXSample:XLinkSolver", "Syntax error"
        End If
    Else
        ' The xpointer() syntax is not used: apparently some shorthand notation
        ' Possible values:
        ' - doc.xml#blah     (by ID)
        ' - doc.xml#/1/4/2   (by element path)
        ' - doc.xml#blah/3/5/2     (by ID and element path)
        
        ' Split the id and possible path
        Dim sIDpart As String
        Dim sPathPart As String
        Dim iSlashPosition As Integer
        Dim sFullPath As String
        
        iSlashPosition = InStr(1, sWorking, "/", vbTextCompare)
        If iSlashPosition = 0 Then 'No slash found: only an id
            sIDpart = sWorking
            sPathPart = ""
        Else
            sIDpart = Mid(sWorking, 1, iSlashPosition - 1)
            sPathPart = Mid(sWorking, iSlashPosition)
        End If
        
        
        ' If any ID expression is found, it is converted to the kind of XPath expression
        ' IE5 understands:
        ' blah becomes id('blah')
        If Len(sIDpart) > 0 Then
            sFullPath = "id('" & sIDpart & "')"
        End If
        
        ' If any path expression is found, it is converted to the kind of XPath expression
        ' IE5 understands:
        ' /1/4/2 becomes /*[0]/*[3]/*[1]
        If Len(sPathPart) > 0 Then
            iCharNumber = 2
            While iCharNumber <= Len(sPathPart)
                iSlashPosition = InStr(iCharNumber, sPathPart, "/")
                If iSlashPosition = 0 Then
                    sFullPath = sFullPath & "/*[" & Mid(sPathPart, iCharNumber) & "]"
                    iCharNumber = Len(sPathPart)
                Else
                    sFullPath = sFullPath & "/*[" & Mid(sPathPart, iCharNumber, iSlashPosition - iCharNumber) & "]"
                    iCharNumber = iSlashPosition
                End If
                iCharNumber = iCharNumber + 1
            Wend
        End If
        If Len(sFullPath) > 0 Then collXPaths.Add sFullPath
    End If
    
    
End Sub

