VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "XLinkExtended"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"389E9B550212"
'The XLinkExtended class can parse a passed XML node that should be an extended
'link. It builds a collection of simple links that make up the extended link.
Option Base 0
Option Explicit


'##ModelId=389E9B550276
Public collSimpleLinks As New Collection

'##ModelId=389E9B550280
Public sBaseURL As String

'##ModelId=389E9B550295
Public Sub buildLinkset(oExtendedElement As MSXML2.IXMLDOMElement, sPrefix As String)
    Dim oLinkElement As IXMLDOMElement
    Dim oLocatorList As IXMLDOMNodeList
    Dim oResourceList As IXMLDOMNodeList
    Dim oArcList As IXMLDOMNodeList
    
    Dim i As Long
    Dim j As Long
    Dim k As Long
    
    Dim collResources As New Collection
    Dim collArcs As New Collection
    
    Dim oLoc As Location
    Dim oTmpArc As XLinkArc
    Dim oTmpLink As XlinkSimple
    Dim sTempURL As String
    
    ' First build a set of locators and resources
    ' What the arcs do is of later concern
    ' We'll store them as locations
    Set oLocatorList = oExtendedElement.selectNodes("descendant::*[attribute::" & sPrefix & ":type = 'locator']")
    For i = 1 To oLocatorList.length
        Set oLinkElement = oLocatorList.Item(i - 1)

        Set oLoc = New Location
        sTempURL = NullCatcher(oLinkElement.getAttribute(sPrefix & ":href"))
        sTempURL = ResolveURL(sBaseURL, sTempURL)
        
        oLoc.sComplexURL = sTempURL
        oLoc.SplitURL
        oLoc.sRole = NullCatcher(oLinkElement.getAttribute(sPrefix & ":role"))
        oLoc.sTitle = NullCatcher(oLinkElement.getAttribute(sPrefix & ":title"))
        collResources.Add oLoc
    Next

    Set oResourceList = oExtendedElement.selectNodes("descendant::*[attribute::" & sPrefix & ":type = 'resource']")
    For i = 1 To oResourceList.length
        Set oLinkElement = oResourceList.Item(i - 1)

        Set oLoc = New Location
        Set oLoc.oXMLNode = oLinkElement 'reference the content in the local resource link
        
        oLoc.sRole = oLinkElement.selectSingleNode("attribute::" & sPrefix & ":role").nodeValue
        oLoc.sTitle = oLinkElement.selectSingleNode("attribute::" & sPrefix & ":title").nodeValue
        
        collResources.Add oLoc
    Next
    
    
    'Now we build a list of arcs. This is a collection of XLinkArc objects
    Set oArcList = oExtendedElement.selectNodes("descendant::*[attribute::" & sPrefix & ":type = 'arc']")
    For i = 1 To oArcList.length
        Set oLinkElement = oArcList.Item(i - 1)
        
        Set oTmpArc = New XLinkArc
        oTmpArc.sFrom = NullCatcher(oLinkElement.getAttribute(sPrefix & ":from"))
        oTmpArc.sTo = NullCatcher(oLinkElement.getAttribute(sPrefix & ":to"))
        oTmpArc.sActuate = NullCatcher(oLinkElement.getAttribute(sPrefix & ":actuate"))
        oTmpArc.sShow = NullCatcher(oLinkElement.getAttribute(sPrefix & ":show"))
        
        collArcs.Add oTmpArc
    Next
    
    'Now we loop through the arcs, constructing Simple links from the associated locators and resources
    For i = 1 To collArcs.Count
        For j = 1 To collResources.Count
            If (collArcs(i).sFrom = "" Or collArcs(i).sFrom = collResources(j).sRole) Then
                For k = 1 To collResources.Count
                    If (collArcs(i).sTo = "" Or collArcs(i).sTo = collResources(k).sRole) Then
                        ' This arc's to and from attributes
                        ' match the roles of 2 resources
                        ' Hurray!
                        Set oTmpLink = New XlinkSimple
                        Set oTmpLink.FromLocation = collResources(j)
                        Set oTmpLink.ToLocation = collResources(k)
                        oTmpLink.sActuate = collArcs(i).sActuate
                        oTmpLink.sShow = collArcs(i).sShow
                        collSimpleLinks.Add oTmpLink
                    End If
                Next
            End If
        Next
    Next
    

End Sub

'##ModelId=389E9B5502BD
Private Function NullCatcher(inVar As Variant) As String
    If IsNull(inVar) Then
        NullCatcher = ""
    Else
        NullCatcher = CStr(inVar)
    End If
End Function


