VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "XLinkedDocument"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"389E9B540315"
'This object can retrieve a document over HTTP, parse it for contained XLink
'information, embed XML linked from other documents and insert linking
'elements at the links to and from locations
'All encountered XLinks are stored in an internal collection
Option Base 0
Option Explicit


'##ModelId=389E9B54037B
Private oDocNode As MSXML2.IXMLDOMNode

'##ModelId=389E9B540385
Public oLocation As New Location

'##ModelId=389E9B5403B5
Private oLinkBase As New Collection




'##ModelId=389E9B5403BF
Public Function makeLinked() As DOMDocument
    
    Dim lHashLocation As Long
    Dim oTmpDoc As DOMDocument
    
    If oLocation.sComplexURL = "" Then oLocation.CombineURLs
    oLocation.SplitURL
    
    Set oDocNode = getXMLNode(oLocation)
    
    If oDocNode Is Nothing Then
        Set oTmpDoc = New DOMDocument
        oTmpDoc.setProperty "SelectionLanguage", "XPath"
        Set oDocNode = oTmpDoc.createElement("dummy")
        oDocNode.Text = "Resource could not be found"
        Set oTmpDoc = Nothing
    End If
    
    extractXLinks
    
    importEmbeddedLinks
    
    'insertlink locations
    processLinks
    
    ' We make the Node into a Document. This makes it easier to handle, because
    ' you can be more sure of the returned object.
    Select Case oDocNode.nodeType
        Case NODE_DOCUMENT
            Set makeLinked = oDocNode
        Case NODE_ELEMENT
            Set oTmpDoc = New DOMDocument
            Set oTmpDoc.documentElement = oDocNode
            Set makeLinked = oTmpDoc
        Case NODE_ATTRIBUTE
            Set oTmpDoc = New DOMDocument
            Set oTmpDoc.documentElement = oTmpDoc.createElement("dummy")
            oTmpDoc.documentElement.setAttributeNode oDocNode
        Case NODE_TEXT, NODE_CDATA_SECTION, NODE_COMMENT
            Set oTmpDoc = New DOMDocument
            Set oTmpDoc.documentElement = oTmpDoc.createElement("dummy")
            oTmpDoc.documentElement.appendChild (oDocNode)
        Case Else
            Err.Raise 9999, "XLinker::XLinkedDocument", "Node type " & oDocNode.nodeTypeString & " not supported"
    End Select
    
    
    
    
End Function


'##ModelId=389E9B5403D4
Private Sub Class_Initialize()
End Sub

'##ModelId=389E9B5403DE
Private Sub Class_Terminate()
End Sub

'##ModelId=389E9B55000A
Private Sub extractXLinks()
    Dim oElementList As IXMLDOMNodeList
    Dim oLinkElement As IXMLDOMElement
    Dim oSimpleLink As XlinkSimple
    Dim sTempURL As String
    Dim sPrefix As String
    Dim oDoc As DOMDocument
    Dim i As Long
    Dim j As Long
    
    
    ' First get all simple links
    Set oElementList = oDocNode.selectNodes("/descendant::*[attribute::*[local-name() = 'type' and namespace-uri() = '" & XLINK_NS & "'] = 'simple']")
    
    For i = 1 To oElementList.length
        Set oLinkElement = oElementList.Item(i - 1)
        Set oSimpleLink = New XlinkSimple
        sPrefix = oLinkElement.selectSingleNode("attribute::*[local-name() = 'type' and namespace-uri() = '" & XLINK_NS & "']").prefix
        oLinkBase.Add oSimpleLink
        Set oSimpleLink.FromLocation.oXMLNode = oLinkElement
        
        sTempURL = NullCatcher(oLinkElement.getAttribute(sPrefix & ":href"))
        sTempURL = ResolveURL(oLocation.sURLPart, sTempURL)
        oSimpleLink.ToLocation.sComplexURL = sTempURL
        
        oSimpleLink.ToLocation.sTitle = NullCatcher(oLinkElement.getAttribute(sPrefix & ":title"))
        oSimpleLink.sShow = NullCatcher(oLinkElement.getAttribute(sPrefix & ":show"))
        oSimpleLink.sActuate = NullCatcher(oLinkElement.getAttribute(sPrefix & ":actuate"))
        oSimpleLink.ToLocation.SplitURL
    Next
    
    ' Now get the extended links
    Set oElementList = oDocNode.selectNodes("/descendant::*[attribute::*[local-name() = 'type' and namespace-uri() = '" & XLINK_NS & "'] = 'extended']")
    
    For i = 1 To oElementList.length
        includeExtendedLink oElementList(i - 1)
    Next
    
    
    ' Finally get the external linksets
    Set oElementList = oDocNode.selectNodes("/descendant::*[contains(attribute::*[local-name() = 'role' and namespace-uri() = '" & XLINK_NS & "'], 'external-linkset')]")
    For i = 1 To oElementList.length
        Set oLinkElement = oElementList.Item(i - 1)
        Set oDoc = New DOMDocument
        oDoc.async = False
        oDoc.Load (ResolveURL(oLocation.sURLPart, oLinkElement.selectSingleNode("attribute::*[local-name() = 'href' and namespace-uri() = '" & XLINK_NS & "']").nodeValue))
        oDoc.setProperty "SelectionLanguage", "XPath"
        Set oElementList = oDoc.selectNodes("/descendant::*[attribute::*[local-name() = 'type' and namespace-uri() = '" & XLINK_NS & "'] = 'extended']")
        
        For j = 1 To oElementList.length
            includeExtendedLink oElementList(j - 1)
        Next
    Next
    
End Sub

'##ModelId=389E9B550014
Private Sub importEmbeddedLinks()
    Dim i As Long
    Dim j As Long
    Dim oLocTo As Location
    Dim oLocFrom As Location
    Dim oNode As IXMLDOMNode
    Dim oXLinker As XLinkedDocument
    
    For i = 1 To oLinkBase.Count
        If oLinkBase.Item(i).sShow = "embed" And oLinkBase.Item(i).sActuate = "onLoad" Then
            Set oLocTo = oLinkBase.Item(i).ToLocation
            Set oLocFrom = oLinkBase.Item(i).FromLocation
            
            ' Set oNode = getXMLNode(oLocTo)
            Set oXLinker = New XLinkedDocument
            Set oXLinker.oLocation = oLocTo
            Set oNode = oXLinker.makeLinked.documentElement

            If Not (oNode Is Nothing) And Not (oLocFrom Is Nothing) Then
                oLocFrom.oXMLNode.parentNode.replaceChild oNode.cloneNode(True), oLocFrom.oXMLNode 'Replace the linking node by the linked node
            End If
        End If
    Next
    i = 1
    While i <= oLinkBase.Count
        'We loop through the same links again and remove them (they should be removed
        'from the document now)
        If oLinkBase.Item(i).sShow = "embed" And oLinkBase.Item(i).sActuate = "onLoad" Then
            oLinkBase.Remove (i)
            i = i - 1 'Correction for the change in index numbers
        End If
        i = i + 1
    Wend
    
    
End Sub


'##ModelId=389E9B550028
Private Function getXMLNode(oLocation As Location) As IXMLDOMNode
    Dim oDoc As New MSXML2.DOMDocument
    
    
    'If the location holds a direct reference: return that
    If Not oLocation.oXMLNode Is Nothing Then
        Set getXMLNode = oLocation.oXMLNode
    Else
    
        If oLocation.sComplexURL = "" Then Err.Raise 9999, "XLinker::XLinkedDocument", "Cannot retrieve resource with unknown URL"
        
        oLocation.SplitURL
            
        oDoc.async = False
        oDoc.Load (oLocation.sURLPart)
        oDoc.setProperty "SelectionLanguage", "XPath"
        Set getXMLNode = getNodeFromDocument(oDoc, oLocation)
    End If

End Function

Private Function getNodeFromDocument(oDoc As DOMDocument, oLocation As Location) As IXMLDOMNode
    Dim i As Long
    Dim oNodeList As IXMLDOMNodeList
    Dim oNode As IXMLDOMNode
    
    If oLocation.collXPaths.Count = 0 Then
        Set getNodeFromDocument = oDoc.documentElement
    Else
        For i = 1 To oLocation.collXPaths.Count
            Set oNodeList = oDoc.selectNodes(oLocation.collXPaths(i))
            If oNodeList.length > 0 Then
                Set oNode = oNodeList.Item(0)
            End If
            If Not oNode Is Nothing Then
                i = oLocation.collXPaths.Count ' Exit the loop
            End If
        Next
        Set getNodeFromDocument = oNode
    End If

End Function

Private Sub processLinks()
    Dim i As Long
    Dim oSL As XlinkSimple
    Dim oNode As IXMLDOMElement
    Dim oChildElement As IXMLDOMElement
    
    For i = 1 To oLinkBase.Count
        Set oSL = oLinkBase(i)
        
        ' If a location is not an object reference, but the document it refers to
        ' is the current document, we solve the reference to an object
        If oSL.FromLocation.oXMLNode Is Nothing And LCase(oSL.FromLocation.sURLPart) = LCase(oLocation.sURLPart) Then
            Set oSL.FromLocation.oXMLNode = getNodeFromDocument(oDocNode.ownerDocument, oSL.FromLocation)
        End If
        If oSL.ToLocation.oXMLNode Is Nothing And LCase(oSL.ToLocation.sURLPart) = LCase(oLocation.sURLPart) Then
            Set oSL.ToLocation.oXMLNode = getNodeFromDocument(oDocNode.ownerDocument, oSL.ToLocation)
        End If
        
        'For all locations that are a node reference, we create the namespace and set the ID
        If Not oSL.ToLocation.oXMLNode Is Nothing Then
            Set oNode = oSL.ToLocation.oXMLNode
            If oNode.getAttributeNode("xmlns:sl") Is Nothing Then oNode.setAttribute "xmlns:sl", SIMPLE_LINK_NS
            oNode.setAttribute "sl:id", UniqueID(oNode)
        End If
        If Not oSL.FromLocation.oXMLNode Is Nothing Then
            Set oNode = oSL.FromLocation.oXMLNode
            If oNode.getAttributeNode("xmlns:sl") Is Nothing Then oNode.setAttribute "xmlns:sl", SIMPLE_LINK_NS
            oNode.setAttribute "sl:id", UniqueID(oNode)
        End If
        
        'For links that are coming from the current page, we will include child elements
        If Not oSL.FromLocation.oXMLNode Is Nothing Then
            Set oNode = oSL.FromLocation.oXMLNode
            If oSL.ToLocation.oXMLNode Is Nothing Then
                'create a child element for external link
                Set oChildElement = oNode.ownerDocument.createElement("sl:ext-target")
                oChildElement.appendChild oNode.ownerDocument.createTextNode(oSL.ToLocation.sComplexURL)
                oChildElement.setAttribute "sl:title", oSL.ToLocation.sTitle
                oChildElement.setAttribute "sl:show", oSL.sShow
                oChildElement.setAttribute "sl:actuate", oSL.sActuate
                oNode.insertBefore oChildElement, oNode.childNodes.Item(0)
            Else
                'create a child element for internal link
                Set oChildElement = oNode.ownerDocument.createElement("sl:int-target")
                oChildElement.appendChild oNode.ownerDocument.createTextNode(UniqueID(oSL.ToLocation.oXMLNode))
                oNode.insertBefore oChildElement, oNode.childNodes.Item(0)
            End If
        End If
    Next

End Sub

Private Sub includeExtendedLink(oLinkElement As IXMLDOMElement)
    Dim oExtLink As XLinkExtended
    Dim attr As IXMLDOMAttribute
    Dim j As Long
        
    Set attr = oLinkElement.selectSingleNode("attribute::*[local-name() = 'type' and namespace-uri() = '" & XLINK_NS & "']")
    
    Set oExtLink = New XLinkExtended
    oExtLink.sBaseURL = oLocation.sURLPart
    oExtLink.buildLinkset oLinkElement, attr.prefix
    
    'Copy all built simple links to our documents linkset
    For j = 1 To oExtLink.collSimpleLinks.Count
        If LCase(oLocation.sURLPart) = LCase(oExtLink.collSimpleLinks(j).FromLocation.sURLPart) Then
            oLinkBase.Add oExtLink.collSimpleLinks(j)
        End If
    Next

End Sub

'##ModelId=389E9B550046
Private Function NullCatcher(inVar As Variant) As String
    If IsNull(inVar) Then
        NullCatcher = ""
    Else
        NullCatcher = CStr(inVar)
    End If
End Function


