VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 2  'RequiresTransaction
END
Attribute VB_Name = "MessageProcessor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Implements ObjectControl

Private oDoc As DOMDocument
Private collSettings As Collection
Private oConnection As Connection
Private lCurrentProdID As Long
Private lCurrentAmount As Long

Public Function processMessage(oQueue As MSMQQueue) As Boolean
    Dim oMsg As MSMQMessage
    Dim oCtx As MTxAS.ObjectContext
    Dim oList As IXMLDOMNodeList
    Dim oElem As IXMLDOMElement
    
    On Error GoTo processMessage_Handler
    
    
    Set oCtx = GetObjectContext()
    Set oMsg = oQueue.Receive(ReceiveTimeout:=1000, Transaction:=MQ_MTS_TRANSACTION)
    If oMsg Is Nothing Then Exit Function
    
    readBody (oMsg.Body)
    
    Set oList = oDoc.selectNodes("//Products/Product")
    For i = 0 To oList.length - 1
        Set oElem = oList.Item(i)
        lCurrentProdID = oElem.selectSingleNode("ID/text()").nodeValue
        lCurrentAmount = oElem.selectSingleNode("Amount/text()").nodeValue
    
        checkStock
        decreaseStock
        checkReorderLevel
    Next
    
    processMessage = True
    oCtx.SetComplete
    
    Exit Function
processMessage_Handler:
    processMessage = False
    oCtx.SetAbort
    
End Function

Private Sub readBody(sMessage As String)
    Set oDoc = New DOMDocument
    oDoc.async = False
    oDoc.loadXML (sMessage)
    If Not oDoc.parseError.errorCode = 0 Then
        Err.Raise 9999, "MessageProcessor", "Problem parsing the XML: " & oDoc.parseError.reason
    End If

End Sub

Private Sub ObjectControl_Activate()
    loadSettings
    
    Set oConnection = New Connection
    oConnection.Open collSettings("ConnectString")
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oConnection = Nothing
End Sub

Private Sub checkStock()
    Dim sSQL As String
    Dim rsResult As Recordset
    
    Set rsResult = oConnection.Execute("SELECT Inventory from Catalog where ProdID = " & lCurrentProdID)
    If rsResult.EOF Then Err.Raise 9999, "MessageProcessor", "No such Product ID"
    If rsResult("Inventory").Value < lCurrentAmount Then
        'Take appropriate action.
        'For simplicity, we do nothing
    End If
    
End Sub
Private Sub decreaseStock()
    Dim sSQL As String
    sSQL = "UPDATE Catalog SET Inventory = Inventory - " & lCurrentAmount & _
           " WHERE ProdID = " & lCurrentProdID
    
    oConnection.Execute sSQL

End Sub

Private Sub checkReorderLevel()
    Dim sSQL As String
    Dim rsResult As Recordset
    Dim oReorder As DOMDocument
    
    
    Set rsResult = New Recordset
    rsResult.CursorLocation = adUseClient
    rsResult.Open "SELECT * from Catalog where ProdID = " & lCurrentProdID, oConnection
    Set rsResult.ActiveConnection = Nothing
    If rsResult("Inventory").Value + rsResult("Reorder_submitted").Value < rsResult("Reorder_threshold").Value Then
        'We have to make a reorder
        'First we process the reorder in our own database
        sSQL = "UPDATE Catalog SET " & _
            " Reorder_submitted = Reorder_submitted + Reorder_amount " & _
            " WHERE  ProdID = " & lCurrentProdID
        oConnection.Execute sSQL
        
        Set oReorder = createDefaultReorder(rsResult("Name").Value, rsResult("SupplID").Value)
        
        transportMessage oReorder
        
    End If

End Sub


Private Function createDefaultReorder(prodName As String, _
                                supplID As Long) As DOMDocument
    Dim sSQL As String
    Dim rsResult As Recordset
    Dim oReorder As DOMDocument
    Dim oTmp As DOMDocument
    Dim oElem As IXMLDOMElement
    Dim oChildElem As IXMLDOMElement
    
    
    Set rsResult = oConnection.Execute("SELECT * from Supplier where SupplID = " & supplID)
    
    Set oReorder = New DOMDocument
    Set oReorder.documentElement = oReorder.createElement("REORDER")
    Set oElem = oReorder.createElement("PRODUCT")
    oReorder.documentElement.appendChild oElem
    Set oChildElem = oReorder.createElement("ID")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(lCurrentProdID)
    Set oChildElem = oReorder.createElement("Amount")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(lCurrentAmount)
    Set oChildElem = oReorder.createElement("Name")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(prodName)
    
    Set oElem = oReorder.createElement("SUPPLIER")
    oReorder.documentElement.appendChild oElem
    Set oChildElem = oReorder.createElement("Name")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(rsResult("Name").Value)
    
    'Now we want to include the xml fragment in the field DestinationDetails
    Set oTmp = New DOMDocument
    oTmp.loadXML (rsResult("DestinationDetails"))
    Set oChildElem = oReorder.createElement("Destination_Details")
    oElem.appendChild oChildElem
    oChildElem.appendChild oTmp.documentElement.cloneNode(True)
    
    Set oChildElem = oReorder.createElement("Supplier_Format")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(rsResult("ReorderFormat"))
    
    Set oChildElem = oReorder.createElement("Transport_Method")
    oElem.appendChild oChildElem
    oChildElem.appendChild oReorder.createTextNode(rsResult("TransportMethod"))
    
    Set createDefaultReorder = oReorder
End Function

Private Sub transportMessage(oMsg As DOMDocument)
    Dim sFormat As String
    Dim sMsg As String
    Dim oTransporter As IReorderTransfer
    
    sFormat = oMsg.selectSingleNode("//Supplier_Format").Text
    If Len(sFormat) > 0 Then
        Dim oXSL As New DOMDocument
        oXSL.async = False
        oXSL.Load (App.Path & "\" & sFormat)
        sMsg = oMsg.transformNode(oXSL)
    Else
        sMsg = oMsg.xml
    End If
    
    Set oTransporter = CreateObject(oMsg.selectSingleNode("//Transport_Method").Text)
    oTransporter.Transfer sMsg, oMsg
End Sub

Private Sub loadSettings()
    Dim oSettings As New DOMDocument
    Dim oList As IXMLDOMNodeList
    Dim oElem As IXMLDOMElement
    
    Set collSettings = New Collection
    
    oSettings.async = False
    oSettings.Load (App.Path & "\settings.xml")
    Set oList = oSettings.selectNodes("//SETTING")
    For i = 0 To oList.length - 1
        Set oElem = oList.Item(i)
        collSettings.Add oElem.getAttribute("value"), oElem.getAttribute("name")
    Next
    
End Sub
