VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "WebTransactions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'************************************************************************
' Class WroxStore.WebTransactions
' Methods for performing web store transactions
'************************************************************************
Option Explicit

Implements ObjectControl

Const PROGID As String = "WroxStore.WebTransactions"
Private oRemoteOrderTx As IRemoteTransactions.IProductOrders
Private oCtx As ObjectContext
Private oError As ErrorUtils.ErrorInfo
Private oApplication As ASPTypeLibrary.Application
Private oXlinkDoc As Xlinker.XLinkedDocument
Private oSoapRq As SoapRequestMts.XmlHttp

Private m_sSoapUrl As String
'************************************************************************
' Private Function AddSoapFoot() As String
'************************************************************************
Private Function AddSoapFoot() As String
    Dim s As String
    s = ""
    s = s & " </SOAP:Body>" & vbLf
    s = s & " </SOAP:Envelope>"

    AddSoapFoot = s
End Function

'************************************************************************
' Private Function AddSoapHead() As String
'************************************************************************
Private Function AddSoapHead() As String
    Dim s As String
    s = ""
    s = s & "<SOAP:Envelope "
    s = s & "xmlns:SOAP='urn:schemas-xmlsoap-org:soap.v1' "
    s = s & "SOAP:encodingStyle='urn:schemas-xmlsoap-org:soap.v1'>" & vbLf
    s = s & "<SOAP:Body>" & vbLf
    
    AddSoapHead = s
End Function
'************************************************************************
' Private Function BuildSoapGetCategoryList() As String
'************************************************************************
Private Function BuildSoapGetCategoryListTx() As String
    Dim sSoapTx As String
    sSoapTx = AddSoapHead()
    sSoapTx = sSoapTx & "<w:soapGetCategoryList "
    sSoapTx = sSoapTx & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
    sSoapTx = sSoapTx & "</w:soapGetCategoryList>" & vbLf
    sSoapTx = sSoapTx & AddSoapFoot()
    
    BuildSoapGetCategoryListTx = sSoapTx
End Function
Private Function BuildSoapGetProductTx(sProdID As String) As String
    Dim sSoapTx As String
    sSoapTx = AddSoapHead()
    sSoapTx = sSoapTx & "<w:soapGetProduct "
    sSoapTx = sSoapTx & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
    sSoapTx = sSoapTx & "   <prodid>" & Trim(sProdID) & "</prodid>" & vbLf
    sSoapTx = sSoapTx & "</w:soapGetProduct>" & vbLf
    sSoapTx = sSoapTx & AddSoapFoot()
    
    BuildSoapGetProductTx = sSoapTx

End Function
'************************************************************************
' Private Function BuildSoapGetSelectedProductsTx(ByVal sXmlParams As String) As String
'************************************************************************
Private Function BuildSoapGetSelectedProductsTx(ByVal sXmlParams As String) As String
  Dim sSoapTx As String
    sSoapTx = AddSoapHead()
    sSoapTx = sSoapTx & "<w:soapGetSelectedProducts "
    sSoapTx = sSoapTx & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
    sSoapTx = sSoapTx & sXmlParams & vbLf
    sSoapTx = sSoapTx & "</w:soapGetSelectedProducts>" & vbLf
    sSoapTx = sSoapTx & AddSoapFoot()
    
    BuildSoapGetSelectedProductsTx = sSoapTx
End Function
'************************************************************************
' Private Function BuildSoapSearchTx(sName As String, sCategory As String) As String
'************************************************************************
Private Function BuildSoapSearchTx(sName As String, sCategory As String) As String
    Dim sSoapTx As String
    sSoapTx = AddSoapHead()
    sSoapTx = sSoapTx & "<w:soapSearchForProduct "
    sSoapTx = sSoapTx & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
    sSoapTx = sSoapTx & "   <name>" & Trim(sName) & "</name>" & vbLf
    sSoapTx = sSoapTx & "   <category>" & Trim(sCategory) & "</category>" & vbLf
    sSoapTx = sSoapTx & "</w:soapSearchForProduct>" & vbLf
    sSoapTx = sSoapTx & AddSoapFoot()
    
    BuildSoapSearchTx = sSoapTx
End Function

'************************************************************************
' Public Function GetCategoryList() As String
' POSTs a SOAP request to pull back a list of produc catategories
' so we can populate a drop-down list
'************************************************************************
Public Function GetCategoryList() As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim oSoapDom As MSXML.DOMDocument
    Dim sSoapRq As String
    Dim oEl As MSXML.IXMLDOMElement
    Dim sProdName As String
    Dim sProdCategory As String
    Dim sSoapResp As String
    Dim sResults As String
    Dim sXSL As String
    Dim sXML As String
    
    Set oDOM = New DOMDocument
    sSoapRq = BuildSoapGetCategoryListTx()
    sSoapResp = PostSoapRq(sSoapRq)
 
    ' We need to parse out the parts we want
    If oDOM.loadXML(sSoapResp) Then
        Set oEl = oDOM.getElementsByTagName("results").Item(0)
        If oEl Is Nothing Then
            Call oError.SetErrorInfo("Failed to get valid results: " & oDOM.xml, _
                PROGID & ".GetCategoryList", -1)
            sResults = oError.GetErrorInfoXml()
        Else
            sXML = oEl.xml
            ' Get the XSL
            sXSL = oApplication("CategoryListXsl")
            sResults = TransformXml(sSoapResp, sXSL)
        End If
    Else
        Call oError.SetErrorInfo("Failed to parse parameters: " & _
            oDOM.parseError.reason, PROGID & ".GetCategoryList", -1)
        sResults = ""
    End If
       
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description & " XML = " & sSoapResp, _
            PROGID & ".GetCategoryList", Err.Number)
        sResults = ""
    End If
    GetCategoryList = sResults

End Function

Public Function GetErrorInfoXml() As String
    GetErrorInfoXml = oError.GetErrorInfoXml()
End Function
'************************************************************************
' Public Function GetProduct(ByVal sProductID As String) As String
' Builds a SOAP transaction for retriving a specific product, POSTs it
' to the SOAP server, takes the response, pulls out the data returned,
' styles it with an XSL file, and returns the final result for inclusion
' in a web page.
'************************************************************************
Public Function GetProduct(ByVal sProductID As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim oSoapDom As MSXML.DOMDocument
    Dim sSoapRq As String
    Dim oEl As MSXML.IXMLDOMElement
    Dim sProdName As String
    Dim sProdCategory As String
    Dim sSoapResp As String
    Dim sResults As String
    Dim sSQL As String
    Dim sXSL As String
    Dim sXML As String

    Set oDOM = New DOMDocument
    sSoapRq = BuildSoapGetProductTx(sProductID)
    sSoapResp = PostSoapRq(sSoapRq)
    
    If oDOM.loadXML(sSoapResp) Then
        Set oEl = oDOM.getElementsByTagName("results").Item(0)
        If oEl Is Nothing Then
            Call oError.SetErrorInfo("Failed to get valid results: " & oDOM.xml, _
                PROGID & ".GetProduct", -1)
            sResults = oError.GetErrorInfoXml()
        Else
            sXML = oEl.xml
            ' Get the XSL
            sXSL = oApplication("ProductXsl")
            ' We're getting back a different sort of document ...
            
            sResults = oEl.xml 'TransformXml(sSoapResp, sXSL)

        End If
    Else
        Call oError.SetErrorInfo("Failed to parse SOAP response: " & _
            oDOM.parseError.reason, PROGID & ".GetProduct", -1)
        sResults = ""
    End If
    
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & _
            Err.Description, PROGID & ".GetProduct", Err.Number)
        sResults = ""
    End If
    GetProduct = sResults
End Function
'************************************************************************
' Public Function GetSelectedProducts(ByVal sXxmlParams As String)
' Runs a SOAP request to pull back specific items based on the ID
' values encoded in sXxmlParams, which should look like this:
'************************************************************************
Public Function GetSelectedProducts(ByVal sXmlParams As String)
    On Error GoTo ErrHand
    
    Dim oSoapDom As MSXML.DOMDocument
    Dim sSoapRq As String
    Dim sSoapResp  As String
    Dim sResults As String
    Dim sXML As String
    Dim sXSL As String
    Dim oEl As MSXML.IXMLDOMElement
    Dim oXmlDom As MSXML.DOMDocument
    Dim oXslDom As MSXML.DOMDocument
    
    Set oXmlDom = New DOMDocument
    Set oXslDom = New DOMDocument
    
    If oXmlDom.loadXML(sXmlParams) Then
        sSoapRq = BuildSoapGetSelectedProductsTx(sXmlParams)
        ' Retrieve the selected items ...
        sSoapResp = PostSoapRq(sSoapRq)
        If oXmlDom.loadXML(sSoapResp) Then
            Set oEl = oXmlDom.getElementsByTagName("DATA").Item(0)
            If oEl Is Nothing Then
                Call oError.SetErrorInfo("Failed to get valid results: " & _
                    oXmlDom.xml, PROGID & ".GetSelectedProducts", -1)
                sResults = ""
            Else
                sXML = oEl.xml
                ' Get the XSL
                sXSL = oApplication("SelectedItemsXsl")
                If oXslDom.loadXML(sXSL) Then
                    sResults = oEl.xml
                    sResults = TransformXml(sResults, sXSL)
                Else
                    Call oError.SetErrorInfo("Failed to parse XSL: " & _
                        oXslDom.parseError.reason, PROGID & ".GetSelectedProducts", _
                        -1)
                    sResults = ""
                End If
            End If
        Else ' Bad XML in response
            Call oError.SetErrorInfo("Failed to parse SOAP response: " & _
                oXmlDom.parseError.reason, PROGID & ".GetSelectedProducts", -1)
            sResults = ""
        End If
    Else
       Call oError.SetErrorInfo("Failed to parse XML params: " & _
            oXmlDom.parseError.reason, PROGID & ".GetSelectedProducts", _
            oXmlDom.parseError.errorCode)
        sResults = ""
    End If
    
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & _
            Err.Description, PROGID & ".GetSelectedProducts", Err.Number)
        sResults = ""
    End If
    
    GetSelectedProducts = sResults
End Function
'************************************************************************
' Public Function PostPurchaseOrder(ByVal sPoDataXml As String) As String
' Takes the XML-formatted purchase order data from the ASP code and sends
' it off to some remote machine. We happen to be using MSMQ, but the class
' that does this hides the actual details.
'************************************************************************
Public Function PostPurchaseOrder(ByVal sPoDataXml As String) As String
    On Error GoTo ErrHand
    
    Dim sResults As String
    Dim sRemProdTxProgID As String
    Dim sConfigData As String
    Dim sPostResults As String
    Dim vRes As Variant
    

    sRemProdTxProgID = oApplication.Value("RemoteProdOrderTxProgID")
    sConfigData = oApplication.Value("RemoteProdOrderTxConfig")
    Set oRemoteOrderTx = oCtx.CreateInstance(sRemProdTxProgID)
    
    If Len(sConfigData) < 1 Then
        Call oError.SetErrorInfo("No config data: ", _
            PROGID & ".PostPurchaseOrder", -1)
        sResults = oError.GetErrorInfoXml()
        Exit Function
    End If
    
    If (oRemoteOrderTx.Configure(sConfigData)) Then
        sPostResults = oRemoteOrderTx.PostPurchaseOrder(sPoDataXml)
        If (InStr(sPostResults, "OK")) Then
            sResults = "<OK/>"
        Else ' remote post ruined our day ...
            Call oError.SetErrorInfo("Post to remote machine failed!", _
                PROGID & ".", -1)
            sResults = oRemoteOrderTx.GetErrorInfoXml()
        End If

    Else ' config data has bad mojo
        Call oError.SetErrorInfo("Configuration of remote poster class failed.", _
            PROGID & ".", -1)
            sResults = oError.GetErrorInfoXml()
    End If
    
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
            PROGID & ".PostPurchaseOrder", Err.Number)
        sResults = oError.GetErrorInfoXml()
    End If
    PostPurchaseOrder = sResults
End Function
'************************************************************************
' Private Function PostSoapRq(sSoap As String) As String
'************************************************************************
Private Function PostSoapRq(sSoap As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM  As MSXML.DOMDocument
    Dim oHttpRq As MSXML.XMLHTTPRequest
    Dim sResults As String
    
    Set oHttpRq = New XMLHTTPRequest
    Set oDOM = New DOMDocument
    
    If oApplication Is Nothing Then
            Call oError.SetErrorInfo("oApplication Is Nothing" _
                , PROGID & "PostSoapRq", -1)
            sResults = oError.GetErrorInfoXml()
            PostSoapRq = oError.GetErrorInfoXml()
        Exit Function
    End If
    
    m_sSoapUrl = oApplication.Value("SoapUrl")
    
    If Len(m_sSoapUrl) < 1 Then
        Call oError.SetErrorInfo("No SOAP URL" _
                , PROGID & "PostSoapRq", -1)
        sResults = oError.GetErrorInfoXml()
    Else
        If oDOM.loadXML(sSoap) Then
            ' Set up parameters for SOAP request
            With oSoapRq
                .SoapServerURL = oApplication.Value("SoapURL")
                .TransactionNamespaceURI = oApplication.Value("SoapTransactionNamespaceURI")
                .TimeoutSeconds = oApplication.Value("SoapTimeout")
                sResults = .PostRequest(sSoap)
                sResults = .GetResponseBody(sResults)
            End With
        Else
            Call oError.SetErrorInfo("Failed to parse SOAP request: " & _
                oDOM.parseError.reason, PROGID & "PostSoapRq", -1)
            sResults = oError.GetErrorInfoXml()
        End If
    End If

ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & _
            Err.Description, PROGID & ".PostSoapRq", Err.Number)
        sResults = oError.GetErrorInfoXml()
    End If
    PostSoapRq = sResults
End Function


'************************************************************************
' Public Function SearchForProducts(ByVal sXmlParams As String) As String
' Caled by thte web page, expects XML back.
'************************************************************************
Public Function SearchForProducts(ByVal sXmlParams As String) As String
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim oSoapDom As MSXML.DOMDocument
    Dim sSoapRq As String
    Dim oEl As MSXML.IXMLDOMElement
    Dim sProdName As String
    Dim sProdCategory As String
    Dim sSoapResp As String
    Dim sResults As String
    Dim sSQL As String
    Dim sXSL As String
    Dim sXML As String
    
    Set oDOM = New DOMDocument
    If oDOM.loadXML(sXmlParams) Then
        ' Parse out the parameters
        Set oEl = oDOM.documentElement
        sProdName = oEl.Attributes.getNamedItem("name").nodeValue
        sProdCategory = oEl.Attributes.getNamedItem("category").nodeValue
        sSoapRq = BuildSoapSearchTx(sProdName, sProdCategory)
        ' POST the request
        sSoapResp = PostSoapRq(sSoapRq)
        ' Should get back something like this:
        '<SOAP:Envelope xmlns:SOAP="urn:schemas-xmlsoap-org:soap.v1" SOAP:encodingStyle="urn:schemas-xmlsoap-org:soap.v1">
        '<SOAP:Body>
        '<soapSearchForProductResponse>
        '    <results>
        '        <DATA>
        '            <Row ProdID="20" Name="Poo" Category="foocat" BriefDesc="bloog" XmlDetails="http://127.0.0.1/ProdFiles/20.xml"/>
        '            <Row ProdID="21" Name="Poo" Category="foocat" BriefDesc="bloog" XmlDetails="file://c:/"/>
        '        </DATA>
        '    </results>
        '</soapSearchForProductResponse>
        '</SOAP:Body>
        
        ' We need to parse out the parts we want
        If oDOM.loadXML(sSoapResp) Then
            Set oEl = oDOM.getElementsByTagName("results").Item(0)
            sXML = oEl.xml
        Else
            Call oError.SetErrorInfo("Failed to parse parameters: " & _
                oDOM.parseError.reason, PROGID & ".SearchForProducts", -1)
            sResults = ""
        End If
        sXSL = oApplication("SearchResultsXsl")
        sResults = TransformXml(sSoapResp, sXSL)
    Else ' Failed to load XML
        Call oError.SetErrorInfo("Failed to parse parameters: " & _
            oDOM.parseError.reason, PROGID & ".SearchForProducts", -1)
        sResults = ""
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
            PROGID & ".SearchForProducts", Err.Number)
        sResults = ""
    End If
    
    SearchForProducts = sResults
End Function
'************************************************************************
' Public Function TransformXml(ByVal sXML as String, sXML as String) as String
' Takes the XML and transforms it with XSL, and sends back the result.
'************************************************************************
Public Function TransformXml(ByVal sXML As String, sXSL As String) As String
    On Error GoTo ErrHand
    
    Dim oXmlDom As MSXML.DOMDocument
    Dim oXslDom As MSXML.DOMDocument
    Dim sResults As String
    
    Set oXmlDom = New DOMDocument
    Set oXslDom = New DOMDocument
    
    If oXmlDom.loadXML(sXML) Then
        If oXslDom.loadXML(sXSL) Then
            sResults = oXmlDom.transformNode(oXslDom)
        Else ' Failed to parse XSL
        Call oError.SetErrorInfo("XSL error: " & oXmlDom.parseError.reason, _
            PROGID & ".TransformXml", oXmlDom.parseError.errorCode)
            sResults = ""
        End If
    Else ' Failed to parse XML
        Call oError.SetErrorInfo("XML error: " & oXmlDom.parseError.reason, _
            PROGID & ".TransformXml", oXmlDom.parseError.errorCode)
        sResults = ""
    End If
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
            PROGID & ".TransformXml", Err.Number)
        sResults = ""
    End If
    Set oXmlDom = Nothing
    Set oXslDom = Nothing
    TransformXml = sResults
End Function

Private Sub ObjectControl_Activate()
    Set oCtx = GetObjectContext()
    Set oApplication = oCtx.Item("Application")
    Set oSoapRq = oCtx.CreateInstance("SoapRequestMts.XmlHttp")
    m_sSoapUrl = oApplication("SoapUrl")
    Set oError = New ErrorUtils.ErrorInfo
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oApplication = Nothing
    Set oSoapRq = Nothing
    Set oError = Nothing
End Sub

