VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 3  'UsesTransaction
END
Attribute VB_Name = "DataServices"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'****************************************************************
' Data services component to manage out product database.
'****************************************************************
Option Explicit
Implements ObjectControl

Const PROGID As String = "WroxDataAccess.DataServices"

Dim oRs As ADODB.Recordset
Dim oConn As ADODB.Connection
Dim oError As ErrorUtils.ErrorInfo  ' Class for handling error info
Dim oCtx As ObjectContext

Private m_sConnectionString As String
Public Property Get ConnectionString() As String
    ConnectionString = m_sConnectionString
End Property
Public Property Let ConnectionString(sConnStr As String)
    m_sConnectionString = sConnStr
End Property

Public Property Get ErrorDescription() As String
    ErrorDescription = oError.Description
End Property
Public Property Get ErrorLocation() As String
    ErrorLocation = oError.Location
End Property
Public Property Get ErrorNumber() As Long
    ErrorNumber = oError.Number
End Property

Public Function GetErrorInfoXML() As String
    GetErrorInfoXML = oError.GetErrorInfoXML
End Function

Private Function ConvertDataToXmlString(vData As Variant) As String
    On Error GoTo ErrHand
    Call oError.ClearErrorInfo
    
    Dim sXML As String
    If IsNull(vData) Then
        sXML = "NULL"
    ElseIf TypeName(vData) = "String" Then
        sXML = XmlEncode(vData)
    Else
        sXML = XmlEncode(CStr(vData))
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        sXML = ""
        Call oError.SetErrorInfo(Err.Description, _
            PROGID & ".ConvertDataToXmlString", Err.Number)
    End If
    
    ConvertDataToXmlString = sXML
End Function
'****************************************************************
' Private Function ConvertRsToXml(oRs As ADODB.Recordset) As String
'****************************************************************
Private Function ConvertRsToXml(oRs As ADODB.Recordset) As String
    On Error GoTo ErrHand
    Dim sXML As String
    Dim fld As ADODB.Field
    Dim sVal As String
    
    Call oError.ClearErrorInfo
    sXML = ""
    ' May want to reference a schema and usr namespace
    sXML = sXML & "<DATA>" & vbCrLf
    Do While Not oRs.EOF
        sXML = sXML & "<Row "
        For Each fld In oRs.Fields
            sVal = ConvertDataToXmlString(fld.Value)
            If oError.Number <> 0 Then
                sXML = sXML & fld.Name & "='ERROR_CONVERTING_TO_XML' "
            Else
                sXML = sXML & fld.Name & "='" & Trim(sVal) & "' "
            End If
        Next
        sXML = sXML & " />" & vbCrLf
        oRs.MoveNext
    Loop
    sXML = sXML & "</DATA>" & vbCrLf

ErrHand:
    If Err.Number <> 0 Then
        sXML = ""
        Call oError.SetErrorInfo(Err.Description, _
            PROGID & ".ConvertRsToXml", Err.Number)
    End If
    ConvertRsToXml = sXML
End Function
'****************************************************************
' Public Function ExecuteInsert(ByVal sSQL As String) As Boolean
'***************************************************************
Public Function ExecuteInsert(ByVal sSQL As String) As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    Call oError.ClearErrorInfo
    
    If (Len(m_sConnectionString) > 0) Then
        If oConn.State <> adStateClosed Then
            oConn.Close
        End If
        oConn.Open (m_sConnectionString)
        Set oRs = oConn.Execute(sSQL)
        Set oRs.ActiveConnection = Nothing
        oConn.Close
        bResults = True
    Else
        bResults = False
        Call oError.SetErrorInfo("No connection string", _
            PROGID & ".ExecuteInsert", -1)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        Call oError.SetErrorInfo(Err.Description & "SQL = " & sSQL, _
            PROGID & ".ExecuteInsert", Err.Number)

    End If
    ExecuteInsert = bResults
End Function
'****************************************************************
' Public Function ExecuteSQL(ByVal sSQL As String) As Boolean
'***************************************************************
Public Function ExecuteSQL(ByVal sSQL As String) As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    Call oError.ClearErrorInfo
    
    If (Len(m_sConnectionString) > 0) Then
        If oConn.State <> adStateClosed Then
            oConn.Close
        End If
        oConn.Open (m_sConnectionString)
        Set oRs = oConn.Execute(sSQL)
        Set oRs.ActiveConnection = Nothing
        oConn.Close
        bResults = True
    Else
        bResults = False
        Call oError.SetErrorInfo("No connection string", _
            PROGID & ".ExecuteSQL", -1)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        Call oError.SetErrorInfo(Err.Description & "SQL = " & sSQL, _
            PROGID & ".ExecuteSQL", Err.Number)

    End If
    ExecuteSQL = bResults
End Function

Public Function ExecuteUpdate(ByVal sSQL As String) As Boolean
    On Error GoTo ErrHand
    Dim bResults As Boolean
    Call oError.ClearErrorInfo
    
    If (Len(m_sConnectionString) > 0) Then
        If oConn.State <> adStateClosed Then
            oConn.Close
        End If
        oConn.Open (m_sConnectionString)
        Set oRs = oConn.Execute(sSQL)
        oConn.Close
        bResults = True
    Else
        bResults = False
        Call oError.SetErrorInfo("No connection string", _
            PROGID & ".ExecuteUpdate", -1)
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        bResults = False
        Call oError.SetErrorInfo(Err.Description & "SQL = " & sSQL, _
            PROGID & ".ExecuteUpdate", Err.Number)
    End If
    ExecuteUpdate = bResults

End Function

'****************************************************************
' Public ExecuteSelectXml(sSQL As String) As String
'***************************************************************
Public Function ExecuteSelectXml(sSQL As String) As String
    On Error GoTo ErrHand
    Dim sResults As String
    Dim sXML As String
    
    Call oError.ClearErrorInfo
    
    If (Len(m_sConnectionString) > 0) Then
        Set oConn = New Connection
        oConn.Open (m_sConnectionString)
        Set oRs = oConn.Execute(sSQL)
        sXML = ConvertRsToXml(oRs)
        If Len(sXML) < 1 Then
            ' Error info should have been set in ConvertRsToXml
            sResults = ""
        Else
            sResults = sXML
        End If
    Else
        Call oError.SetErrorInfo("No connection string", _
            PROGID & ".ExecuteSelectXml", -1)
        sResults = ""
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo(Err.Description, _
            PROGID & ".ExecuteSelectXml", Err.Number)
        sResults = ""
    End If
    
    ExecuteSelectXml = sResults
End Function

Private Function XmlEncode(sText) As String
    Dim s As String
    s = Replace(sText, "&", "&amp;")
    s = Replace(s, "<", "&lt;")
    s = Replace(s, ">", "&gt;")
    s = Replace(s, "'", "&apos;")
    s = Replace(s, """", "&quot;")
    XmlEncode = s
End Function
Private Sub ObjectControl_Activate()
    m_sConnectionString = ""
    Set oConn = New Connection
    Set oError = New ErrorUtils.ErrorInfo
    Set oCtx = GetObjectContext()
    oError.ClearErrorInfo
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set oError = Nothing
    Set oConn = Nothing
    Set oCtx = Nothing
End Sub
