VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "ProductOrdersMsmq"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit


Implements ObjectControl
Implements IRemoteTransactions.IProductOrders

Const PROGID  As String = "WroxRemoteTX.ProductOrdersMsmq"
Const MQ_SEND_ACCESS = 2
Const MQ_DENY_NONE = 0

Private Qinfo As MSMQ.MSMQQueueInfo
Private Q As MSMQ.MSMQQueue
Private Qmsg As MSMQ.MSMQMessage

Private oError As ErrorUtils.ErrorInfo
Private oCtx As ObjectContext
Private oConfigDataDict As Scripting.Dictionary
'**********************************************************************
' Private Function IProductOrders_Configure(ByVal sXmlConfigData As String) As Boolean
' Takes an XML string containing configuration data and sets some private memembers.
' Returns True if happy, False if sad.
' We expect an XML string like
' <Config>
'  <Item type='machineName' value='' />
'  <Item type='queueName' value='' />
' </Config>
'**********************************************************************

Private Function IProductOrders_Configure(ByVal sXmlConfigData As String) As Boolean
    On Error GoTo ErrHand
    
    Dim oDOM As MSXML.DOMDocument
    Dim bResults As Boolean
    Dim oNodeList As IXMLDOMNodeList
    Dim oEl As IXMLDOMElement
    Dim sKey As String
    Dim sData As String
    Dim nIdx As Integer
    
    Call oError.ClearErrorInfo
    Set oDOM = New DOMDocument
        
    If oDOM.loadXML(sXmlConfigData) Then
        Set oNodeList = oDOM.getElementsByTagName("Item")
        For nIdx = 0 To oNodeList.length - 1
            Set oEl = oNodeList.Item(nIdx)
            sKey = oEl.Attributes.getNamedItem("type").nodeValue
            sData = oEl.Attributes.getNamedItem("value").nodeValue
            oConfigDataDict.Add sKey, sData
        Next
        bResults = True
    Else ' Bad XML!
        Call oError.SetErrorInfo("XML error: " & oDOM.parseError.reason, _
            PROGID & ".Configure", oDOM.parseError.errorCode)
        bResults = False
    End If
    
        
ErrHand:

    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
            PROGID & ".Configure", Err.Number)
        bResults = False
    End If

    IProductOrders_Configure = bResults
End Function

Private Function IProductOrders_GetErrorInfoXml() As String
    IProductOrders_GetErrorInfoXml = oError.GetErrorInfoXML()
End Function

Private Function IProductOrders_PostPurchaseOrder(ByVal sPoXml As String) As String
    On Error GoTo ErrHand
    
    Dim sResults As String
    Dim sMachineName As String
    Dim sQueueName As String
    
    Call oError.ClearErrorInfo
    
    sMachineName = oConfigDataDict.Item("machineName")
    sQueueName = oConfigDataDict.Item("queueName")
    If Len(sMachineName) > 0 Then
        sMachineName = "\\" & sMachineName & "\"
    End If
    Qinfo.PathName = sMachineName & sQueueName
    
    Set Q = Qinfo.Open(MQ_SEND_ACCESS, MQ_DENY_NONE)
  
    'Create the message
    Set Qmsg = New MSMQ.MSMQMessage
    Qmsg.Label = "WROXPO_" & Now()
    Qmsg.Body = sPoXml
  
    'Invoke the Send method of the MSMQMessage object
    Qmsg.send Q
  
    'Invoke the Close method
    Q.Close
    sResults = "<OK/>"
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description & " Qinfo.PathName  = " & Qinfo.PathName, _
            PROGID & ".PostPurchaseOrder", Err.Number)
        sResults = oError.GetErrorInfoXML()
    End If
    
    IProductOrders_PostPurchaseOrder = sResults
End Function

Private Sub ObjectControl_Activate()
    Set Qinfo = New MSMQ.MSMQQueueInfo
    Set Qmsg = New MSMQ.MSMQMessage
    Set oError = New ErrorUtils.ErrorInfo
    Set oConfigDataDict = New Scripting.Dictionary
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
    Set Qinfo = Nothing
    Set Qmsg = Nothing
    Set oError = Nothing
End Sub
