VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "ProductOrdersSoap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'**********************************************************************
' Class  WroxRemoteTX.ProductOrdersSoap
' Handles SOAP transactions to the warehouse system that processes
' customer orders.
' Important: Do not add public methods. The private methods provided
' by implementing IRemoteTransactions.IProductOrders
' provide a consistent interface in case we want to swapt objects
' and use a differenProductOrders are available if you declare an object
' of type IRemoteTransactions.IProductOrders and instantiate it with
' CreateObject.
' Adding additional methods means adding dependencies that other implementaions
' may not have.  If you think there should be other methods, change the interface
' class and recompile.
' The setup is simple: Create the class, set the configuration info, and
' call the posting class. Check the error info if you think something bad
' happened.
'**********************************************************************
Option Explicit

Implements ObjectControl
Implements IRemoteTransactions.IProductOrders

Const PROGID  As String = "WroxRemoteTX.ProductOrdersSoap"

Private oSoapRq As SoapRequestMts.XmlHttp
Private oError As ErrorUtils.ErrorInfo
Private oCtx As ObjectContext

Private oConfigDataDict As Scripting.Dictionary
'**********************************************************************
' Private Function BuildSoapPostOrder(sOrderInfoXml As String) As String
' Takes the order info and configures it for the SOAP body, adding the
' SOAP envelope stuff as well.
'**********************************************************************
Private Function BuildSoapPostOrder(sOrderInfoXml As String) As String
    Dim sSoapTx As String
    Dim sOrderInfo As String
    Dim oDOM As DOMDocument
    
    Set oDOM = New DOMDocument
    If oDOM.loadXML(sOrderInfoXml) Then
        sSoapTx = "</SOAP:Body>" & vbLf
        sSoapTx = sSoapTx & " </SOAP:Envelope>"
        sSoapTx = sSoapTx & "<soapPostPurchaseOrder>" & vbLf
        sSoapTx = sSoapTx & "   <w:orderInfo "
        sSoapTx = sSoapTx & "xmlns:w='www.wrox.com/VbXml'>" & vbLf
        sSoapTx = sSoapTx & sOrderInfoXml & "</w:orderInfo>" & vbLf
        sSoapTx = sSoapTx & "</soapPostPurchaseOrder>" & vbLf
        sSoapTx = sSoapTx & " </SOAP:Body>" & vbLf
        sSoapTx = sSoapTx & "</SOAP:Envelope>"
    Else
        Call oError.SetErrorInfo("Error parsing XML: " & oDOM.parseError.reason, _
            PROGID & ".BuildSoapPostOrder", oDOM.parseError.errorCode)
        sSoapTx = ""
    End If
    
    BuildSoapPostOrder = sSoapTx
End Function

'**********************************************************************
' Private Function IProductOrders_Configure(ByVal sXmlConfigData As String) As Boolean
' Takes an XML string containing configuration data and sets some private memembers.
' Returns True if happy, False if sad.
' We expect an XML string like
' <Config>
'  <Item type='soapServerUrl' value='http://192.168.0.1/soapb2/SoapSrv.asp' />
'  <Item type='transactionNamespace' value='http://www.logicmilestone.com/vbSoap' />
'  <Item type='timeoutSeconds ' value='300' />
' </Config>
'**********************************************************************
Private Function IProductOrders_Configure(ByVal sXmlConfigData As String) As Boolean
    On Error GoTo ErrHand
    Dim oDOM As MSXML.DOMDocument
    Dim bResults As Boolean
    Dim oNodeList As IXMLDOMNodeList
    Dim oEl As IXMLDOMElement
    Dim sKey As String
    Dim sData As String
    Dim nIdx As Integer
    
    Set oDOM = New DOMDocument
    If oDOM.loadXML(sXmlConfigData) Then
        Set oNodeList = oDOM.getElementsByTagName("Item")
        For nIdx = 0 To oNodeList.length
            Set oEl = oNodeList.Item(nIdx)
            sKey = oEl.Attributes.getNamedItem("type").nodeValue
            sData = oEl.Attributes.getNamedItem("value").nodeValue
            oConfigDataDict.Add sKey, sData
        Next
        bResults = True
    Else ' Bad XML!
        Call oError.SetErrorInfo("XML error: " & oDOM.parseError.reason, _
            PROGID & ".Configure", oDOM.parseError.errorCode)
        bResults = False
    End If
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM error: " & Err.Description, _
            PROGID & ".Configure", Err.Description)
        bResults = False
    End If
End Function

Private Function IProductOrders_GetErrorInfoXml() As String
    IProductOrders_GetErrorInfoXml = oError.GetErrorInfoXML()
End Function

Private Function IProductOrders_PostPurchaseOrder(ByVal sPoXml As String) As String
    On Error GoTo ErrHand
    
    Dim sResults As String
    Dim sSoap As String
    
    sSoap = BuildSoapPostOrder(sPoXml)
    
    With oSoapRq
        .SoapServerURL = oConfigDataDict.Item("soapServerUrl")
        .TransactionNamespaceURI = oConfigDataDict.Item("transactionNamespace")
        .TimeoutSeconds = oConfigDataDict.Item("timeoutSeconds")
        sResults = .PostRequest(sSoap)
        sResults = .GetResponseBody(sResults)
    End With
    
    sResults = "<OK/>"
    
ErrHand:
    If Err.Number <> 0 Then
        Call oError.SetErrorInfo("COM Error: " & Err.Description, _
            PROGID & ".PostPurchaseOrder", -1)
        sResults = oError.GetErrorInfoXML()
    End If
    
    IProductOrders_PostPurchaseOrder = sResults
End Function

Private Sub ObjectControl_Activate()
    Set oCtx = GetObjectContext()
    Set oError = New ErrorUtils.ErrorInfo
    Set oSoapRq = oCtx.CreateInstance("SoapRequestMts.XmlHttp")
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
   
    Set oError = Nothing
    Set oSoapRq = Nothing
    Set oCtx = Nothing
End Sub
