VERSION 5.00
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "SHDOCVW.DLL"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{6B8AD819-CABC-11D3-89BA-444553540000}#24.0#0"; "XmlText.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Product Info Editor"
   ClientHeight    =   6120
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   13290
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6120
   ScaleWidth      =   13290
   StartUpPosition =   2  'CenterScreen
   Begin MSComDlg.CommonDialog dlgOpen 
      Left            =   6720
      Top             =   5775
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin SHDocVwCtl.WebBrowser wbPreview 
      Height          =   5475
      Left            =   6720
      TabIndex        =   1
      Top             =   105
      Width           =   6420
      ExtentX         =   11324
      ExtentY         =   9657
      ViewMode        =   0
      Offline         =   0
      Silent          =   0
      RegisterAsBrowser=   0
      RegisterAsDropTarget=   1
      AutoArrange     =   0   'False
      NoClientEdge    =   0   'False
      AlignLeft       =   0   'False
      ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
      Location        =   ""
   End
   Begin TabDlg.SSTab tabCtl 
      Height          =   5685
      Left            =   315
      TabIndex        =   0
      Top             =   210
      Width           =   6105
      _ExtentX        =   10769
      _ExtentY        =   10028
      _Version        =   393216
      Tabs            =   4
      Tab             =   3
      TabsPerRow      =   2
      TabHeight       =   520
      TabCaption(0)   =   "Product Essentials"
      TabPicture(0)   =   "frmMain.frx":0000
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "lblProdID"
      Tab(0).Control(1)=   "lblProdName"
      Tab(0).Control(2)=   "lblMftID"
      Tab(0).Control(3)=   "lblProdCategory"
      Tab(0).Control(4)=   "txtProductID"
      Tab(0).Control(5)=   "txtProductName"
      Tab(0).Control(6)=   "txtMftID"
      Tab(0).Control(7)=   "lstProductCategory"
      Tab(0).ControlCount=   8
      TabCaption(1)   =   "Product Description"
      TabPicture(1)   =   "frmMain.frx":001C
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "lblElements"
      Tab(1).Control(1)=   "cmbElements"
      Tab(1).Control(2)=   "txtMessages"
      Tab(1).Control(3)=   "xmlTxtProductDesc"
      Tab(1).ControlCount=   4
      TabCaption(2)   =   "Related Products"
      TabPicture(2)   =   "frmMain.frx":0038
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "lstRelatedProducts"
      Tab(2).Control(1)=   "lstPickAvailProds"
      Tab(2).Control(2)=   "lblRemoveRelProd"
      Tab(2).Control(3)=   "lblRelProds"
      Tab(2).Control(4)=   "Label1"
      Tab(2).ControlCount=   5
      TabCaption(3)   =   "Related URLs"
      TabPicture(3)   =   "frmMain.frx":0054
      Tab(3).ControlEnabled=   -1  'True
      Tab(3).Control(0)=   "lblUrslHelp1"
      Tab(3).Control(0).Enabled=   0   'False
      Tab(3).Control(1)=   "lblUrlHelp2"
      Tab(3).Control(1).Enabled=   0   'False
      Tab(3).Control(2)=   "cmbUrls"
      Tab(3).Control(2).Enabled=   0   'False
      Tab(3).ControlCount=   3
      Begin XmlText.XmlTextbox xmlTxtProductDesc 
         Height          =   3375
         Left            =   -74685
         TabIndex        =   21
         Tag             =   "<DESCRIPTION>"
         Top             =   1470
         Width           =   5370
         _ExtentX        =   9472
         _ExtentY        =   5953
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BorderStyle     =   1
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         ParseErrorReason=   $"frmMain.frx":0070
      End
      Begin VB.ListBox lstRelatedProducts 
         Height          =   2400
         ItemData        =   "frmMain.frx":00A1
         Left            =   -74685
         List            =   "frmMain.frx":00A3
         TabIndex        =   18
         Top             =   2730
         Width           =   5265
      End
      Begin VB.ListBox lstPickAvailProds 
         Height          =   1230
         ItemData        =   "frmMain.frx":00A5
         Left            =   -74685
         List            =   "frmMain.frx":00A7
         Sorted          =   -1  'True
         TabIndex        =   16
         Top             =   1050
         Width           =   5265
      End
      Begin VB.TextBox txtMessages 
         ForeColor       =   &H000000FF&
         Height          =   435
         Left            =   -74685
         MultiLine       =   -1  'True
         TabIndex        =   14
         Top             =   5040
         Width           =   5265
      End
      Begin VB.ComboBox cmbElements 
         Height          =   315
         Left            =   -72375
         TabIndex        =   13
         Top             =   1050
         Width           =   2955
      End
      Begin VB.ComboBox cmbUrls 
         Height          =   3495
         Left            =   315
         Style           =   1  'Simple Combo
         TabIndex        =   10
         Top             =   1155
         Width           =   5370
      End
      Begin VB.ListBox lstProductCategory 
         Height          =   2205
         Left            =   -73110
         TabIndex        =   9
         Top             =   2520
         Width           =   3795
      End
      Begin VB.TextBox txtMftID 
         Height          =   285
         Left            =   -73110
         TabIndex        =   7
         Text            =   "00000"
         Top             =   1995
         Width           =   3795
      End
      Begin VB.TextBox txtProductName 
         Height          =   285
         Left            =   -73110
         TabIndex        =   5
         Top             =   1470
         Width           =   3795
      End
      Begin VB.TextBox txtProductID 
         Enabled         =   0   'False
         Height          =   285
         Left            =   -73110
         TabIndex        =   3
         Text            =   "000000"
         Top             =   1050
         Width           =   3795
      End
      Begin VB.Label lblRemoveRelProd 
         AutoSize        =   -1  'True
         Caption         =   "Double-click an item to remove it."
         Height          =   195
         Left            =   -74685
         TabIndex        =   20
         Top             =   5250
         Width           =   2355
      End
      Begin VB.Label lblRelProds 
         AutoSize        =   -1  'True
         Caption         =   "... to add to this list"
         Height          =   195
         Left            =   -74685
         TabIndex        =   19
         Top             =   2520
         Width           =   1320
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Double-click on on an item ..."
         Height          =   195
         Left            =   -74685
         TabIndex        =   17
         Top             =   840
         Width           =   2070
      End
      Begin VB.Label lblElements 
         AutoSize        =   -1  'True
         Caption         =   "Elements"
         Height          =   195
         Left            =   -70065
         TabIndex        =   15
         Top             =   840
         Width           =   645
      End
      Begin VB.Label lblUrlHelp2 
         AutoSize        =   -1  'True
         Caption         =   "Double-click an item to remove."
         Height          =   195
         Left            =   315
         TabIndex        =   12
         Top             =   5145
         Width           =   2235
      End
      Begin VB.Label lblUrslHelp1 
         AutoSize        =   -1  'True
         Caption         =   "Enter text and press ""Enter"" to add URL."
         Height          =   195
         Left            =   315
         TabIndex        =   11
         Top             =   4830
         Width           =   2895
      End
      Begin VB.Label lblProdCategory 
         AutoSize        =   -1  'True
         Caption         =   "Product category:"
         Height          =   195
         Left            =   -74685
         TabIndex        =   8
         Top             =   2520
         Width           =   1260
      End
      Begin VB.Label lblMftID 
         AutoSize        =   -1  'True
         Caption         =   "Manufactuer's ID:"
         Height          =   195
         Left            =   -74790
         TabIndex        =   6
         Top             =   1995
         Width           =   1260
      End
      Begin VB.Label lblProdName 
         AutoSize        =   -1  'True
         Caption         =   "Product name:"
         Height          =   195
         Left            =   -74790
         TabIndex        =   4
         Top             =   1470
         Width           =   1035
      End
      Begin VB.Label lblProdID 
         AutoSize        =   -1  'True
         Caption         =   "Product ID"
         Height          =   195
         Left            =   -74790
         TabIndex        =   2
         Top             =   1050
         Width           =   765
      End
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&Local"
      Begin VB.Menu mnuLocalOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuLocalSave 
         Caption         =   "&Save"
      End
   End
   Begin VB.Menu mnuWeb 
      Caption         =   "&Web"
      Begin VB.Menu mnuWebOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuWebSave 
         Caption         =   "&Save"
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "Editing &Options"
      Begin VB.Menu mnuDisableAngles 
         Caption         =   "Disable < and >"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuAutoValidate 
         Caption         =   "&Auto-validate"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu mnuPreview 
      Caption         =   "&Preview"
   End
   Begin VB.Menu mnuExit 
      Caption         =   "E&xit"
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'**********************************************************************
' Product Information XML Editor
'**********************************************************************
Option Explicit

Dim g_bLoadComplete As Boolean
Dim g_nSelTextLocation As Integer

Const RES_CATEGORY_LIST As Integer = 103
Const RES_PREVIEW_XSL As Integer = 104
Const RES_ELEMENT_LIST As Integer = 105
Const RES_RELPROD_LIST As Integer = 106

Private Sub cmbElements_Click()
    Dim sEl As String
    xmlTxtProductDesc.SelStart = g_nSelTextLocation
    sEl = cmbElements.List(cmbElements.ListIndex)
    xmlTxtProductDesc.SelText = "<" & sEl & "></" & sEl & ">"
End Sub

Private Sub cmbUrls_DblClick()
    cmbUrls.RemoveItem (cmbUrls.ListIndex)
End Sub

Private Sub cmbUrls_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = Asc(vbCrLf) Then
        cmbUrls.AddItem (cmbUrls.Text)
    End If
End Sub

Private Sub Form_Load()
    
    Dim sBuf As String
    Dim lSize As Long
    Dim lRetval As Long
    sBuf = String(255, 0)
    lSize = 255
   
    sBuf = String(255, 0)
    lSize = 255
    lRetval = GetSystemDirectoryA(sBuf, lSize)
    sBuf = Left(sBuf, lRetval)

    wbPreview.Navigate2 ("res://" & sBuf & "\\SHDOCLC.DLL/dnserror.htm")
    g_bLoadComplete = False
    
    ' Wait until the doc has loaded
    Do While Not g_bLoadComplete
        DoEvents
    Loop
    
    'Clear the document body
    wbPreview.Document.body.innerHTML = ""
    
    ' Set up our lists
    Call PopulateCategoryList
    Call PopulateElementList
    Call PopulatePickRelatedProductsList
    xmlTxtProductDesc.AutoValidate = True
    xmlTxtProductDesc.NoUserElements = True
    
End Sub

Private Sub lstPickAvailProds_DblClick()
    lstRelatedProducts.AddItem (lstPickAvailProds.List(lstPickAvailProds.ListIndex))
    lstPickAvailProds.RemoveItem (lstPickAvailProds.ListIndex)
End Sub

Private Sub lstRelatedProducts_DblClick()
    lstPickAvailProds.AddItem (lstRelatedProducts.List(lstRelatedProducts.ListIndex))
    lstRelatedProducts.RemoveItem (lstRelatedProducts.ListIndex)
    
End Sub

Private Sub mnuAutoValidate_Click()
    mnuAutoValidate.Checked = Not mnuAutoValidate.Checked
    xmlTxtProductDesc.AutoValidate = mnuAutoValidate.Checked
End Sub

Private Sub mnuDisableAngles_Click()
    mnuDisableAngles.Checked = Not (mnuDisableAngles.Checked)
    xmlTxtProductDesc.NoUserElements = mnuDisableAngles.Checked
End Sub

Private Sub mnuExit_Click()
    ' See if the file has changed !!!
    ' If so, prompt to save ....
    
    ' Now quit
    End
End Sub

Private Sub mnuLocalOpen_Click()
    Call OpenLocalFile
End Sub

Private Sub mnuLocalSave_Click()
    Call SaveLocalFile
End Sub

Private Sub mnuPreview_Click()
    Call PreviewDocument
End Sub
Private Function BuildDocument() As String
    On Error GoTo ErrHand
    Dim sDescription As String
    Dim nIdx As Integer
    Dim sXML As String
    
    sXML = ""
    
    sXML = sXML & "<PRODUCT ID='" & txtProductID & "'>" & vbCrLf
    sXML = sXML & "<NAME>" & txtProductName & "</NAME>" & vbCrLf
    sXML = sXML & xmlTxtProductDesc.Text & vbCrLf
    sXML = sXML & "<CATEGORY>" & lstProductCategory.List(lstProductCategory.ListIndex) & "</CATEGORY>" & vbCrLf
    sXML = sXML & "<RELATEDURLS>" & vbCrLf
    For nIdx = 0 To cmbUrls.ListCount - 1
        sXML = sXML & "<URL href='" & cmbUrls.List(nIdx) & "' />" & vbCrLf
    Next
    sXML = sXML & "</RELATEDURLS>" & vbCrLf
    sXML = sXML & "<RELATEDPRODUCTS>" & vbCrLf
    For nIdx = 0 To lstRelatedProducts.ListCount - 1
        sXML = sXML & "<PRODUCT name='" & lstRelatedProducts.List(nIdx) & "'/>" & vbCrLf
    Next
    sXML = sXML & "</RELATEDPRODUCTS>" & vbCrLf
    
    
    sXML = sXML & "</PRODUCT>"
    
    
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error! " & Err.Description, vbCritical, "Error in " & Err.Source
        sXML = ""
    End If
    BuildDocument = sXML
End Function
'*********************************************************************
' Private Sub OpenLocalFile()
' Read in a file from the local file system and parse it into
' the form.  Check that the XML is well-formed, or complain.
'*********************************************************************
Private Sub OpenLocalFile()
    On Error GoTo ErrHand
    Dim strFilefilter  As String
    Dim strFilename As String
    Dim objDOM As MSXML.DOMDocument
    
    Set objDOM = New DOMDocument
    strFilefilter = "XML Files (*.xml)|*.xml|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CANCELERROR = True
        .Filter = strFilefilter
        .ShowOpen
    End With
    
    strFilename = dlgOpen.FileName
    
    If (Len(strFilename) > 0) Then
        If Not objDOM.Load("file://" & strFilename) Then
            MsgBox "Error loading XML document: " & objDOM.parseError.reason, vbExclamation, "XML load error"
            strFilename = ""
        Else
            mnuLocalSave.Enabled = True
            mnuWebSave.Enabled = True
            If Not ParseDomIntoForm(objDOM) Then
                MsgBox "Error parsing data file into form", vbCritical
            End If
        End If
    End If
    
    
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
       MsgBox "Error: " & Err.Description, vbExclamation, "Error opening file"
    End If
    
    Set objDOM = Nothing
End Sub
'*********************************************************************
' Private Function ParseDomIntoForm(oDOM As DOMDocument) As Boolean
' We want to take the contents of the DOM and put the data into the
' correct form elements.
'*********************************************************************
Private Function ParseDomIntoForm(oDOM As DOMDocument) As Boolean
    ' On Error GoTo ErrHand
    Dim oEl As IXMLDOMElement
    Dim oNodeList As IXMLDOMNodeList
    Dim sTemp As String
    Dim nIdx As Integer
    
    With oDOM
        sTemp = ""
        Set oEl = .childNodes(0)
        
        txtProductID = oEl.Attributes.getNamedItem("ID").nodeValue
        Set oEl = .getElementsByTagName("NAME").Item(0)
        For nIdx = 0 To oEl.childNodes.length - 1
            sTemp = sTemp & oEl.childNodes.Item(nIdx).nodeValue
        Next
        txtProductName = sTemp
        Set oEl = .getElementsByTagName("DESCRIPTION").Item(0)
        xmlTxtProductDesc.Text = oEl.xml
        
        sTemp = ""
        Set oEl = .getElementsByTagName("CATEGORY").Item(0)
        For nIdx = 0 To oEl.childNodes.length - 1
            sTemp = sTemp & oEl.childNodes.Item(nIdx).nodeValue
        Next
        
        For nIdx = 0 To lstProductCategory.ListCount - 1
            If lstProductCategory.List(nIdx) = sTemp Then
                lstProductCategory.ListIndex = nIdx
            End If
        Next
        
        sTemp = ""
        
        Set oNodeList = .selectNodes("//RELATEDURLS/URL")
        For nIdx = 0 To oNodeList.length - 1
            cmbUrls.AddItem (oNodeList.Item(nIdx).Attributes.getNamedItem("href").nodeValue)
        Next
        
        Set oNodeList = .selectNodes("//RELATEDPRODUCTS/PRODUCT")
        For nIdx = 0 To oNodeList.length - 1
            
            lstRelatedProducts.AddItem (oNodeList.Item(nIdx).Attributes.getNamedItem("name").nodeValue)
        Next
        
    End With 'oDOM
    ParseDomIntoForm = True
ErrHand:
    If Err.Number <> 0 Then
        ' Show error message here, or in calling function?
        ParseDomIntoForm = False
    End If
End Function
Private Sub PopulateCategoryList()
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = LoadResString(RES_CATEGORY_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        lstProductCategory.AddItem (varItem)
    Next
  
End Sub
Private Sub PopulateElementList()
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = LoadResString(RES_ELEMENT_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        cmbElements.AddItem (varItem)
    Next
  
End Sub

Function PopulatePickRelatedProductsList() As Boolean
    Dim sListItems As String
    Dim asItems() As String
    Dim varItem  As Variant
    
    sListItems = LoadResString(RES_RELPROD_LIST)
    asItems = Split(sListItems, "|")
    For Each varItem In asItems()
        lstPickAvailProds.AddItem (varItem)
    Next
End Function

Private Sub PreviewDocument()
    On Error GoTo ErrHand
    
    Dim sProdXML As String
    Dim sXSL As String
    Dim sHTML As String
    Dim oDomXsl  As MSXML.DOMDocument
    Dim objDOM As MSXML.DOMDocument
    
    ' Clear any current text
    wbPreview.Document.body.innerHTML = ""
    
    ' Build the document
    sProdXML = BuildDocument()
    Set objDOM = New DOMDocument
    
    If Not objDOM.loadXML(sProdXML) Then
        wbPreview.Document.Write _
            "<HTML><BODY><H1>Error</H1></BODY></HTML>"
    Else
        Set oDomXsl = New DOMDocument
        sXSL = LoadResString(RES_PREVIEW_XSL)

        If Not oDomXsl.loadXML(sXSL) Then
            wbPreview.Document.Write _
                "<HTML><BODY><H1>Error</H1></BODY></HTML>"
            MsgBox "XSL Error: " & oDomXsl.parseError.reason
            Debug.Print sXSL
        Else
        
            sHTML = objDOM.transformNode(oDomXsl)
            wbPreview.Document.Write sHTML
            Debug.Print sHTML
        End If
    End If
ErrHand:
    If Err.Number <> 0 Then
        MsgBox "Error previewing document." & _
            Err.Description, vbCritical, "Preview Error"
    End If
    Set objDOM = Nothing
    Set oDomXsl = Nothing
End Sub

Sub SaveLocalFile()
    On Error GoTo ErrHand
    Dim strFilename  As String
    Dim fsoSave As Scripting.FileSystemObject
    Dim tsSave As Scripting.TextStream
    Dim strFilefilter  As String
    Dim sXML As String
    Dim nSaveQuery As Integer
    
    Set fsoSave = New FileSystemObject
    strFilefilter = "XML Files (*.xml)|*.xml|All Files (*.*)|*.*"
    strFilename = ""
    
    With dlgOpen
        .FileName = ""
        .CANCELERROR = True
        .Filter = strFilefilter
        .ShowSave
    End With
    
    strFilename = dlgOpen.FileName
    
    If (Len(strFilename) > 0) Then
        sXML = BuildDocument()
        If Len(sXML) < 0 Then
            MsgBox "Error building file data"
            strFilename = ""
        Else
            If fsoSave.FileExists(strFilename) Then
                nSaveQuery = MsgBox("File exists. Overwrite?", vbYesNoCancel, "Save local file")
                Select Case nSaveQuery
                    Case vbYes
                        ' GO overwrite and quite
                        Set tsSave = fsoSave.OpenTextFile(strFilename, ForWriting, False)
                        tsSave.Write (sXML)
                        tsSave.Close
                    Case vbNo
                        Call SaveLocalFile
                        ' Redisplay the Save dialog
                    Case vbCancel
                        ' Forget it and quit
                End Select
            Else
                Set tsSave = fsoSave.OpenTextFile(strFilename, ForWriting, True)
                tsSave.Write (sXML)
                tsSave.Close
            End If
        End If
    End If
    
    
ErrHand:
    If (Err.Number <> 0) And (Err.Number <> cdlCancel) Then
       MsgBox "Error: " & Err.Description, vbExclamation, "Error saving  file"
    End If
    
    Set fsoSave = Nothing
    Set tsSave = Nothing

End Sub

Private Sub mnuWebOpen_Click()
' We need a transaction that lets us hit a web sever for a list
' of files, returned as XML.  We'll display the list in a dialog box;
' Selecting a file calls another web transaction to return the file.
' We may want to flag the file (change it to read-only?) so that no one
' else tries to change it while it's "checked out."
End Sub

Private Sub wbPreview_DocumentComplete(ByVal pDisp As Object, URL As Variant)
    g_bLoadComplete = True
End Sub

Private Sub xmlTxtProductDesc_LostFocus()
    Debug.Print xmlTxtProductDesc.SelStart
    g_nSelTextLocation = xmlTxtProductDesc.SelStart
End Sub

Private Sub xmlTxtProductDesc_ParseError()
    txtMessages = xmlTxtProductDesc.ParseErrorReason
    xmlTxtProductDesc.SelStart = xmlTxtProductDesc.ParseErrorPosition
End Sub
