VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStringTestWrapper"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'*********************************************************************
'  SoapWrappers.CStringTestWrapper
'*********************************************************************
Option Explicit

'*********************************************************************
'  GetNsStrings extracts the namespace name and builds string for the
'  xmlns attribute
'*********************************************************************
Private Function GetNsStrings(oEl As IXMLDOMElement, _
                              sNsPrefix As String, _
                              sNsAttr As String) As Boolean
     On Error GoTo ErrHand
     Dim bResults As Boolean
     Dim asTemp() As String
     
     asTemp = Split(oEl.nodeName, ":")
     sNsPrefix = asTemp(0)
     
     sNsAttr = "xmlns:" & sNsPrefix & " = '" & oEl.Attributes.getNamedItem("xmlns:" & sNsPrefix).nodeValue & "'"
     bResults = True
     
ErrHand:
     If Err.Number <> 0 Then
         bResults = False
     End If
     GetNsStrings = bResults
End Function


'*********************************************************************
' Public Function soapStringReverse(sSoapParams As String) As String
' Wrapper function to take SOAP params, decode them into VB types,
' and call the actual VB object to do the work.  The results are then
' encoded as a SOAP XML response.
' The function expects the SOAP Body element (and its children):
'        <SOAP:Body>
'            <m:soapStringReverse xmlns:m='SomeUri'>
'                <text>Hello, world!</text>
'            </m:soapStringReverse>
'        </SOAP:Body>
'
'
'*********************************************************************
Public Function soapStringReverse(sSoapParams As String) As String
    On Error GoTo ErrHand
    
    Dim soapDestStr As SoapDest.CStringTest
    Dim oDOM As DOMDocument
    Dim sText As String
    Dim oElNode As IXMLDOMElement
    Dim sResults As String
    Dim sResponse As String
    Dim sNsPrefix As String
    Dim sNsUriAttr As String
    Set oDOM = New DOMDocument
    
    If oDOM.loadXML(sSoapParams) Then
        Set oElNode = oDOM.getElementsByTagName("SOAP:Body").Item(0)
        Set oElNode = oElNode.firstChild
        
        If GetNsStrings(oElNode, sNsPrefix, sNsUriAttr) Then
            Set oElNode = oDOM.getElementsByTagName("text").Item(0)
            sText = oElNode.childNodes.Item(0).nodeValue
            Set soapDestStr = New CStringTest
            sResults = soapDestStr.StringReverse(sText)
            sResponse = "<soapStringReverseResponse>" & Chr(10)
            sResponse = sResponse & "<text>"
            sResponse = sResponse & sResults
            sResponse = sResponse & "</text>" & Chr(10)
            sResponse = sResponse & "</soapStringReverseResponse>"
        Else
            sResponse = sResponse & "<SOAP:Fault>" & Chr(10)
            sResponse = sResponse & "Invalid namespace." & Chr(10)
            sResponse = sResponse & "</SOAP:Fault>"
        End If
    Else
        ' DOM parse Error!
        sResponse = sResponse & "<SOAP:Fault>" & Chr(10)
        sResponse = sResponse & "Error parsing paramters: " & Chr(10)
        sResponse = sResponse & oDOM.parseError.reason & Chr(10)
        sResponse = sResponse & "</SOAP:Fault>"

    End If
     
ErrHand:
    If Err.Number <> 0 Then
        sResponse = sResponse & "<SOAP:Fault>" & Chr(10)
        sResponse = sResponse & "COM Error: " & Chr(10)
        sResponse = sResponse & Err.Description & Chr(10)
        sResponse = sResponse & "</SOAP:Fault>"
    End If

     ' Clean up
     Set soapDestStr = Nothing
     Set oDOM = Nothing
     
     soapStringReverse = sResponse
End Function

