/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class DepthBreadth
extends Applet
implements ActionListener,
MouseListener,
Runnable {
    static final int SQUARE_SIZE = 12;
    int rows;
    int columns;
    boolean[][] encountered;
    boolean[][] finished;
    Button abortButton;
    Label message;
    Choice methodChoice;
    static final int STACK = 0;
    static final int QUEUE = 1;
    static final int RANDOM = 2;
    int method;
    int startRow;
    int startCol;
    Thread runner;
    static final int NOT_RUNNING = 0;
    static final int GO = 1;
    static final int SUSPEND = 2;
    static final int NEW_START = 3;
    static final int TERMINATE = 4;
    int status = 0;
    Queue queue = null;
    Stack stack = null;
    Vector randomList = null;

    public void init() {
        this.setLayout(null);
        this.setBackground(new Color(220, 220, 255));
        this.addMouseListener(this);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.rows = (n2 - 100) / 12;
        this.columns = (n - 20) / 12;
        this.encountered = new boolean[this.rows][this.columns];
        this.finished = new boolean[this.rows][this.columns];
        Font font = new Font("Helvetica", 0, 14);
        this.message = new Label("Click any square to begin.", 1);
        this.message.setForeground(Color.blue);
        this.message.setFont(font);
        this.methodChoice = new Choice();
        this.methodChoice.add("Stack");
        this.methodChoice.add("Queue");
        this.methodChoice.add("Random");
        this.methodChoice.setBackground(Color.white);
        this.abortButton = new Button("Abort");
        this.abortButton.setEnabled(false);
        this.abortButton.addActionListener(this);
        this.abortButton.setBackground(Color.lightGray);
        Label label = new Label("Use:", 2);
        label.setForeground(Color.blue);
        label.setFont(font);
        this.add(this.message);
        this.add(label);
        this.add(this.methodChoice);
        this.add(this.abortButton);
        this.message.setBounds(15, n2 - 75, n - 30, 18);
        label.setBounds(15, n2 - 50, 50, 18);
        this.methodChoice.setBounds(75, n2 - 50, n - 150, 18);
        this.abortButton.setBounds(75, n2 - 25, n - 150, 18);
    }

    public synchronized void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.blue);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.drawRect(1, 1, n - 3, n2 - 3);
        graphics.setColor(Color.white);
        graphics.fillRect(10, 10, this.columns * 12, this.rows * 12);
        graphics.setColor(Color.black);
        int n3 = 0;
        while (n3 <= this.rows) {
            graphics.drawLine(10, 10 + n3 * 12, this.columns * 12 + 10, 10 + n3 * 12);
            ++n3;
        }
        int n4 = 0;
        while (n4 <= this.columns) {
            graphics.drawLine(10 + n4 * 12, 10, 10 + n4 * 12, this.rows * 12 + 10);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.rows) {
            int n6 = 0;
            while (n6 < this.columns) {
                if (this.finished[n5][n6]) {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(11 + n6 * 12, 11 + n5 * 12, 11, 11);
                } else if (this.encountered[n5][n6]) {
                    graphics.setColor(Color.red);
                    graphics.fillRect(11 + n6 * 12, 11 + n5 * 12, 11, 11);
                }
                ++n6;
            }
            ++n5;
        }
    }

    void putSquare(int n, int n2) {
        Graphics graphics = this.getGraphics();
        if (this.finished[n][n2]) {
            graphics.setColor(Color.gray);
        } else if (this.encountered[n][n2]) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(11 + n2 * 12, 11 + n * 12, 11, 11);
        graphics.dispose();
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n = (mouseEvent.getY() - 10) / 12;
        int n2 = (mouseEvent.getX() - 10) / 12;
        if (n < 0 || n >= this.rows || n2 < 0 || n2 >= this.columns) {
            return;
        }
        if (this.status == 0) {
            int n3 = 0;
            while (n3 < this.rows) {
                int n4 = 0;
                while (n4 < this.columns) {
                    this.encountered[n3][n4] = false;
                    this.finished[n3][n4] = false;
                    ++n4;
                }
                ++n3;
            }
            this.repaint();
            this.startRow = n;
            this.startCol = n2;
            this.status = 1;
            this.runner = new Thread(this);
            this.runner.start();
        } else {
            this.startRow = n;
            this.startCol = n2;
            this.status = 3;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doAbort();
    }

    synchronized void doAbort() {
        if (this.status != 0) {
            this.status = 4;
            this.notify();
        }
    }

    public synchronized void start() {
        if (this.status != 0) {
            this.status = 1;
            this.notify();
        }
    }

    public synchronized void stop() {
        if (this.status != 0) {
            this.status = 2;
            this.notify();
        }
    }

    public void destroy() {
        this.doAbort();
    }

    synchronized void delay() {
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {}
        while (this.status == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == 4) {
            throw new RuntimeException("Terminated");
        }
    }

    void finish(int n, int n2) {
        this.encounter(n - 1, n2);
        this.encounter(n + 1, n2);
        this.encounter(n, n2 - 1);
        this.encounter(n, n2 + 1);
        this.finished[n][n2] = true;
        this.putSquare(n, n2);
        this.delay();
    }

    Location removeItem() {
        Location location = null;
        switch (this.method) {
            case 0: {
                if (!this.stack.isEmpty()) {
                    location = this.stack.pop();
                }
                this.message.setText("Stack size is " + this.stack.getSize());
                break;
            }
            case 1: {
                if (!this.queue.isEmpty()) {
                    location = this.queue.dequeue();
                }
                this.message.setText("Queue size is " + this.queue.getSize());
                break;
            }
            case 2: {
                if (this.randomList.size() > 0) {
                    int n = (int)((double)this.randomList.size() * Math.random());
                    location = (Location)this.randomList.elementAt(n);
                    this.randomList.removeElementAt(n);
                }
                this.message.setText("List size is " + this.randomList.size());
                break;
            }
        }
        return location;
    }

    void encounter(int n, int n2) {
        if (n < 0 || n >= this.rows || n2 < 0 || n2 >= this.columns || this.encountered[n][n2]) {
            return;
        }
        Location location = new Location(n, n2);
        switch (this.method) {
            case 0: {
                this.stack.push(location);
                this.message.setText("Stack size is " + this.stack.getSize());
                break;
            }
            case 1: {
                this.queue.enqueue(location);
                this.message.setText("Queue size is " + this.queue.getSize());
                break;
            }
            case 2: {
                this.randomList.addElement(location);
                this.message.setText("List size is " + this.randomList.size());
                break;
            }
        }
        this.encountered[n][n2] = true;
        this.putSquare(n, n2);
        this.delay();
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static class Location {
        int row;
        int column;

        Location(int n, int n2) {
            this.row = n;
            this.column = n2;
        }
    }

    static class Node {
        Location loc;
        Node next;

        Node() {
        }
    }

    static class Stack {
        private Node top = null;
        private int size = 0;

        void push(Location location) {
            Node node = new Node();
            node.loc = location;
            node.next = this.top;
            this.top = node;
            ++this.size;
        }

        Location pop() {
            Location location = this.top.loc;
            this.top = this.top.next;
            --this.size;
            return location;
        }

        boolean isEmpty() {
            return this.top == null;
        }

        int getSize() {
            return this.size;
        }

        Stack() {
        }
    }

    static class Queue {
        private Node head = null;
        private Node tail = null;
        private int size;

        void enqueue(Location location) {
            Node node = new Node();
            node.loc = location;
            if (this.head == null) {
                this.head = node;
                this.tail = node;
            } else {
                this.tail.next = node;
                this.tail = node;
            }
            ++this.size;
        }

        Location dequeue() {
            Location location = this.head.loc;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            --this.size;
            return location;
        }

        boolean isEmpty() {
            return this.head == null;
        }

        int getSize() {
            return this.size;
        }

        Queue() {
        }
    }
}

