/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ShapeCanvas
extends Canvas
implements ActionListener,
ItemListener,
MouseListener,
MouseMotionListener {
    Image offScreenCanvas = null;
    Graphics offScreenGraphics;
    Vector shapes = new Vector();
    Color currentColor = Color.red;
    Shape shapeBeingDragged = null;
    int prevDragX;
    int prevDragY;

    ShapeCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void paint(Graphics g) {
        this.makeOffScreenCanvas();
        g.drawImage(this.offScreenCanvas, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void makeOffScreenCanvas() {
        if (this.offScreenCanvas == null) {
            this.offScreenCanvas = this.createImage(this.getSize().width, this.getSize().height);
            this.offScreenGraphics = this.offScreenCanvas.getGraphics();
        }
        this.offScreenGraphics.setColor(this.getBackground());
        this.offScreenGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int top = this.shapes.size();
        int i = 0;
        while (i < top) {
            Shape s = (Shape)this.shapes.elementAt(i);
            s.draw(this.offScreenGraphics);
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        Choice colorChoice = (Choice)evt.getItemSelectable();
        switch (colorChoice.getSelectedIndex()) {
            case 0: {
                this.currentColor = Color.red;
                break;
            }
            case 1: {
                this.currentColor = Color.green;
                break;
            }
            case 2: {
                this.currentColor = Color.blue;
                break;
            }
            case 3: {
                this.currentColor = Color.cyan;
                break;
            }
            case 4: {
                this.currentColor = Color.magenta;
                break;
            }
            case 5: {
                this.currentColor = Color.yellow;
                break;
            }
            case 6: {
                this.currentColor = Color.black;
                break;
            }
            case 7: {
                this.currentColor = Color.white;
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("Rect")) {
            this.addShape(new RectShape());
        } else if (command.equals("Oval")) {
            this.addShape(new OvalShape());
        } else if (command.equals("RoundRect")) {
            this.addShape(new RoundRectShape());
        }
    }

    synchronized void addShape(Shape shape) {
        shape.setColor(this.currentColor);
        shape.reshape(3, 3, 50, 30);
        this.shapes.addElement(shape);
        this.repaint();
    }

    public synchronized void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        int i = this.shapes.size() - 1;
        while (i >= 0) {
            Shape s = (Shape)this.shapes.elementAt(i);
            if (s.containsPoint(x, y)) {
                this.shapeBeingDragged = s;
                this.prevDragX = x;
                this.prevDragY = y;
                if (evt.isShiftDown()) {
                    this.shapes.removeElement(s);
                    this.shapes.addElement(s);
                    this.repaint();
                }
                return;
            }
            --i;
        }
    }

    public synchronized void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.shapeBeingDragged != null) {
            this.shapeBeingDragged.moveBy(x - this.prevDragX, y - this.prevDragY);
            this.prevDragX = x;
            this.prevDragY = y;
            this.repaint();
        }
    }

    public synchronized void mouseReleased(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.shapeBeingDragged != null) {
            this.shapeBeingDragged.moveBy(x - this.prevDragX, y - this.prevDragY);
            if (this.shapeBeingDragged.left >= this.getSize().width || this.shapeBeingDragged.top >= this.getSize().height || this.shapeBeingDragged.left + this.shapeBeingDragged.width < 0 || this.shapeBeingDragged.top + this.shapeBeingDragged.height < 0) {
                this.shapes.removeElement(this.shapeBeingDragged);
            }
            this.shapeBeingDragged = null;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }
}

