/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;

public class DialogDemoLauncher
extends Applet
implements ActionListener {
    DemoFrame demo;
    Button launchButton;

    public void init() {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.launchButton = new Button("Launch DialogDemo");
        this.add("Center", this.launchButton);
        this.launchButton.addActionListener(this);
    }

    public synchronized void actionPerformed(ActionEvent evt) {
        if (this.demo == null) {
            this.demo = new DemoFrame();
            this.launchButton.setLabel("Close DialogDemo");
            this.demo.addWindowListener(new FrameListener());
        } else {
            this.launchButton.setEnabled(false);
            this.demo.dispose();
        }
    }

    public synchronized void destroy() {
        if (this.demo != null) {
            this.demo.dispose();
            this.demo = null;
        }
    }

    class FrameListener
    extends WindowAdapter {
        public synchronized void windowClosed(WindowEvent evt) {
            DialogDemoLauncher.this.launchButton.setLabel("Launch ShapeDraw");
            DialogDemoLauncher.this.launchButton.setEnabled(true);
            DialogDemoLauncher.this.demo = null;
        }

        FrameListener() {
        }
    }

    class DemoFrame
    extends Frame
    implements ActionListener,
    Runnable {
        TextArea transcript;
        Thread runner;
        volatile boolean isOpen;

        DemoFrame() {
            super("Dialog Demo");
            ((Component)this).setBackground(Color.white);
            this.setLayout(new BorderLayout(5, 5));
            this.transcript = new TextArea("This window is the main frame for a demonstration of modal dialogs.  When you click on the \"Show Dialogs\" button, a series of several dialogs will appear.  You have to click one of the buttons in each dialog to make it go away.", 8, 45, 3);
            this.add("Center", this.transcript);
            Button bttn = new Button("Show Dialogs");
            bttn.addActionListener(this);
            Panel panel = new Panel();
            panel.add(bttn);
            this.add("South", panel);
            this.addWindowListener(new 1(this));
            this.pack();
            ((Component)this).setLocation(80, 100);
            this.setResizable(false);
            this.show();
            this.isOpen = true;
        }

        public void actionPerformed(ActionEvent evt) {
            this.runner = new Thread(this);
            this.runner.start();
        }

        public void run() {
            if (!this.isOpen) {
                return;
            }
            this.transcript.setText("Creating first dialog...\n");
            MessageDialog md1 = new MessageDialog(this, "To dismiss this dialog, you must click on one of the following buttons. Until you do, the main Dialog Demo frame will be inaccessible.", "First", "Second", "Third");
            if (!this.isOpen) {
                return;
            }
            this.transcript.append("Creading second dialog...\n");
            MessageDialog md2 = new MessageDialog((Frame)this, "In the previous dialog, you clicked on the button named " + md1.getUserAction() + ".  Would you like to see another dialog?", "Yes", "No");
            if (!this.isOpen) {
                return;
            }
            if ("Yes".equals(md2.getUserAction())) {
                this.transcript.append("Creating third dialog...\n");
                new MessageDialog((Frame)this, "The time is " + new Date().toString());
            } else {
                this.transcript.append("OK, no more dialogs\n");
            }
            if (!this.isOpen) {
                return;
            }
            this.transcript.append("Done.\n\n");
            this.transcript.append("Click the button to start again.");
        }
    }
}

