/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MessageDialog
extends Dialog
implements ActionListener {
    private String buttonClicked;

    public String getUserAction() {
        return this.buttonClicked;
    }

    public MessageDialog(Frame parent, String message) {
        this(parent, message, "OK", null, null);
    }

    public MessageDialog(Frame parent, String message, String button) {
        this(parent, message, button, null, null);
    }

    public MessageDialog(Frame parent, String message, String button1, String button2) {
        this(parent, message, button1, button2, null);
    }

    public MessageDialog(Frame parent, String message, String button1, String button2, String button3) {
        super(parent, null, true);
        ((Component)this).setBackground(Color.white);
        this.add("Center", new MessageCanvas(message));
        Panel buttonBar = new Panel();
        buttonBar.setLayout(new FlowLayout(2, 10, 10));
        Button b1 = new Button(button1 == null ? "OK" : button1);
        b1.addActionListener(this);
        buttonBar.add(b1);
        if (button2 != null) {
            Button b2 = new Button(button2);
            b2.addActionListener(this);
            buttonBar.add(b2);
        }
        if (button3 != null) {
            Button b3 = new Button(button3);
            b3.addActionListener(this);
            buttonBar.add(b3);
        }
        this.add("South", buttonBar);
        this.pack();
        ((Component)this).setLocation(parent.getLocation().x + 50, parent.getLocation().y + 30);
        this.show();
    }

    public Insets getInsets() {
        Insets ins = (Insets)super.getInsets().clone();
        ins.left += 5;
        ins.right += 5;
        ins.bottom += 12;
        ins.top += 5;
        return ins;
    }

    public void actionPerformed(ActionEvent evt) {
        this.buttonClicked = evt.getActionCommand();
        this.dispose();
    }

    private static class MessageCanvas
    extends Canvas {
        private String message;
        private Vector messageStrings;
        private int messageWidth;
        private int messageHeight;
        private Font font;
        private int lineHeight;
        private int fontAscent;

        MessageCanvas(String message) {
            this.message = message == null ? "" : message;
        }

        public Dimension getPreferredSize() {
            if (this.messageStrings == null) {
                this.makeStringList();
            }
            return new Dimension(this.messageWidth + 20, this.messageHeight + 17);
        }

        public void paint(Graphics g) {
            int x;
            int y;
            if (this.messageStrings == null) {
                this.makeStringList();
            }
            if ((y = (this.getSize().height - this.messageHeight) / 2 + this.fontAscent) < this.fontAscent) {
                y = this.fontAscent;
            }
            if ((x = (this.getSize().width - this.messageWidth) / 2) < 0) {
                x = 0;
            }
            g.setFont(this.font);
            int i = 0;
            while (i < this.messageStrings.size()) {
                g.drawString((String)this.messageStrings.elementAt(i), x, y);
                y += this.lineHeight;
                ++i;
            }
        }

        private void makeStringList() {
            this.messageStrings = new Vector();
            this.font = new Font("Dialog", 0, 12);
            FontMetrics fm = this.getFontMetrics(this.font);
            this.lineHeight = fm.getHeight() + 3;
            this.fontAscent = fm.getAscent();
            int totalWidth = fm.stringWidth(this.message);
            if (totalWidth <= 280) {
                this.messageStrings.addElement(this.message);
                this.messageWidth = 280;
                this.messageHeight = this.lineHeight;
            } else {
                this.messageWidth = totalWidth > 1800 ? Math.min(500, totalWidth / 6) : 300;
                int actualWidth = 0;
                String line = "    ";
                String word = "";
                this.message = String.valueOf(this.message) + " ";
                int i = 0;
                while (i < this.message.length()) {
                    if (this.message.charAt(i) == ' ') {
                        if (fm.stringWidth(String.valueOf(line) + word) > this.messageWidth + 8) {
                            this.messageStrings.addElement(line);
                            actualWidth = Math.max(actualWidth, fm.stringWidth(line));
                            line = "";
                        }
                        if ((line = String.valueOf(line) + word).length() > 0) {
                            line = String.valueOf(line) + ' ';
                        }
                        word = "";
                    } else {
                        word = String.valueOf(word) + this.message.charAt(i);
                    }
                    ++i;
                }
                if (line.length() > 0) {
                    this.messageStrings.addElement(line);
                    actualWidth = Math.max(actualWidth, fm.stringWidth(line));
                }
                this.messageHeight = this.lineHeight * this.messageStrings.size() - fm.getLeading();
                this.messageWidth = Math.max(280, actualWidth);
            }
        }
    }
}

