/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ShapeCanvas
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener {
    Image offScreenCanvas = null;
    Graphics offScreenGraphics;
    Vector shapes = new Vector();
    Color currentColor = Color.red;
    PopupMenu popup;
    Shape selectedShape = null;
    Shape draggedShape = null;
    int prevDragX;
    int prevDragY;

    ShapeCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popup = new PopupMenu();
        this.popup.add("Red");
        this.popup.add("Green");
        this.popup.add("Blue");
        this.popup.add("Cyan");
        this.popup.add("Magenta");
        this.popup.add("Yellow");
        this.popup.add("Black");
        this.popup.add("White");
        this.popup.addSeparator();
        this.popup.add("Big");
        this.popup.add("Medium");
        this.popup.add("Small");
        this.popup.addSeparator();
        this.popup.add("Delete");
        this.popup.add("Bring To Front");
        this.add(this.popup);
        this.popup.addActionListener(this);
    }

    public synchronized void paint(Graphics g) {
        this.makeOffScreenCanvas();
        g.drawImage(this.offScreenCanvas, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void makeOffScreenCanvas() {
        if (this.offScreenCanvas == null) {
            this.offScreenCanvas = this.createImage(this.getSize().width, this.getSize().height);
            this.offScreenGraphics = this.offScreenCanvas.getGraphics();
        }
        this.offScreenGraphics.setColor(this.getBackground());
        this.offScreenGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int top = this.shapes.size();
        int i = 0;
        while (i < top) {
            Shape s = (Shape)this.shapes.elementAt(i);
            s.draw(this.offScreenGraphics);
            ++i;
        }
    }

    synchronized void addShape(Shape shape) {
        shape.setColor(this.currentColor);
        shape.reshape(3, 3, 50, 30);
        this.shapes.addElement(shape);
        this.repaint();
    }

    Shape clickedShape(int x, int y) {
        int i = this.shapes.size() - 1;
        while (i >= 0) {
            Shape s = (Shape)this.shapes.elementAt(i);
            if (s.containsPoint(x, y)) {
                return s;
            }
            --i;
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (this.selectedShape == null) {
            return;
        }
        if (command.equals("Red")) {
            this.selectedShape.setColor(Color.red);
        } else if (command.equals("Green")) {
            this.selectedShape.setColor(Color.green);
        } else if (command.equals("Blue")) {
            this.selectedShape.setColor(Color.blue);
        } else if (command.equals("Cyan")) {
            this.selectedShape.setColor(Color.cyan);
        } else if (command.equals("Magenta")) {
            this.selectedShape.setColor(Color.magenta);
        } else if (command.equals("Yellow")) {
            this.selectedShape.setColor(Color.yellow);
        } else if (command.equals("Black")) {
            this.selectedShape.setColor(Color.black);
        } else if (command.equals("White")) {
            this.selectedShape.setColor(Color.white);
        } else if (command.equals("Big")) {
            this.selectedShape.resize(75, 45);
        } else if (command.equals("Medium")) {
            this.selectedShape.resize(50, 30);
        } else if (command.equals("Small")) {
            this.selectedShape.resize(25, 15);
        } else if (command.equals("Delete")) {
            this.shapes.removeElement(this.selectedShape);
        } else if (command.equals("Bring To Front")) {
            this.shapes.removeElement(this.selectedShape);
            this.shapes.addElement(this.selectedShape);
        }
        this.repaint();
    }

    public synchronized void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (evt.isPopupTrigger()) {
            this.selectedShape = this.clickedShape(x, y);
            if (this.selectedShape != null) {
                this.popup.show(this, x, y);
            }
        } else {
            this.draggedShape = this.clickedShape(x, y);
            if (this.draggedShape != null) {
                this.prevDragX = x;
                this.prevDragY = y;
                if (evt.isShiftDown()) {
                    this.shapes.removeElement(this.draggedShape);
                    this.shapes.addElement(this.draggedShape);
                    this.repaint();
                }
            }
        }
    }

    public synchronized void mouseDragged(MouseEvent evt) {
        if (this.draggedShape != null) {
            int x = evt.getX();
            int y = evt.getY();
            this.draggedShape.moveBy(x - this.prevDragX, y - this.prevDragY);
            this.prevDragX = x;
            this.prevDragY = y;
            this.repaint();
        }
    }

    public synchronized void mouseReleased(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.draggedShape != null) {
            this.draggedShape.moveBy(x - this.prevDragX, y - this.prevDragY);
            if (this.draggedShape.left >= this.getSize().width || this.draggedShape.top >= this.getSize().height || this.draggedShape.left + this.draggedShape.width < 0 || this.draggedShape.top + this.draggedShape.height < 0) {
                this.shapes.removeElement(this.draggedShape);
            }
            this.draggedShape = null;
            this.repaint();
        } else if (evt.isPopupTrigger()) {
            this.selectedShape = this.clickedShape(x, y);
            if (this.selectedShape != null) {
                this.popup.show(this, x, y);
            }
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }
}

