<?php

$version = "3.5.3";

/*****************************************************************************\
 * myExplorer                                                                *
 * http://www.bmitt.com/files/webauthoring/php/                              *
 * ------------------------------------------------------------------------- *
 * written by      : Bernhard Mitterer @: admin@bmitt.com                    *
 * last modified   : 2016-01-10                                              *
 *****************************************************************************

 CHANGES:

    2.2
        - support for special chars in path and filenames

    2.3
        - fixed problem with special chars (htmlentities)
        - validates as XHTML 1.0 Strict
        - validates as CSS 2.0

    2.4
        - added possibility to print statistics
          (filecount, dircount, total filesize )

    2.5
        - different icons for filetypes
        - AAA Bobby Approved

    2.6
        - fixed problem with urlcoding (special chars again)
        - added possibility to handle files depending on their extension

    2.7
        - redesign of code to support userdefined sorting
        - significant performance enhancements
        - ability to benchmark the script

    3.1
        - possibility to enter path directly in addressbar
        - icons updated
        - added toolbar
        - redesign of code to support multiple views
          (added icon view)

    3.2
        - changed descending sort to print files before folders
        - changed look to Windows Explorer Style
        - sorting considers german "Umlaute"
        - fixed problem with sorting by filetypee (thanks to hitz)

    3.3
        - replaced deprecated functions to be PHP >=5.3 compliant
        - fixed some minor issues

    3.4
        - fixed XSS Vulnerability in Sorting Parameters

    3.5
        - added Search Bar
        - added flag to deny/allow directory listing of hidden folders
        - requires PHP Version >= 4.2
        - validates as XHTML 1.0 Strict and HTML 5
        - validates as CSS 2.1


 ADDONS

    + myExplorer Redirector
        just an index-file which can be copied in each listed directory
        to redirect the user who tries to access the folders directly to
        the corresponding folder in myExplorer

    + myExplorer Download
        script to finetune the behavior when link to file is clicked
        (show inline, show download dialog, count downloads,...)


 USAGE:

    1. adapt the Configuration-Section to your needs
    2. thats it!


 CONFIGURATION:

     bool $cfg['su'] (= false)
        su stands for SuperUser and enables
           - relative paths upwards ('../') and
           - going above $cfg['rootDir']

     bool $cfg['allowHidden'] (= false)
        this attribute specifies if direct access to hidden
        folders is allowed by entering the path into the 
        address bar

     string $cfg['rootDir'] (= '')
        use this attribute to specify the root-directory
        of myExplorer relative to this file (the one you
        are reading). it is not possible to view
        directories above $cfg['rootDir'].
        eg. $cfg['rootDir'] = 'files';

     string $cfg['indexDir'] (= '')
        use this attribute to specify the directory
        (relativ to $cfg['rootDir']) which myExplorer should
        show when opening this page.
        if you want myExplorer to start in "files/mp3"
        and $cfg['rootDir'] is set to "files" you should set
        $cfg['indexDir'] to 'mp3'.
        if you want myExplorer to start in $cfg['rootDir']
        you do not have to set this attribute

     string $cfg['imgDir'] (= 'img')
        this attribute specifies the path to the icon-files
        ($cfg['imgDir'] is prepended to the filenames specified in
        $cfg['filetypes'], $cfg['picUp'] and $cfg['picFolder'])

     string $cfg['referer'] (= $_SERVER['PHP_SELF'])
        this attibute specifies the url to this page.
        you only will have to set this attribute if
        you have already query-strings in this url
        eg. $cfg['referer'] = 'index.php?pageID=234'

     string $cfg['defView'] (= 'detail')
        this attribute specifies the default view.
        possible values are 'icon' and 'detail'

     bool $cfg['showToolBar'] (= true)
        this attribute specifies if the toolbar
        should be shown (above the table)

     bool $cfg['showAddrBar'] (= true)
        this attribute specifies if the current directory
        should be shown (above the table)

     bool $cfg['disableAddrBar'] (= false)
        this attribute specifies whether the Address Bar is
        writable (false) or not (true)

     bool $cfg['showSearchBar'] (= true)
        this attribute specifies if search bar
        should be shown (next to address bar)
        Only matching files in the current directory are displayed
        Search is not case sensitive and matches anywhere in the 
        file/folder name. Think of it more as a display filter...

     bool $cfg['showStat'] (= true)
        this attribute specifies if filecount, dircount
        and total filesize should be shown (at the bottom
        of the table)

     bool $cfg['benchmark'] (= false)
        this attribute specifies if the processing time of
        the script is measured an printed at the bottom

     int $cfg['maxStrlen'] (= 20)
        this attribute applies only to icon view and specifies
        the max. number of shown filename characters.
        if filename is longer, the rest of the charakters is
        replaced by '...'

     string $cfg['dateFormat'] (= 'Y-m-d H:i')
        this attribute specifies the format of the
        'Last Modified'-Timestamp. For possible values look at
        'http://www.php.net/date'  (Table 1)

     string $cfg['hName']    (= 'Name')
     string $cfg['hSize']    (= 'Size')
     string $cfg['hType']    (= 'Type')
     string $cfg['hLastMod'] (= 'Last Modified')
        these attributes specify the column-headers
        of the table

     bool $cfg['showSize']    (= true)
     bool $cfg['showType']    (= false)
     bool $cfg['showLastMod'] (= true)
        these attributes specify which columns to show

     string $cfg['showFiles']   (= '*')
     string $cfg['hideFiles']   (= '.*,index*,*.php')
     string $cfg['showFolders'] (= '*')
     string $cfg['hideFolders'] (= '.*,img')
        specify which files/folders should be shown
        default is 'implicit show'.
        * (asterisk) is the only wildcard allowed and
                     stands for "at least one charakter"

     bool $cfg['fastSort'] (= false)
        true:  the directory content is ALWAYS sorted
               ascending by filename. This option allows
               faster sorting for large directory listings
        false: sorts depending on the choosen column

     string $cfg['sortC'] (= 'N')
        defines default sort-column
          N: names of files/folders
          S: size of files/folders
          M: last modified of files/folders

     string $cfg['sortO'] (= 'A')
        defines default sort-order
          A: ascending
          D: descending

     bool $cfg['showSortPic'] (= true)
        true:  image showing sort direction is shown
               next to the column name
        false: no sort direction is shown

     string $cfg['sortPicAsc']    (= 'sortasc.gif')
     string $cfg['sortPicDesc']   (= 'sortdesc.gif')
        define image names for sort direction

     string $cfg['picUp']     (= 'folderup.gif')
     string $cfg['picFolder'] (= 'folder.gif')
        these attributes specify the names of the folder-icons

     bool $cfg['picFile']   (= 'true')
        true:  enables different icons for different filetypes
               icons are specified in $picIcons
        false: shows the default icon ( $cfg['filetypes']['.*'] )

     string $cfg['picHome']        (= 'home.gif')
     string $cfg['picUpEnabled']   (= 'folderup.gif')
     string $cfg['picUpDisabled']  (= 'folderup_disabled.gif')
     string $cfg['picReload']      (= 'reload.gif')
     string $cfg['picDetailView']  (= 'detailview.gif')
     string $cfg['picIconView']    (= 'iconview.gif')
     string $cfg['picSep']         (= 'separator.gif')
        these attributes specify the names of the toolbar-icons

     int $cfg['xAction'] (= false)
     string $cfg['xFilename'] (= 'dofile.php')
        if this attrib $cfg['xAction'] = false you can ignore the
        attrib $cfg['xFilename']. if you want to do something
        special when clicking on a file, set $cfg['xAction'] = true
        the script specified in $cfg['xFilename'] gets the
        path and filename of the selected file in the
        variable $_GET['file']

     array $cfg['filetypes']
        each line has the following format:
        '<extension>,<tab><iconfile>,<tab><description>,<tab><xAction>,<tab><xFilename>',

        <extension>   is the filename extension including the point
        <iconfile>    is the name of the icon-file related with <extension>
        <type>        filetype description shown when $cfg['showType'] = true
        <xAction>     if true the filename is given by Method GET to the
                      php-script specified in ...
        <xFilename>.

        - each line has to be bordered by single quotes (')
        - each line has to be terminated by a comma (,)
        - a comma has to separate the fields

        Defaults:
            description, xaction and xfilename are OPTIONAL
            if empty the following values are assumed
            <description> = <ext> File  (eg. 'TXT File)'
            <xaction>     = $cfg['xAction']
            <xfilename>   = $cfg['xFilename']

     Hint: To set the global width of the explorer adopt the following line
        in the CSS Section ( you can use relative (%) or absolute (px) values )

        Line 391:   #explorer { width:100% }

\*****************************************************************************/


/*****************************************************************************\
 * Configuration (adapt this section to your needs)                          *
\*****************************************************************************/

# priviledges
$cfg['su']             = false;
$cfg['allowHidden']    = false;
# paths
$cfg['rootDir']        = '';
$cfg['indexDir']       = '';
$cfg['imgDir']         = 'img';
$cfg['referer']        = $_SERVER['PHP_SELF'];
# appearance
$cfg['defView']        = 'detail';    // detail or icon
$cfg['showToolBar']    = true;
$cfg['showAddrBar']    = true;
$cfg['disableAddrBar'] = false;
$cfg['showSearchBar']  = true;
$cfg['showStatBar']    = true;
$cfg['benchmark']      = false;
$cfg['maxStrlen']      = 20;
$cfg['dateFormat']     = 'Y-m-d G:i';
# labels for tableheader (detail view)
$cfg['hName']          = 'Name';
$cfg['hSize']          = 'Size';
$cfg['hType']          = 'Type';
$cfg['hLastMod']       = 'Last Modified';
# show attributes (detail view)
$cfg['showName']       = true;    // makes no sense to hide filename
$cfg['showSize']       = true;
$cfg['showType']       = false;
$cfg['showLastMod']    = true;
# filter
$cfg['showFiles']      = '*';
$cfg['hideFiles']      = '.*,index*,*.php';
$cfg['showFolders']    = '*';
$cfg['hideFolders']    = '.*,img,css';
# sort options
$cfg['fastSort']       = false;
$cfg['sortC']          = 'N';
$cfg['sortO']          = 'A';
$cfg['showSortPic']    = true;
$cfg['sortPicAsc']     = 'sortasc.gif';
$cfg['sortPicDesc']    = 'sortdesc.gif';
# pic-names
$cfg['picUp']          = 'folderup.gif';
$cfg['picFolder']      = 'folder.gif';
$cfg['picFile']        = true;
# toolbar
$cfg['picHome']        = 'home.gif';
$cfg['picUpEnabled']   = 'folderup.gif';
$cfg['picUpDisabled']  = 'folderup_disabled.gif';
$cfg['picReload']      = 'reload.gif';
$cfg['picDetailView']  = 'detailview.gif';
$cfg['picIconView']    = 'iconview.gif';
$cfg['picSep']         = 'separator.gif';
# mode
$cfg['xAction']        = false;
$cfg['xFilename']      = 'download.php';
# filetypes
$cfg['filetypes']      = array(
#   Extension   Icon (Pic)      Description (Type)      xAction     xFilename
#   ----------------------------------------------------------------------------------
#   '.ext',     extfile.gif,    EXT-File,               1,          download.php',      <-- EXAMPLE
    '.*,        file.gif,       Unknown,                 ,                      ',
    '.bat,      batfile.gif,    Batchfile,               ,                      ',
    '.bmp,      bmpfile.gif,    Bitmap,                  ,                      ',
    '.bz2,      rarfile.gif,    BZ2 Archive,             ,                      ',
    '.c,        cfile.gif,      C Sourcefile,            ,                      ',
    '.chm,      chmfile.gif,    Helpfile,                ,                      ',
    '.cpp,      cppfile.gif,    C++ Sourcefile,          ,                      ',
    '.css,      cssfile.gif,    Cascading Style Sheet,   ,                      ',
    '.doc,      docfile.gif,    Word Document,           ,                      ',
    '.eml,      emlfile.gif,    E-Mail File,             ,                      ',
    '.exe,      exefile.gif,    Executable,              ,                      ',
    '.gif,      giffile.gif,    GIF Image,               ,                      ',
    '.gz,       zipfile.gif,    GZ Archive,              ,                      ',
    '.h,        hfile.gif,      C/C++ Headerfile,        ,                      ',
    '.hlp,      hlpfile.gif,    Helpfile,                ,                      ',
    '.htm,      htmfile.gif,    HTML Document,           ,                      ',
    '.html,     htmfile.gif,    HTML Document,           ,                      ',
    '.jpg,      jpgfile.gif,    JPG Image,               ,                      ',
    '.js,       jsfile.gif,     JavaScript File,         ,                      ',
#    '.m,        mfile.gif,      Matlab File,             ,                      ',
    '.mp3,      mp3file.gif,    MP3 Audiofile,           ,                      ',
    '.mpg,      mp3file.gif,    MPG Videofile,           ,                      ',
    '.pdf,      pdffile.gif,    PDF Document,            ,                      ',
    '.png,      giffile.gif,    PNG Image,               ,                      ',
    '.pps,      pptfile.gif,    PowerPoint Show,         ,                      ',
    '.ppt,      pptfile.gif,    PowerPoint File,         ,                      ',
    '.rar,      rarfile.gif,    RAR Archive,             ,                      ',
#    '.rtf,      rtffile.gif,    Rich Text Format,        ,                      ',
#    '.swf,      swffile.gif,    Flash Object,            ,                      ',
    '.txt,      txtfile.gif,    Textfile,                ,                      ',
    '.wmv,      mp3file.gif,    Windows Media File,      ,                      ',
    '.xls,      xlsfile.gif,    Excel Chart,             ,                      ',
    '.zip,      zipfile.gif,    ZIP Archive,             ,                      ',
);

?>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="author" content="Bernhard Mitterer" />
  <meta name='original-source' content='http://www.bmitt.com/files/webauthoring/php/'>

  <title>BMITT.com - myExplorer</title>

  <style type="text/css">
  <!--

    /*************************************************************************\
     * Global Styles                                                         *
    \*************************************************************************/

	#explorer { width:100% }
	
    #explorer * { font:11px Tahoma,sans-serif; margin:0; padding:0; border-width:0; }
    #explorer table { width:100%; }

    #explorer a { color:black; text-decoration:none; }
    #explorer a span { padding:2px; }
    #explorer a:hover { text-decoration:none; }
    #explorer a:hover * { color:#009; text-decoration:underline; }
    #explorer a:focus span { background-color:#009; color:white; }
    #explorer a:active span { background-color:#009; color:white; }


    /*************************************************************************\
     * Styles for Detail View                                                *
    \*************************************************************************/

    #detailview { width:100%; border-spacing:0; }

    #detailview #sortasc  a { background-image:url('img/sortasc.gif'); background-repeat:no-repeat; background-position:right;padding-right:12px; }
    #detailview #sortdesc a { background-image:url('img/sortdesc.gif'); background-repeat:no-repeat; background-position:right;padding-right:12px; }

    #detailview th { background-color:#eed; padding:2px 5px 2px 9px; text-align:left; border-bottom:1px solid #ccb; }
    #detailview th { background-image:url('img/bg_header_sep.gif'); background-repeat:no-repeat; background-position:right;}

    #detailview td { padding:1px 5px; }

    #detailview *.name    { ; }
    #detailview *.size    { width:120px; text-align:right; }
    #detailview *.type    { width:120px; }
    #detailview *.lastmod { width:160px; }

    #detailview td.name img { margin:0 2px; vertical-align:text-bottom; width:16px; height:16px; }


    /*************************************************************************\
     * Styles for Icon View                                                  *
    \*************************************************************************/

    #iconview { width:100%; border-spacing:0; }

    #iconview img { margin:3px; }

    #iconview div.folder { float:left; width:100px; height:65px; text-align:center; margin:7px; }
    #iconview div.file   { float:left; width:100px; height:65px; text-align:center; margin:7px; }


    /*************************************************************************\
     * Styles for Framework (Menubars, Statistik, Benchmark)                 *
    \*************************************************************************/

    #explorer { border:1px outset #777; }

    #toolbar { padding:0 3px; border-bottom:1px solid #ccb; border-top:1px solid white; background-color:#eed; border-spacing:0; }
    #toolbar td.iconbar { width:190px; }
    #toolbar td.addrbar { padding-right:3px; }

    #iconbar img { padding:2px; vertical-align:middle; border:1px solid #eed; width:24px; height:24px; }
    #iconbar img.separator { width:1px; height:27px; }
    #iconbar img.active { border:1px inset #ace; background-color:#ffe; }

    #iconbar a:hover img { border:1px outset #ace;  background-color:#ffe; }
    #iconbar a:focus img { border:1px outset #ace;  background-color:#ffe; }
    #iconbar a:active img { border:1px inset #ace;  background-color:#ffe; }

    #addrbar { width:100%; }
    #search_td { width:150px; padding-left:5px; }

    #addr { padding:3px; border:1px solid #79b; background-color:white; color:black; }
    #addr { background-image:url('img/bg_addrbar.gif'); background-repeat:no-repeat; background-position:left; }
    #addr input { width:90%; margin-left:25px; }
    
    #search { padding:3px; border:1px solid #79b; background-color:white; color:black; width:150px; }
    #search { background-image:url('img/bg_searchbar.gif'); background-repeat:no-repeat; background-position:right; }
    #search input { width:90%; margin-right:25px; }

    #errmsg { margin:1px; border:1px solid #b00; background-color:#ffa; color:#b00; height:18px; }
    #errmsg span { float:left; width:85%; padding:2px 5px; }
    #errmsg img { float:right; width:14px; height:14px; padding:2px; }

    #content { border:1px solid #79b; padding:1px; }

    #statusbar { padding:2px 5px; clear:both; text-align:right; border-top:1px solid #998; border-bottom:1px solid #ccb; background-color:#eed; }

    #benchmark { font:11px Tahoma,sans-serif; padding:5px; }

  -->
  </style>
</head>
<body>

<?php

// Check PHP Version for minimum Requirement
if( version_compare(PHP_VERSION, '4.2', '<') ) {
    echo '<div id="explorer">'."\n\n";
    echo '<div id="errmsg" style="padding:5px 5px 0px 5px; font-weight:bold;">PHP Version 4.2.0 or later required! Current Version is '.PHP_VERSION."</div>\n";
    echo '</div>'."\n\n";
    echo '</body>'."\n";
    echo '<html>'."\n";
    exit(0);
}

/*****************************************************************************\
 * prepare variables                                                         *
\*****************************************************************************/

// Report all errors except E_NOTICE and E_WARNING
#error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);

// Benchmark START
if( $cfg['benchmark'] )
    $g_time_start = getmicrotime();

// Check Path Formats ---------------------------------------------------------
$cfg['rootDir']    = formatDir($cfg['rootDir'],true,true);
$cfg['indexDir']   = formatDir($cfg['indexDir']);
$cfg['referer']    = addLinker($cfg['referer']);
$cfg['imgDir']     = formatDir($cfg['imgDir'],true);
// ----------------------------------------------------------------------------

// Create Filetype Array ------------------------------------------------------
$cfg['filetypes'] = parseFiletypeConfig( $cfg['filetypes'] );
// ----------------------------------------------------------------------------

// Handle (given) Directory ---------------------------------------------------
# initialize
$g_dir = $cfg['indexDir'];

# make local variable from HTTP_GET_VARS
if(isset($_GET['dir']))
    $g_dir = formatDir(rawParam('dir'));

# check given directory if it is valid/allowed
$g_err = NULL;
if( !isValidDir($cfg['rootDir'].$g_dir) ) {
    $g_err = array(
        "errmsg"  => "Invalid Directory",
        "errinfo" => $g_dir
    );
    $g_dir = $cfg['indexDir'];
}

# real path ($g_dir is just fake [relative to $cfg['rootDir']] for display)
$g_ldir = formatDir($cfg['rootDir'].$g_dir,true);
$g_dirsize = 0;

// ----------------------------------------------------------------------------

// Handle (given) View --------------------------------------------------------
$g_view = $cfg['defView'];

if(isset($_GET['view']) && in_array($_GET['view'],array('detail','icon'))) {
    $g_view = $_GET['view'];
}
// ----------------------------------------------------------------------------

// Get Directory Content ------------------------------------------------------
$g_files = array();
$g_folders = array();

# unfiltered directory content (fills $g_files and $g_folders)
getDirContent( $g_ldir );

# filter arrays (new version)
$g_r_showFiles = makeRegex( $cfg['showFiles'] );
$g_r_hideFiles = makeRegex( $cfg['hideFiles'] );
$g_r_showFolders = makeRegex( $cfg['showFolders'] );
$g_r_hideFolders = makeRegex( '.,..,'.$cfg['hideFolders'] );
$g_files = preg_grep( "/$g_r_showFiles/i", $g_files );
$g_files = preg_grep( "/$g_r_hideFiles/i", $g_files, PREG_GREP_INVERT );
$g_folders = preg_grep( "/$g_r_showFolders/i", $g_folders );
$g_folders = preg_grep( "/$g_r_hideFolders/i", $g_folders, PREG_GREP_INVERT );

# respect search string
if( $_GET['search'] ) {
    $g_r_search = makeRegex( rawParam('search'), true );
    $g_files = preg_grep( "/$g_r_search/i", $g_files );
    $g_folders = preg_grep( "/$g_r_search/i", $g_folders );
}

# sort only by name
if( $cfg['fastSort'] ) {
    natcasesort( $g_files );
    natcasesort( $g_folders );
}

# get file properties
$g_files   = getFileAttr( $g_files );
$g_folders = getFolderAttr( $g_folders );
// ----------------------------------------------------------------------------


// Sort Directory Content -----------------------------------------------------
# parse sort criteria
if    ( $cfg['fastSort'] )         { $g_C = 'N'; $g_O = 'A';       }
#elseif( isset($_GET['D']) ) { $g_C = 'D'; $g_O = $_GET[$g_C]; }
elseif( isset($_GET['M']) ) { $g_C = 'M'; $g_O = getSortOrder($_GET[$g_C]); }
elseif( isset($_GET['S']) ) { $g_C = 'S'; $g_O = getSortOrder($_GET[$g_C]); }
elseif( isset($_GET['N']) ) { $g_C = 'N'; $g_O = getSortOrder($_GET[$g_C]); }
else                        { $g_C = $cfg['sortC']; $g_O = $cfg['sortO']; }

# sort
if( !$cfg['fastSort'] ) {
    usort( $g_files, 'cmp' );
    usort( $g_folders, 'cmp' );
}

# get new order of columns (array)
$g_neworder = newOrder( $g_C, $g_O );

# get sort pic
$g_sortpic = array('N'=>'','S'=>'','M'=>'','D'=>'');
$g_sort = array('N'=>'','S'=>'','M'=>'','D'=>'');
if( $cfg['showSortPic'] ) {
    $g_img = ($g_O=='D') ? $cfg['sortPicAsc'] : $cfg['sortPicDesc'];
    $g_sortpic[$g_C] = '<img src="'.$cfg['imgDir'].$g_img.'" alt="" />';
    $g_sort[$g_C] = ' id="'.(($g_O=='D') ? 'sortasc' : 'sortdesc').'"';
}
// ----------------------------------------------------------------------------

// Prepare Path Template ------------------------------------------------------
$g_tpl_target = $cfg['referer'].$g_C.'='.$g_O.'&amp;view='.$g_view.'&amp;dir=';
// ----------------------------------------------------------------------------

// handle up-button -----------------------------------------------------------
$g_up = getUpTarget($g_dir);
$g_uptarget = NULL;
if( $cfg['su'] || ($g_dir && ($g_up!==false)) ) {
    $g_uptarget = $g_tpl_target.rawurlencode($g_up);
}
// ----------------------------------------------------------------------------


/*****************************************************************************\
 * prepare templates                                                         *
\*****************************************************************************/

// Iconbar --------------------------------------------------------------------
$tb_imgdir    = $cfg['imgDir'].'24/';
$tb_separator = '<img src="'.$tb_imgdir.$cfg['picSep'].'" alt="|" class="separator" />';

$g_iconbar = ''.
    '<div id="iconbar">'."\n".
    '  <a href="'.$g_tpl_target.rawurlencode($cfg['indexDir']).'" title="Home"><img src="'.$tb_imgdir.$cfg['picHome'].'" alt="Home" /></a>'."\n".
    '  <a href="'.$g_tpl_target.rawurlencode($g_dir).'" title="Reload"><img src="'.$tb_imgdir.$cfg['picReload'].'" alt="Reload" /></a>'."\n".
  (($g_uptarget) ? (
    '  <a href="'.$g_uptarget.'" title="Up"><img src="'.$tb_imgdir.$cfg['picUpEnabled'].'" alt="Up" /></a>'."\n"
  ):(
    '  <img src="'.$tb_imgdir.$cfg['picUpDisabled'].'" alt="Up" />'."\n"
  )).
    '  '.$tb_separator."\n".
    '  <a href="'.$cfg['referer'].$g_C.'='.$g_O.'&amp;view=detail&amp;dir='.rawurlencode($g_dir).'" title="Detail View"><img src="'.$tb_imgdir.$cfg['picDetailView'].'"'.(($g_view=='detail') ? ' class="active"' : '').' alt="Detail View" /></a>'."\n".
    '  <a href="'.$cfg['referer'].$g_C.'='.$g_O.'&amp;view=icon&amp;dir='.rawurlencode($g_dir).'" title="Icon View"><img src="'.$tb_imgdir.$cfg['picIconView'].'"'.(($g_view=='icon') ? ' class="active"' : '').' alt="Icon View" /></a>'."\n".
    '  '.$tb_separator."\n".
    '</div>'."\n";
// ----------------------------------------------------------------------------

// Addressbar -----------------------------------------------------------------
$imgdir = $cfg['imgDir'].'16/';

$g_searchbar = ''.
    '</td><td id="search_td">'."\n".
    '  <div id="search">'."\n".
    '    <input name="search" type="text" tabindex="2" value="'.htmlentities(rawParam('search')).'" />'."\n".
    '  <input type="submit" value="&gt;" tabindex="3" style="position:absolute; border:none; overflow:hidden; height:0; width:0; padding:0; margin:0;" />'."\n".
    '  </div>'."\n";

$g_addrbar = ''.
    '<form method="get" action="'.$cfg['referer'].'">'."\n".
    '<table id="addrbar"><tr><td id="addr_td">'."\n".
    '  <div id="addr">'."\n".
    '    <input type="hidden" name="'.$g_C.'" value="'.$g_O.'" />'."\n".
    '    <input type="hidden" name="view" value="'.$g_view.'" />'."\n".
    '    <input name="dir" type="text" tabindex="1" value="/'.htmlentities($g_dir).'"'.(($cfg['disableAddrBar'] && !$cfg['su'])?' readonly="readonly"':'').' />'."\n".
    '  </div>'."\n".
    ( $cfg['showSearchBar'] ? $g_searchbar : '' ).
    '</td></tr></table>'."\n".
    '</form>'."\n";
// ----------------------------------------------------------------------------

// Toolbar --------------------------------------------------------------------
$g_toolbar = ''.
    '<table id="toolbar">'."\n".
    '  <tr>'."\n".
    '    <td class="iconbar">'."\n\n".
    $g_iconbar."\n".
    '    </td>'."\n".
    '    <td class="addrbar">'."\n\n".
    $g_addrbar."\n".
    '    </td>'."\n".
    '  </tr>'."\n".
    '</table>'."\n";
// ----------------------------------------------------------------------------

// Error Msg ------------------------------------------------------------------
$g_errmsg = ''.
    '<div id="errmsg">'.
      '<span>'.$g_err['errmsg'].' <em>"/'.htmlentities($g_err['errinfo']).'"</em></span>'.
      '<a href="'.$g_tpl_target.rawurlencode($g_dir).'" title=""><img src="'.$cfg['imgDir'].'close.gif" alt="x" /></a>'.
    '</div>';
// ----------------------------------------------------------------------------

// Detail View ----------------------------------------------------------------
$th_tpl_target = $cfg['referer'].'view='.$g_view.'&amp;dir='.rawurlencode($g_dir).'&amp;';
$col_count = ($cfg['showName']+$cfg['showSize']+$cfg['showType']+$cfg['showLastMod']);
$imgdir = $cfg['imgDir'].'16/';

$tpl['detail']['header'] = "\n".
    '<table id="detailview">'."\n".
    '  <tr>'."\n".
  ($cfg['showName']    ? '    <th class="name"'.$g_sort['N'].'><a href="'.$th_tpl_target.'N='.$g_neworder['N'].'">'.$cfg['hName'].'</a></th>'."\n" : '').
  ($cfg['showSize']    ? '    <th class="size"'.$g_sort['S'].'><a href="'.$th_tpl_target.'S='.$g_neworder['S'].'">'.$cfg['hSize'].'</a></th>'."\n" : '').
  ($cfg['showLastMod'] ? '    <th class="lastmod"'.$g_sort['M'].'><a href="'.$th_tpl_target.'M='.$g_neworder['M'].'">'.$cfg['hLastMod'].'</a></th>'."\n" : '').
  ($cfg['showType']    ? '    <th class="type"'.$g_sort['D'].'><a href="'.$th_tpl_target.'D='.$g_neworder['D'].'">'.$cfg['hType'].'</a></th>'."\n" : '').
    '  </tr>'."\n";

$tpl['detail']['up'] = ''.
    '  <tr class="folder">'."\n".
  ($cfg['showName']    ? '    <td class="name"><a href="'.$g_uptarget.'" title="'.$g_uptarget.'"><img src="'.$imgdir.$cfg['picUp'].'" alt="up" /><span>..</span></a></td>'."\n" : '').
  ($cfg['showSize']    ? '    <td class="size">&nbsp;</td>'."\n" : '').
  ($cfg['showLastMod'] ? '    <td class="lastmod">&nbsp;</td>'."\n" : '').
  ($cfg['showType']    ? '    <td class="type">Up</td>'."\n" : '').
    '  </tr>'."\n";

$tpl['detail']['folder'] = ''.
    '  <tr class="folder">'."\n".
  ($cfg['showName']    ? '    <td class="name"><a href="{HREF}" title=""><img src="'.$imgdir.$cfg['picFolder'].'" alt="dir" /><span>{NAME}</span></a></td>'."\n" : '').
  ($cfg['showSize']    ? '    <td class="size">&nbsp;</td>'."\n" : '').
  ($cfg['showLastMod'] ? '    <td class="lastmod">{LASTMOD}</td>'."\n" : '').
  ($cfg['showType']    ? '    <td class="type">{TYPE}</td>'."\n" : '').
    '  </tr>'."\n";

$tpl['detail']['file'] = ''.
    '  <tr class="file">'."\n".
  ($cfg['showName']    ? '    <td class="name"><a href="{HREF}" title="{TOOLTIP}"><img src="'.$imgdir.'{IMG}" alt="file" /><span>{NAME}</span></a></td>'."\n" : '').
  ($cfg['showSize']    ? '    <td class="size">{SIZE}</td>'."\n" : '').
  ($cfg['showLastMod'] ? '    <td class="lastmod">{LASTMOD}</td>'."\n" : '').
  ($cfg['showType']    ? '    <td class="type">{TYPE}</td>'."\n" : '').
    '  </tr>'."\n";

$tpl['detail']['footer'] = ''.
    '  <tr class="vspace"><td colspan="'.$col_count.'">&nbsp;</td></tr>'."\n".
    '</table>'."\n";
// ----------------------------------------------------------------------------

// Icon View ------------------------------------------------------------------
$imgdir = $cfg['imgDir'].'32/';

$tpl['icon']['header'] = "\n".
    '<table id="iconview">'."\n".
    '  <tr>'."\n".
    '    <td>'."\n";

$tpl['icon']['up'] = "\n".
    '<div class="folder">'."\n".
    '  <a href="'.$g_uptarget.'" title="'.$g_uptarget.'">'."\n".
    '    <img src="'.$imgdir.$cfg['picUp'].'" alt="up" /><br />'."\n".
    '    <span class="name">..</span>'."\n".
    '  </a>'."\n".
    '</div>'."\n";

$tpl['icon']['folder'] = "\n".
    '<div class="folder">'."\n".
    '  <a href="{HREF}" title="">'."\n".
    '    <img src="'.$imgdir.$cfg['picFolder'].'" alt="dir" title="" /><br />'."\n".
    '    <span class="name">{SHORT_NAME}</span>'."\n".
    '  </a>'."\n".
    '</div>'."\n";

$tpl['icon']['file'] = "\n".
    '<div class="file">'."\n".
    '  <a href="{HREF}" title="{TOOLTIP}">'."\n".
    '    <img src="'.$imgdir.'{IMG}" alt="file" title="{TOOLTIP}" /><br />'."\n".
    '    <span class="name">{SHORT_NAME}</span>'."\n".
    '  </a>'."\n".
    '</div>'."\n";

$tpl['icon']['footer'] = "\n".
    '    </td>'."\n".
    '  </tr>'."\n".
    '  <tr class="vspace"><td>&nbsp;</td></tr>'."\n".
    '</table>'."\n";
// ----------------------------------------------------------------------------


/*****************************************************************************\
 * Output                                                                    *
\*****************************************************************************/

printExplorer();

?>

</body>
</html>

<?php

/*****************************************************************************\
 * Functions                                                                 *
\*****************************************************************************/

// ----------------------------------------------------------------------------
// printExplorer() Main Output Function
function printExplorer()
{
    global $cfg, $tpl;
    global $g_toolbar, $g_addrbar, $g_errmsg;
    global $g_folders, $g_files, $g_dirsize;
    global $g_dir, $g_ldir, $g_err;
    global $g_tpl_target, $g_uptarget;
    global $g_view, $g_O, $g_time_start;

    # Frame
    echo '<div id="explorer">'."\n\n";

    # Toolbar
    if($cfg['showToolBar']) {
        echo $g_toolbar."\n";
    }
    # Addressbar
    if($cfg['showAddrBar'] && !$cfg['showToolBar']) {
        echo $g_addrbar."\n";
    }
    # Error Message
    if($g_err) {
        echo $g_errmsg."\n";
    }

    // ----------------------------------------------------------------------------
    // print Content
    echo '<div id="content">'."\n";

    # Header
    echo $tpl[$g_view]['header'];

    # UP-Button
    if( !$cfg['showToolBar'] && $g_uptarget ) {
        echo $tpl[$g_view]['up'];
    }

    # directory listing
    if( $g_O == 'A' ) {
        echo FolderListing().FileListing();
    } else {
        echo FileListing().FolderListing();
    }
    # Footer
    echo $tpl[$g_view]['footer'];

    echo "\n".'</div>'."\n\n";
    // ----------------------------------------------------------------------------

    # Statusbar
    if($cfg['showStatBar']) {
        echo "\n".'<div id="statusbar"><span id="stats">'.getStatMsg().'</span></div>'."\n";
    }
    # Frame END
    echo "\n".'</div>'."\n\n";

    # Benchmark
    if( $cfg['benchmark'] ) {
        printf("\n".'<div id="benchmark">processing time: %.3f seconds</div>'."\n", getmicrotime()-$g_time_start);
    }
    return 0;
}

// ----------------------------------------------------------------------------
// FolderListing() returns Folder Listing for $g_view
function FolderListing()
{
    global $cfg, $tpl;
    global $g_view, $g_folders, $g_dir;
    global $g_tpl_target;

    $ret = '';
    foreach ($g_folders as $folder)
    {
        # shorten foldername
        $foldername = $folder['name'];
        if( strlen($folder['name']) >= $cfg['maxStrlen'] ) {
            $foldername = substr($folder['name'], 0, $cfg['maxStrlen']-3).'...';
        }
        $tmp = array();
        $tmp['from'] = array( '{HREF}','{NAME}','{SHORT_NAME}','{LASTMOD}','{TYPE}' );
        $tmp['to'] = array(
            $g_tpl_target.rawurlencode($g_dir.'/'.$folder['name']),
            htmlentities($folder['name']),
            htmlentities($foldername),
            date($cfg['dateFormat'],$folder['lmod']),
            htmlentities($folder['type']),
        );
        $ret .= str_replace( $tmp['from'], $tmp['to'], $tpl[$g_view]['folder'] );
    }
    return $ret;
}

// ----------------------------------------------------------------------------
// FileListing() returns File Listing for $g_view
function FileListing()
{
    global $cfg, $tpl;
    global $g_view, $g_files, $g_dirsize, $g_ldir;

    $ret = '';
    foreach ($g_files as $file)
    {
        $g_dirsize += $file['size'];              // total filesize in current dir

        $target = getTarget($g_ldir.$file['name']);
        $size = ceil($file['size']/1024);         // convert from byte to kilobyte
        $size = "$size KB";                       // add unit
        $lastmod = date($cfg['dateFormat'],$file['lmod']);

        # shorten filename
        $filename = $file['name'];
        if( strlen($file['name']) >= $cfg['maxStrlen'] ) {
            $filename = substr($file['name'], 0, $cfg['maxStrlen']-3).'...';
        }

        $tooltip  = ' '.$file['name']." \n";
        $tooltip .= ' Type: '.$file['type']." \n";
        $tooltip .= ' Last Modified: '.$lastmod." \n";
        $tooltip .= ' Size: '.$size;

        $tmp = array();
        $tmp['from'] = array( '{HREF}','{IMG}','{NAME}','{SHORT_NAME}','{SIZE}','{LASTMOD}','{TYPE}','{TOOLTIP}' );
        $tmp['to'] = array(
            getTarget($g_ldir.$file['name']),
            getIcon($file['name']),
            htmlentities($file['name']),
            htmlentities($filename),
            $size,
            $lastmod,
            htmlentities($file['type']),
            htmlentities($tooltip),
        );
        $ret .= str_replace( $tmp['from'], $tmp['to'], $tpl[$g_view]['file'] );
    }
    return $ret;
}

// ----------------------------------------------------------------------------
// getStatMsg() returns Statistik Message
function getStatMsg( )
{
    global $g_folders, $g_files, $g_dirsize;

    $folder_count = count($g_folders);
    $file_count   = count($g_files);
    $total_size   = ceil($g_dirsize/1024);

    $msg  = $folder_count.' '.($folder_count==1?'directory':'directories').' | ';
    $msg .= $file_count.' '.($file_count==1?'file':'files').' | ';
    $msg .= $total_size.' kByte total';

    return $msg;
}

// ----------------------------------------------------------------------------
// getUpTarget() returns target directory for UP button
function getUpTarget( $dir )
{
    global $cfg;

    if( $cfg['su'] && (!$dir || (substr($dir,-2)=='..')) )
        $target = formatDir($dir,true).'..';
    else
        $target = substr($dir,0,strrpos($dir,'/'));

    return $target;
}

// ----------------------------------------------------------------------------
// getDirContent() fills, filter and sort Arrays of files and folders
function getDirContent($dir)
{
    global $g_files, $g_folders;

    # fill arrays
    $handle = @opendir($dir);
    while( $file = readdir($handle) ) {
        if( is_dir("$dir/$file") )
            $g_folders[] = $file;
        elseif( is_file("$dir/$file") )
            $g_files[] = $file;
    }
    @closedir($handle);
}

// ----------------------------------------------------------------------------
// addLinker()    adds '?' or '&' to the referer
function addLinker($referer)
{
    // assume that last char is not '?' or '&'
    return strchr($referer,'?') ? "$referer&amp;" : "$referer?";
}

// ----------------------------------------------------------------------------
// formatDir()    skip trailing and leading "/" in given $dir-string and
//                add slashes depending on params
function formatDir($dir, $trailing=false, $leading=false)
{
    $dir = trim($dir,' /');
    if( $trailing && $dir )
        $dir = "$dir/";
    if( $leading ) #&& ($dir[0]!='/') )
        $dir = "./$dir";

    return $dir;
}

// ----------------------------------------------------------------------------
// makeRegex()   make regular expression from $filter-string
//               if $loose=true pattern matches even in the middle the text
function makeRegex( $filter, $loose=false )
{
    $regex = '';
    $regex = str_replace('.', '\.', $filter);
    $regex = str_replace('/', '\/', $regex);
    $regex = str_replace('*', '.+', $regex);
    $regex = str_replace(',', '$|^', $regex);
    
    if( $loose ) 
        $regex = ".*$regex.*";
    
    return "^$regex$";
}

// ----------------------------------------------------------------------------
// isValidDir()   return true if directory is valid/allowed
function isValidDir( $dir )
{
    global $cfg;

    // check if folder exists (when manipulated manually)
    if( !is_dir($dir) ) return false;
    // No Restrictions are applied to Superuser
    if( $cfg['su'] ) return true;
    // prevent cd with relative path '../'
    if( strpos($dir,'..')!==false ) return false;
    // handle root directory
    if( $dir == './' ) return true; 
    // check if directory is allowed
    if( !$cfg['allowHidden'] ) {
        $allow = makeRegex($cfg['showFolders']);
        $hide  = makeRegex($cfg['hideFolders']);
        $arr   = explode( '/', $dir );

        foreach( $arr as $val )
            if( !preg_match("/$allow/i",$val) || preg_match("/$hide/i",$val) )
                return false;
    }
    // nothing suspicious found
    return true;
}

// ----------------------------------------------------------------------------
// rawParam()
function rawParam( $param )
{
    return ini_get('magic_quotes_gpc') ? stripslashes($_GET[$param]) : $_GET[$param];
}

// ----------------------------------------------------------------------------
// getAttributes()   returns array with fileproperties
//                   (name, size, lastmod and desc)
function getFileAttr( $obj )
{
    global $g_ldir;

    $tmp = array();
    foreach( $obj as $file ) {
        $tmp[] = array(
            'name' => $file,
            'size' => filesize("$g_ldir$file"),    // get 'size of file' in bytes
            'lmod' => filemtime("$g_ldir$file"),   // get 'last modified date'
            'type' => getTyp("$file")             // get 'file description'
        );
    }
    return $tmp;
}

// ----------------------------------------------------------------------------
// getFolderAttributes()   returns array with fileproperties (name, size and lastmod)
function getFolderAttr( $obj )
{
    global $g_ldir;

    $tmp = array();
    foreach( $obj as $folder ) {
        $tmp[] = array(
            'name' => $folder,
            'size' => '',
            'lmod' => filemtime("$g_ldir$folder"),   // get 'last modified date'
            'type' => 'File Folder'
        );
    }
    return $tmp;
}

// ----------------------------------------------------------------------------
// compare()
function cmp($a, $b) {

    global $g_C, $g_O;

    $sortKey   = array( 'N'=>'name', 'S'=>'size', 'M'=>'lmod', 'D'=>'type' );
    $sortOrder = array( 'A'=> 1, 'D'=> -1 );

    // sort by main criteria ($g_C)
    $ret = $sortOrder[$g_O] * strnatcasecmp(strtr($a[$sortKey[$g_C]],"","AOUaous"), strtr($b[$sortKey[$g_C]],"","AOUaous"));
    // sort equal values by filename
    if( $ret == 0 && $g_C != 'N' )
        $ret = $sortOrder[$g_O] * strnatcasecmp(strtr($a[$sortKey['N']],"","AOUaous"), strtr($b[$sortKey['N']],"","AOUaous"));

    return $ret;
}

// ----------------------------------------------------------------------------
// parseFiletypeConfig()   returns 2-dim array from given config-array
function parseFiletypeConfig( $picIcons )
{
    global $cfg;

    foreach( $picIcons as $type ) {
        $tmp = preg_split ( '/[[:blank:]]*,[[:blank:]]*/i', $type );
        if( $tmp[4]=='' ) $tmp[4] = $cfg['xFilename'];
        if( $tmp[3]=='' ) $tmp[3] = $cfg['xAction'];

        $ret[$tmp[0]] = array(
            'icon' => $tmp[1],
            'type' => $tmp[2],
            'xact' => $tmp[3],
            'xfn'  => $tmp[4]
        );

    }
    return $ret;
}

// ----------------------------------------------------------------------------
// getSortOrder()   filters User Input and returns SortOrder (A or D)
function getSortOrder( $O )
{
    global $cfg;

    if( in_array($O, array('A','D')) ) 
        return $O;

    return $cfg['sortO'];
}

// ----------------------------------------------------------------------------
// newOrder()   return order of $C for the next klick
function newOrder( $C, $O )
{
    $tmp = array(
        'N' => 'A',
        'S' => 'A',
        'M' => 'A',
        'D' => 'A'
    );
    // reverse order of current column
    $tmp[$C] = ($O=='D') ? 'A' : 'D';

    return $tmp;
}

// ----------------------------------------------------------------------------
// getTarget()   return target of click
function getTarget( $filename )
{
    global $cfg;

    // extract filename extension
    $ext = strtolower( strrchr( $filename, '.' ) );
    // handle unknown extensions
    if( !array_key_exists($ext,$cfg['filetypes']) )
        $ext = '.*';
    // format/encode url
    $filename = str_replace('%2F', '/', rawurlencode($filename));

    // return matching target
    return $cfg['filetypes'][$ext]['xact'] ? $cfg['filetypes'][$ext]['xfn']."?file=$filename" : $filename;
}

// ----------------------------------------------------------------------------
// getIcon()   return icon-image based on filename extension
function getIcon( $filename )
{
    global $cfg;

    // extract filename extension
    $ext = strtolower( strrchr( $filename, '.' ) );
    // return default image if $cfg['picFile'] = false or extension is unknown
    if( !$cfg['picFile'] || !array_key_exists($ext,$cfg['filetypes']) )
        return $cfg['filetypes']['.*']['icon'];

    // return matching image
    return $cfg['filetypes'][$ext]['icon'];
}

// ----------------------------------------------------------------------------
// getTyp()   return type-description based on filename extension
function getTyp( $filename )
{
    global $cfg;

    // extract filename extension
    $ext = strtolower( strrchr( $filename, '.' ) );
    // handle files without extension
    if( !$ext )
        return 'unknown';
    // return default description if extension is unknown
    if( !$cfg['filetypes'][$ext]['type'] )
        return substr(strtoupper($ext),1).' File';

    // return matching description
    return $cfg['filetypes'][$ext]['type'];
}

// ----------------------------------------------------------------------------
// getmicrotime()   return float value of unix timestamp in seconds
function getmicrotime()
{
   list($usec, $sec) = explode(" ",microtime());
   return ((float)$usec + (float)$sec);
}

// ----------------------------------------------------------------------------
// debug_output()   just for debugging
function debug_output( $var )
{
     echo '<pre>'."\n";
     print_r( $var );
     echo '<pre>'."\n";
}

?>

